/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.config.model.FacesConfig;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.config.model.NavigationRule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JSFConfigUtilities {
    public static List getAllNavigationRules(JSFConfigDataObject data) {
        ArrayList<NavigationRule> list = new ArrayList<NavigationRule>();
        try {
            FacesConfig config = data.getFacesConfig();
            NavigationRule[] rules = config.getNavigationRule();
            if (rules != null) {
                for (int i = 0; i < rules.length; ++i) {
                    list.add(rules[i]);
                }
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return list;
    }

    public static List getAllManagedBeans(JSFConfigDataObject data) {
        ArrayList<ManagedBean> list = new ArrayList<ManagedBean>();
        try {
            FacesConfig config = data.getFacesConfig();
            ManagedBean[] beans = config.getManagedBean();
            for (int i = 0; i < beans.length; ++i) {
                list.add(beans[i]);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return list;
    }

    public static NavigationRule findNavigationRule(JSFConfigDataObject data, String fromView) {
        try {
            return JSFConfigUtilities.findNavigationRule(data.getFacesConfig(), fromView);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    public static NavigationRule findNavigationRule(FacesConfig config, String fromView) {
        if (fromView != null) {
            NavigationRule[] rules = config.getNavigationRule();
            for (int i = 0; i < rules.length; ++i) {
                if (!fromView.equals(rules[i].getFromViewId())) continue;
                return rules[i];
            }
        }
        return null;
    }

    public static SourceGroup[] getDocBaseGroups(FileObject fo) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        return sources.getSourceGroups("doc_root");
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }

    public static Servlet getActionServlet(FileObject dd) {
        if (dd == null) {
            return null;
        }
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
            return (Servlet)webApp.findBeanByName("Servlet", "ServletClass", "javax.faces.webapp.FacesServlet");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getActionServletMapping(FileObject dd) {
        Servlet servlet = JSFConfigUtilities.getActionServlet(dd);
        if (servlet != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                ServletMapping[] mappings = webApp.getServletMapping();
                for (int i = 0; i < mappings.length; ++i) {
                    if (!mappings[i].getServletName().equals(servlet.getServletName())) continue;
                    return mappings[i].getUrlPattern();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    public static boolean validateXML(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.validateXml");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static boolean verifyObjects(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.verifyObjects");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static String[] getConfigFiles(FileObject dd) {
        if (dd != null) {
            InitParam param = null;
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "javax.faces.CONFIG_FILES");
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (param != null) {
                String value = param.getParamValue().trim();
                if (value != null) {
                    String[] files = value.split(",");
                    for (int i = 0; i < files.length; ++i) {
                        files[i] = files[i].trim();
                    }
                    return files;
                }
            } else {
                WebModule wm = WebModule.getWebModule((FileObject)dd);
                FileObject baseDir = wm.getDocumentBase();
                FileObject fo = baseDir.getFileObject("WEB-INF/faces-config.xml");
                if (fo != null) {
                    return new String[]{"WEB-INF/faces-config.xml"};
                }
            }
        }
        return new String[0];
    }

    public static FileObject[] getConfiFilesFO(FileObject dd) {
        String[] sFiles = JSFConfigUtilities.getConfigFiles(dd);
        if (sFiles.length > 0) {
            WebModule wm = WebModule.getWebModule((FileObject)dd);
            FileObject documentBase = wm.getDocumentBase();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < sFiles.length; ++i) {
                FileObject file = documentBase.getFileObject(sFiles[i]);
                if (file == null) continue;
                files.add(file);
            }
            return files.toArray(new FileObject[files.size()]);
        }
        return new FileObject[0];
    }

    public static String translateURI(String mapping, String uri) {
        String resource = "";
        if (mapping != null && mapping.length() > 0) {
            if (mapping.startsWith("*.")) {
                resource = uri.indexOf(46) > 0 ? uri.substring(0, uri.lastIndexOf(46)) + mapping.substring(1) : uri + mapping.substring(1);
            } else if (mapping.endsWith("/*")) {
                resource = mapping.substring(0, mapping.length() - 2) + uri;
            }
        }
        return resource;
    }

    public static FileObject findFacesConfigForManagedBean(WebModule wm, String name) {
        FileObject[] configs = JSFConfigUtilities.getConfiFilesFO(wm.getDeploymentDescriptor());
        try {
            for (int i = 0; i < configs.length; ++i) {
                DataObject dObject = DataObject.find((FileObject)configs[i]);
                if (!(dObject instanceof JSFConfigDataObject)) continue;
                ManagedBean[] beans = ((JSFConfigDataObject)dObject).getFacesConfig().getManagedBean();
                for (int j = 0; j < beans.length; ++j) {
                    if (!beans[j].getManagedBeanName().equals(name)) continue;
                    return configs[i];
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }
}

