/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.mapviewer;

import com.sun.j2ee.blueprints.ui.mapviewer.MapComponent;
import com.sun.j2ee.blueprints.ui.mapviewer.MapMarker;
import com.sun.j2ee.blueprints.ui.mapviewer.MapPoint;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class MapRenderer
extends Renderer {
    private static final String BACKGROUND_IMAGE = "/com/sun/j2ee/blueprints/ui/mapviewer/Background.jpg";
    private static final String GOOGLE_LOADED = "com.sun.j2ee.mapviewer.GOOGLE_LOADED";
    private static final String GOOGLE_RESOURCE = "http://maps.google.com/maps?file=api&v=1&key=";
    private static final String SCRIPT_RESOURCE = "/META-INF/mapviewer/script.js";
    private static final String AUTHORIZATION_KEY = "com.sun.j2ee.blueprints.ui.mapviewer.KEY";
    private static XhtmlHelper helper = new XhtmlHelper();

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String style;
        MapComponent map = (MapComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)map);
        writer.writeAttribute("id", (Object)map.getClientId(context), "id");
        String styleClass = map.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if ((style = map.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.write("\n");
        if (!Beans.isDesignTime()) {
            if (!context.getExternalContext().getRequestMap().containsKey(GOOGLE_LOADED)) {
                writer.startElement("script", (UIComponent)map);
                writer.writeAttribute("type", (Object)"text/javascript", null);
                writer.writeURIAttribute("src", (Object)this.url(context, map), null);
                writer.endElement("script");
                writer.write("\n");
                context.getExternalContext().getRequestMap().put(GOOGLE_LOADED, Boolean.TRUE);
            }
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
        }
        writer.startElement("div", (UIComponent)map);
        writer.writeAttribute("id", (Object)(map.getClientId(context) + "_map"), "id");
        style = "height: 100%; width: 100%;";
        if (Beans.isDesignTime()) {
            style = style + " border: 1px dashed gray; color: black; text-align: center; vertical-align: middle;";
            String url = MapRenderer.class.getResource(BACKGROUND_IMAGE).toString();
            style = style + " background-image: url('" + url + "');" + " background-repeat: repeat;";
        }
        writer.writeAttribute("style", (Object)style, null);
        if (Beans.isDesignTime()) {
            writer.startElement("p", (UIComponent)map);
            writer.writeText((Object)Util.getMessage("mapviewer.design.title"), null);
            writer.endElement("p");
            writer.write("\n");
            ValueBinding vb = null;
            vb = map.getValueBinding("center");
            if (vb != null) {
                writer.startElement("p", (UIComponent)map);
                writer.writeText((Object)Util.getMessage("mapviewer.design.center"), null);
                writer.writeText((Object)vb.getExpressionString(), null);
                writer.endElement("p");
                writer.write("\n");
            }
            if ((vb = map.getValueBinding("info")) != null) {
                writer.startElement("p", (UIComponent)map);
                writer.writeText((Object)Util.getMessage("mapviewer.design.info"), null);
                writer.writeText((Object)vb.getExpressionString(), null);
                writer.endElement("p");
                writer.write("\n");
            }
            if ((vb = map.getValueBinding("markers")) != null) {
                writer.startElement("p", (UIComponent)map);
                writer.writeText((Object)Util.getMessage("mapviewer.design.markers"), null);
                writer.writeText((Object)vb.getExpressionString(), null);
                writer.endElement("p");
                writer.write("\n");
            }
        }
        writer.endElement("div");
        writer.write("\n");
        if (!Beans.isDesignTime()) {
            MapMarker[] markers;
            MapMarker info;
            int zoomLevel;
            String name = this.name(context, map);
            String clientId = map.getClientId(context);
            double latitude = 0.0;
            double longitude = 0.0;
            MapPoint point = map.getCenter();
            if (point != null) {
                latitude = point.getLatitude();
                longitude = point.getLongitude();
            }
            if (latitude == 0.0 && longitude == 0.0) {
                latitude = 37.4419;
                longitude = -122.1419;
            }
            if ((zoomLevel = map.getZoomLevel()) < 1) {
                zoomLevel = 4;
            }
            writer.startElement("script", (UIComponent)map);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            writer.writeText((Object)("var " + name + " = null;\n"), null);
            writer.writeText((Object)("bpui.mapviewer.setup_" + name + " = function() {\n"), null);
            writer.writeText((Object)("  " + name + " = bpui.mapviewer.createMap(" + "\"" + clientId + "_map\", " + latitude + ", " + longitude + ", " + zoomLevel + ");\n"), null);
            if (!map.isDraggingEnabled()) {
                writer.writeText((Object)("  bpui.mapviewer.setDragging(" + name + ", false);\n"), null);
            }
            if (map.isMapControls()) {
                writer.writeText((Object)("  bpui.mapviewer.addControl(" + name + ", " + "bpui.mapviewer.createMapControl());\n"), null);
            }
            if (map.isTypeControls()) {
                writer.writeText((Object)("  bpui.mapviewer.addControl(" + name + ", " + "bpui.mapviewer.createTypeControl());\n"), null);
            }
            if ((info = map.getInfo()) != null && info.getMarkup() != null) {
                if (info.getLatitude() != 0.0 && info.getLongitude() != 0.0) {
                    writer.writeText((Object)("  bpui.mapviewer.openInfoWindowHtml(" + name + ", " + info.getLatitude() + ", " + info.getLongitude() + ", " + "\"" + this.markup(info.getMarkup()) + "\"" + ");\n"), null);
                } else {
                    writer.writeText((Object)("  bpui.mapviewer.openInfoWindowHtml(" + name + ", " + latitude + ", " + longitude + ", " + "\"" + this.markup(info.getMarkup()) + "\"" + ");\n"), null);
                }
            }
            if ((markers = map.getMarkers()) != null) {
                for (int i = 0; i < markers.length; ++i) {
                    MapMarker marker = markers[i];
                    if (marker.getMarkup() != null) {
                        writer.writeText((Object)("  bpui.mapviewer.addMarker(" + name + ", " + marker.getLatitude() + ", " + marker.getLongitude() + ", " + "\"" + this.markup(marker.getMarkup()) + "\"" + ");\n"), null);
                        continue;
                    }
                    writer.writeText((Object)("  bpcui_mapviewer_addMarker(" + name + ", " + marker.getLatitude() + ", " + marker.getLongitude() + ", " + "null" + ");\n"), null);
                }
            }
            writer.writeText((Object)"}\n", null);
            writer.writeText((Object)("setTimeout('bpui.mapviewer.setup_" + name + "()', 0);\n"), null);
            writer.endElement("script");
            writer.write("\n");
        }
        writer.endElement("div");
        writer.write("\n");
    }

    private String markup(String markup) {
        if (markup.indexOf(34) < 0) {
            return markup;
        }
        StringBuffer sb = new StringBuffer(markup.length() + 4);
        for (int i = 0; i < markup.length(); ++i) {
            char ch = markup.charAt(i);
            if (ch == '\"') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String name(FacesContext context, MapComponent map) {
        return map.getClientId(context).replace(':', '_');
    }

    private String point(MapPoint point) {
        return "new GPoint(" + point.getLongitude() + ", " + point.getLatitude() + ")";
    }

    private String url(FacesContext context, MapComponent map) {
        StringBuffer sb = new StringBuffer(GOOGLE_RESOURCE);
        String key = map.getKey();
        if (key == null) {
            key = context.getExternalContext().getInitParameter(AUTHORIZATION_KEY);
        }
        sb.append(key);
        return sb.toString();
    }
}

