/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.Constant;
import javax.jmi.model.DataType;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Parameter;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKindEnum;
import org.netbeans.api.mdr.JMIStreamFactory;
import org.netbeans.lib.jmi.mapping.GenericMapper;
import org.netbeans.lib.jmi.util.ContainsIterator;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.util.TagProvider;

public class JavaMapper
extends GenericMapper {
    private static final String DOC_ATTR_GETTER = "Returns the value of attribute {0}.";
    private static final String DOC_ATTR_GETTER_RETURN = "Value of attribute {0}.";
    private static final String DOC_ATTR_SETTER = "Sets the value of {0} attribute. See '{'@link #{1}'}' for description on the attribute.";
    private static final String DOC_ATTR_SETTER_PARAM = "New value to be set.";
    private static final String DOC_ATTR_GETTER_RETURN_ORDERED = "Value of {0} attribute. Element type: '{'@link {1}'}'";
    private static final String DOC_ATTR_GETTER_RETURN_MULTI = "Value of {0} attribute. Element type: '{'@link {1}'}'";
    private static final String DOC_ASSOC_PROXY = "{0} association proxy interface.";
    private static final String DOC_ASSOC_EXISTS = "Queries whether a link currently exists between a given pair of instance objects in the association's link set.";
    private static final String DOC_ASSOC_EXISTS_PARAM1 = "Value of the first association end.";
    private static final String DOC_ASSOC_EXISTS_PARAM2 = "Value of the second association end.";
    private static final String DOC_ASSOC_EXISTS_RETURN = "Returns true if the queried link exists.";
    private static final String DOC_ASSOC_ADD = "Creates a link between the pair of instance objects in the association's link set.";
    private static final String DOC_ASSOC_REMOVE = "Removes a link between a pair of instance objects in the current association's link set.";
    private static final String DOC_ASSOC_GET_END1_SINGLE = "Queries the instance object that is related to a particular instance object by a link in the current association's link set.";
    private static final String DOC_ASSOC_GET_END1_MULTI = "Queries the instance objects that are related to a particular instance object by a link in the current association's link set.";
    private static final String DOC_ASSOC_GET_END1_ORDERED = "Queries the instance objects that are related to a particular instance object by a link in the current association's link set.";
    private static final String DOC_ASSOC_GET_END1_PARAM = "Required value of the first association end.";
    private static final String DOC_ASSOC_GET_END1_RETURN_SINGLE = "Related object or <code>null</code> if none exists.";
    private static final String DOC_ASSOC_GET_END1_RETURN_MULTI = "Collection of related objects.";
    private static final String DOC_ASSOC_GET_END1_RETURN_ORDERED = "List of related objects.";
    private static final String DOC_ASSOC_GET_END2_PARAM = "Required value of the second association end.";
    private static final String DOC_INSTANCE = "{0} object instance interface.";
    private static final String DOC_REFERENCE_GETTER = "Returns the value of reference {0}.";
    private static final String DOC_REFERENCE_GETTER_RETURN = "Value of reference {0}.";
    private static final String DOC_REFERENCE_SETTER = "Sets the value of reference {0}. See '{'@link #{1}'}' for description on the reference.";
    private static final String DOC_REFERENCE_SETTER_PARAM = "New value to be set.";
    private static final String DOC_REFERENCE_GETTER_RETURN_ORDERED = "Value of reference {0}. Element type: '{'@link {1}'}'";
    private static final String DOC_REFERENCE_GETTER_RETURN_MULTI = "Value of reference {0}. Element type: '{'@link {1}'}'";
    private static final String DOC_CLASS_PROXY = "{0} class proxy interface.";
    private static final String DOC_CLASS_PROXY_CREATE = "The default factory operation used to create an instance object.";
    private static final String DOC_CLASS_PROXY_CREATE_RETURN = "The created instance object.";
    private static final String DOC_CLASS_PROXY_CREATE2 = "Creates an instance object having attributes initialized by the passed values.";
    private static final String DOC_PACKAGE = "{0} package interface.";
    private static final String DOC_PACKAGE_GET_IMPORT = "Returns clustered package {1}.";
    private static final String DOC_PACKAGE_GET_IMPORT_RETURN = "Proxy object related to clustered package {1}.";
    private static final String DOC_PACKAGE_GET_NESTED = "Returns nested package {1}.";
    private static final String DOC_PACKAGE_GET_NESTED_RETURN = "Proxy object related to nested package {1}.";
    private static final String DOC_PACKAGE_GET_CLASS = "Returns {1} class proxy object.";
    private static final String DOC_PACKAGE_GET_CLASS_RETURN = "{1} class proxy object.";
    private static final String DOC_PACKAGE_GET_ASSOC = "Returns {1} association proxy object.";
    private static final String DOC_PACKAGE_GET_ASSOC_RETURN = "{1} association proxy object.";
    private static final String DOC_EXCEPTION = "{0} exception implementation class.";
    private static final String DOC_EXCEPTION_CONSTRUCTOR = "The public constructor.";
    private static final String DOC_EXCEPTION_GETTER = "Returns value of parameter {1}.";
    private static final String DOC_EXCEPTION_GETTER_RETURN = "Value of parameter {1}.";
    private static final String DOC_ENUM_INTERFACE = "{0} enumeration interface.";
    private static final String DOC_ENUM_CLASS = "{0} enumeration class implementation.";
    private static final String DOC_ENUM_LITERAL = "Enumeration constant corresponding to literal {1}.";
    private static final String DOC_ENUM_REFTYPENAME = "Returns fully qualified name of the enumeration type.";
    private static final String DOC_ENUM_REFTYPENAME_RETURN = "List containing all parts of the fully qualified name.";
    private static final String DOC_ENUM_TOSTRING = "Returns a string representation of the enumeration value.";
    private static final String DOC_ENUM_TOSTRING_RETURN = "A string representation of the enumeration value.";
    private static final String DOC_ENUM_HASHCODE = "Returns a hash code for this the enumeration value.";
    private static final String DOC_ENUM_HASHCODE_RETURN = "A hash code for this enumeration value.";
    private static final String DOC_ENUM_EQUALS = "Indicates whether some other object is equal to this enumeration value.";
    private static final String DOC_ENUM_EQUALS_RETURN = "true if the other object is the enumeration of the same type and of the same value.";
    private static final String DOC_ENUM_EQUALS_PARAM = "The reference object with which to compare.";
    private static final String DOC_ENUM_FORNAME = "Translates literal name to correspondent enumeration value.";
    private static final String DOC_ENUM_FORNAME_RETURN = "Enumeration value corresponding to the passed literal.";
    private static final String DOC_ENUM_FORNAME_PARAM = "Enumeration literal.";
    private static final String DOC_ENUM_READRESOLVE = "Resolves serialized instance of enumeration value.";
    private static final String DOC_ENUM_READRESOLVE_RETURN = "Resolved enumeration value.";
    private static final String DOC_STRUCT = "{0} structure interface.";
    private static final String DOC_STRUCT_CREATE = "Creates an instance of {0} structure type.";
    private static final String DOC_STRUCT_CREATE_RETURN = "Value of {0}.";
    private static final String DOC_STRUCT_GETTER = "Returns value of {1} field.";
    private static final String DOC_STRUCT_GETTER_RETURN = "Value of {1} field.";
    private static final String DOC_WARNING = "<p><em><strong>Note:</strong> This type should not be subclassed or implemented by clients. It is generated from a MOF metamodel and automatically implemented by MDR (see <a href=\"http://mdr.netbeans.org/\">mdr.netbeans.org</a>).</em></p>";
    private int indentation = 0;
    private final JMIStreamFactory generator;
    private static final String TAB = "    ";
    private PrintStream stream = null;
    private String header = null;
    private ClassContents cachedClassContents;

    private void generate(String text) throws IOException {
        this.generateTabs();
        this.stream.println(text);
        JavaMapper.checkStreamForErrors(this.stream);
    }

    private void generateTabs() throws IOException {
        for (int i = 0; i < this.indentation; ++i) {
            this.stream.print(TAB);
        }
        JavaMapper.checkStreamForErrors(this.stream);
    }

    private void newLine() throws IOException {
        this.stream.println();
        JavaMapper.checkStreamForErrors(this.stream);
    }

    private void indent() {
        ++this.indentation;
    }

    private void indent(int count) {
        this.indentation = count;
    }

    private void unindent() {
        --this.indentation;
    }

    protected boolean createStream(List pkg, String name) throws IOException {
        if (this.stream != null) {
            this.closeStream();
            throw new IllegalStateException("Attempting to create stream before previous stream was closed.");
        }
        OutputStream os = this.generator.createStream(pkg, name);
        if (os != null) {
            this.stream = new PrintStream(os);
        }
        return this.stream != null;
    }

    protected void closeStream() throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Attempting to close the stream without opening it first.");
        }
        PrintStream ps = this.stream;
        this.stream = null;
        ps.close();
        JavaMapper.checkStreamForErrors(ps);
    }

    private static void checkStreamForErrors(PrintStream ps) throws IOException {
        if (ps.checkError()) {
            throw new IOException("Error writing to print stream during JMI Source generator.");
        }
    }

    private void interfaceHeader(String pkg, String name, Object[] ancestors, ModelElement elem, String comment) throws IOException {
        this.classHeader(pkg, name, ancestors, null, true, elem, comment);
    }

    private void classHeader(String pkg, String name, Object[] ancestors, Object[] interfaces, boolean isInterface, ModelElement elem, String comment) throws IOException {
        this.classHeader(pkg, name, ancestors, interfaces, isInterface, false, elem, comment);
    }

    private void classHeader(String pkg, String name, Object[] ancestors, Object[] interfaces, boolean isInterface, boolean isFinal, ModelElement elem, String comment) throws IOException {
        String type;
        int i;
        this.indent(0);
        StringBuffer sbAnc = new StringBuffer();
        StringBuffer sbIfc = new StringBuffer();
        if (this.header != null) {
            this.generate(this.header);
            this.newLine();
        }
        this.generate("package " + pkg + ";");
        this.newLine();
        this.classJavaDoc(elem, comment);
        if (ancestors != null) {
            i = 0;
            while (i < ancestors.length) {
                if (sbAnc.length() > 0) {
                    sbAnc.append(", ");
                } else {
                    sbAnc.append(" extends ");
                }
                sbAnc.append((String)ancestors[i++]);
            }
        }
        if (isInterface) {
            type = "interface";
        } else {
            type = isFinal ? "final class" : "class";
            if (interfaces != null) {
                i = 0;
                while (i < interfaces.length) {
                    if (sbIfc.length() > 0) {
                        sbIfc.append(", ");
                    } else {
                        sbIfc.append(" implements ");
                    }
                    sbIfc.append((String)interfaces[i++]);
                }
            }
        }
        this.generate("public " + type + " " + name + sbAnc.toString() + sbIfc.toString() + " {");
        this.indent();
    }

    private void interfaceFooter(String name) throws IOException {
        this.classFooter(name, true);
    }

    private void classFooter(String name, boolean isInterface) throws IOException {
        this.unindent();
        this.generate("}");
    }

    private void interfaceMethod(String returnType, String name, Object[] parameters, Object[] exceptions) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (parameters != null) {
            i = 0;
            while (i < parameters.length) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)parameters[i++] + " " + (String)parameters[i++]);
            }
        }
        if (exceptions != null) {
            i = 0;
            while (i < exceptions.length) {
                if (sb2.length() > 0) {
                    sb2.append(", ");
                } else {
                    sb2.append(" throws ");
                }
                sb2.append((String)exceptions[i++]);
            }
        }
        this.generate("public " + returnType + " " + name + "(" + sb + ")" + sb2 + ";");
    }

    private void interfaceField(String fieldType, String name, String value) throws IOException {
        this.generate("public final " + fieldType + " " + name + " = " + value + ";");
    }

    private void attributeTemplate(Object objAttribute) throws IOException {
        Attribute attr = (Attribute)objAttribute;
        String attrName = JavaMapper.firstUpper(this.tagProvider.getSubstName((ModelElement)attr));
        Classifier attrType = this.getAttrType((TypedElement)attr);
        String attrTypeName = this.getTypeName((StructuralFeature)attr, 1);
        if (attr.getMultiplicity().getUpper() == 1) {
            String setterName;
            String name;
            if (attrType instanceof PrimitiveType && attrType.getName().equals("Boolean")) {
                name = attrName.substring(0, 2).equals("Is") ? JavaMapper.firstLower(attrName) : "is" + attrName;
                setterName = "set" + name.substring(2);
            } else {
                name = "get" + attrName;
                setterName = "set" + attrName;
            }
            String getterType = attrTypeName;
            if (attr.getMultiplicity().getLower() == 1) {
                getterType = this.getPrimitiveName(getterType);
            }
            this.methodJavaDoc((ModelElement)attr, true, DOC_ATTR_GETTER, DOC_ATTR_GETTER_RETURN, null, null, null);
            this.interfaceMethod(getterType, name, null, null);
            if (attr.isChangeable()) {
                this.methodJavaDoc((ModelElement)attr, false, DOC_ATTR_SETTER, null, new String[]{"newValue"}, new Object[]{"New value to be set."}, new String[]{name});
                this.interfaceMethod("void", setterName, new String[]{getterType, "newValue"}, null);
            }
        } else if (attr.getMultiplicity().getUpper() != 0) {
            boolean ordered = attr.getMultiplicity().isOrdered();
            this.methodJavaDoc((ModelElement)attr, true, DOC_ATTR_GETTER, ordered ? "Value of {0} attribute. Element type: '{'@link {1}'}'" : "Value of {0} attribute. Element type: '{'@link {1}'}'", null, null, new String[]{this.getTypeName(attrType)});
            this.interfaceMethod(attrTypeName, "get" + attrName, null, null);
        }
    }

    private void operationTemplate(Object objOperation) throws IOException {
        ModelElement element;
        Operation oper = (Operation)objOperation;
        ArrayList<String> exceptions = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<Parameter> parametersList = new ArrayList<Parameter>();
        ArrayList<String> parametersNames = new ArrayList<String>();
        String operType = "void";
        Parameter returnParam = null;
        Iterator it = oper.getContents().iterator();
        while (it.hasNext()) {
            element = (ModelElement)it.next();
            if (!(element instanceof Parameter)) continue;
            Parameter param = (Parameter)element;
            if (param.getDirection().equals(DirectionKindEnum.RETURN_DIR)) {
                operType = this.getTypeName(param, 1);
                returnParam = param;
                continue;
            }
            parameters.add(this.getTypeName(param, 1));
            String name = this.tagProvider.getSubstName((ModelElement)param) + (param.getDirection().equals(DirectionKindEnum.IN_DIR) ? "" : "[]");
            parameters.add(name);
            parametersList.add(param);
            parametersNames.add(name);
        }
        it = oper.getExceptions().iterator();
        while (it.hasNext()) {
            element = (ModelElement)it.next();
            exceptions.add(this.tagProvider.getTypeFullName(element));
        }
        int size = parametersList.size();
        Object[] paramsArray = new Object[size];
        paramsArray = parametersList.toArray(paramsArray);
        String[] namesArray = new String[size];
        namesArray = parametersNames.toArray(namesArray);
        this.methodJavaDoc((ModelElement)oper, true, null, returnParam, namesArray, paramsArray, null);
        this.interfaceMethod(operType, this.tagProvider.getSubstName((ModelElement)oper), parameters.toArray(), exceptions.toArray());
    }

    private void constantTemplate(Object objConstant) throws IOException {
        Constant constant = (Constant)objConstant;
        DataType type = (DataType)this.getAttrType((TypedElement)constant);
        String value = constant.getValue();
        if (type.getName().equals("String")) {
            value = "\"" + value.replace('\n', ' ') + "\"";
        }
        this.fieldJavaDoc((ModelElement)constant);
        this.interfaceField(this.getTypeName2((TypedElement)constant), this.tagProvider.getSubstName((ModelElement)constant), value);
    }

    private void referenceTemplate(Object objReference) throws IOException {
        Reference ref = (Reference)objReference;
        String refName = JavaMapper.firstUpper(this.tagProvider.getSubstName((ModelElement)ref));
        String refType = this.getTypeName(this.getAttrType((TypedElement)ref));
        if (ref.getMultiplicity().getUpper() == 1) {
            this.methodJavaDoc((ModelElement)ref, true, DOC_REFERENCE_GETTER, DOC_REFERENCE_GETTER_RETURN, null, null, null);
            this.interfaceMethod(refType, "get" + refName, null, null);
            if (ref.isChangeable()) {
                this.methodJavaDoc((ModelElement)ref, false, DOC_REFERENCE_SETTER, null, new String[]{"newValue"}, new Object[]{"New value to be set."}, new String[]{"get" + refName});
                this.interfaceMethod("void", "set" + refName, new String[]{refType, "newValue"}, null);
            }
        } else if (ref.getMultiplicity().getUpper() != 0) {
            boolean isOrdered = ref.getMultiplicity().isOrdered();
            this.methodJavaDoc((ModelElement)ref, true, DOC_REFERENCE_GETTER, isOrdered ? "Value of reference {0}. Element type: '{'@link {1}'}'" : "Value of reference {0}. Element type: '{'@link {1}'}'", null, null, new String[]{refType});
            this.interfaceMethod(this.getTypeName((StructuralFeature)ref, 1), "get" + refName, null, null);
        }
    }

    protected void classProxyTemplate(MofClass objClass) throws IOException {
        ClassContents contents = this.getClassContents(objClass);
        this.interfaceHeader(this.tagProvider.getTypePrefix((ModelElement)objClass), this.tagProvider.getSubstName((ModelElement)objClass) + CLASS_POSTFIX, new String[]{"javax.jmi.reflect.RefClass"}, (ModelElement)objClass, DOC_CLASS_PROXY);
        if (!objClass.isAbstract()) {
            this.methodJavaDoc((ModelElement)objClass, false, DOC_CLASS_PROXY_CREATE, DOC_CLASS_PROXY_CREATE_RETURN, null, null, null);
            this.interfaceMethod(this.tagProvider.getSubstName((ModelElement)objClass), "create" + this.tagProvider.getSubstName((ModelElement)objClass), null, null);
            if (contents.allAttributes.size() > 0) {
                Object[] params = contents.allAttributes.toArray();
                Object[] paramsObjects = contents.allAttributesObjects.toArray();
                String[] paramsNames = new String[paramsObjects.length];
                for (int x = 0; x < paramsNames.length; ++x) {
                    paramsNames[x] = ((ModelElement)paramsObjects[x]).getName();
                }
                String name = this.tagProvider.getSubstName((ModelElement)objClass);
                this.methodJavaDoc((ModelElement)objClass, false, DOC_CLASS_PROXY_CREATE2, DOC_CLASS_PROXY_CREATE_RETURN, paramsNames, paramsObjects, null);
                this.interfaceMethod(this.tagProvider.getSubstName((ModelElement)objClass), "create" + name, params, null);
            }
        }
        Iterator it = contents.clsOperations.iterator();
        while (it.hasNext()) {
            this.operationTemplate(it.next());
        }
        it = contents.clsAttributes.iterator();
        while (it.hasNext()) {
            this.attributeTemplate(it.next());
        }
        it = contents.structures.iterator();
        while (it.hasNext()) {
            this.structTemplate(it.next());
        }
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objClass) + CLASS_POSTFIX);
    }

    protected void classInstanceTemplate(MofClass objClass) throws IOException {
        ClassContents contents = this.getClassContents(objClass);
        ArrayList<String> ancestors = new ArrayList<String>();
        List supertypes = objClass.getSupertypes();
        Iterator it = supertypes.iterator();
        while (it.hasNext()) {
            ancestors.add(this.tagProvider.getTypeFullName((ModelElement)it.next()));
        }
        if (ancestors.size() == 0) {
            ancestors.add("javax.jmi.reflect.RefObject");
        }
        this.interfaceHeader(this.tagProvider.getTypePrefix((ModelElement)objClass), this.tagProvider.getSubstName((ModelElement)objClass), ancestors.toArray(), (ModelElement)objClass, DOC_INSTANCE);
        it = contents.constants.iterator();
        while (it.hasNext()) {
            this.constantTemplate(it.next());
        }
        it = contents.instOperations.iterator();
        while (it.hasNext()) {
            this.operationTemplate(it.next());
        }
        it = contents.instAttributes.iterator();
        while (it.hasNext()) {
            this.attributeTemplate(it.next());
        }
        it = contents.instReferences.iterator();
        while (it.hasNext()) {
            this.referenceTemplate(it.next());
        }
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objClass));
    }

    private ClassContents getClassContents(MofClass cls) {
        if (this.cachedClassContents == null || this.cachedClassContents.objClass != cls) {
            this.cachedClassContents = new ClassContents(cls);
        }
        return this.cachedClassContents;
    }

    protected void associationTemplate(Association objAssociation) throws IOException {
        boolean ordered;
        boolean single;
        List contents = objAssociation.getContents();
        AssociationEnd[] ends = new AssociationEnd[2];
        int i = 0;
        Iterator it = contents.iterator();
        while (it.hasNext() && i < 2) {
            Object element = it.next();
            if (!(element instanceof AssociationEnd)) continue;
            ends[i++] = (AssociationEnd)element;
        }
        String end1Name = this.tagProvider.getSubstName((ModelElement)ends[0]);
        String end1Class = this.getTypeName(this.getAttrType((TypedElement)ends[0]));
        String end2Name = this.tagProvider.getSubstName((ModelElement)ends[1]);
        String end2Class = this.getTypeName(this.getAttrType((TypedElement)ends[1]));
        this.interfaceHeader(this.tagProvider.getTypePrefix((ModelElement)objAssociation), this.tagProvider.getSubstName((ModelElement)objAssociation), new String[]{"javax.jmi.reflect.RefAssociation"}, (ModelElement)objAssociation, DOC_ASSOC_PROXY);
        this.methodJavaDoc((ModelElement)objAssociation, false, DOC_ASSOC_EXISTS, DOC_ASSOC_EXISTS_RETURN, new String[]{end1Name, end2Name}, new Object[]{DOC_ASSOC_EXISTS_PARAM1, DOC_ASSOC_EXISTS_PARAM2}, null);
        this.interfaceMethod("boolean", "exists", new String[]{end1Class, end1Name, end2Class, end2Name}, null);
        if (ends[0].isNavigable()) {
            single = ends[0].getMultiplicity().getUpper() == 1;
            ordered = ends[0].getMultiplicity().isOrdered();
            this.methodJavaDoc((ModelElement)objAssociation, false, single ? DOC_ASSOC_GET_END1_SINGLE : (ordered ? "Queries the instance objects that are related to a particular instance object by a link in the current association's link set." : "Queries the instance objects that are related to a particular instance object by a link in the current association's link set."), single ? DOC_ASSOC_GET_END1_RETURN_SINGLE : (ordered ? DOC_ASSOC_GET_END1_RETURN_ORDERED : DOC_ASSOC_GET_END1_RETURN_MULTI), new String[]{end2Name}, new Object[]{DOC_ASSOC_GET_END2_PARAM}, null);
            this.interfaceMethod(single ? end1Class : (ordered ? "java.util.List" : "java.util.Collection"), "get" + JavaMapper.firstUpper(end1Name), new String[]{end2Class, end2Name}, null);
        }
        if (ends[1].isNavigable()) {
            single = ends[1].getMultiplicity().getUpper() == 1;
            ordered = ends[1].getMultiplicity().isOrdered();
            this.methodJavaDoc((ModelElement)objAssociation, false, single ? DOC_ASSOC_GET_END1_SINGLE : (ordered ? "Queries the instance objects that are related to a particular instance object by a link in the current association's link set." : "Queries the instance objects that are related to a particular instance object by a link in the current association's link set."), single ? DOC_ASSOC_GET_END1_RETURN_SINGLE : (ordered ? DOC_ASSOC_GET_END1_RETURN_ORDERED : DOC_ASSOC_GET_END1_RETURN_MULTI), new String[]{end1Name}, new Object[]{DOC_ASSOC_GET_END1_PARAM}, null);
            this.interfaceMethod(single ? end2Class : (ordered ? "java.util.List" : "java.util.Collection"), "get" + JavaMapper.firstUpper(end2Name), new String[]{end1Class, end1Name}, null);
        }
        if (ends[0].isChangeable() && ends[1].isChangeable()) {
            String[] names = new String[]{end1Name, end2Name};
            Object[] params = new Object[]{DOC_ASSOC_EXISTS_PARAM1, DOC_ASSOC_EXISTS_PARAM2};
            this.methodJavaDoc((ModelElement)objAssociation, false, DOC_ASSOC_ADD, null, names, params, null);
            this.interfaceMethod("boolean", "add", new String[]{end1Class, end1Name, end2Class, end2Name}, null);
            this.methodJavaDoc((ModelElement)objAssociation, false, DOC_ASSOC_REMOVE, null, names, params, null);
            this.interfaceMethod("boolean", "remove", new String[]{end1Class, end1Name, end2Class, end2Name}, null);
        }
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objAssociation));
    }

    protected void packageTemplate(MofPackage objPackage) throws IOException {
        ArrayList<String> ancestors = new ArrayList<String>();
        List supertypes = objPackage.getSupertypes();
        Iterator it = supertypes.iterator();
        while (it.hasNext()) {
            ancestors.add(this.tagProvider.getTypeFullName((ModelElement)it.next()) + PACKAGE_POSTFIX);
        }
        if (ancestors.size() == 0) {
            ancestors.add("javax.jmi.reflect.RefPackage");
        }
        this.interfaceHeader(this.tagProvider.getTypePrefix((ModelElement)objPackage), this.tagProvider.getSubstName((ModelElement)objPackage) + PACKAGE_POSTFIX, ancestors.toArray(), (ModelElement)objPackage, DOC_PACKAGE);
        ArrayList<ModelElement> nestedPackages = new ArrayList<ModelElement>();
        ArrayList<ModelElement> classes = new ArrayList<ModelElement>();
        ArrayList<ModelElement> associations = new ArrayList<ModelElement>();
        ArrayList<ModelElement> structureTypes = new ArrayList<ModelElement>();
        List elements = objPackage.getContents();
        Iterator it2 = elements.iterator();
        while (it2.hasNext()) {
            ModelElement element = (ModelElement)it2.next();
            if (element instanceof Association) {
                associations.add(element);
                continue;
            }
            if (element instanceof MofClass) {
                classes.add(element);
                continue;
            }
            if (element instanceof MofPackage) {
                nestedPackages.add(element);
                continue;
            }
            if (element instanceof StructureType) {
                structureTypes.add(element);
                continue;
            }
            if (!(element instanceof Import)) continue;
            Import imp = (Import)element;
            if (imp.isClustered() && VisibilityKindEnum.PUBLIC_VIS.equals((Object)imp.getVisibility())) {
                Namespace ns = imp.getImportedNamespace();
                if (!(ns instanceof MofPackage) || !VisibilityKindEnum.PUBLIC_VIS.equals((Object)((MofPackage)ns).getVisibility())) continue;
                String typeName = this.tagProvider.getTypeFullName((ModelElement)ns) + PACKAGE_POSTFIX;
                String elementName = this.tagProvider.getSubstName(element);
                this.interfaceMethod(typeName, "get" + elementName, null, null);
                continue;
            }
            Logger.getDefault().log("import: " + imp.getName() + " mofid: " + imp.refMofId() + " clustered: " + imp.isClustered() + " visibility: " + imp.getVisibility());
        }
        this.addProxyGetter(objPackage, nestedPackages, PACKAGE_POSTFIX);
        this.addProxyGetter(objPackage, classes, CLASS_POSTFIX);
        this.addProxyGetter(objPackage, associations, "");
        Iterator i = structureTypes.iterator();
        while (i.hasNext()) {
            this.structTemplate(i.next());
        }
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objPackage) + PACKAGE_POSTFIX);
    }

    void addProxyGetter(MofPackage objPackage, ArrayList list, String suffix) throws IOException {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            GeneralizableElement element = (GeneralizableElement)i.next();
            if (!VisibilityKindEnum.PUBLIC_VIS.equals((Object)element.getVisibility())) continue;
            String methodComment = null;
            String returnComment = null;
            if (element instanceof Import) {
                methodComment = DOC_PACKAGE_GET_IMPORT;
                returnComment = DOC_PACKAGE_GET_IMPORT_RETURN;
            } else if (element instanceof MofPackage) {
                methodComment = DOC_PACKAGE_GET_NESTED;
                returnComment = DOC_PACKAGE_GET_NESTED_RETURN;
            } else if (element instanceof MofClass) {
                methodComment = DOC_PACKAGE_GET_CLASS;
                returnComment = DOC_PACKAGE_GET_CLASS_RETURN;
            } else if (element instanceof Association) {
                methodComment = DOC_PACKAGE_GET_ASSOC;
                returnComment = DOC_PACKAGE_GET_ASSOC_RETURN;
            }
            String typeName = this.tagProvider.getTypeFullName((ModelElement)element);
            String elementName = this.tagProvider.getSubstName((ModelElement)element);
            if (methodComment != null) {
                this.methodJavaDoc((ModelElement)objPackage, false, methodComment, returnComment, null, null, new String[]{elementName});
            }
            this.interfaceMethod(typeName + suffix, "get" + elementName, null, null);
        }
    }

    protected void exceptionTemplate(MofException objException) throws IOException {
        String typeName;
        String getterName;
        String paramName;
        List contents = objException.getContents();
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Parameter> paramsObjects = new ArrayList<Parameter>();
        ArrayList<String> paramsNames = new ArrayList<String>();
        ArrayList<String> codeConstr = new ArrayList<String>();
        StringBuffer paramsConstr = new StringBuffer(100);
        StringBuffer codeMsg = new StringBuffer(100);
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof Parameter)) continue;
            Parameter param = (Parameter)element;
            paramsObjects.add(param);
            params.add(this.getTypeName(param, 1));
            paramName = JavaMapper.firstLower(this.tagProvider.getSubstName((ModelElement)param));
            paramsNames.add(paramName);
            params.add(JavaMapper.removeUnderscores(paramName));
            getterName = paramName;
            if (param.getType() instanceof PrimitiveType && param.getType().getName().equals("Boolean")) {
                if (getterName.indexOf("is") != 0) {
                    getterName = "is_" + getterName;
                }
            } else {
                getterName = "get_" + getterName;
            }
            params.add(JavaMapper.removeUnderscores(getterName));
        }
        String exceptionName = this.tagProvider.getSubstName((ModelElement)objException);
        this.classHeader(this.tagProvider.getTypePrefix((ModelElement)objException), exceptionName, new Object[]{"javax.jmi.reflect.RefException"}, null, false, (ModelElement)objException, DOC_EXCEPTION);
        Iterator it2 = params.iterator();
        while (it2.hasNext()) {
            typeName = (String)it2.next();
            paramName = (String)it2.next();
            this.generate("private final " + typeName + " " + paramName + ";");
            codeConstr.add("this." + paramName + " = " + paramName + ";");
            paramsConstr.append(", " + typeName + " " + paramName);
            getterName = paramName + ": \" + " + paramName;
            if (codeMsg.length() == 0) {
                codeMsg.append("\"" + getterName);
            } else {
                codeMsg.append(" + \", " + getterName);
            }
            it2.next();
        }
        this.methodJavaDoc((ModelElement)objException, false, DOC_EXCEPTION_CONSTRUCTOR, null, paramsNames.toArray(new String[0]), paramsObjects.toArray(), null);
        this.generate("public " + exceptionName + "(" + (paramsConstr.length() == 0 ? "" : paramsConstr.toString().substring(2)) + ") {");
        this.indent();
        this.generate("super(" + codeMsg.toString() + ");");
        it2 = codeConstr.iterator();
        while (it2.hasNext()) {
            this.generate((String)it2.next());
        }
        this.unindent();
        this.generate("}");
        it2 = params.iterator();
        while (it2.hasNext()) {
            typeName = (String)it2.next();
            paramName = (String)it2.next();
            getterName = (String)it2.next();
            this.methodJavaDoc((ModelElement)objException, false, DOC_EXCEPTION_GETTER, DOC_EXCEPTION_GETTER_RETURN, null, null, new String[]{paramName});
            this.generate("public " + typeName + " " + getterName + "() {");
            this.indent();
            this.generate("return " + paramName + ";");
            this.unindent();
            this.generate("}");
        }
        this.classFooter(exceptionName, false);
    }

    protected void enumerationInterfaceTemplate(EnumerationType objEnumeration) throws IOException {
        String packageName = this.tagProvider.getTypePrefix((ModelElement)objEnumeration);
        String ifcName = this.tagProvider.getSubstName((ModelElement)objEnumeration);
        this.interfaceHeader(packageName, ifcName, new Object[]{"javax.jmi.reflect.RefEnum"}, (ModelElement)objEnumeration, DOC_ENUM_INTERFACE);
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objEnumeration));
    }

    protected void enumerationClassTemplate(EnumerationType objEnumeration) throws IOException {
        String literal;
        String packageName = this.tagProvider.getTypePrefix((ModelElement)objEnumeration);
        String ifcName = this.tagProvider.getSubstName((ModelElement)objEnumeration);
        String clsName = ifcName + ENUM_POSTFIX;
        List literals = objEnumeration.getLabels();
        this.classHeader(packageName, clsName, new Object[0], new Object[]{ifcName}, false, true, (ModelElement)objEnumeration, DOC_ENUM_CLASS);
        Iterator it = literals.iterator();
        while (it.hasNext()) {
            literal = (String)it.next();
            this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_LITERAL, null, null, null, new String[]{literal});
            this.generate("public static final " + clsName + " " + TagProvider.mapEnumLiteral(literal) + " = new " + clsName + "(\"" + literal + "\");");
        }
        this.newLine();
        this.generate("private static final java.util.List typeName;");
        this.generate("private final java.lang.String literalName;");
        this.newLine();
        this.generate("static {");
        this.indent();
        this.generate("java.util.ArrayList temp = new java.util.ArrayList();");
        String enumFQN = "";
        Iterator it2 = objEnumeration.getQualifiedName().iterator();
        while (it2.hasNext()) {
            String fqnElement = (String)it2.next();
            this.generate("temp.add(\"" + fqnElement + "\");");
            enumFQN = enumFQN + fqnElement + (it2.hasNext() ? "." : "");
        }
        this.generate("typeName = java.util.Collections.unmodifiableList(temp);");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.generate("private " + clsName + "(java.lang.String literalName) {");
        this.indent();
        this.generate("this.literalName = literalName;");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_REFTYPENAME, DOC_ENUM_REFTYPENAME_RETURN, null, null, null);
        this.generate("public java.util.List refTypeName() {");
        this.indent();
        this.generate("return typeName;");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_TOSTRING, DOC_ENUM_TOSTRING_RETURN, null, null, null);
        this.generate("public java.lang.String toString() {");
        this.indent();
        this.generate("return literalName;");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_HASHCODE, DOC_ENUM_HASHCODE_RETURN, null, null, null);
        this.generate("public int hashCode() {");
        this.indent();
        this.generate("return literalName.hashCode();");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_EQUALS, DOC_ENUM_EQUALS_RETURN, new String[]{"o"}, new Object[]{DOC_ENUM_EQUALS_PARAM}, null);
        this.generate("public boolean equals(java.lang.Object o) {");
        this.indent();
        this.generate("if (o instanceof " + clsName + ") return (o == this);");
        this.generate("else if (o instanceof " + ifcName + ") return (o.toString().equals(literalName));");
        this.generate("else return ((o instanceof javax.jmi.reflect.RefEnum) && ((javax.jmi.reflect.RefEnum) o).refTypeName().equals(typeName) && o.toString().equals(literalName));");
        this.unindent();
        this.generate("}");
        this.newLine();
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_FORNAME, DOC_ENUM_FORNAME_RETURN, new String[]{"name"}, new Object[]{DOC_ENUM_FORNAME_PARAM}, null);
        this.generate("public static " + ifcName + " forName(java.lang.String name) {");
        this.indent();
        it2 = literals.iterator();
        while (it2.hasNext()) {
            literal = (String)it2.next();
            this.generate("if (name.equals(\"" + literal + "\")) return " + TagProvider.mapEnumLiteral(literal) + ";");
        }
        this.generate("throw new java.lang.IllegalArgumentException(\"Unknown literal name '\" + name + \"' for enumeration '" + enumFQN + "'\");");
        this.unindent();
        this.generate("}");
        this.methodJavaDoc((ModelElement)objEnumeration, false, DOC_ENUM_READRESOLVE, DOC_ENUM_READRESOLVE_RETURN, null, null, null);
        this.generate("protected java.lang.Object readResolve() throws java.io.ObjectStreamException {");
        this.indent();
        this.generate("try {");
        this.indent();
        this.generate("return forName(literalName);");
        this.unindent();
        this.generate("} catch (java.lang.IllegalArgumentException e) {");
        this.indent();
        this.generate("throw new java.io.InvalidObjectException(e.getMessage());");
        this.unindent();
        this.generate("}");
        this.unindent();
        this.generate("}");
        this.classFooter(ifcName, false);
    }

    protected void structureTemplate(StructureType objStructure) throws IOException {
        this.interfaceHeader(this.tagProvider.getTypePrefix((ModelElement)objStructure), this.tagProvider.getSubstName((ModelElement)objStructure), new Object[]{"javax.jmi.reflect.RefStruct"}, (ModelElement)objStructure, DOC_STRUCT);
        List fields = objStructure.getContents();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            String memberName;
            ModelElement field = (ModelElement)it.next();
            if (!(field instanceof StructureField)) continue;
            Classifier fieldType = ((StructureField)field).getType();
            String fieldName = memberName = JavaMapper.firstUpper(this.tagProvider.getSubstName(field));
            memberName = fieldType instanceof PrimitiveType && fieldType.getName().equals("Boolean") ? (memberName.indexOf("Is") != 0 ? "is" + memberName : JavaMapper.firstLower(memberName)) : "get" + memberName;
            this.methodJavaDoc((ModelElement)objStructure, false, DOC_STRUCT_GETTER, DOC_STRUCT_GETTER_RETURN, null, null, new String[]{fieldName});
            this.interfaceMethod(this.getPrimitiveName(this.getTypeName(fieldType)), memberName, null, null);
        }
        this.interfaceFooter(this.tagProvider.getSubstName((ModelElement)objStructure));
    }

    void structTemplate(Object objStructure) throws IOException {
        DataType dataType = (DataType)objStructure;
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<ModelElement> structureFields = new ArrayList<ModelElement>();
        ArrayList<String> paramNames = new ArrayList<String>();
        List fields = dataType.getContents();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            ModelElement field = (ModelElement)it.next();
            if (!(field instanceof StructureField)) continue;
            parameters.add(this.getTypeName2((TypedElement)((StructureField)field)));
            String name = this.tagProvider.getSubstName(field);
            parameters.add(name);
            paramNames.add(name);
            structureFields.add(field);
        }
        Object[] params = new String[parameters.size()];
        params = parameters.toArray(params);
        int size = structureFields.size();
        Object[] structFields = new Object[size];
        String[] parNames = new String[size];
        structFields = structureFields.toArray(structFields);
        parNames = paramNames.toArray(parNames);
        this.methodJavaDoc((ModelElement)dataType, false, DOC_STRUCT_CREATE, DOC_STRUCT_CREATE_RETURN, parNames, structFields, null);
        this.interfaceMethod(this.tagProvider.getTypeFullName((ModelElement)dataType), "create" + JavaMapper.firstUpper(this.tagProvider.getSubstName((ModelElement)dataType)), params, null);
    }

    private void classJavaDoc(ModelElement elem, String genericComment) throws IOException {
        this.generate("/**");
        if (genericComment != null) {
            this.javaDoc(MessageFormat.format(genericComment, elem.getName()));
        }
        this.javaDoc(elem.getAnnotation());
        this.javaDoc(" ");
        this.javaDoc(DOC_WARNING);
        this.generate(" */");
    }

    private void fieldJavaDoc(ModelElement elem) throws IOException {
        this.generate("/**");
        this.javaDoc(elem.getAnnotation());
        this.generate(" */");
    }

    private void methodJavaDoc(ModelElement elem, boolean annotate, String genericComment, Object retValDescriptor, String[] args, Object[] argDescriptors, String[] variables) throws IOException {
        String text;
        int x;
        Object[] vars = variables == null ? new String[1] : new String[variables.length + 1];
        vars[0] = elem.getName();
        if (variables != null) {
            for (x = 0; x < variables.length; ++x) {
                vars[x + 1] = variables[x];
            }
        }
        this.generate("/**");
        if (genericComment != null) {
            this.javaDoc(MessageFormat.format(genericComment, vars));
        }
        if (annotate) {
            this.javaDoc(elem.getAnnotation());
        }
        if (args != null) {
            for (x = 0; x < args.length; ++x) {
                if (argDescriptors[x] instanceof ModelElement) {
                    text = ((ModelElement)argDescriptors[x]).getAnnotation();
                } else {
                    text = (String)argDescriptors[x];
                    if (text != null) {
                        text = MessageFormat.format(text, vars);
                    }
                }
                if (text == null) continue;
                this.javaDoc("@param " + args[x] + " " + text);
            }
        }
        if (retValDescriptor instanceof ModelElement) {
            text = elem.getAnnotation();
        } else {
            text = (String)retValDescriptor;
            if (text != null) {
                text = MessageFormat.format(text, vars);
            }
        }
        if (text != null) {
            this.javaDoc("@return " + text);
        }
        this.generate(" */");
    }

    private void javaDoc(String text) throws IOException {
        if (text == null) {
            return;
        }
        int MAX_LINE_LENGTH = 70;
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = reader.readLine();
        while (line != null) {
            int length = line.length();
            int pos = 0;
            while (pos < length) {
                String s;
                if (length - pos <= 70) {
                    s = line.substring(pos);
                    pos = length;
                } else {
                    int pos2;
                    for (pos2 = pos + 70; pos2 < length && !Character.isWhitespace(text.charAt(pos2)); ++pos2) {
                    }
                    while (pos2 < length && Character.isWhitespace(text.charAt(pos2))) {
                        ++pos2;
                    }
                    s = line.substring(pos, pos2);
                    pos = pos2;
                }
                this.generate(" * " + s);
            }
            line = reader.readLine();
        }
    }

    public JavaMapper(JMIStreamFactory sf, String header) {
        this.generator = sf;
        if (header != null && header.trim().length() > 0) {
            this.header = "/*\n";
            StringTokenizer tokenizer = new StringTokenizer(header, "\n");
            while (tokenizer.hasMoreTokens()) {
                this.header = this.header + " * " + tokenizer.nextToken() + "\n";
            }
            this.header = this.header + " */";
        }
    }

    private final class ClassContents {
        final Collection instAttributes = new ArrayList();
        final Collection instOperations = new ArrayList();
        final Collection instReferences = new ArrayList();
        final Collection clsAttributes = new ArrayList();
        final Collection clsOperations = new ArrayList();
        final Collection allAttributes = new ArrayList();
        final Collection allAttributesObjects = new ArrayList();
        final Collection constants = new ArrayList();
        final Collection enumerations = new ArrayList();
        final Collection structures = new ArrayList();
        final MofClass objClass;

        private ClassContents(MofClass objClass) {
            Feature feature;
            ModelElement element;
            this.objClass = objClass;
            List elements = objClass.getContents();
            ContainsIterator it = elements.iterator();
            while (it.hasNext()) {
                element = (ModelElement)it.next();
                if (element instanceof Constant) {
                    this.constants.add(element);
                    continue;
                }
                if (element instanceof Feature) {
                    feature = (Feature)element;
                    if (!feature.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
                    if (feature instanceof Attribute) {
                        if (!feature.getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) continue;
                        this.instAttributes.add(feature);
                        continue;
                    }
                    if (feature instanceof Operation) {
                        if (!feature.getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) continue;
                        this.instOperations.add(feature);
                        continue;
                    }
                    if (!(feature instanceof Reference)) continue;
                    this.instReferences.add(feature);
                    continue;
                }
                if (element instanceof EnumerationType) {
                    this.enumerations.add(element);
                    continue;
                }
                if (!(element instanceof StructureType)) continue;
                this.structures.add(element);
            }
            it = new ContainsIterator((GeneralizableElement)objClass);
            while (it.hasNext()) {
                element = (ModelElement)it.next();
                if (element instanceof Attribute) {
                    feature = (Attribute)element;
                    if (feature.getScope().equals(ScopeKindEnum.CLASSIFIER_LEVEL)) {
                        this.clsAttributes.add(feature);
                        continue;
                    }
                    if (((Attribute)feature).isDerived()) continue;
                    this.allAttributes.add(JavaMapper.this.getTypeName((StructuralFeature)((Attribute)feature), 1));
                    this.allAttributes.add(JavaMapper.this.tagProvider.getSubstName((ModelElement)feature));
                    this.allAttributesObjects.add(feature);
                    continue;
                }
                if (!(element instanceof Operation) || !(feature = (Operation)element).getScope().equals(ScopeKindEnum.CLASSIFIER_LEVEL)) continue;
                this.clsOperations.add(feature);
            }
        }
    }
}

