/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;

public class InstallerRegistry {
    static final String INSTALLER_REGISTRY_FOLDER = "org-netbeans-api-java/platform/installers";
    static Reference defaultInstance;
    private Provider provider;
    private List platformInstalls;
    static final /* synthetic */ boolean $assertionsDisabled;

    InstallerRegistry(FileObject registryResource) {
        if (!$assertionsDisabled && registryResource == null) {
            throw new AssertionError();
        }
        this.provider = new Provider(registryResource);
    }

    InstallerRegistry(GeneralPlatformInstall[] platformInstalls) {
        if (!$assertionsDisabled && platformInstalls == null) {
            throw new AssertionError();
        }
        this.platformInstalls = Arrays.asList(platformInstalls);
    }

    public List getInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), PlatformInstall.class);
    }

    public List getCustomInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), CustomPlatformInstall.class);
    }

    public List getAllInstallers() {
        if (this.platformInstalls != null) {
            return this.platformInstalls;
        }
        Object o = Collections.EMPTY_LIST;
        try {
            if (!$assertionsDisabled && this.provider == null) {
                throw new AssertionError();
            }
            o = this.provider.instanceCreate();
        }
        catch (IOException ex) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return o;
    }

    public static InstallerRegistry getDefault() {
        Object o = defaultInstance.get();
        if (o != null) {
            return (InstallerRegistry)o;
        }
        o = new InstallerRegistry(Repository.getDefault().getDefaultFileSystem().findResource(INSTALLER_REGISTRY_FOLDER));
        defaultInstance = new WeakReference(o);
        return (InstallerRegistry)o;
    }

    static InstallerRegistry prepareForUnitTest(GeneralPlatformInstall[] platformInstalls) {
        InstallerRegistry regs = new InstallerRegistry(platformInstalls);
        defaultInstance = new WeakReference<InstallerRegistry>(regs);
        return regs;
    }

    private static List filter(List list, Class clazz) {
        ArrayList result = new ArrayList(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!clazz.isInstance(item)) continue;
            result.add(item);
        }
        return result;
    }

    static {
        $assertionsDisabled = !InstallerRegistry.class.desiredAssertionStatus();
        defaultInstance = new WeakReference<Object>(null);
    }

    private static class Provider
    extends FolderInstance {
        Provider(FileObject registryResource) {
            super(DataFolder.findFolder((FileObject)registryResource));
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            ArrayList<Object> installers = new ArrayList<Object>(cookies.length);
            for (int i = 0; i < cookies.length; ++i) {
                InstanceCookie cake = cookies[i];
                Object o = null;
                try {
                    if (cake instanceof InstanceCookie.Of && !((InstanceCookie.Of)cake).instanceOf(class$org$netbeans$spi$java$platform$PlatformInstall == null ? InstallerRegistry.class$("org.netbeans.spi.java.platform.PlatformInstall") : class$org$netbeans$spi$java$platform$PlatformInstall) && !((InstanceCookie.Of)cake).instanceOf(class$org$netbeans$spi$java$platform$CustomPlatformInstall == null ? InstallerRegistry.class$("org.netbeans.spi.java.platform.CustomPlatformInstall") : class$org$netbeans$spi$java$platform$CustomPlatformInstall)) continue;
                    o = cake.instanceCreate();
                }
                catch (IOException ex) {
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (o == null) continue;
                installers.add(o);
            }
            return installers;
        }
    }
}

