/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.netbeans.lib.ddl.CheckConstraintDescriptor;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.TableColumnDescriptor;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.AbstractTableColumn;

public class TableColumn
extends AbstractTableColumn
implements Serializable,
TableColumnDescriptor,
CheckConstraintDescriptor {
    public static final String COLUMN = "COLUMN";
    public static final String CHECK = "CHECK";
    public static final String UNIQUE = "UNIQUE";
    public static final String PRIMARY_KEY = "PRIMARY_KEY";
    public static final String FOREIGN_KEY = "FOREIGN_KEY";
    public static final String CHECK_CONSTRAINT = "CHECK_CONSTRAINT";
    public static final String UNIQUE_CONSTRAINT = "UNIQUE_CONSTRAINT";
    public static final String PRIMARY_KEY_CONSTRAINT = "PRIMARY_KEY_CONSTRAINT";
    public static final String FOREIGN_KEY_CONSTRAINT = "FOREIGN_KEY_CONSTRAINT";
    int type;
    int size = 0;
    int decsize = 0;
    boolean nullable = true;
    String defval;
    String checke;
    Vector constraintColumns;
    static final long serialVersionUID = 4298150043758715392L;

    public int getColumnType() {
        return this.type;
    }

    public void setColumnType(int columnType) {
        this.type = columnType;
    }

    public int getColumnSize() {
        return this.size;
    }

    public void setColumnSize(int csize) {
        this.size = csize;
    }

    public int getDecimalSize() {
        return this.decsize;
    }

    public void setDecimalSize(int dsize) {
        this.decsize = dsize;
    }

    public boolean isNullAllowed() {
        return this.nullable;
    }

    public void setNullAllowed(boolean flag) {
        this.nullable = flag;
    }

    public String getDefaultValue() {
        return this.defval;
    }

    public void setDefaultValue(String val) {
        this.defval = val;
    }

    public String getCheckCondition() {
        return this.checke;
    }

    public void setCheckCondition(String val) {
        this.checke = val;
    }

    public Vector getTableConstraintColumns() {
        return this.constraintColumns;
    }

    public void setTableConstraintColumns(Vector columns) {
        this.constraintColumns = columns;
    }

    public Map getColumnProperties(AbstractCommand cmd) throws DDLException {
        Map dbTypePrefixSuffix;
        String qdefval;
        DatabaseSpecification spec = cmd.getSpecification();
        Map args = super.getColumnProperties(cmd);
        String stype = spec.getType(this.type);
        Vector charactertypes = (Vector)spec.getProperties().get("CharacterTypes");
        String strdelim = (String)spec.getProperties().get("StringDelimiter");
        Vector sizelesstypes = (Vector)spec.getProperties().get("SizelessTypes");
        String coldelim = (String)spec.getProperties().get("ArgumentListDelimiter");
        if (sizelesstypes != null && this.size > 0 && !sizelesstypes.contains(stype)) {
            if (this.size > 0) {
                args.put("column.size", String.valueOf(this.size));
            }
            if (this.decsize > 0) {
                args.put("column.decsize", String.valueOf(this.decsize));
            }
        }
        if (!((qdefval = this.defval) == null || !charactertypes.contains(spec.getType(this.type)) || qdefval.startsWith(strdelim) || qdefval.endsWith(strdelim) || qdefval.startsWith("(" + strdelim) || qdefval.endsWith(strdelim + ")"))) {
            qdefval = strdelim + this.defval + strdelim;
        }
        String dbType = spec.getType(this.type);
        String dbTypeSuffix = null;
        Map suffixTypeMap = (Map)spec.getProperties().get("TypePrefixSuffixMap");
        if (suffixTypeMap != null && (dbTypePrefixSuffix = (Map)suffixTypeMap.get(dbType)) != null) {
            dbType = (String)dbTypePrefixSuffix.get("Prefix");
            dbTypeSuffix = (String)dbTypePrefixSuffix.get("Suffix");
        }
        args.put("column.type", dbType);
        if (dbTypeSuffix != null) {
            args.put("column.type.suffix", dbTypeSuffix);
        }
        if (!this.nullable) {
            args.put("column.notnull", "");
        }
        if (!(!this.nullable && qdefval != null && (qdefval.equalsIgnoreCase("null") || qdefval.equalsIgnoreCase("'null'") || qdefval.equalsIgnoreCase("\"null\"")) || this.defval == null || this.defval.equals(""))) {
            args.put("default.value", qdefval);
        }
        if (this.checke != null) {
            args.put("check.condition", this.checke);
        }
        if (this.constraintColumns != null) {
            String cols = "";
            Enumeration col_e = this.constraintColumns.elements();
            while (col_e.hasMoreElements()) {
                Object zrus = col_e.nextElement();
                Hashtable col = (Hashtable)zrus;
                boolean inscomma = col_e.hasMoreElements();
                cols = cols + cmd.quote((String)col.get("name")) + (inscomma ? coldelim : "");
            }
            args.put("constraint.columns", cols);
        }
        return args;
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObject(in);
        this.type = in.readInt();
        this.size = in.readInt();
        this.decsize = in.readInt();
        this.nullable = in.readBoolean();
        this.defval = (String)in.readObject();
        this.checke = (String)in.readObject();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.type);
        out.writeInt(this.size);
        out.writeInt(this.decsize);
        out.writeBoolean(this.nullable);
        out.writeObject(this.defval);
        out.writeObject(this.checke);
    }
}

