/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.CDATASectionImpl;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.DocumentTypeImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.ErrorManager;

public class XMLDocumentModelProvider
implements DocumentModelProvider {
    public static final String XML_TAG = "tag";
    public static final String XML_EMPTY_TAG = "empty_tag";
    public static final String XML_CONTENT = "content";
    public static final String XML_PI = "pi";
    public static final String XML_CDATA = "cdata";
    public static final String XML_DOCTYPE = "doctype";
    public static final String XML_COMMENT = "comment";
    public static final String XML_ERROR = "error";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.measure");

    public void updateModel(DocumentModel.DocumentModelModificationTransaction dtm, DocumentModel model, DocumentModel.DocumentChange[] changes) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        long a = System.currentTimeMillis();
        if (debug) {
            System.out.println("\n\n\n\n\n");
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure((DocumentElement)model.getRootElement());
        }
        ArrayList<DocumentElement> regenerate = new ArrayList<DocumentElement>();
        for (int i = 0; i < changes.length; ++i) {
            DocumentElement toRegenerate;
            DocumentElement leaf;
            int changeOffset;
            block37: {
                DocumentModel.DocumentChange dch = changes[i];
                changeOffset = dch.getChangeStart().getOffset();
                int changeLength = dch.getChangeLength();
                toRegenerate = leaf = model.getLeafElementForOffset(changeOffset);
                if (debug) {
                    System.out.println("");
                }
                if (debug) {
                    System.out.println(dch);
                }
                try {
                    if (debug) {
                        System.out.println("inserted text:'" + model.getDocument().getText(changeOffset, changeLength) + "'");
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("leaf = " + leaf);
                }
                XMLSyntaxSupport sup = (XMLSyntaxSupport)((BaseDocument)model.getDocument()).getSyntaxSupport();
                boolean textOnly = false;
                boolean attribsOnly = false;
                try {
                    for (TokenItem ti = sup.getTokenChain(changeOffset, changeOffset + 1); ti != null && ti.getOffset() < changeOffset + changeLength; ti = ti.getNext()) {
                        if (ti.getTokenID() == XMLTokenIDs.TEXT || ti.getTokenID() == XMLTokenIDs.DECLARATION || ti.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || ti.getTokenID() == XMLTokenIDs.PI_CONTENT || ti.getTokenID() == XMLTokenIDs.CDATA_SECTION) {
                            textOnly = true;
                        } else {
                            if (ti.getTokenID() != XMLTokenIDs.ARGUMENT && ti.getTokenID() != XMLTokenIDs.OPERATOR && ti.getTokenID() != XMLTokenIDs.VALUE) continue;
                            attribsOnly = true;
                        }
                        break;
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
                if (textOnly && (leaf.getType().equals(XML_CONTENT) || leaf.getType().equals(XML_DOCTYPE) || leaf.getType().equals(XML_PI) || leaf.getType().equals(XML_COMMENT) || leaf.getType().equals(XML_CDATA))) {
                    if (debug) {
                        System.out.println("ONLY CONTENT UPDATE!!!");
                    }
                    dtm.updateDocumentElementText(leaf);
                    if (dch.getChangeLength() == 1) continue;
                }
                if ((attribsOnly || dch.getChangeType() == 1) && (leaf.getType().equals(XML_TAG) || leaf.getType().equals(XML_EMPTY_TAG))) {
                    if (debug) {
                        System.out.println("POSSIBLE ATTRIBS UPDATE!!!");
                    }
                    try {
                        SyntaxElement sel = sup.getElementChain(leaf.getStartOffset() + 1);
                        if (!(sel instanceof Tag) && !(sel instanceof EmptyTag)) break block37;
                        Map newAttrs = this.createAttributesMap((Tag)sel);
                        AttributeSet existing = leaf.getAttributes();
                        boolean update = false;
                        if (existing.getAttributeCount() == newAttrs.size()) {
                            for (String attrName : newAttrs.keySet()) {
                                String attrValue = (String)newAttrs.get(attrName);
                                if (attrName == null || attrValue == null || existing.containsAttribute(attrName, attrValue)) continue;
                                update = true;
                                break;
                            }
                        } else {
                            update = true;
                        }
                        if (update) {
                            dtm.updateDocumentElementAttribs(leaf, newAttrs);
                        }
                    }
                    catch (BadLocationException ble) {
                        ErrorManager.getDefault().notify(16, (Throwable)ble);
                    }
                }
            }
            if (leaf.getStartOffset() == leaf.getEndOffset() || changeOffset == leaf.getStartOffset() || changeOffset == leaf.getEndOffset()) {
                toRegenerate = leaf.getParentElement();
            } else if (leaf.getType().equals(XML_CONTENT)) {
                while ((toRegenerate = toRegenerate.getParentElement()) != null && toRegenerate.getType().equals(XML_CONTENT)) {
                }
                if (toRegenerate == null) {
                    toRegenerate = model.getRootElement();
                }
            }
            if (toRegenerate == null) {
                toRegenerate = model.getRootElement();
            }
            Iterator itr = regenerate.iterator();
            boolean hasAncestor = false;
            while (itr.hasNext()) {
                DocumentElement de = (DocumentElement)itr.next();
                if (!de.equals((Object)toRegenerate) && !model.isDescendantOf(de, toRegenerate)) continue;
                hasAncestor = true;
                break;
            }
            if (hasAncestor) continue;
            ArrayList<DocumentElement> toRemove = new ArrayList<DocumentElement>();
            for (DocumentElement de : regenerate) {
                if (!model.isDescendantOf(toRegenerate, de)) continue;
                toRemove.add(de);
            }
            regenerate.removeAll(toRemove);
            regenerate.add(toRegenerate);
            if (debug) {
                System.out.println("===================================================================");
            }
            if (debug) {
                System.out.println("change happened in " + leaf);
            }
            if (!debug) continue;
            System.out.println("we will regenerate its parent " + toRegenerate);
        }
        for (DocumentElement de : regenerate) {
            this.generateDocumentElements(dtm, model, de);
        }
        if (measure) {
            System.out.println("[xmlmodel] generated in " + (System.currentTimeMillis() - a));
        }
    }

    private void generateDocumentElements(DocumentModel.DocumentModelModificationTransaction dtm, DocumentModel model, DocumentElement de) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        int startOffset = de.getStartOffset();
        int endOffset = de.getEndOffset();
        BaseDocument doc = (BaseDocument)model.getDocument();
        XMLSyntaxSupport sup = new XMLSyntaxSupport(doc);
        if (debug) {
            System.out.println("[XMLDocumentModelProvider] regenerating " + de);
        }
        ArrayList<DocumentElement> addedElements = new ArrayList<DocumentElement>();
        ArrayList<DocumentElement> skipped = new ArrayList<DocumentElement>();
        try {
            Stack<SyntaxElement> elementsStack = new Stack<SyntaxElement>();
            SyntaxElement sel = sup.getElementChain(Math.min(doc.getLength(), startOffset + 1));
            while (sel != null && this.getSyntaxElementEndOffset(sel) <= endOffset) {
                String nodeName;
                if (sel instanceof SyntaxElement.Error) {
                    if (debug) {
                        System.out.println("Error found! => adding error element.");
                    }
                    String errorText = doc.getText(sel.getElementOffset(), sel.getElementLength());
                    addedElements.add(dtm.addDocumentElement(errorText, XML_ERROR, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                }
                if (sel instanceof StartTag) {
                    SyntaxElement endTagCheck;
                    StartTag stag = (StartTag)sel;
                    DocumentElement tagDE = DocumentModelUtils.findElement((DocumentModel)model, (int)sel.getElementOffset(), (String)stag.getTagName(), (String)XML_TAG);
                    if (tagDE != null && !tagDE.equals((Object)de) && (endTagCheck = sup.getElementChain(Math.min(doc.getLength(), tagDE.getEndOffset() + 1))) instanceof EndTag && ((EndTag)endTagCheck).getTagName().equals(stag.getTagName())) {
                        if (debug) {
                            System.out.println("found existing element " + tagDE + " => skipping");
                        }
                        sel = endTagCheck.getNext();
                        skipped.add(tagDE);
                        continue;
                    }
                    elementsStack.push(sel);
                } else if (sel instanceof EndTag) {
                    if (!elementsStack.isEmpty()) {
                        StartTag latest = (StartTag)elementsStack.peek();
                        if (((EndTag)sel).getTagName().equals(latest.getTagName())) {
                            Map attribs = this.createAttributesMap(latest);
                            addedElements.add(dtm.addDocumentElement(latest.getTagName(), XML_TAG, attribs, latest.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            elementsStack.pop();
                        } else {
                            ArrayList<SyntaxElement> savedElements = new ArrayList<SyntaxElement>();
                            boolean foundStartTag = false;
                            while (!elementsStack.isEmpty()) {
                                SyntaxElement s = (SyntaxElement)elementsStack.pop();
                                savedElements.add(s);
                                Tag start = (Tag)s;
                                Tag end = (Tag)sel;
                                if (!(s instanceof StartTag) || !start.getTagName().equals(end.getTagName())) continue;
                                Map attribs = this.createAttributesMap((StartTag)s);
                                addedElements.add(dtm.addDocumentElement(start.getTagName(), XML_TAG, attribs, start.getElementOffset(), this.getSyntaxElementEndOffset(end)));
                                foundStartTag = true;
                                break;
                            }
                            if (!foundStartTag) {
                                for (int i = savedElements.size() - 1; i >= 0; --i) {
                                    elementsStack.push((SyntaxElement)savedElements.get(i));
                                }
                            }
                        }
                    }
                } else if (sel instanceof EmptyTag) {
                    Map attribs = this.createAttributesMap((Tag)sel);
                    addedElements.add(dtm.addDocumentElement(((EmptyTag)sel).getTagName(), XML_EMPTY_TAG, attribs, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                } else if (sel instanceof CDATASectionImpl) {
                    addedElements.add(dtm.addDocumentElement(XML_CDATA, XML_CDATA, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                } else if (sel instanceof ProcessingInstructionImpl) {
                    nodeName = ((ProcessingInstructionImpl)sel).getNodeName();
                    if (nodeName != null) {
                        addedElements.add(dtm.addDocumentElement(nodeName, XML_PI, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                    }
                } else if (sel instanceof DocumentTypeImpl) {
                    nodeName = ((DocumentTypeImpl)sel).getName();
                    if (nodeName != null) {
                        addedElements.add(dtm.addDocumentElement(nodeName, XML_DOCTYPE, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                    }
                } else if (sel instanceof CommentImpl) {
                    addedElements.add(dtm.addDocumentElement(XML_COMMENT, XML_COMMENT, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                } else {
                    addedElements.add(dtm.addDocumentElement("...", XML_CONTENT, Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                }
                try {
                    SyntaxElement prev = null;
                    int add = 0;
                    while ((prev = sup.getElementChain(sel.getElementOffset() + sel.getElementLength() + ++add)) != null && sel.getElementOffset() >= prev.getElementOffset()) {
                    }
                    sel = prev;
                }
                catch (BadLocationException ble) {
                    sel = null;
                }
            }
            List existingElements = this.getDescendantsOfNotSkippedElements(de, skipped);
            existingElements.add(de);
            for (DocumentElement d : existingElements) {
                if (addedElements.contains(d)) continue;
                dtm.removeDocumentElement(d, false);
                if (!debug) continue;
                System.out.println("[xml model] removed element " + d);
            }
        }
        catch (BadLocationException e) {
            throw new DocumentModelException("Error occurred during generation of Document elements", (Throwable)e);
        }
    }

    private List getDescendantsOfNotSkippedElements(DocumentElement de, List skippedElements) {
        ArrayList<DocumentElement> desc = new ArrayList<DocumentElement>();
        for (DocumentElement child : de.getChildren()) {
            if (skippedElements.contains(child)) continue;
            desc.add(child);
            desc.addAll(this.getDescendantsOfNotSkippedElements(child, skippedElements));
        }
        return desc;
    }

    private int getSyntaxElementEndOffset(SyntaxElement sel) {
        return sel.getElementOffset() + sel.getElementLength() - 1;
    }

    private Map createAttributesMap(Tag tag) {
        HashMap<String, String> map = new HashMap<String, String>(tag.getAttributes().getLength());
        for (int i = 0; i < tag.getAttributes().getLength(); ++i) {
            AttrImpl attr = (AttrImpl)tag.getAttributes().item(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }
}

