/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.StopBuildingAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

public final class TargetExecutor
implements Runnable {
    private static final boolean USE_PROGRESS = Boolean.getBoolean("org.apache.tools.ant.module.run.TargetExecutor.USE_PROGRESS");
    private static final Map freeTabs = new WeakHashMap();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getDefault().getVerbosity();
    private Properties properties = (Properties)AntSettings.getDefault().getProperties().clone();
    private List targetNames;
    private String displayName;

    public TargetExecutor(AntProjectCookie pcookie, String[] targets) {
        this.pcookie = pcookie;
        this.targetNames = targets == null ? null : Arrays.asList((Object[])targets);
    }

    public void setVerbosity(int v) {
        this.verbosity = v;
    }

    public synchronized void setProperties(Properties p) {
        this.properties = (Properties)p.clone();
    }

    public synchronized void addProperties(Properties p) {
        if (p.isEmpty()) {
            return;
        }
        Properties old = this.properties;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)old);
        this.properties.putAll((Map<?, ?>)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        ExecutorTask task;
        Iterator it;
        Element projel = this.pcookie.getProjectElement();
        String projectName = projel != null ? Actions.cutAmpersand((String)projel.getAttribute("name")) : NbBundle.getMessage((Class)TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String fileName = this.pcookie.getFileObject() != null ? this.pcookie.getFileObject().getNameExt() : this.pcookie.getFile().getName();
        if (projectName.equals("")) {
            projectName = fileName;
        }
        if (this.targetNames != null) {
            StringBuffer targetList = new StringBuffer();
            it = this.targetNames.iterator();
            if (it.hasNext()) {
                targetList.append((String)it.next());
            }
            while (it.hasNext()) {
                targetList.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor") : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"SEP_output_target"));
                targetList.append((String)it.next());
            }
            this.displayName = NbBundle.getMessage((Class)TargetExecutor.class, (String)"TITLE_output_target", (Object)projectName, (Object)fileName, (Object)targetList);
        } else {
            this.displayName = NbBundle.getMessage((Class)TargetExecutor.class, (String)"TITLE_output_notarget", (Object)projectName, (Object)fileName);
        }
        it = this;
        synchronized (it) {
            if (AntSettings.getDefault().getAutoCloseTabs()) {
                Map map = freeTabs;
                synchronized (map) {
                    Iterator it2 = freeTabs.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry entry = it2.next();
                        InputOutput free = (InputOutput)entry.getKey();
                        String freeName = (String)entry.getValue();
                        if (this.io == null && freeName.equals(this.displayName)) {
                            this.io = free;
                            this.io.getOut().reset();
                            this.io.getErr().reset();
                            continue;
                        }
                        free.closeInputOutput();
                    }
                    freeTabs.clear();
                }
            }
            if (this.io == null) {
                this.io = IOProvider.getDefault().getIO(this.displayName, true);
            }
            task = ExecutionEngine.getDefault().execute(this.displayName, (Runnable)this, InputOutput.NULL);
        }
        WrapperExecutorTask wrapper = new WrapperExecutorTask(task, this.io);
        RequestProcessor.getDefault().post((Runnable)((Object)wrapper));
        return wrapper;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask task = ExecutionEngine.getDefault().execute(NbBundle.getMessage((Class)TargetExecutor.class, (String)"LABEL_execution_name"), (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        final Thread[] thisProcess = new Thread[1];
        ProgressHandle[] handle = new ProgressHandle[1];
        try {
            final boolean[] displayed = new boolean[]{AntSettings.getDefault().getAlwaysShowOutput()};
            if (this.outputStream == null && displayed[0]) {
                this.io.select();
            }
            if (AntSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            if (this.outputStream != null) {
                throw new RuntimeException("XXX No support for outputStream currently!");
            }
            OutputWriter out = this.io.getOut();
            OutputWriter err = this.io.getErr();
            File buildFile = this.pcookie.getFile();
            if (buildFile == null) {
                err.println(NbBundle.getMessage((Class)TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                return;
            }
            Thread.currentThread().setPriority(3);
            final Runnable interestingOutputCallback = new Runnable(){

                public void run() {
                    if (!displayed[0]) {
                        displayed[0] = true;
                        TargetExecutor.this.io.select();
                    }
                }
            };
            ReaderInputStream in = null;
            if (this.outputStream == null) {
                try {
                    in = new ReaderInputStream(this.io.getIn()){

                        public int read() throws IOException {
                            interestingOutputCallback.run();
                            return super.read();
                        }

                        public int read(byte[] b) throws IOException {
                            interestingOutputCallback.run();
                            return super.read(b);
                        }

                        public int read(byte[] b, int off, int len) throws IOException {
                            interestingOutputCallback.run();
                            return super.read(b, off, len);
                        }

                        public long skip(long n) throws IOException {
                            interestingOutputCallback.run();
                            return super.skip(n);
                        }
                    };
                }
                catch (IOException e) {
                    AntModule.err.notify(1, (Throwable)e);
                }
            }
            thisProcess[0] = Thread.currentThread();
            if (USE_PROGRESS) {
                handle[0] = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        TargetExecutor.stopProcess(thisProcess[0]);
                        return true;
                    }
                }, (Action)new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        TargetExecutor.this.io.select();
                    }
                });
                handle[0].start();
            }
            StopBuildingAction.registerProcess(thisProcess[0], this.displayName);
            this.ok = AntBridge.getInterface().run(buildFile, this.targetNames, (InputStream)in, out, err, this.properties, this.verbosity, this.displayName, interestingOutputCallback);
        }
        finally {
            if (this.io != null) {
                Map map = freeTabs;
                synchronized (map) {
                    freeTabs.put(this.io, this.displayName);
                }
            }
            if (thisProcess[0] != null) {
                StopBuildingAction.unregisterProcess(thisProcess[0]);
            }
            if (handle[0] != null) {
                handle[0].finish();
            }
        }
    }

    static void stopProcess(Thread t) {
        AntBridge.getInterface().stop(t);
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask task, InputOutput io) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
            this.io = io;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }
}

