/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.loader.AntProjectDataObject;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.w3c.dom.Element;

final class AntProjectDataEditor
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
ChangeListener {
    private boolean addedChangeListener = false;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;

    public AntProjectDataEditor(AntProjectDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new AntEnv(obj));
        this.setMIMEType("text/x-ant+xml");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        AntEnv e = (AntEnv)this.env;
        e.getAntProjectDataObject().addSaveCookie(e);
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        AntEnv e = (AntEnv)this.env;
        e.getAntProjectDataObject().removeSaveCookie(e);
    }

    protected String messageName() {
        String name = super.messageName();
        return this.annotateWithProjectName(name);
    }

    protected String messageHtmlName() {
        String name = super.messageHtmlName();
        return name != null ? this.annotateWithProjectName(name) : null;
    }

    private String annotateWithProjectName(String name) {
        DataObject d = this.getDataObject();
        if (d.getPrimaryFile().getNameExt().equals("build.xml")) {
            String projectName;
            AntProjectCookie cookie = (AntProjectCookie)d.getCookie(AntProjectCookie.class);
            Element pel = cookie.getProjectElement();
            if (pel != null && !(projectName = pel.getAttribute("name")).equals("")) {
                name = NbBundle.getMessage((Class)AntProjectDataEditor.class, (String)"LBL_editor_tab", (Object)name, (Object)projectName);
            }
            if (!this.addedChangeListener) {
                cookie.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)cookie));
                this.addedChangeListener = true;
            }
        }
        return name;
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        super.initializeCloneableEditor(editor);
        editor.setActivatedNodes(new Node[]{new FilterNode(this.getDataObject().getNodeDelegate()){

            public String getDisplayName() {
                return AntProjectDataEditor.this.messageName();
            }
        }});
    }

    public void stateChanged(ChangeEvent e) {
        this.updateTitles();
    }

    private static class AntEnv
    extends DataEditorSupport.Env
    implements SaveCookie {
        private static final long serialVersionUID = 6610627377311504616L;

        public AntEnv(AntProjectDataObject obj) {
            super((DataObject)obj);
        }

        AntProjectDataObject getAntProjectDataObject() {
            return (AntProjectDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((AntProjectDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public void save() throws IOException {
            ((AntProjectDataEditor)this.findCloneableOpenSupport()).saveDocument();
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = AntProjectDataEditor.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
        }
    }
}

