/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexNodeInfo;
import org.openide.ErrorManager;

public class IndexListNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 5809643799834921044L;

    public void initChildren(Vector children) throws DatabaseException {
        try {
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            Connection con = this.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            ResultSet rs = dmd.getIndexInfo(drvSpec.getCatalog(), drvSpec.getSchema(), table, false, true);
            if (rs != null) {
                HashSet<String> ixmap = new HashSet<String>();
                while (rs.next()) {
                    HashMap rset = this.getRow(rs);
                    if (rset == null || rset.get(new Integer(6)) == null) continue;
                    IndexNodeInfo info = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", rset);
                    if (info != null) {
                        if (ixmap.contains(info.getName())) continue;
                        ixmap.add(info.getName());
                        info.put("index", info.getName());
                        children.add(info);
                        continue;
                    }
                    throw new Exception(IndexListNodeInfo.bundle().getString("EXC_UnableToCreateIndexNodeInfo"));
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public HashMap getRow(ResultSet rs) {
        HashMap<Integer, String> rset = new HashMap<Integer, String>();
        try {
            int count = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String value = null;
                try {
                    value = rs.getString(i);
                }
                catch (SQLException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    rset = null;
                    break;
                }
                rset.put(new Integer(i), value);
            }
        }
        catch (SQLException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
            rset = null;
        }
        return rset;
    }

    public void addIndex(String name) throws DatabaseException {
        try {
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getIndexInfo(table, false, true);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                IndexNodeInfo info = null;
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    String findex = (String)rset.get(new Integer(6));
                    if (findex != null && findex.equalsIgnoreCase(name)) {
                        info = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", rset);
                    }
                    rset.clear();
                }
                rs.close();
                if (info != null) {
                    ((DatabaseNodeChildren)this.getNode().getChildren()).createSubnode(info, true);
                }
                this.getParent().refreshChildren();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseException(e.getMessage());
        }
    }
}

