/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel
implements DocumentListener,
ListDataListener {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private static final String BUNDLE = "org.netbeans.modules.db.resources.Bundle";
    private JPanel connectProgressPanel;
    private JLabel driverLabel;
    private JTextField driverTextField;
    private JPanel jPanel1;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JComboBox urlComboBox;
    private JLabel urlLabel;
    private JLabel userLabel;
    private JTextField userTextField;

    public NewConnectionPanel(ConnectionDialogMediator mediator, String driverClass, DatabaseConnection connection) {
        this.mediator = mediator;
        this.connection = connection;
        this.initComponents();
        this.initAccessibility();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), driverClass);
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            public void connectionStep(String step) {
                NewConnectionPanel.this.setProgressMessage(step);
            }

            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress(false);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
        this.driverTextField.setText(connection.getDriver());
        this.urlComboBox.setSelectedItem(connection.getDatabase());
        this.userTextField.setText(connection.getUser());
        this.passwordField.setText(connection.getPassword());
        String driver = connection.getDriver();
        String driverName = connection.getDriverName();
        if (driver != null && driverName != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                JDBCDriver dbDriver;
                Object item = this.templateComboBox.getItemAt(i);
                if (!(item instanceof JDBCDriver) || !(dbDriver = (JDBCDriver)item).getClassName().equals(driver) || !dbDriver.getName().equals(driverName)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.driverTextField.getDocument().addDocumentListener(this);
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.templateComboBox.getModel().addListDataListener(this);
        this.urlComboBox.getModel().addListDataListener(this);
        this.checkValid();
    }

    private void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle((String)BUNDLE);
        this.templateLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(b.getString("ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.driverLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_NewConnectionDriverClassA11yDesc"));
        this.driverTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_NewConnectionDriverClassComboBoxA11yName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_NewConnectionDatabaseURLA11yDesc"));
        this.urlComboBox.getAccessibleContext().setAccessibleName(b.getString("ACS_NewConnectionDatabaseURLTextFieldA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_NewConnectionUserNameA11yDesc"));
        this.userTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(b.getString("ACS_NewConnectionPasswordTextFieldA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(b.getString("ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_ConnectionProgressBarA11yDesc"));
    }

    public void initializeFocus() {
        this.getInitiallyFocusedComponent().requestFocusInWindow();
    }

    private JComponent getInitiallyFocusedComponent() {
        if (this.templateComboBox.getItemCount() <= 1) {
            return this.templateComboBox;
        }
        if (this.connection.getDatabase().length() == 0) {
            return this.urlComboBox;
        }
        if (this.userTextField.getText().length() == 0) {
            return this.userTextField;
        }
        if (this.passwordField.getPassword().length == 0) {
            return this.passwordField;
        }
        return this.urlComboBox;
    }

    private void initComponents() {
        this.templateLabel = new JLabel();
        this.templateComboBox = new JComboBox();
        this.driverLabel = new JLabel();
        this.driverTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.passwordCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.templateLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverName_Mnemonic").charAt(0));
        this.templateLabel.setLabelFor(this.templateComboBox);
        this.templateLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.templateLabel, gridBagConstraints);
        this.templateComboBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionDriverNameComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(evt);
            }
        });
        this.templateComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.templateComboBox, gridBagConstraints);
        this.driverLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverClass_Mnemonic").charAt(0));
        this.driverLabel.setLabelFor(this.driverTextField);
        this.driverLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.driverLabel, gridBagConstraints);
        this.driverTextField.setColumns(50);
        this.driverTextField.setEditable(false);
        this.driverTextField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionDriverClassComboBoxA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.driverTextField, gridBagConstraints);
        this.urlLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDatabaseURL_Mnemonic").charAt(0));
        this.urlLabel.setLabelFor(this.urlComboBox);
        this.urlLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDatabaseURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.urlLabel, gridBagConstraints);
        this.urlComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.urlComboBox, gridBagConstraints);
        this.userLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionUserName_Mnemonic").charAt(0));
        this.userLabel.setLabelFor(this.userTextField);
        this.userLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionUserName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.userLabel, gridBagConstraints);
        this.userTextField.setColumns(50);
        this.userTextField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionUserNameTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.userTextField, gridBagConstraints);
        this.passwordLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionPassword_Mnemonic").charAt(0));
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordField.setColumns(50);
        this.passwordField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionPasswordTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordField, gridBagConstraints);
        this.passwordCheckBox.setMnemonic(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionRememberPassword_Mnemonic").charAt(0));
        this.passwordCheckBox.setText(NbBundle.getBundle((String)BUNDLE).getString("NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionRememberPasswordA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        this.connectProgressPanel.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_ConnectionProgressBarA11yDesc"));
        this.progressMessageLabel.setText(" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    private void templateComboBoxItemStateChanged(ItemEvent evt) {
        this.checkValid();
    }

    private void templateComboBoxActionPerformed(ActionEvent evt) {
        Object item = this.templateComboBox.getSelectedItem();
        if (!(item instanceof JDBCDriver)) {
            return;
        }
        JDBCDriver drv = (JDBCDriver)item;
        List urls = null;
        String driver = null;
        if (drv != null) {
            driver = drv.getClassName();
            urls = DriverListUtil.getURLs(driver);
        }
        this.urlComboBox.removeAllItems();
        if (!this.connection.getDatabase().equals("")) {
            this.urlComboBox.addItem(this.connection.getDatabase());
        } else if (urls != null) {
            for (int i = 0; i < urls.size(); ++i) {
                this.urlComboBox.addItem((String)urls.get(i));
            }
        }
        if (driver != null) {
            this.driverTextField.setText(driver);
        }
    }

    private JDBCDriver getSelectedDriver() {
        Object item = this.templateComboBox.getSelectedItem();
        if (item instanceof JDBCDriver) {
            return (JDBCDriver)item;
        }
        return null;
    }

    public void setConnectionInfo() {
        JDBCDriver driver = this.getSelectedDriver();
        if (driver != null) {
            this.connection.setDriverName(driver.getName());
            this.connection.setDriver(driver.getClassName());
        }
        this.connection.setDatabase((String)this.urlComboBox.getSelectedItem());
        this.connection.setUser(this.userTextField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
    }

    private String getPassword() {
        String tempPassword = new String(this.passwordField.getPassword());
        String password = tempPassword.length() > 0 ? tempPassword : null;
        return password;
    }

    public String getTitle() {
        return NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle(null);
                NewConnectionPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)NewConnectionPanel.this.progressHandle);
                NewConnectionPanel.this.progressContainerPanel.add((Component)NewConnectionPanel.this.progressComponent, "Center");
                NewConnectionPanel.this.progressHandle.start();
                NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Connecting"));
            }
        });
    }

    private void setProgressMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressMessageLabel.setText(message);
            }
        });
    }

    private void stopProgress(final boolean connected) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle.finish();
                NewConnectionPanel.this.progressContainerPanel.remove(NewConnectionPanel.this.progressComponent);
                NewConnectionPanel.this.progressContainerPanel.repaint();
                if (connected) {
                    NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Established"));
                } else {
                    NewConnectionPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)NewConnectionPanel.BUNDLE).getString("ConnectionProgress_Failed"));
                }
            }
        });
    }

    private void resetProgress() {
        this.progressMessageLabel.setText("");
    }

    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    public void contentsChanged(ListDataEvent e) {
        this.fireChange();
    }

    public void intervalAdded(ListDataEvent e) {
        this.fireChange();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }

    private void checkValid() {
        this.mediator.setValid(this.getSelectedDriver() != null);
    }
}

