/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dataview;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.windows.TopComponent;

public class DataViewWindow
extends TopComponent {
    private JTextArea queryarea;
    private JTable jtable;
    private DataModel dbadaptor;
    private JComboBox rcmdscombo;
    private JLabel status;
    private ResourceBundle bundle;
    private Node node;
    private JPopupMenu tablePopupMenu;
    static final long serialVersionUID = 6855188441469780252L;
    static int tstrg = 0;
    static int gtcmd = 0;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo;
    static /* synthetic */ Class class$org$openide$util$datatransfer$MultiTransferObject;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public DataViewWindow(DatabaseNodeInfo info, String query) throws SQLException {
        this.node = info.getNode();
        this.bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewWindowA11yDesc"));
        Node tempNode = this.node;
        while (!(tempNode instanceof ConnectionNode)) {
            tempNode = tempNode.getParentNode();
        }
        String title = tempNode.getDisplayName();
        int idx = title.indexOf(" [");
        title = title.substring(0, idx);
        this.setName(title);
        this.setToolTipText(this.bundle.getString("CommandEditorTitle") + " " + tempNode.getDisplayName());
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        this.setLayout(layout);
        this.dbadaptor = new DataModel(info);
        JPanel subpane = new JPanel();
        GridBagLayout sublayout = new GridBagLayout();
        GridBagConstraints subcon = new GridBagConstraints();
        subpane.setLayout(sublayout);
        subcon.fill = 2;
        subcon.weightx = 0.0;
        subcon.weighty = 0.0;
        subcon.gridx = 0;
        subcon.gridy = 0;
        subcon.gridwidth = 3;
        subcon.insets = new Insets(0, 0, 5, 0);
        subcon.anchor = 15;
        JLabel queryLabel = new JLabel(this.bundle.getString("QueryLabel"));
        queryLabel.setDisplayedMnemonic(this.bundle.getString("QueryLabel_Mnemonic").charAt(0));
        queryLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewQueryLabelA11yDesc"));
        sublayout.setConstraints(queryLabel, subcon);
        subpane.add(queryLabel);
        subcon.fill = 1;
        subcon.weightx = 1.0;
        subcon.weighty = 1.0;
        subcon.gridx = 0;
        subcon.gridwidth = 3;
        subcon.gridy = 1;
        this.queryarea = new JTextArea(query, 3, 70);
        this.queryarea.setLineWrap(true);
        this.queryarea.setWrapStyleWord(true);
        this.queryarea.setDropTarget(new DropTarget(this.queryarea, new ViewDropTarget()));
        this.queryarea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewTextAreaA11yName"));
        this.queryarea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewTextAreaA11yDesc"));
        this.queryarea.setToolTipText(this.bundle.getString("ACS_DataViewTextAreaA11yDesc"));
        queryLabel.setLabelFor(this.queryarea);
        JScrollPane scrollpane = new JScrollPane(this.queryarea);
        subcon.insets = new Insets(0, 0, 5, 0);
        sublayout.setConstraints(scrollpane, subcon);
        subpane.add(scrollpane);
        subcon.fill = 2;
        subcon.weightx = 0.0;
        subcon.weighty = 0.0;
        subcon.gridx = 0;
        subcon.gridy = 2;
        subcon.gridwidth = 1;
        subcon.insets = new Insets(0, 0, 5, 5);
        subcon.anchor = 10;
        JLabel comboLabel = new JLabel(this.bundle.getString("HistoryLabel"));
        comboLabel.setDisplayedMnemonic(this.bundle.getString("HistoryLabel_Mnemonic").charAt(0));
        comboLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewHistoryLabelA11yDesc"));
        sublayout.setConstraints(comboLabel, subcon);
        subpane.add(comboLabel);
        subcon.fill = 2;
        subcon.weightx = 1.0;
        subcon.weighty = 0.0;
        subcon.gridx = 1;
        subcon.gridy = 2;
        subcon.gridwidth = 1;
        subcon.insets = new Insets(0, 0, 5, 5);
        subcon.anchor = 15;
        this.rcmdscombo = new JComboBox(new ComboModel());
        this.rcmdscombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewComboBoxA11yName"));
        this.rcmdscombo.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewComboBoxA11yDesc"));
        this.rcmdscombo.setToolTipText(this.bundle.getString("ACS_DataViewComboBoxA11yDesc"));
        comboLabel.setLabelFor(this.rcmdscombo);
        sublayout.setConstraints(this.rcmdscombo, subcon);
        subpane.add(this.rcmdscombo);
        this.rcmdscombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                RecentCommand cmd = (RecentCommand)source.getSelectedItem();
                if (cmd != null) {
                    DataViewWindow.this.setCommand(cmd.getCommand());
                }
            }
        });
        subcon.gridx = 2;
        subcon.gridy = 2;
        subcon.weightx = 0.0;
        subcon.weighty = 0.0;
        subcon.insets = new Insets(0, 0, 5, 0);
        subcon.fill = 2;
        subcon.anchor = 15;
        final JButton fetchbtn = new JButton(this.bundle.getString("ExecuteButton"));
        fetchbtn.setToolTipText(this.bundle.getString("ACS_ExecuteButtonA11yDesc"));
        fetchbtn.setMnemonic(this.bundle.getString("ExecuteButton_Mnemonic").charAt(0));
        sublayout.setConstraints(fetchbtn, subcon);
        subpane.add(fetchbtn);
        fetchbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fetchbtn.setEnabled(false);
                RequestProcessor.Task t = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        DataViewWindow.this.executeCommand();
                    }
                });
                t.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        fetchbtn.setEnabled(true);
                    }
                });
                RequestProcessor.getDefault().post((Runnable)t, 0);
            }
        });
        subcon.fill = 2;
        subcon.weightx = 1.0;
        subcon.weighty = 0.0;
        subcon.gridx = 0;
        subcon.gridy = 3;
        subcon.gridwidth = 3;
        subcon.insets = new Insets(0, 0, 5, 0);
        subcon.anchor = 15;
        this.status = new JLabel(" ");
        this.status.setBorder(new LineBorder(Color.gray));
        this.status.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewStatusLabelA11yDesc"));
        sublayout.setConstraints(this.status, subcon);
        subpane.add(this.status);
        JPanel subpane2 = new JPanel();
        GridBagLayout sublayout2 = new GridBagLayout();
        GridBagConstraints subcon2 = new GridBagConstraints();
        subpane2.setLayout(sublayout2);
        subcon2.fill = 2;
        subcon2.weightx = 0.0;
        subcon2.weighty = 0.0;
        subcon2.gridx = 0;
        subcon2.gridy = 0;
        subcon2.gridwidth = 1;
        subcon2.insets = new Insets(5, 0, 0, 0);
        subcon2.anchor = 15;
        JLabel tableLabel = new JLabel(this.bundle.getString("ResultsLabel"));
        tableLabel.setDisplayedMnemonic(this.bundle.getString("ResultsLabel_Mnemonic").charAt(0));
        tableLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewResultsLabelA11yDesc"));
        sublayout2.setConstraints(tableLabel, subcon2);
        subpane2.add(tableLabel);
        this.tablePopupMenu = new JPopupMenu();
        JMenuItem miCopyValue = new JMenuItem(this.bundle.getString("CopyCellValue"));
        miCopyValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Object o = DataViewWindow.this.jtable.getValueAt(DataViewWindow.this.jtable.getSelectedRow(), DataViewWindow.this.jtable.getSelectedColumn());
                    String output = o != null ? o.toString() : "";
                    ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = DataViewWindow.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    StringSelection strSel = new StringSelection(output);
                    clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(miCopyValue);
        JMenuItem miCopyRowValues = new JMenuItem(this.bundle.getString("CopyRowValues"));
        miCopyRowValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int[] columns;
                    int[] rows = DataViewWindow.this.jtable.getSelectedRows();
                    if (DataViewWindow.this.jtable.getRowSelectionAllowed()) {
                        columns = new int[DataViewWindow.this.jtable.getColumnCount()];
                        for (int a = 0; a < columns.length; ++a) {
                            columns[a] = a;
                        }
                    } else {
                        columns = DataViewWindow.this.jtable.getSelectedColumns();
                    }
                    if (rows != null && columns != null) {
                        StringBuffer output = new StringBuffer();
                        for (int row = 0; row < rows.length; ++row) {
                            for (int column = 0; column < columns.length; ++column) {
                                Object o;
                                if (column > 0) {
                                    output.append('\t');
                                }
                                output.append((o = DataViewWindow.this.jtable.getValueAt(rows[row], columns[column])) != null ? o.toString() : "");
                            }
                            output.append('\n');
                        }
                        ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = DataViewWindow.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                        StringSelection strSel = new StringSelection(output.toString());
                        clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(miCopyRowValues);
        this.jtable = new JTable(this.dbadaptor);
        this.jtable.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewTableA11yName"));
        this.jtable.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewTableA11yDesc"));
        this.jtable.setToolTipText(this.bundle.getString("ACS_DataViewTableA11yDesc"));
        this.jtable.setAutoResizeMode(0);
        this.jtable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = DataViewWindow.this.jtable.rowAtPoint(e.getPoint());
                    int column = DataViewWindow.this.jtable.columnAtPoint(e.getPoint());
                    boolean inSelection = false;
                    int[] rows = DataViewWindow.this.jtable.getSelectedRows();
                    for (int a = 0; a < rows.length; ++a) {
                        if (rows[a] != row) continue;
                        inSelection = true;
                        break;
                    }
                    if (!DataViewWindow.this.jtable.getRowSelectionAllowed()) {
                        inSelection = false;
                        int[] columns = DataViewWindow.this.jtable.getSelectedColumns();
                        for (int a = 0; a < columns.length; ++a) {
                            if (columns[a] != column) continue;
                            inSelection = true;
                            break;
                        }
                    }
                    if (!inSelection) {
                        DataViewWindow.this.jtable.changeSelection(row, column, false, false);
                    }
                    DataViewWindow.this.tablePopupMenu.show(DataViewWindow.this.jtable, e.getX(), e.getY());
                }
            }
        });
        tableLabel.setLabelFor(this.jtable);
        scrollpane = new JScrollPane(this.jtable);
        subcon2.fill = 1;
        subcon2.weightx = 1.0;
        subcon2.weighty = 1.0;
        subcon2.gridx = 0;
        subcon2.gridy = 1;
        subcon2.gridwidth = 1;
        sublayout2.setConstraints(scrollpane, subcon2);
        subpane2.add(scrollpane);
        con.weightx = 1.0;
        con.weighty = 1.0;
        con.fill = 1;
        con.gridx = 0;
        con.gridwidth = 1;
        con.gridy = 1;
        con.insets = new Insets(12, 12, 11, 11);
        JSplitPane split = new JSplitPane(0, subpane, subpane2);
        layout.setConstraints(split, con);
        this.add(split);
    }

    protected String preferredID() {
        return this.getName();
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getCommand() {
        return this.queryarea.getText();
    }

    public void setCommand(String command) {
        this.queryarea.setText(command);
    }

    public boolean executeCommand() {
        boolean ret;
        String command = this.queryarea.getText().trim();
        try {
            this.dbadaptor.execute(command);
            RecentCommand rcmd = new RecentCommand(command);
            ((ComboModel)this.rcmdscombo.getModel()).addElement(rcmd);
            ret = true;
        }
        catch (Exception exc) {
            ret = false;
            this.status.setText(this.bundle.getString("CommandFailed"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(this.bundle.getString("DataViewFetchErrorPrefix") + exc.getMessage()), 0));
        }
        return ret;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return null;
    }

    class DataModel
    extends AbstractTableModel {
        DatabaseNodeInfo node_info;
        Vector coldef = new Vector();
        Vector data = new Vector();
        boolean editable = false;
        static final long serialVersionUID = 7729426847826999963L;

        public DataModel(DatabaseNodeInfo node_info) throws SQLException {
            this.node_info = node_info;
        }

        public synchronized void execute(String command) throws Exception {
            Statement stat;
            if (command.length() == 0) {
                DataViewWindow.this.status.setText(" ");
                return;
            }
            DataViewWindow.this.status.setText(DataViewWindow.this.bundle.getString("CommandRunning"));
            try {
                Connection con = this.node_info.getConnection();
                stat = con.createStatement();
            }
            catch (Exception exc) {
                String message = MessageFormat.format(DataViewWindow.this.bundle.getString("EXC_ConnectionIsBroken"), exc.getMessage());
                throw new DatabaseException(message);
            }
            if (command.toLowerCase().startsWith("select")) {
                ResultSet rs = stat.executeQuery(command);
                ResultSetMetaData mdata = rs.getMetaData();
                int cols = mdata.getColumnCount();
                Vector<ColDef> coldefWork = new Vector<ColDef>();
                Vector dataWork = new Vector();
                for (int column = 1; column <= cols; ++column) {
                    boolean writable;
                    try {
                        writable = mdata.isWritable(column);
                    }
                    catch (SQLException exc) {
                        writable = false;
                    }
                    ColDef cd = new ColDef(mdata.getColumnLabel(column), writable);
                    cd.setDataType(mdata.getColumnType(column));
                    coldefWork.add(cd);
                }
                int rcounter = 0;
                int limit = 100;
                int step = 200;
                String cancel = DataViewWindow.this.bundle.getString("DataViewCancelButton");
                String nextset = DataViewWindow.this.bundle.getString("DataViewNextFetchButton");
                String allset = DataViewWindow.this.bundle.getString("DataViewAllFetchButton");
                JButton fetchNext = new JButton(nextset);
                fetchNext.getAccessibleContext().setAccessibleDescription(DataViewWindow.this.bundle.getString("ACS_DataViewNextFetchButtonA11yDesc"));
                fetchNext.setMnemonic(DataViewWindow.this.bundle.getString("FetchNextFetchButton_Mnemonic").charAt(0));
                JButton fetchAll = new JButton(allset);
                fetchAll.getAccessibleContext().setAccessibleDescription(DataViewWindow.this.bundle.getString("ACS_DataViewAllFetchButtonA11yDesc"));
                fetchAll.setMnemonic(DataViewWindow.this.bundle.getString("FetchAllFetchButton_Mnemonic").charAt(0));
                JButton no = new JButton(cancel);
                no.getAccessibleContext().setAccessibleDescription(DataViewWindow.this.bundle.getString("ACS_DataViewCancelButtonA11yDesc"));
                no.setMnemonic(DataViewWindow.this.bundle.getString("FetchCancelButton_Mnemonic").charAt(0));
                while (rs.next()) {
                    String retv;
                    Vector<Object> row = new Vector<Object>(cols);
                    for (int column = 1; column <= cols; ++column) {
                        row.add(rs.getObject(column));
                    }
                    dataWork.addElement(row);
                    if (++rcounter < limit) continue;
                    Object[] arr = new String[]{new Integer(rcounter).toString(), new Integer(step).toString()};
                    String message = MessageFormat.format(DataViewWindow.this.bundle.getString("DataViewMessage"), arr);
                    NotifyDescriptor ndesc = new NotifyDescriptor((Object)message, DataViewWindow.this.bundle.getString("FetchDataTitle"), 1, 3, new Object[]{fetchNext, fetchAll, no}, NotifyDescriptor.CANCEL_OPTION);
                    Object ret = DialogDisplayer.getDefault().notify(ndesc);
                    if (ret instanceof JButton) {
                        try {
                            retv = ((JButton)ret).getText();
                        }
                        catch (ClassCastException exc) {
                            retv = cancel;
                        }
                    } else {
                        retv = cancel;
                    }
                    if (retv.equals(allset)) {
                        limit = Integer.MAX_VALUE;
                        continue;
                    }
                    if (!retv.equals(nextset)) break;
                    limit += step;
                }
                final Vector assignData = dataWork;
                final Vector<ColDef> assignColdef = coldefWork;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DataModel.this.data = assignData;
                        DataModel.this.coldef = assignColdef;
                        DataModel.this.fireTableChanged(null);
                    }
                });
                rs.close();
            } else if (command.toLowerCase().startsWith("delete") || command.toLowerCase().startsWith("insert") || command.toLowerCase().startsWith("update")) {
                stat.executeUpdate(command);
            } else {
                stat.execute(command);
                while (!(DataViewWindow.this.node instanceof ConnectionNode)) {
                    DataViewWindow.this.node = DataViewWindow.this.node.getParentNode();
                }
                Enumeration nodes = DataViewWindow.this.node.getChildren().nodes();
                while (nodes.hasMoreElements()) {
                    ((DatabaseNodeInfo)((Node)nodes.nextElement()).getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? DataViewWindow.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo)).refreshChildren();
                }
            }
            DataViewWindow.this.status.setText(DataViewWindow.this.bundle.getString("CommandExecuted"));
            stat.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getColumnName(int column) {
            Vector vector = this.coldef;
            synchronized (vector) {
                if (column < this.coldef.size()) {
                    String cname = ((ColDef)this.coldef.elementAt(column)).getName();
                    return cname;
                }
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class getColumnClass(int column) {
            Vector vector = this.coldef;
            synchronized (vector) {
                if (column < this.coldef.size()) {
                    int coltype = ((ColDef)this.coldef.elementAt(column)).getDataType();
                    switch (coltype) {
                        case -1: 
                        case 1: 
                        case 12: {
                            return class$java$lang$String == null ? (class$java$lang$String = DataViewWindow.class$("java.lang.String")) : class$java$lang$String;
                        }
                        case -7: {
                            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataViewWindow.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return class$java$lang$Integer == null ? (class$java$lang$Integer = DataViewWindow.class$("java.lang.Integer")) : class$java$lang$Integer;
                        }
                        case -5: {
                            return class$java$lang$Long == null ? (class$java$lang$Long = DataViewWindow.class$("java.lang.Long")) : class$java$lang$Long;
                        }
                        case 6: 
                        case 8: {
                            return class$java$lang$Double == null ? (class$java$lang$Double = DataViewWindow.class$("java.lang.Double")) : class$java$lang$Double;
                        }
                        case 91: {
                            return class$java$sql$Date == null ? (class$java$sql$Date = DataViewWindow.class$("java.sql.Date")) : class$java$sql$Date;
                        }
                    }
                }
                return class$java$lang$Object == null ? (class$java$lang$Object = DataViewWindow.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCellEditable(int row, int column) {
            Vector vector = this.coldef;
            synchronized (vector) {
                if (!this.editable) {
                    return false;
                }
                if (column < this.coldef.size()) {
                    return ((ColDef)this.coldef.elementAt(column)).isWritable();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getColumnCount() {
            Vector vector = this.coldef;
            synchronized (vector) {
                return this.coldef.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Vector vector = this.data;
            synchronized (vector) {
                return this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int aRow, int aColumn) {
            Vector vector = this.data;
            synchronized (vector) {
                Vector row = new Vector();
                if (aRow < this.data.size()) {
                    row = (Vector)this.data.elementAt(aRow);
                }
                if (row != null && aColumn < row.size()) {
                    return row.elementAt(aColumn);
                }
                return null;
            }
        }

        private String format(Object value, int type) {
            if (value == null) {
                return "null";
            }
            switch (type) {
                case 4: 
                case 6: 
                case 8: {
                    return value.toString();
                }
                case -7: {
                    return (Boolean)value != false ? "1" : "0";
                }
                case 91: {
                    return value.toString();
                }
            }
            return "\"" + value.toString() + "\"";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object value, int row, int column) {
            Vector vector = this.coldef;
            synchronized (vector) {
                int enucol = 0;
                StringBuffer where = new StringBuffer();
                Enumeration enu = this.coldef.elements();
                while (enu.hasMoreElements()) {
                    ColDef cd = (ColDef)enu.nextElement();
                    if (cd.isBestRowIdentifierColumn()) {
                        String key = cd.getName();
                        String val = this.format(this.getValueAt(row, enucol), cd.getDataType());
                        if (where.length() > 0) {
                            where.append(" and ");
                        }
                        where.append(key + " = " + val);
                    }
                    ++enucol;
                }
            }
        }
    }

    class ViewDropTarget
    implements DropTargetListener {
        ViewDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        private ColumnNodeInfo getNodeInfo(Transferable t) {
            Node n = NodeTransfer.node((Transferable)t, (int)6);
            if (n != null) {
                return (ColumnNodeInfo)n.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = DataViewWindow.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            n = NodeTransfer.node((Transferable)t, (int)1);
            if (n != null) {
                return (ColumnNodeInfo)n.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = DataViewWindow.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            return null;
        }

        public void drop(DropTargetDropEvent dtde) {
            String query = null;
            Transferable t = dtde.getTransferable();
            StringBuffer buff = new StringBuffer();
            try {
                DataFlavor multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("transferFlavorsMultiFlavorName"), (class$org$openide$util$datatransfer$MultiTransferObject == null ? (class$org$openide$util$datatransfer$MultiTransferObject = DataViewWindow.class$("org.openide.util.datatransfer.MultiTransferObject")) : class$org$openide$util$datatransfer$MultiTransferObject).getClassLoader());
                if (t.isDataFlavorSupported(multiFlavor)) {
                    MultiTransferObject mobj = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    int count = mobj.getCount();
                    int tabidx = 0;
                    HashMap<String, Integer> tabidxmap = new HashMap<String, Integer>();
                    for (int i = 0; i < count; ++i) {
                        ColumnNodeInfo nfo = this.getNodeInfo(mobj.getTransferableAt(i));
                        if (nfo == null) continue;
                        String tablename = nfo.getTable();
                        Integer tableidx = (Integer)tabidxmap.get(tablename);
                        if (tableidx == null) {
                            tableidx = new Integer(tabidx++);
                            tabidxmap.put(tablename, tableidx);
                        }
                        if (buff.length() > 0) {
                            buff.append(", ");
                        }
                        buff.append("t" + tableidx + "." + nfo.getName());
                    }
                    StringBuffer frombuff = new StringBuffer();
                    Iterator iter = tabidxmap.keySet().iterator();
                    while (iter.hasNext()) {
                        String tab = (String)iter.next();
                        if (frombuff.length() > 0) {
                            frombuff.append(", ");
                        }
                        frombuff.append(tab + " t" + tabidxmap.get(tab));
                    }
                    query = "select " + buff.toString() + " from " + frombuff.toString();
                } else {
                    ColumnNodeInfo nfo = this.getNodeInfo(t);
                    if (nfo != null) {
                        query = "select " + nfo.getName() + " from " + nfo.getTable();
                    }
                }
                if (query != null) {
                    DataViewWindow.this.setCommand(query);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ComboModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        Vector commands;
        Object selected;
        static final long serialVersionUID = -5831993904798984334L;

        public ComboModel() {
            this(new Vector(1));
        }

        public ComboModel(Vector elems) {
            this.commands = elems;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        public void addElement(Object obj) {
            if (!this.commands.contains(obj)) {
                this.commands.add(obj);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElement(Object obj) {
            this.commands.removeElement(obj);
            this.fireContentsChanged(this, -1, -1);
        }

        public void insertElementAt(Object obj, int index) {
            if (!this.commands.contains(obj)) {
                this.commands.insertElementAt(obj, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElementAt(int index) {
            this.commands.removeElementAt(index);
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.commands.size();
        }

        public Object getElementAt(int index) {
            return this.commands.get(index);
        }
    }

    class RecentCommand {
        private String command;
        private String shortCommand;

        public RecentCommand(String cmd) {
            this.command = cmd;
            this.shortCommand = this.getShortCommand();
        }

        public String toString() {
            return this.shortCommand;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecentCommand) {
                return ((RecentCommand)obj).getShortCommand().equals(this.shortCommand);
            }
            return super.equals(obj);
        }

        private String getShortCommand() {
            StringTokenizer tokenizer = new StringTokenizer(this.command);
            StringBuffer buffer = new StringBuffer();
            while (tokenizer.hasMoreElements()) {
                buffer.append(tokenizer.nextElement());
                buffer.append(" ");
            }
            return buffer.toString();
        }
    }

    class ColDef {
        private String name;
        private boolean writable;
        private boolean bric;
        int datatype;

        public ColDef(String name, boolean flag) {
            this.name = name;
            this.writable = flag;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getDataType() {
            return this.datatype;
        }

        public void setDataType(int type) {
            this.datatype = type;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean flag) {
            this.writable = flag;
        }

        public boolean isBestRowIdentifierColumn() {
            return this.bric;
        }

        public void setBestRowIdentifierColumn(boolean flag) {
            this.bric = flag;
        }
    }
}

