/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathSourceCache {
    public static final String PROP_ROOTS = "roots";
    private final WeakReference<ClassPath> classPathRef;
    private final Listener listener = new Listener();
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    List<SourceForBinaryQuery.Result> results;
    private long invalidResults;
    Set<FileObject> sourceRoots;
    private long invalidSourceRoots;
    boolean deinitialized;
    private boolean resolveSources;

    public static ClassPathSourceCache newInstance(ClassPath classPath, boolean resolveSources) {
        ClassPathSourceCache created = new ClassPathSourceCache(classPath, resolveSources);
        created.initialize();
        return created;
    }

    private ClassPathSourceCache(ClassPath classPath, boolean resolveSources) {
        assert (classPath != null);
        this.classPathRef = new CleanupReference<ClassPath>(classPath);
        this.resolveSources = resolveSources;
    }

    private void initialize() {
        ClassPath classPath = (ClassPath)this.classPathRef.get();
        if (classPath != null) {
            classPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)classPath));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean contains(FileObject f) {
        return ClassPathSourceCache.findOwnerRoot(this.getSourceRootSet(), f) != null;
    }

    public FileObject[] getRoots() {
        Set<FileObject> sourceRoots = this.getSourceRootSet();
        return sourceRoots.toArray(new FileObject[sourceRoots.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FileObject> getSourceRootSet() {
        long invalidSourceRootsCopy;
        ClassPathSourceCache classPathSourceCache = this;
        synchronized (classPathSourceCache) {
            if (this.sourceRoots != null) {
                return this.sourceRoots;
            }
            invalidSourceRootsCopy = this.invalidSourceRoots;
        }
        final HashSet<FileObject> newSourceRoots = new HashSet<FileObject>();
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ClassPath classPath = (ClassPath)ClassPathSourceCache.this.classPathRef.get();
                    if (classPath != null) {
                        for (FileObject root : classPath.getRoots()) {
                            newSourceRoots.add(root);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        if (this.resolveSources) {
            for (SourceForBinaryQuery.Result result : this.getResults()) {
                for (FileObject sourceRoot : result.getRoots()) {
                    newSourceRoots.add(sourceRoot);
                }
            }
        }
        ClassPathSourceCache classPathSourceCache2 = this;
        synchronized (classPathSourceCache2) {
            if (this.invalidSourceRoots == invalidSourceRootsCopy) {
                if (this.sourceRoots == null) {
                    this.sourceRoots = newSourceRoots;
                }
                return this.sourceRoots;
            }
            return newSourceRoots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SourceForBinaryQuery.Result> getResults() {
        long invalidResultsCopy;
        ClassPathSourceCache classPathSourceCache = this;
        synchronized (classPathSourceCache) {
            if (this.results != null) {
                return this.results;
            }
            assert (this.sourceRoots == null);
            invalidResultsCopy = this.invalidResults;
        }
        List<SourceForBinaryQuery.Result> newResults = null;
        ClassPath classPath = (ClassPath)this.classPathRef.get();
        if (classPath == null) {
            newResults = Collections.emptyList();
        } else {
            newResults = new ArrayList();
            List entries = classPath.entries();
            for (ClassPath.Entry entry : entries) {
                newResults.add(SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()));
            }
        }
        ClassPathSourceCache classPathSourceCache2 = this;
        synchronized (classPathSourceCache2) {
            if (this.invalidResults == invalidResultsCopy) {
                if (this.results == null) {
                    for (SourceForBinaryQuery.Result result : newResults) {
                        result.addChangeListener((ChangeListener)this.listener);
                    }
                    this.results = newResults;
                }
                return this.results;
            }
            return newResults;
        }
    }

    private static FileObject findOwnerRoot(Set<FileObject> roots, FileObject resource) {
        for (FileObject f = resource; f != null; f = f.getParent()) {
            if (!roots.contains(f)) continue;
            return f;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CleanupReference<T>
    extends WeakReference<T>
    implements Runnable {
        public CleanupReference(T referent) {
            super(referent, Utilities.activeReferenceQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassPathSourceCache classPathSourceCache = ClassPathSourceCache.this;
            synchronized (classPathSourceCache) {
                if (ClassPathSourceCache.this.results != null) {
                    for (SourceForBinaryQuery.Result result : ClassPathSourceCache.this.results) {
                        result.removeChangeListener((ChangeListener)ClassPathSourceCache.this.listener);
                    }
                }
                ClassPathSourceCache.this.results = Collections.emptyList();
                ClassPathSourceCache.this.invalidResults++;
                ClassPathSourceCache.this.sourceRoots = Collections.emptySet();
                ClassPathSourceCache.this.invalidSourceRoots++;
                ClassPathSourceCache.this.deinitialized = true;
            }
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("entries".equals(propertyName)) {
                if (ClassPathSourceCache.this.resolveSources) {
                    this.entriesChanged();
                }
            } else if (ClassPathSourceCache.PROP_ROOTS.equals(propertyName)) {
                this.rootsChanged();
            }
        }

        public void stateChanged(ChangeEvent evt) {
            this.rootsChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void entriesChanged() {
            ClassPathSourceCache classPathSourceCache = ClassPathSourceCache.this;
            synchronized (classPathSourceCache) {
                if (!ClassPathSourceCache.this.deinitialized) {
                    if (ClassPathSourceCache.this.results != null) {
                        for (SourceForBinaryQuery.Result result : ClassPathSourceCache.this.results) {
                            result.removeChangeListener((ChangeListener)this);
                        }
                    }
                    ClassPathSourceCache.this.results = null;
                    ClassPathSourceCache.this.invalidResults++;
                    ClassPathSourceCache.this.sourceRoots = null;
                    ClassPathSourceCache.this.invalidSourceRoots++;
                    ClassPathSourceCache.this.propChangeSupport.firePropertyChange(ClassPathSourceCache.PROP_ROOTS, null, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rootsChanged() {
            ClassPathSourceCache classPathSourceCache = ClassPathSourceCache.this;
            synchronized (classPathSourceCache) {
                if (!ClassPathSourceCache.this.deinitialized) {
                    ClassPathSourceCache.this.sourceRoots = null;
                    ClassPathSourceCache.this.invalidSourceRoots++;
                    ClassPathSourceCache.this.propChangeSupport.firePropertyChange(ClassPathSourceCache.PROP_ROOTS, null, null);
                }
            }
        }
    }
}

