/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 524288;
    private static final int UPDATE_DELAY = 300;
    private boolean testTargetStarted = false;
    private boolean testTaskStarted = false;
    private boolean reportStarted = false;
    private boolean testsuiteStatsKnown = false;
    private final AntSession session;
    private final int sessionType;
    private boolean expectXmlReport;
    private final File antScript;
    private final long timeOfSessionStart;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private Report topReport;
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private String suiteName;
    private List callstackBuffer;
    private StringBuffer xmlOutputBuffer;
    private boolean readingOutputReport;
    private boolean lastHeaderBrief;
    private boolean waitingForIssueStatus;
    private final Manager manager = Manager.getInstance();
    private String classpath;
    private ClassPath platformSources;

    JUnitOutputReader(AntSession session, int sessionType, long timeOfSessionStart) {
        this.session = session;
        this.sessionType = sessionType;
        this.antScript = session.getOriginatingScript();
        this.timeOfSessionStart = timeOfSessionStart;
    }

    void verboseMessageLogged(AntEvent event) {
        String executable;
        ClassPath platformSrcs;
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        Matcher matcher = RegexpUtils.CLASSPATH_ARGS.matcher(msg);
        if (matcher.find()) {
            this.classpath = matcher.group(1);
        }
        if ((matcher = RegexpUtils.JAVA_EXECUTABLE.matcher(msg)).find() && (platformSrcs = this.findPlatformSources(executable = matcher.group(1))) != null) {
            this.platformSources = platformSrcs;
        }
    }

    void messageLogged(AntEvent event) {
        Matcher matcher;
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        if (this.waitingForIssueStatus) {
            assert (this.testcase != null);
            matcher = this.regexp.getTestcaseIssuePattern().matcher(msg);
            if (matcher.matches()) {
                boolean error = matcher.group(1) == null;
                this.trouble = this.testcase.trouble = new Report.Trouble(error);
                this.waitingForIssueStatus = false;
                return;
            }
            this.report.reportTest(this.testcase);
            this.waitingForIssueStatus = false;
        }
        if (this.xmlOutputBuffer != null) {
            this.xmlOutputBuffer.append(msg).append('\n');
            if (msg.equals("</testsuite>")) {
                this.closePreviousReport();
            }
            return;
        }
        if (this.readingOutputReport) {
            if (msg.startsWith("--------") && (matcher = this.regexp.getOutputDelimPattern().matcher(msg)).matches() && matcher.group(1) == null) {
                this.readingOutputReport = false;
            }
            return;
        }
        if (this.trouble != null) {
            if (this.trouble.exceptionClsName == null) {
                matcher = this.regexp.getTestcaseExceptionPattern().matcher(msg);
                if (matcher.matches()) {
                    this.trouble.exceptionClsName = matcher.group(1);
                    String exceptionMsg = matcher.group(2);
                    if (exceptionMsg != null) {
                        this.trouble.message = exceptionMsg;
                    }
                }
                return;
            }
            String trimmed = RegexpUtils.specialTrim(msg);
            if (trimmed.length() == 0) {
                if (this.callstackBuffer != null) {
                    this.trouble.stackTrace = this.callstackBuffer.toArray(new String[this.callstackBuffer.size()]);
                    this.callstackBuffer = null;
                }
                this.report.reportTest(this.testcase);
                this.trouble = null;
                this.testcase = null;
                return;
            }
            if (trimmed.startsWith("[catch] ")) {
                trimmed = trimmed.substring("[catch] ".length());
            }
            if (trimmed.startsWith("at ") && (matcher = this.regexp.getCallstackLinePattern().matcher(msg)).matches()) {
                if (this.callstackBuffer == null) {
                    this.callstackBuffer = new ArrayList(8);
                }
                this.callstackBuffer.add(trimmed.substring("at ".length()));
                this.setClasspathSourceRoots();
                return;
            }
            if (this.callstackBuffer == null && this.trouble.message != null) {
                this.trouble.message = this.trouble.message + '\n' + msg;
            }
            return;
        }
        if (msg.startsWith("Testcase: ")) {
            boolean success;
            if (this.report == null) {
                return;
            }
            String header = msg.substring("Testcase: ".length());
            boolean bl = this.lastHeaderBrief ? this.tryParseBriefHeader(header) || !(this.lastHeaderBrief = !this.tryParsePlainHeader(header)) : (success = this.tryParsePlainHeader(header) || (this.lastHeaderBrief = this.tryParseBriefHeader(header)));
            if (success) {
                this.waitingForIssueStatus = !this.lastHeaderBrief;
            }
        } else if (msg.startsWith("--------")) {
            if (this.report == null) {
                return;
            }
            matcher = this.regexp.getOutputDelimPattern().matcher(msg);
            if (matcher.matches()) {
                this.readingOutputReport = true;
            }
        } else if (this.expectXmlReport && msg.startsWith("<?xml")) {
            matcher = this.regexp.getXmlDeclPattern().matcher(msg.trim());
            if (matcher.matches()) {
                this.suiteStarted(null);
                this.xmlOutputBuffer = new StringBuffer(4096);
                this.xmlOutputBuffer.append(msg);
            }
        } else if (msg.startsWith("Testsuite: ")) {
            this.suiteName = msg.substring("Testsuite: ".length());
            if (this.regexp.getFullJavaIdPattern().matcher(this.suiteName).matches()) {
                this.suiteStarted(this.suiteName);
                this.report.resultsDir = JUnitOutputReader.determineResultsDir(event);
            }
        } else if (msg.startsWith("Tests run: ")) {
            block42: {
                if (this.report == null) {
                    return;
                }
                if (this.testsuiteStatsKnown) {
                    return;
                }
                matcher = this.regexp.getSuiteStatsPattern().matcher(msg);
                if (matcher.matches()) {
                    assert (this.report != null);
                    try {
                        this.report.totalTests = Integer.parseInt(matcher.group(1));
                        this.report.failures = Integer.parseInt(matcher.group(2));
                        this.report.errors = Integer.parseInt(matcher.group(3));
                        this.report.elapsedTimeMillis = this.regexp.parseTimeMillis(matcher.group(4));
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block42;
                        throw new AssertionError();
                    }
                }
            }
            this.testsuiteStatsKnown = true;
        } else if (this.suiteName != null && msg.startsWith("Test ") && msg.endsWith(" FAILED") && msg.equals("Test " + this.suiteName + " FAILED")) {
            this.suiteName = null;
        } else {
            this.displayOutput(msg, event.getLogLevel() == 1);
        }
    }

    private static File determineResultsDir(AntEvent event) {
        TaskStructure[] taskChildren;
        File resultsDir = null;
        String dirName = null;
        TaskStructure taskStruct = event.getTaskStructure();
        if (taskStruct != null && (taskChildren = taskStruct.getChildren()).length != 0) {
            for (int i = 0; i < taskChildren.length; ++i) {
                TaskStructure taskChild = taskChildren[i];
                String taskChildName = taskChild.getName();
                if (!taskChildName.equals("batchtest") && !taskChildName.equals("test")) continue;
                String dirAttr = taskChild.getAttribute("todir");
                dirName = dirAttr != null ? event.evaluate(dirAttr) : ".";
                break;
            }
        }
        if (dirName != null) {
            resultsDir = new File(dirName);
            if (!resultsDir.isAbsolute()) {
                resultsDir = new File(event.getProperty("basedir"), dirName);
            }
            if (!resultsDir.exists() || !resultsDir.isDirectory()) {
                resultsDir = null;
            }
        } else {
            resultsDir = null;
        }
        return resultsDir;
    }

    private Report createReport(String suiteName) {
        Report report = new Report(suiteName);
        report.antScript = this.antScript;
        report.classpath = this.classpath;
        report.platformSources = this.platformSources;
        this.classpath = null;
        this.platformSources = null;
        return report;
    }

    private ClassPath findPlatformSources(String javaExecutable) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            File f;
            FileObject fo = platforms[i].findTool("java");
            if (fo == null || !(f = FileUtil.toFile((FileObject)fo)).getAbsolutePath().startsWith(javaExecutable)) continue;
            return platforms[i].getSourceFolders();
        }
        return null;
    }

    private void setClasspathSourceRoots() {
        if (this.report == null) {
            return;
        }
        if (this.report.classpathSourceRoots != null) {
            return;
        }
        if (this.report.classpath == null) {
            return;
        }
        LinkedHashSet<Object> sourceRoots = new LinkedHashSet<Object>();
        StringTokenizer tok = new StringTokenizer(this.report.classpath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            URL root;
            URL binroot;
            String binrootS = tok.nextToken();
            File f = FileUtil.normalizeFile((File)new File(binrootS));
            try {
                binroot = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            if (FileUtil.isArchiveFile((URL)binroot) && (root = FileUtil.getArchiveRoot((URL)binroot)) != null) {
                binroot = root;
            }
            FileObject[] someRoots = SourceForBinaryQuery.findSourceRoots((URL)binroot).getRoots();
            sourceRoots.addAll(Arrays.asList((Object[])someRoots));
        }
        if (this.report.platformSources != null) {
            sourceRoots.addAll(Arrays.asList(this.report.platformSources.getRoots()));
        } else {
            JavaPlatform platform = JavaPlatform.getDefault();
            if (platform != null) {
                sourceRoots.addAll(Arrays.asList(platform.getSourceFolders().getRoots()));
            }
        }
        this.report.classpathSourceRoots = sourceRoots;
        this.report.classpath = null;
        this.report.platformSources = null;
    }

    void testTargetStarted() {
        this.checkTestTargetStarted();
    }

    void testTaskStarted(boolean expectXmlOutput) {
        this.expectXmlReport = expectXmlOutput;
        this.checkTestTaskStarted();
    }

    void buildFinished(AntEvent event) {
        this.finishReport(event.getException());
        Manager.getInstance().sessionFinished(this.session, this.sessionType, !this.testTaskStarted);
    }

    private Report suiteStarted(String suiteName) {
        this.closePreviousReport();
        this.report = this.createReport(suiteName);
        this.checkReportStarted();
        Manager.getInstance().displaySuiteRunning(this.session, this.sessionType, suiteName);
        return this.report;
    }

    private void suiteFinished(Report report) {
        Manager.getInstance().displayReport(this.session, this.sessionType, report);
    }

    void finishReport(Throwable exception) {
        if (this.waitingForIssueStatus) {
            assert (this.testcase != null);
            this.report.reportTest(this.testcase);
        }
        this.closePreviousReport();
    }

    private void displayOutput(String text, boolean error) {
        this.checkReportStarted();
        Manager.getInstance().displayOutput(this.session, this.sessionType, text, error);
    }

    private void checkTestTargetStarted() {
        if (!this.testTargetStarted) {
            this.testTargetStarted = true;
            Manager.getInstance().targetStarted(this.session, this.sessionType);
        }
    }

    private void checkTestTaskStarted() {
        if (!this.testTaskStarted) {
            this.testTargetStarted = true;
            this.testTaskStarted = true;
            Manager.getInstance().testStarted(this.session, this.sessionType);
        }
    }

    private void checkReportStarted() {
        this.checkTestTaskStarted();
        if (!this.reportStarted) {
            this.reportStarted = true;
            Manager.getInstance().reportStarted(this.session);
        }
    }

    private boolean tryParsePlainHeader(String testcaseHeader) {
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(testcaseHeader);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            int timeMillis = this.regexp.parseTimeMillisNoNFE(matcher.group(2));
            this.testcase = new Report.Testcase();
            this.testcase.className = null;
            this.testcase.name = methodName;
            this.testcase.timeMillis = timeMillis;
            this.trouble = null;
            return true;
        }
        return false;
    }

    private boolean tryParseBriefHeader(String testcaseHeader) {
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(testcaseHeader);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            String clsName = matcher.group(2);
            boolean error = matcher.group(3) == null;
            this.testcase = new Report.Testcase();
            this.testcase.className = clsName;
            this.testcase.name = methodName;
            this.testcase.timeMillis = -1;
            this.trouble = this.testcase.trouble = new Report.Trouble(error);
            return true;
        }
        return false;
    }

    private void closePreviousReport() {
        block13: {
            long fileSize;
            File reportFile;
            if (this.xmlOutputBuffer != null) {
                try {
                    String xmlOutput = this.xmlOutputBuffer.toString();
                    this.xmlOutputBuffer = null;
                    Report xmlReport = XmlOutputParser.parseXmlOutput(new StringReader(xmlOutput));
                    this.report.update(xmlReport);
                }
                catch (SAXException ex) {
                }
                catch (IOException ex) {
                    assert (false);
                }
            } else if (this.report != null && this.report.resultsDir != null && (reportFile = new File(this.report.resultsDir, "TEST-" + this.report.suiteClassName + ".xml")).exists() && reportFile.isFile() && reportFile.canRead() && reportFile.lastModified() >= this.timeOfSessionStart && (fileSize = reportFile.length()) > 0L && fileSize <= 524288L) {
                try {
                    Report fileReport = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(reportFile), "UTF-8"));
                    this.report.update(fileReport);
                }
                catch (UnsupportedCharsetException ex) {
                    assert (false);
                }
                catch (SAXException ex) {
                }
                catch (IOException ex) {
                    int severity = 1;
                    ErrorManager errMgr = ErrorManager.getDefault();
                    if (!errMgr.isLoggable(severity)) break block13;
                    errMgr.notify(severity, errMgr.annotate((Throwable)ex, "I/O exception while reading JUnit XML report file from JUnit: "));
                }
            }
        }
        if (this.report != null) {
            this.suiteFinished(this.report);
        }
        this.callstackBuffer = null;
        this.xmlOutputBuffer = null;
        this.readingOutputReport = false;
        this.testcase = null;
        this.trouble = null;
        this.report = null;
        this.testsuiteStatsKnown = false;
    }
}

