/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionLayoutPopup;
import org.netbeans.modules.editor.completion.CompletionScrollPane;
import org.netbeans.modules.editor.completion.DocumentationScrollPane;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;

public final class CompletionLayout {
    public static final int COMPLETION_ITEM_HEIGHT = 16;
    private static final float COMPLETION_WIDTH_THRESHOLD = 0.5f;
    private static final float COMPLETION_HEIGHT_THRESHOLD = 0.7f;
    private static final int COMPLETION_ANCHOR_HORIZONTAL_SHIFT = 25;
    static final int POPUP_VERTICAL_GAP = 1;
    private Reference editorComponentRef;
    private final CompletionPopup completionPopup = new CompletionPopup();
    private final DocPopup docPopup;
    private final TipPopup tipPopup;
    private Stack visiblePopups;

    CompletionLayout() {
        this.completionPopup.setLayout(this);
        this.completionPopup.setPreferDisplayAboveCaret(true);
        this.docPopup = new DocPopup();
        this.docPopup.setLayout(this);
        this.docPopup.setPreferDisplayAboveCaret(false);
        this.tipPopup = new TipPopup();
        this.tipPopup.setLayout(this);
        this.tipPopup.setPreferDisplayAboveCaret(true);
        this.visiblePopups = new Stack();
    }

    public JTextComponent getEditorComponent() {
        return this.editorComponentRef != null ? (JTextComponent)this.editorComponentRef.get() : null;
    }

    public void setEditorComponent(JTextComponent editorComponent) {
        this.hideAll();
        this.editorComponentRef = new WeakReference<JTextComponent>(editorComponent);
    }

    private void hideAll() {
        this.completionPopup.hide();
        this.docPopup.hide();
        this.tipPopup.hide();
        this.visiblePopups.clear();
    }

    public void showCompletion(List data, String title, int anchorOffset, ListSelectionListener listSelectionListener) {
        this.completionPopup.show(data, title, anchorOffset, listSelectionListener);
        if (!this.visiblePopups.contains(this.completionPopup)) {
            this.visiblePopups.push(this.completionPopup);
        }
    }

    public boolean hideCompletion() {
        if (this.completionPopup.isVisible()) {
            this.completionPopup.hide();
            this.visiblePopups.remove(this.completionPopup);
            return true;
        }
        return false;
    }

    public boolean isCompletionVisible() {
        return this.completionPopup.isVisible();
    }

    public CompletionItem getSelectedCompletionItem() {
        return this.completionPopup.getSelectedCompletionItem();
    }

    public void processKeyEvent(KeyEvent evt) {
        for (int i = this.visiblePopups.size() - 1; i >= 0; --i) {
            CompletionLayoutPopup popup = (CompletionLayoutPopup)this.visiblePopups.get(i);
            popup.processKeyEvent(evt);
            if (!evt.isConsumed()) continue;
            return;
        }
    }

    public void showDocumentation(CompletionDocumentation doc, int anchorOffset) {
        this.docPopup.show(doc, anchorOffset);
        if (!this.visiblePopups.contains(this.docPopup)) {
            this.visiblePopups.push(this.docPopup);
        }
    }

    public boolean hideDocumentation() {
        if (this.docPopup.isVisible()) {
            this.docPopup.hide();
            this.visiblePopups.remove(this.docPopup);
            return true;
        }
        return false;
    }

    public boolean isDocumentationVisible() {
        return this.docPopup.isVisible();
    }

    public void clearDocumentationHistory() {
        this.docPopup.clearHistory();
    }

    public void showToolTip(JToolTip toolTip, int anchorOffset) {
        this.tipPopup.show(toolTip, anchorOffset);
        if (!this.visiblePopups.contains(this.tipPopup)) {
            this.visiblePopups.push(this.tipPopup);
        }
    }

    public boolean hideToolTip() {
        if (this.tipPopup.isVisible()) {
            this.tipPopup.hide();
            this.visiblePopups.remove(this.tipPopup);
            return true;
        }
        return false;
    }

    public boolean isToolTipVisible() {
        return this.tipPopup.isVisible();
    }

    void updateLayout(CompletionLayoutPopup popup) {
        popup.resetPreferredSize();
        if (popup == this.completionPopup) {
            if (this.isToolTipVisible()) {
                boolean wantAboveCaret;
                boolean bl = wantAboveCaret = !this.tipPopup.isDisplayAboveCaret();
                if (this.completionPopup.isEnoughSpace(wantAboveCaret)) {
                    this.completionPopup.showAlongAnchorBounds(wantAboveCaret);
                } else {
                    Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
                    occupiedBounds = this.tipPopup.unionBounds(occupiedBounds);
                    this.completionPopup.showAlongOccupiedBounds(occupiedBounds, this.tipPopup.isDisplayAboveCaret());
                }
            } else {
                popup.showAlongAnchorBounds();
            }
            if (this.docPopup.isVisible() && (this.docPopup.isOverlapped(popup) || this.docPopup.isOverlapped(this.tipPopup) || this.docPopup.getAnchorOffset() != this.completionPopup.getAnchorOffset() || !this.docPopup.isShowRetainedPreferredSize())) {
                this.updateLayout(this.docPopup);
            }
        } else if (popup == this.docPopup) {
            if (this.isCompletionVisible()) {
                popup.setAnchorOffset(this.completionPopup.getAnchorOffset());
            }
            Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
            occupiedBounds = this.tipPopup.unionBounds(this.completionPopup.unionBounds(occupiedBounds));
            this.docPopup.showAlongOccupiedBounds(occupiedBounds);
        } else if (popup == this.tipPopup) {
            popup.showAlongAnchorBounds();
            if (this.completionPopup.isOverlapped(popup) || this.docPopup.isOverlapped(popup)) {
                this.updateLayout(this.completionPopup);
            }
        }
    }

    private static final class TipPopup
    extends CompletionLayoutPopup {
        private TipPopup() {
        }

        protected void show(JToolTip toolTip, int anchorOffset) {
            Dimension lastSize;
            if (this.isVisible()) {
                lastSize = this.getContentComponent().getSize();
                this.resetPreferredSize();
            } else {
                lastSize = new Dimension(0, 0);
            }
            this.setContentComponent(toolTip);
            this.setAnchorOffset(anchorOffset);
            if (!this.getPreferredSize().equals(lastSize)) {
                this.getLayout().updateLayout(this);
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            if (this.isVisible() && KeyStroke.getKeyStroke(27, 0).equals(KeyStroke.getKeyStrokeForEvent(evt))) {
                evt.consume();
                CompletionImpl.get().hideToolTip();
            }
        }
    }

    private static final class DocPopup
    extends CompletionLayoutPopup {
        private DocPopup() {
        }

        private DocumentationScrollPane getDocumentationScrollPane() {
            return (DocumentationScrollPane)this.getContentComponent();
        }

        protected void show(CompletionDocumentation doc, int anchorOffset) {
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            if (!this.isVisible()) {
                this.setContentComponent(new DocumentationScrollPane(editorComponent));
            }
            this.getDocumentationScrollPane().setData(doc);
            if (!this.isVisible()) {
                this.setAnchorOffset(anchorOffset);
                this.getLayout().updateLayout(this);
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.getDocumentationScrollPane().getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.getDocumentationScrollPane().getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.getDocumentationScrollPane(), 0, null));
                evt.consume();
            }
        }

        public void clearHistory() {
            if (this.isVisible()) {
                this.getDocumentationScrollPane().clearHistory();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 25;
        }
    }

    private static final class CompletionPopup
    extends CompletionLayoutPopup {
        private CompletionPopup() {
        }

        private CompletionScrollPane getCompletionScrollPane() {
            return (CompletionScrollPane)this.getContentComponent();
        }

        public void show(List data, String title, int anchorOffset, ListSelectionListener listSelectionListener) {
            Dimension lastSize;
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            int lastAnchorOffset = this.getAnchorOffset();
            if (this.isVisible()) {
                lastSize = this.getContentComponent().getSize();
                this.resetPreferredSize();
            } else {
                lastSize = new Dimension(0, 0);
                this.setContentComponent(new CompletionScrollPane(editorComponent, listSelectionListener, new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        CompletionItem selectedItem;
                        JTextComponent c = CompletionPopup.this.getEditorComponent();
                        if (SwingUtilities.isLeftMouseButton(evt) && c != null && evt.getClickCount() == 2 && (selectedItem = CompletionPopup.this.getCompletionScrollPane().getSelectedCompletionItem()) != null) {
                            selectedItem.defaultAction(c);
                        }
                    }
                }));
            }
            this.getCompletionScrollPane().setData(data, title);
            this.setAnchorOffset(anchorOffset);
            Dimension prefSize = this.getPreferredSize();
            boolean changePopupSize = this.isVisible() ? prefSize.height > lastSize.height || prefSize.width > lastSize.width || (float)prefSize.height < (float)lastSize.height * 0.7f || (float)prefSize.width < (float)lastSize.width * 0.5f || anchorOffset != lastAnchorOffset : true;
            if (changePopupSize) {
                this.getLayout().updateLayout(this);
            }
        }

        public CompletionItem getSelectedCompletionItem() {
            return this.isVisible() ? this.getCompletionScrollPane().getSelectedCompletionItem() : null;
        }

        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.getCompletionScrollPane().getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.getCompletionScrollPane().getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.getCompletionScrollPane(), 0, null));
                evt.consume();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 25;
        }
    }
}

