/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public final class J2eeVersionWarningPanel
extends JPanel {
    public static final String WARN_SET_JDK_14 = "warnSetJdk14";
    public static final String WARN_SET_JDK_15 = "warnSetJdk15";
    public static final String WARN_SET_SOURCE_LEVEL_14 = "warnSetSourceLevel14";
    public static final String WARN_SET_SOURCE_LEVEL_15 = "warnSetSourceLevel15";
    private String warningType;
    private String javaPlatformName;
    private JCheckBox downgradeJdk14CheckBox;
    private JCheckBox downgradeJdk15CheckBox;
    private JCheckBox downgradeSourceLevel14CheckBox;
    private JCheckBox downgradeSourceLevel15CheckBox;
    private JPanel setJdk14Panel;
    private JPanel setJdk15Panel;
    private JPanel setSourceLevel14Panel;
    private JPanel setSourceLevel15Panel;
    private JTextArea warningJdk14TextArea;
    private JTextArea warningJdk15TextArea;
    private JTextArea warningSourceLevel14TextArea;
    private JTextArea warningSourceLevel15TextArea;

    public J2eeVersionWarningPanel(String warningType) {
        this.initComponents();
        this.setWarningType(warningType);
    }

    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        this.warningType = warningType;
        this.setJdk14Panel.setVisible(false);
        this.setSourceLevel14Panel.setVisible(false);
        this.setJdk15Panel.setVisible(false);
        this.setSourceLevel15Panel.setVisible(false);
        if (WARN_SET_JDK_14.equals(warningType)) {
            this.setJdk14Panel.setVisible(true);
            this.downgradeJdk14CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetJdk14());
        } else if (WARN_SET_SOURCE_LEVEL_14.equals(warningType)) {
            this.setSourceLevel14Panel.setVisible(true);
            this.downgradeSourceLevel14CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetSourceLevel14());
        } else if (WARN_SET_JDK_15.equals(warningType)) {
            this.setJdk15Panel.setVisible(true);
            this.downgradeJdk15CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetJdk15());
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(warningType)) {
            this.setSourceLevel15Panel.setVisible(true);
            this.downgradeSourceLevel15CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetSourceLevel15());
        }
    }

    public boolean getDowngradeAllowed() {
        if (WARN_SET_JDK_14.equals(this.warningType)) {
            return this.downgradeJdk14CheckBox.isSelected();
        }
        if (WARN_SET_SOURCE_LEVEL_14.equals(this.warningType)) {
            return this.downgradeSourceLevel14CheckBox.isSelected();
        }
        if (WARN_SET_JDK_15.equals(this.warningType)) {
            return this.downgradeJdk15CheckBox.isSelected();
        }
        if (WARN_SET_SOURCE_LEVEL_15.equals(this.warningType)) {
            return this.downgradeSourceLevel15CheckBox.isSelected();
        }
        return false;
    }

    public String getSuggestedJavaPlatformName() {
        JavaPlatform[] java14Platforms;
        if (this.javaPlatformName == null && WARN_SET_JDK_14.equals(this.warningType)) {
            java14Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            this.javaPlatformName = java14Platforms[0].getDisplayName();
        }
        if (this.javaPlatformName == null && WARN_SET_JDK_15.equals(this.warningType)) {
            java14Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            this.javaPlatformName = java14Platforms[0].getDisplayName();
        }
        return this.javaPlatformName;
    }

    public static String findWarningType(String j2eeLevel) {
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion version = defaultPlatform.getSpecification().getVersion();
        if (new SpecificationVersion("1.4").equals((Object)version) && j2eeLevel.equals("1.4")) {
            return null;
        }
        if (new SpecificationVersion("1.5").equals((Object)version) && j2eeLevel.equals("1.5")) {
            return null;
        }
        if (j2eeLevel.equals("1.4")) {
            JavaPlatform[] java14Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            if (java14Platforms.length > 0) {
                return WARN_SET_JDK_14;
            }
            return WARN_SET_SOURCE_LEVEL_14;
        }
        assert (j2eeLevel.equals("1.5"));
        JavaPlatform[] java15Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
        if (java15Platforms.length > 0) {
            return WARN_SET_JDK_15;
        }
        return WARN_SET_SOURCE_LEVEL_15;
    }

    private static JavaPlatform[] getJavaPlatforms(String level) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", new SpecificationVersion(level)));
    }

    private void initComponents() {
        this.setJdk14Panel = new JPanel();
        this.warningJdk14TextArea = new JTextArea();
        this.downgradeJdk14CheckBox = new JCheckBox();
        this.setSourceLevel15Panel = new JPanel();
        this.warningSourceLevel15TextArea = new JTextArea();
        this.downgradeSourceLevel15CheckBox = new JCheckBox();
        this.setJdk15Panel = new JPanel();
        this.warningJdk15TextArea = new JTextArea();
        this.downgradeJdk15CheckBox = new JCheckBox();
        this.setSourceLevel14Panel = new JPanel();
        this.warningSourceLevel14TextArea = new JTextArea();
        this.downgradeSourceLevel14CheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setJdk14Panel.setLayout(new GridBagLayout());
        this.warningJdk14TextArea.setEditable(false);
        this.warningJdk14TextArea.setLineWrap(true);
        this.warningJdk14TextArea.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk14"));
        this.warningJdk14TextArea.setWrapStyleWord(true);
        this.warningJdk14TextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.setJdk14Panel.add((Component)this.warningJdk14TextArea, gridBagConstraints);
        this.warningJdk14TextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSN_Recommendation"));
        this.warningJdk14TextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSD_Recommendation"));
        this.downgradeJdk14CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetJdk14").charAt(0));
        this.downgradeJdk14CheckBox.setSelected(true);
        this.downgradeJdk14CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk14"));
        this.downgradeJdk14CheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.downgradeJdk14CheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2eeVersionWarningPanel.this.downgradeJdk14CheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setJdk14Panel.add((Component)this.downgradeJdk14CheckBox, gridBagConstraints);
        this.downgradeJdk14CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk14"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.setJdk14Panel, gridBagConstraints);
        this.setSourceLevel15Panel.setLayout(new GridBagLayout());
        this.warningSourceLevel15TextArea.setEditable(false);
        this.warningSourceLevel15TextArea.setLineWrap(true);
        this.warningSourceLevel15TextArea.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel15"));
        this.warningSourceLevel15TextArea.setWrapStyleWord(true);
        this.warningSourceLevel15TextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.setSourceLevel15Panel.add((Component)this.warningSourceLevel15TextArea, gridBagConstraints);
        this.warningSourceLevel15TextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSN_Recommendation"));
        this.warningSourceLevel15TextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSD_Recommendation"));
        this.downgradeSourceLevel15CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetSourceLevel15").charAt(0));
        this.downgradeSourceLevel15CheckBox.setSelected(true);
        this.downgradeSourceLevel15CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel15"));
        this.downgradeSourceLevel15CheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.downgradeSourceLevel15CheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2eeVersionWarningPanel.this.downgradeSourceLevel15CheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setSourceLevel15Panel.add((Component)this.downgradeSourceLevel15CheckBox, gridBagConstraints);
        this.downgradeSourceLevel15CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel15"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.setSourceLevel15Panel, gridBagConstraints);
        this.setJdk15Panel.setLayout(new GridBagLayout());
        this.warningJdk15TextArea.setEditable(false);
        this.warningJdk15TextArea.setLineWrap(true);
        this.warningJdk15TextArea.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk15"));
        this.warningJdk15TextArea.setWrapStyleWord(true);
        this.warningJdk15TextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.setJdk15Panel.add((Component)this.warningJdk15TextArea, gridBagConstraints);
        this.warningJdk15TextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSN_Recommendation"));
        this.warningJdk15TextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSD_Recommendation"));
        this.downgradeJdk15CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetJdk15").charAt(0));
        this.downgradeJdk15CheckBox.setSelected(true);
        this.downgradeJdk15CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk15"));
        this.downgradeJdk15CheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.downgradeJdk15CheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2eeVersionWarningPanel.this.downgradeJdk15CheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setJdk15Panel.add((Component)this.downgradeJdk15CheckBox, gridBagConstraints);
        this.downgradeJdk15CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk15"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.setJdk15Panel, gridBagConstraints);
        this.setSourceLevel14Panel.setLayout(new GridBagLayout());
        this.warningSourceLevel14TextArea.setEditable(false);
        this.warningSourceLevel14TextArea.setLineWrap(true);
        this.warningSourceLevel14TextArea.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel14"));
        this.warningSourceLevel14TextArea.setWrapStyleWord(true);
        this.warningSourceLevel14TextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.setSourceLevel14Panel.add((Component)this.warningSourceLevel14TextArea, gridBagConstraints);
        this.warningSourceLevel14TextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSN_Recommendation"));
        this.warningSourceLevel14TextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"ACSD_Recommendation"));
        this.downgradeSourceLevel14CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetSourceLevel14").charAt(0));
        this.downgradeSourceLevel14CheckBox.setSelected(true);
        this.downgradeSourceLevel14CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel14"));
        this.downgradeSourceLevel14CheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.downgradeSourceLevel14CheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                J2eeVersionWarningPanel.this.downgradeSourceLevel14CheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setSourceLevel14Panel.add((Component)this.downgradeSourceLevel14CheckBox, gridBagConstraints);
        this.downgradeSourceLevel14CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel14"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.setSourceLevel14Panel, gridBagConstraints);
    }

    private void downgradeSourceLevel15CheckBoxActionPerformed(ActionEvent evt) {
        FoldersListSettings.getDefault().setAgreedSetSourceLevel15(this.downgradeSourceLevel15CheckBox.isSelected());
    }

    private void downgradeJdk15CheckBoxActionPerformed(ActionEvent evt) {
        FoldersListSettings.getDefault().setAgreedSetJdk15(this.downgradeJdk15CheckBox.isSelected());
    }

    private void downgradeSourceLevel14CheckBoxActionPerformed(ActionEvent evt) {
        FoldersListSettings.getDefault().setAgreedSetSourceLevel14(this.downgradeSourceLevel14CheckBox.isSelected());
    }

    private void downgradeJdk14CheckBoxActionPerformed(ActionEvent evt) {
        FoldersListSettings.getDefault().setAgreedSetJdk14(this.downgradeJdk14CheckBox.isSelected());
    }
}

