/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.wizards.NewEarProjectWizardIterator;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompleteEarProjectWizardIterator
extends NewEarProjectWizardIterator {
    @Override
    public Set instantiate() throws IOException {
        File dirF = (File)this.wiz.getProperty("projdir");
        String name = (String)this.wiz.getProperty("name");
        String serverInstanceID = (String)this.wiz.getProperty("serverInstanceID");
        String j2eeLevel = (String)this.wiz.getProperty("j2eeLevel");
        String sourceLevel = (String)this.wiz.getProperty("setSourceLevel");
        return this.testableInstantiate(dirF, name, j2eeLevel, serverInstanceID, sourceLevel);
    }

    Set<FileObject> testableInstantiate(File dirF, String name, String j2eeLevel, String serverInstanceID, String sourceLevel) throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        AntProjectHelper h = EarProjectGenerator.createProject(dirF, name, j2eeLevel, serverInstanceID, sourceLevel);
        String tmp = CompleteEarProjectWizardIterator.constructWarName(name);
        File webAppDir = new File(dirF, tmp);
        tmp = CompleteEarProjectWizardIterator.constructEjbJarName(name);
        File ejbJarDir = new File(dirF, tmp);
        tmp = CompleteEarProjectWizardIterator.constructCarName(name);
        File carDir = new File(dirF, tmp);
        try {
            FileObject webRoot = h.getProjectDirectory().getFileObject("web");
            FileObject indexJSPFo = this.getIndexJSPFO(webRoot, "index");
            assert (indexJSPFo != null) : "webRoot: " + webRoot + ", defaultJSP: index";
            resultSet.add(indexJSPFo);
        }
        catch (Exception x) {
            // empty catch block
        }
        FileObject dir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dirF));
        Project p = ProjectManager.getDefault().findProject(dir);
        resultSet.add(dir);
        try {
            AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
            ReferenceHelper refHelper = new ReferenceHelper(h, aux, h.getStandardPropertyEvaluator());
            EarProjectProperties epp = new EarProjectProperties((EarProject)p.getLookup().lookup(EarProject.class), refHelper, new EarProjectType());
            h = EjbJarProjectGenerator.createProject((File)FileUtil.normalizeFile((File)ejbJarDir), (String)CompleteEarProjectWizardIterator.constructEjbJarProjectName(name), (String)EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR), (String)serverInstanceID);
            FileObject dir2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)ejbJarDir));
            resultSet.add(dir2);
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[]{p});
            WebProjectCreateData createData = new WebProjectCreateData();
            createData.setProjectDir(FileUtil.normalizeFile((File)webAppDir));
            createData.setName(CompleteEarProjectWizardIterator.constructWebProjectName(name));
            createData.setServerInstanceID(serverInstanceID);
            createData.setSourceStructure("BluePrints");
            createData.setJavaEEVersion(EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR));
            createData.setContextPath("/" + CompleteEarProjectWizardIterator.constructWebProjectName(name));
            h = WebProjectUtilities.createProject((WebProjectCreateData)createData);
            dir2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)webAppDir));
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[]{p});
            resultSet.add(dir2);
            h = AppClientProjectGenerator.createProject((File)FileUtil.normalizeFile((File)carDir), (String)CompleteEarProjectWizardIterator.constructCarProjectName(name), null, (String)EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR), (String)serverInstanceID);
            dir2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)carDir));
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[]{p});
            resultSet.add(dir2);
        }
        catch (SecurityException se) {
            ErrorManager.getDefault().log(1, se.getLocalizedMessage());
        }
        return resultSet;
    }

    private static String constructWarName(String name) {
        return name.toLowerCase(Locale.US) + "-war";
    }

    private static String constructEjbJarName(String name) {
        return name.toLowerCase(Locale.US) + "-ejb";
    }

    private static String constructWebProjectName(String name) {
        return name.toLowerCase(Locale.US) + "-war";
    }

    private static String constructEjbJarProjectName(String name) {
        return name.toLowerCase(Locale.US) + "-ejb";
    }

    private static String constructCarName(String name) {
        return name.toLowerCase(Locale.US) + "-car";
    }

    private static String constructCarProjectName(String name) {
        return name.toLowerCase(Locale.US) + "-car";
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(CompleteEarProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }
}

