/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.Vector;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeployer;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.EarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.EjbDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.util.WLDebug;
import org.openide.ErrorManager;

public class WLDeploymentManager
implements DeploymentManager {
    private DeploymentManager dm;
    private InstanceProperties instanceProperties;
    private String uri;
    private String username;
    private String password;
    private boolean isConnected;
    private String host;
    private String port;
    private Process process;
    private ClassLoader swapLoader;

    public WLDeploymentManager(DeploymentManager dm, String uri, String username, String password, String host, String port) {
        this.dm = dm;
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.isConnected = true;
    }

    public WLDeploymentManager(DeploymentManager dm, String uri, String host, String port) {
        this.dm = dm;
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.isConnected = false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getURI() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.getInstanceProperties().getProperty("username");
    }

    public String getPassword() {
        return this.getInstanceProperties().getProperty("password");
    }

    public String getPort() {
        return this.port;
    }

    public boolean isLocal() {
        return new Boolean(this.getInstanceProperties().getProperty("isLocal"));
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.uri);
        }
        return this.instanceProperties;
    }

    public synchronized void setServerProcess(Process process) {
        this.process = process;
    }

    public synchronized Process getServerProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(this.getClass(), "distribute(" + target + ", " + file + ", " + file2 + ")");
        }
        if (this.isLocal()) {
            return new WLDeployer(this.uri).deploy(target, file, file2, this.getHost(), this.getPort());
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.distribute(target, file, file2));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    private void modifiedLoader() {
        this.swapLoader = Thread.currentThread().getContextClassLoader();
        String serverRoot = this.getInstanceProperties().getProperty("serverRoot");
        if (serverRoot == null) {
            serverRoot = WLPluginProperties.getInstance().getInstallLocation();
        }
        Thread.currentThread().setContextClassLoader(WLDeploymentFactory.getWLClassLoader(serverRoot));
    }

    private void originalLoader() {
        Thread.currentThread().setContextClassLoader(this.swapLoader);
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        ModuleType type = deployableObject.getType();
        if (type == ModuleType.WAR) {
            return new WarDeploymentConfiguration(deployableObject);
        }
        if (type == ModuleType.EAR) {
            return new EarDeploymentConfiguration(deployableObject);
        }
        if (type == ModuleType.EJB) {
            return new EjbDeploymentConfiguration(deployableObject);
        }
        throw new InvalidModuleException("Unsupported module type: " + type.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("redeploy(" + targetModuleID + ", " + inputStream + ", " + inputStream2 + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.redeploy(targetModuleID, inputStream, inputStream2));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("distribute(" + target + ", " + inputStream + ", " + inputStream2 + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.distribute(target, inputStream, inputStream2));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("undeploy(" + targetModuleID + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.undeploy(targetModuleID));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("stop(" + targetModuleID + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.stop(targetModuleID));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("start(" + targetModuleID + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.start(targetModuleID));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getAvailableModules(" + moduleType + ", " + target + ")");
        }
        this.modifiedLoader();
        try {
            TargetModuleID[] t;
            TargetModuleID[] targetModuleIDArray = t = this.dm.getAvailableModules(moduleType, target);
            return targetModuleIDArray;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getNonRunningModules(" + moduleType + ", " + target + ")");
        }
        this.modifiedLoader();
        try {
            TargetModuleID[] t = this.dm.getNonRunningModules(moduleType, target);
            for (int i = 0; i < t.length; ++i) {
                System.out.println("non running module:" + t[i]);
            }
            TargetModuleID[] targetModuleIDArray = t;
            return targetModuleIDArray;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getRunningModules(" + moduleType + ", " + target + ")");
        }
        this.modifiedLoader();
        try {
            TargetModuleID[] t = this.dm.getRunningModules(moduleType, target);
            for (int i = 0; i < t.length; ++i) {
                System.out.println("running module:" + t[i]);
            }
            TargetModuleID[] targetModuleIDArray = t;
            return targetModuleIDArray;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("redeploy(" + targetModuleID + ", " + file + ", " + file2 + ")");
        }
        this.modifiedLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.dm.redeploy(targetModuleID, file, file2));
            return delegatingProgressObject;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) throws UnsupportedOperationException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("setLocale(" + locale + ")");
        }
        this.modifiedLoader();
        try {
            this.dm.setLocale(locale);
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocaleSupported(Locale locale) {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("isLocaleSupported(" + locale + ")");
        }
        this.modifiedLoader();
        try {
            boolean bl = this.dm.isLocaleSupported(locale);
            return bl;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("setDConfigBeanVersion(" + dConfigBeanVersionType + ")");
        }
        this.modifiedLoader();
        try {
            this.dm.setDConfigBeanVersion(dConfigBeanVersionType);
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("isDConfigBeanVersionSupported(" + dConfigBeanVersionType + ")");
        }
        this.modifiedLoader();
        try {
            boolean bl = this.dm.isDConfigBeanVersionSupported(dConfigBeanVersionType);
            return bl;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block9: {
            if (WLDebug.isEnabled()) {
                WLDebug.notify("release()");
            }
            this.modifiedLoader();
            try {
                if (this.dm == null) break block9;
                try {
                    this.dm.release();
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                finally {
                    this.dm = null;
                }
            }
            finally {
                this.originalLoader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRedeploySupported() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("isRedeploySupported()");
        }
        this.modifiedLoader();
        try {
            boolean bl = this.dm.isRedeploySupported();
            return bl;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getCurrentLocale() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getCurrentLocale()");
        }
        this.modifiedLoader();
        try {
            Locale locale = this.dm.getCurrentLocale();
            return locale;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DConfigBeanVersionType getDConfigBeanVersion() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getDConfigBeanVersion()");
        }
        this.modifiedLoader();
        try {
            DConfigBeanVersionType dConfigBeanVersionType = this.dm.getDConfigBeanVersion();
            return dConfigBeanVersionType;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getDefaultLocale() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getDefaultLocale()");
        }
        this.modifiedLoader();
        try {
            Locale locale = this.dm.getDefaultLocale();
            return locale;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale[] getSupportedLocales() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getSupportedLocales()");
        }
        this.modifiedLoader();
        try {
            Locale[] localeArray = this.dm.getSupportedLocales();
            return localeArray;
        }
        finally {
            this.originalLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target[] getTargets() throws IllegalStateException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify("getTargets()");
        }
        this.modifiedLoader();
        try {
            Target[] targetArray = this.dm.getTargets();
            return targetArray;
        }
        finally {
            this.originalLoader();
        }
    }

    static class DelegatingProgressObject
    implements ProgressObject,
    ProgressListener {
        ProgressObject original;
        private Vector listeners = new Vector();

        DelegatingProgressObject(ProgressObject original) {
            this.original = original;
            original.addProgressListener((ProgressListener)this);
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.original.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return this.original.getResultTargetModuleIDs();
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return this.getClientConfiguration(targetModuleID);
        }

        public boolean isCancelSupported() {
            return this.original.isCancelSupported();
        }

        public void cancel() throws OperationUnsupportedException {
            this.original.cancel();
        }

        public boolean isStopSupported() {
            return this.original.isStopSupported();
        }

        public void stop() throws OperationUnsupportedException {
            this.original.stop();
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.listeners.add(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.listeners.remove(progressListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent progressEvent) {
            Vector targets = null;
            DelegatingProgressObject delegatingProgressObject = this;
            synchronized (delegatingProgressObject) {
                if (this.listeners != null) {
                    targets = (Vector)this.listeners.clone();
                }
            }
            if (targets != null) {
                for (int i = 0; i < targets.size(); ++i) {
                    ProgressListener target = (ProgressListener)targets.elementAt(i);
                    target.handleProgressEvent(progressEvent);
                }
            }
        }
    }
}

