/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Enumeration;
import java.util.WeakHashMap;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.util.WLDebug;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class WLDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:WebLogic:http://";
    private static WLDeploymentFactory instance;
    private DeploymentFactory wlFactory = null;
    private static final WeakHashMap<InstanceProperties, WLDeploymentManager> managerCache;
    private static WLClassLoader loader;

    public static synchronized DeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WLDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public static ClassLoader getWLClassLoader(String serverRoot) {
        if (loader == null) {
            WLDeploymentFactory.resetWLClassLoader(serverRoot);
        }
        return loader;
    }

    private static void resetWLClassLoader(String serverRoot) {
        loader = null;
        try {
            URL[] urls = new URL[]{new File(serverRoot + "/server/lib/weblogic.jar").toURI().toURL()};
            loader = new WLClassLoader(urls, WLDeploymentFactory.class.getClassLoader());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentManager getDM(String uri, String username, String password, String host, String port) throws DeploymentManagerCreationException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(WLDeploymentFactory.class, "getDM, uri:" + uri + " username:" + username + " password:" + password + " host:" + host + " port:" + port);
        }
        DeploymentManagerCreationException dmce = null;
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            String serverRoot = InstanceProperties.getInstanceProperties((String)uri).getProperty("serverRoot");
            if (serverRoot == null) {
                serverRoot = WLPluginProperties.getInstance().getInstallLocation();
            }
            ClassLoader loader = WLDeploymentFactory.getWLClassLoader(serverRoot);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> helperClazz = loader.loadClass("weblogic.deploy.api.tools.SessionHelper");
            Method m = helperClazz.getDeclaredMethod("getDeploymentManager", String.class, String.class, String.class, String.class);
            Object o = m.invoke(null, host, port, username, password);
            if (DeploymentManager.class.isAssignableFrom(o.getClass())) {
                DeploymentManager deploymentManager = (DeploymentManager)o;
                return deploymentManager;
            }
            dmce = new DeploymentManagerCreationException("Instance created by weblogic is not DeploymentManager instance.");
        }
        catch (Exception e) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            ErrorManager.getDefault().annotate((Throwable)dmce, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        throw dmce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentManager getDiscoDM(String uri) throws DeploymentManagerCreationException {
        DeploymentManagerCreationException dmce = null;
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            String serverRoot = InstanceProperties.getInstanceProperties((String)uri).getProperty("serverRoot");
            if (serverRoot == null) {
                serverRoot = WLPluginProperties.getInstance().getInstallLocation();
            }
            ClassLoader loader = WLDeploymentFactory.getWLClassLoader(serverRoot);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> helperClazz = loader.loadClass("weblogic.deploy.api.tools.SessionHelper");
            Method m = helperClazz.getDeclaredMethod("getDisconnectedDeploymentManager", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            if (DeploymentManager.class.isAssignableFrom(o.getClass())) {
                DeploymentManager deploymentManager = (DeploymentManager)o;
                return deploymentManager;
            }
            dmce = new DeploymentManagerCreationException("Instance created by weblogic is not disconnected DeploymentManager instance.");
        }
        catch (Exception e) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic disconnected DeploymentManager instance.");
            ErrorManager.getDefault().annotate((Throwable)dmce, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        throw dmce;
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(WLDeploymentFactory.class, "getDeploymentManager, uri:" + uri + " username:" + username + " password:" + password);
        }
        String[] parts = uri.split(":");
        String host = parts[3].substring(2);
        String port = parts[4];
        WLDeploymentManager dm = new WLDeploymentManager(this.getDM(uri, username, password, host, port), uri, username, password, host, port);
        this.updateManagerCache(dm, uri);
        return dm;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(WLDeploymentFactory.class, "getDisconnectedDeploymentManager, uri:" + uri);
        }
        String[] parts = uri.split(":");
        String host = parts[3].substring(2);
        String port = parts[4];
        WLDeploymentManager dm = new WLDeploymentManager(this.getDiscoDM(uri), uri, host, port);
        this.updateManagerCache(dm, uri);
        return dm;
    }

    private void updateManagerCache(WLDeploymentManager dm, String uri) {
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (managerCache.get(ip) != null) {
            dm.setServerProcess(managerCache.get(ip).getServerProcess());
        }
        managerCache.put(ip, dm);
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_productVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_displayName");
    }

    static {
        managerCache = new WeakHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WLClassLoader
    extends URLClassLoader {
        public WLClassLoader(URL[] urls, ClassLoader parent) throws MalformedURLException, RuntimeException {
            super(urls, parent);
        }

        public void addURL(File f) throws MalformedURLException, RuntimeException {
            if (f.isFile()) {
                this.addURL(f.toURL());
            }
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.indexOf("jndi.properties") != -1 || name.indexOf("i18n_user.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }
    }
}

