/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

final class FreeformEvaluator
implements PropertyEvaluator,
AntProjectListener,
PropertyChangeListener {
    private final FreeformProject project;
    private PropertyEvaluator delegate;
    private final List listeners = new ArrayList();
    private final Set intermediateEvaluators = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FreeformEvaluator(FreeformProject project) throws IOException {
        this.project = project;
        this.init();
        project.helper().addAntProjectListener((AntProjectListener)this);
    }

    private void init() throws IOException {
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.delegate = this.initEval();
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        if (org.netbeans.modules.ant.freeform.Util.err.isLoggable(1)) {
            org.netbeans.modules.ant.freeform.Util.err.log("properties for " + this.project.getProjectDirectory() + ": " + this.delegate.getProperties());
        }
    }

    private PropertyEvaluator initEval() throws IOException {
        Iterator ieIt = this.intermediateEvaluators.iterator();
        while (ieIt.hasNext()) {
            PropertyEvaluator intermediate = (PropertyEvaluator)ieIt.next();
            intermediate.removePropertyChangeListener((PropertyChangeListener)this);
            ieIt.remove();
        }
        PropertyProvider preprovider = this.project.helper().getStockPropertyPreprovider();
        ArrayList<PropertyProvider> defs = new ArrayList<PropertyProvider>();
        Element genldata = this.project.helper().getPrimaryConfigurationData(true);
        Element properties = Util.findElement(genldata, "properties", "http://www.netbeans.org/ns/freeform-project/1");
        if (properties != null) {
            List props = Util.findSubElements(properties);
            Iterator it = props.iterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (e.getLocalName().equals("property")) {
                    String val = Util.findText(e);
                    if (val == null) {
                        val = "";
                    }
                    defs.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap(e.getAttribute("name"), val)));
                    continue;
                }
                if (!$assertionsDisabled && !e.getLocalName().equals("property-file")) {
                    throw new AssertionError(e);
                }
                String fname = Util.findText(e);
                if (fname.indexOf("${") != -1) {
                    PropertyEvaluator intermediate = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)preprovider, (PropertyProvider[])defs.toArray(new PropertyProvider[defs.size()]));
                    fname = intermediate.evaluate(fname);
                    intermediate.addPropertyChangeListener((PropertyChangeListener)this);
                    this.intermediateEvaluators.add(intermediate);
                }
                defs.add(PropertyUtils.propertiesFilePropertyProvider((File)this.project.helper().resolveFile(fname)));
            }
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)preprovider, (PropertyProvider[])defs.toArray(new PropertyProvider[defs.size()]));
    }

    public String getProperty(String prop) {
        return this.delegate.getProperty(prop);
    }

    public String evaluate(String text) {
        return this.delegate.evaluate(text);
    }

    public Map getProperties() {
        return this.delegate.getProperties();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String prop) {
        PropertyChangeListener[] _listeners;
        FreeformEvaluator freeformEvaluator = this;
        synchronized (freeformEvaluator) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(this, prop, null, null);
        for (int i = 0; i < _listeners.length; ++i) {
            _listeners[i].propertyChange(ev);
        }
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.fireAnyChange();
    }

    private void fireAnyChange() {
        try {
            this.init();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        this.fireChange(null);
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object source = propertyChangeEvent.getSource();
        if (!$assertionsDisabled && !(source instanceof PropertyEvaluator)) {
            throw new AssertionError(source);
        }
        if (this.intermediateEvaluators.contains(source)) {
            this.fireAnyChange();
        } else {
            if (!$assertionsDisabled && source != this.delegate) {
                throw new AssertionError((Object)("Got change from " + source + " rather than current delegate " + this.delegate));
            }
            this.fireChange(propertyChangeEvent.getPropertyName());
        }
    }

    static {
        $assertionsDisabled = !FreeformEvaluator.class.desiredAssertionStatus();
    }
}

