/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    static ClassPath createClassPath(String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<PathResourceImplementation> list = new ArrayList<PathResourceImplementation>();
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken();
            File f = FileUtil.normalizeFile((File)new File(item));
            URL url = Util.getRootURL(f);
            if (url == null) continue;
            list.add(ClassPathSupport.createResource((URL)url));
        }
        return ClassPathSupport.createClassPath(list);
    }

    static URL getRootURL(File f) {
        try {
            String surl;
            URL url = f.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!f.exists() && !(surl = url.toExternalForm()).endsWith("/")) {
                url = new URL(surl + "/");
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String normalizeName(String displayName) {
        StringBuffer normalizedName = new StringBuffer();
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                normalizedName.append(c);
                continue;
            }
            normalizedName.append('_');
        }
        return normalizedName.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform plat) {
        String version = (String)plat.getSystemProperties().get("java.specification.version");
        if (version == null) {
            version = "1.1";
        }
        return Util.makeSpec(version);
    }

    public static FileObject findTool(String toolName, Collection installFolders) {
        return Util.findTool(toolName, installFolders, null);
    }

    public static FileObject findTool(String toolName, Collection installFolders, String archFolderName) {
        if (!$assertionsDisabled && toolName == null) {
            throw new AssertionError();
        }
        Iterator it = installFolders.iterator();
        while (it.hasNext()) {
            FileObject tool;
            FileObject root = (FileObject)it.next();
            FileObject bin = root.getFileObject("bin");
            if (bin == null || archFolderName != null && (bin = bin.getFileObject(archFolderName)) == null || (tool = bin.getFileObject(toolName, Utilities.isWindows() ? "exe" : null)) == null) continue;
            return tool;
        }
        return null;
    }

    public static String getExtensions(String extPath) {
        if (extPath == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tk = new StringTokenizer(extPath, File.pathSeparator);
        while (tk.hasMoreTokens()) {
            File extFolder = FileUtil.normalizeFile((File)new File(tk.nextToken()));
            File[] files = extFolder.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$platformdefinition$Util == null ? Util.class$("org.netbeans.modules.java.j2seplatform.platformdefinition.Util") : class$org$netbeans$modules$java$j2seplatform$platformdefinition$Util), (String)"MSG_BrokenExtension"), f, extFolder));
                    continue;
                }
                if (Utilities.getOperatingSystem() == 4096 && "._.DS_Store".equals(f.getName())) continue;
                FileObject fo = FileUtil.toFileObject((File)f);
                if (!$assertionsDisabled && fo == null) {
                    throw new AssertionError((Object)("Must have defined a FileObject for existent file " + f));
                }
                if (!FileUtil.isArchiveFile((FileObject)fo)) continue;
                sb.append(File.pathSeparator);
                sb.append(files[i].getAbsolutePath());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion(vers);
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

