/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.ArrayReferenceClass;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.ChangeModElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.CreateMethodElement;
import org.netbeans.modules.refactoring.EncapsulateFieldElement;
import org.netbeans.modules.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EncapsulateFieldRefactoringPlugin
extends JavaRefactoringPlugin {
    private final RefObject jmiObject;
    private Field encapsulatedField;
    private String getterName;
    private String setterName;
    private int methodModifiers;
    private int fieldModifiers;
    private Method currentGetter;
    private Method currentSetter;
    private static int accessModifiers = 7;
    private boolean alwaysUseAccessors;
    private EncapsulateFieldRefactoring refactoring;
    public static final String CLASS_FIELD_PREFIX = "_";

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring refactoring) {
        this.refactoring = refactoring;
        this.jmiObject = (RefObject)refactoring.getRefactoredObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            Problem result = EncapsulateFieldRefactoringPlugin.isElementAvail((Element)this.jmiObject);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            this.fireProgressListenerStep();
            if (!(this.jmiObject instanceof Field) || this.jmiObject instanceof EnumConstant) {
                Problem problem = EncapsulateFieldRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)EncapsulateFieldRefactoring.class, (String)"ERR_EncapsulateWrongType"));
                return problem;
            }
            this.encapsulatedField = (Field)this.jmiObject;
            if (!CheckUtils.isElementInOpenProject((Element)this.jmiObject)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    private Problem checkParameters(String getter, String setter, int accessModifier, int fieldModifier, boolean alwaysUseAccessors) {
        if (getter != null && !Utilities.isJavaIdentifier((String)getter) || setter != null && !Utilities.isJavaIdentifier((String)setter) || getter == null && setter == null) {
            return new Problem(true, NbBundle.getMessage((Class)EncapsulateFieldRefactoring.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(String getter, String setter, int accessModifier, int fieldModifier, boolean alwaysUseAccessors) {
        Object result = null;
        this.fireProgressListenerStart(2, 8);
        try {
            this.setterName = setter;
            this.getterName = getter;
            this.methodModifiers = accessModifier;
            this.fieldModifiers = fieldModifier;
            this.alwaysUseAccessors = alwaysUseAccessors;
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private TypeReference getTypeReference() {
        TypeReference ref = this.encapsulatedField.getTypeName();
        int dims = this.encapsulatedField.getDimCount();
        ref = (TypeReference)ref.duplicate();
        if (dims > 0) {
            if (ref instanceof ArrayReference) {
                ArrayReference arrRef = (ArrayReference)ref;
                arrRef.setDimCount(arrRef.getDimCount() + dims);
            } else {
                ArrayReferenceClass arrClass = ((JavaModelPackage)this.encapsulatedField.refImmediatePackage()).getArrayReference();
                ref = arrClass.createArrayReference(null, (MultipartId)ref, dims);
            }
        }
        return ref;
    }

    private void createGetterAndSetter(RefactoringElementsBag elms) {
        ClassMember cm;
        String fieldName = this.encapsulatedField.getName();
        int staticMod = this.encapsulatedField.getModifiers() & 8;
        String parName = staticMod != 0 ? "a" + EncapsulateFieldRefactoringPlugin.getCapitalizedName(this.encapsulatedField) : EncapsulateFieldRefactoringPlugin.stripPrefix(fieldName);
        String getterBody = "return ".concat(fieldName).concat(";");
        String setterBody = (staticMod == 0 ? "this." : "").concat(fieldName).concat(" = ").concat(parName).concat(";");
        Type fieldType = this.encapsulatedField.getType();
        ClassDefinition jcls = this.encapsulatedField.getDeclaringClass();
        JavaModelPackage modelExtent = (JavaModelPackage)jcls.refImmediatePackage();
        TypeReference fieldTypeName = this.getTypeReference();
        Parameter par = modelExtent.getParameter().createParameter(parName, null, false, null, 0, false);
        int newmods = this.methodModifiers | staticMod;
        List features = jcls.getContents();
        ListIterator iter = features.listIterator(features.size());
        ClassMember insertPoint = null;
        JavaMetamodel manager = JavaMetamodel.getManager();
        while (iter.hasPrevious() && manager.isElementGuarded((Element)(cm = (ClassMember)iter.previous()))) {
            insertPoint = cm;
        }
        par.setTypeName(fieldTypeName);
        Method method = this.currentGetter = this.getterName != null ? jcls.getMethod(this.getterName, Collections.EMPTY_LIST, false) : null;
        if (this.currentGetter == null && this.getterName != null) {
            CreateMethodElement getter = new CreateMethodElement(newmods, this.getterName, fieldTypeName, Collections.EMPTY_LIST, getterBody, insertPoint, jcls, true);
            elms.add(this.refactoring, getter);
        }
        Method method2 = this.currentSetter = this.setterName != null ? jcls.getMethod(this.setterName, Collections.singletonList(fieldType), false) : null;
        if (this.currentSetter == null && this.setterName != null) {
            boolean enabled = !Modifier.isFinal(this.encapsulatedField.getModifiers());
            CreateMethodElement setter = new CreateMethodElement(newmods, this.setterName, null, Collections.singletonList(par), setterBody, insertPoint, jcls, enabled);
            elms.add(this.refactoring, setter);
        }
    }

    private static String stripPrefix(String identifierString) {
        String stripped = identifierString.startsWith(CLASS_FIELD_PREFIX) ? identifierString.substring(CLASS_FIELD_PREFIX.length()) : identifierString;
        return stripped;
    }

    private static StringBuffer getCapitalizedName(Field field) {
        StringBuffer name = new StringBuffer(EncapsulateFieldRefactoringPlugin.stripPrefix(field.getName()));
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return name;
    }

    public static String computeSetterName(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return null;
        }
        StringBuffer name = EncapsulateFieldRefactoringPlugin.getCapitalizedName(field);
        name.insert(0, "set");
        return name.toString();
    }

    public static String computeGetterName(Field field) {
        StringBuffer name = EncapsulateFieldRefactoringPlugin.getCapitalizedName(field);
        Type retVal = field.getType();
        if (retVal instanceof PrimitiveType && ((PrimitiveType)retVal).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
            name.insert(0, "is");
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    private boolean isOutsideGetterSetter(Element el) {
        Feature f = JavaModelUtil.getDeclaringFeature((Element)el);
        return !f.equals(this.currentGetter) && !f.equals(this.currentSetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag elements) {
        this.fireProgressListenerStart(3, 9);
        try {
            int mods;
            this.fireProgressListenerStep();
            this.referencesIterator = this.encapsulatedField.getReferences().iterator();
            int targetMods = mods = this.encapsulatedField.getModifiers();
            if ((mods & accessModifiers) != this.fieldModifiers) {
                int newMods;
                targetMods = newMods = mods & ~accessModifiers | this.fieldModifiers;
                elements.add(this.refactoring, new ChangeModElement((Feature)this.encapsulatedField, newMods));
            }
            this.createGetterAndSetter(elements);
            while (this.referencesIterator.hasNext()) {
                if (this.cancelRequest) {
                    Problem newMods = null;
                    return newMods;
                }
                Element usage = (Element)this.referencesIterator.next();
                if (!this.isOutsideGetterSetter(usage)) continue;
                boolean enabled = true;
                VariableAccess varAcc = (VariableAccess)usage;
                boolean writeAccess = varAcc.isWrite();
                if (!this.alwaysUseAccessors) {
                    boolean bl = enabled = !EncapsulateFieldRefactoringPlugin.isAccessible(varAcc, targetMods);
                }
                if ((!writeAccess || this.setterName == null) && (writeAccess || this.getterName == null)) continue;
                elements.add(this.refactoring, new EncapsulateFieldElement(this.encapsulatedField, (VariableAccess)usage, this.getterName, this.setterName, enabled, writeAccess));
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.referencesIterator = null;
            this.fireProgressListenerStop();
        }
    }

    private static final boolean isAccessible(VariableAccess usage, int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        ClassDefinition declaring = ((Field)usage.getElement()).getDeclaringClass();
        if (Modifier.isPrivate(modifiers)) {
            ClassDefinition element = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)usage);
            return element.equals(declaring);
        }
        if (Modifier.isProtected(modifiers)) {
            if (EncapsulateFieldRefactoringPlugin.isTheSamePackage(usage)) {
                return true;
            }
            ClassDefinition cd = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)usage);
            do {
                if (!cd.isSubTypeOf(declaring)) continue;
                return true;
            } while ((cd = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)cd)) != null);
            return false;
        }
        return EncapsulateFieldRefactoringPlugin.isTheSamePackage(usage);
    }

    private static final boolean isTheSamePackage(VariableAccess usage) {
        return usage.getResource().getPackageName().equals(usage.getElement().getResource().getPackageName());
    }

    private static final ClassDefinition getClassDefinition(Element usage) {
        Element element = (Element)usage.refImmediateComposite();
        if (element instanceof Resource || element instanceof JavaPackage) {
            return null;
        }
        while (!(element instanceof ClassDefinition)) {
            element = (Element)element.refImmediateComposite();
        }
        return (ClassDefinition)element;
    }

    public Field getEncapsulatedField() {
        return this.encapsulatedField;
    }
}

