/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.netbeans.spi.diff.MergeVisualizer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResolveConflictsExecutor {
    private static final String TMP_PREFIX = "merge";
    static final String CHANGE_LEFT = "<<<<<<< ";
    static final String CHANGE_RIGHT = ">>>>>>> ";
    static final String CHANGE_DELIMETER = "=======";
    private String leftFileRevision = null;
    private String rightFileRevision = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void exec(File file) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        MergeVisualizer merge = (MergeVisualizer)Lookup.getDefault().lookup(MergeVisualizer.class);
        if (merge == null) {
            throw new IllegalStateException("No Merge engine found.");
        }
        try {
            FileObject fo = FileUtil.toFileObject((File)file);
            this.handleMergeFor(file, fo, fo.lock(), merge);
        }
        catch (FileAlreadyLockedException e) {
            Set components = TopComponent.getRegistry().getOpened();
            Iterator i = components.iterator();
            while (i.hasNext()) {
                TopComponent tc = (TopComponent)i.next();
                if (tc.getClientProperty((Object)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsExecutor == null ? ResolveConflictsExecutor.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsExecutor") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsExecutor).getName()) == null) continue;
                tc.requestActive();
            }
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
        }
    }

    private void handleMergeFor(File file, FileObject fo, FileLock lock, MergeVisualizer merge) throws IOException {
        StreamSource s2;
        StreamSource s1;
        String mimeType = fo == null ? "text/plain" : fo.getMIMEType();
        String ext = "." + fo.getExt();
        File f1 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        File f2 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        File f3 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        f1.deleteOnExit();
        f2.deleteOnExit();
        f3.deleteOnExit();
        Difference[] diffs = this.copyParts(true, file, f1, true);
        if (diffs.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)ResolveConflictsExecutor.class, (String)"NoConflictsInFile", (Object)file)));
            return;
        }
        this.copyParts(false, file, f2, false);
        String originalLeftFileRevision = this.leftFileRevision;
        String originalRightFileRevision = this.rightFileRevision;
        if (this.leftFileRevision != null) {
            this.leftFileRevision.trim();
        }
        if (this.rightFileRevision != null) {
            this.rightFileRevision.trim();
        }
        this.leftFileRevision = this.leftFileRevision == null || this.leftFileRevision.equals(file.getName()) ? NbBundle.getMessage((Class)ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage((Class)ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.leftFileRevision);
        this.rightFileRevision = this.rightFileRevision == null || this.rightFileRevision.equals(file.getName()) ? NbBundle.getMessage((Class)ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage((Class)ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.rightFileRevision);
        String encoding = EncodedReaderFactory.getDefault().getEncoding(fo);
        if (encoding != null) {
            s1 = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)mimeType, (Reader)new InputStreamReader((InputStream)new FileInputStream(f1), encoding));
            s2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)mimeType, (Reader)new InputStreamReader((InputStream)new FileInputStream(f2), encoding));
        } else {
            s1 = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)mimeType, (File)f1);
            s2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)mimeType, (File)f2);
        }
        MergeResultWriterInfo result = new MergeResultWriterInfo(f1, f2, f3, file, mimeType, originalLeftFileRevision, originalRightFileRevision, fo, lock, encoding);
        try {
            Component c = merge.createView(diffs, s1, s2, (StreamSource)result);
            if (c instanceof TopComponent) {
                ((TopComponent)c).putClientProperty((Object)ResolveConflictsExecutor.class.getName(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] copyParts(boolean generateDiffs, File source, File dest, boolean leftPart) throws IOException {
        Object v1;
        ArrayList<Difference> diffList;
        BufferedWriter w;
        block35: {
            BufferedReader r = new BufferedReader(new FileReader(source));
            w = new BufferedWriter(new FileWriter(dest));
            diffList = null;
            if (generateDiffs) {
                diffList = new ArrayList<Difference>();
            }
            try {
                String line;
                boolean isChangeLeft = false;
                boolean isChangeRight = false;
                int f1l1 = 0;
                int f1l2 = 0;
                int f2l1 = 0;
                int f2l2 = 0;
                StringBuffer text1 = new StringBuffer();
                StringBuffer text2 = new StringBuffer();
                int i = 1;
                int j = 1;
                while ((line = r.readLine()) != null) {
                    String lineText;
                    if (line.startsWith(CHANGE_LEFT)) {
                        if (generateDiffs) {
                            if (this.leftFileRevision == null) {
                                this.leftFileRevision = line.substring(CHANGE_LEFT.length());
                            }
                            if (isChangeLeft) {
                                f1l2 = i - 1;
                                diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                                f2l2 = 0;
                                f2l1 = 0;
                                f1l2 = 0;
                                f1l1 = 0;
                                text1.delete(0, text1.length());
                                text2.delete(0, text2.length());
                            } else {
                                f1l1 = i;
                            }
                        }
                        isChangeLeft = !isChangeLeft;
                        continue;
                    }
                    if (line.startsWith(CHANGE_RIGHT)) {
                        if (generateDiffs) {
                            if (this.rightFileRevision == null) {
                                this.rightFileRevision = line.substring(CHANGE_RIGHT.length());
                            }
                            if (isChangeRight) {
                                f2l2 = j - 1;
                                diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                                f2l2 = 0;
                                f2l1 = 0;
                                f1l2 = 0;
                                f1l1 = 0;
                                text1.delete(0, text1.length());
                                text2.delete(0, text2.length());
                            } else {
                                f2l1 = j;
                            }
                        }
                        isChangeRight = !isChangeRight;
                        continue;
                    }
                    if (isChangeRight && line.indexOf(CHANGE_RIGHT) != -1) {
                        lineText = line.substring(0, line.lastIndexOf(CHANGE_RIGHT));
                        if (generateDiffs) {
                            if (this.rightFileRevision == null) {
                                this.rightFileRevision = line.substring(line.lastIndexOf(CHANGE_RIGHT) + CHANGE_RIGHT.length());
                            }
                            text2.append(lineText);
                            f2l2 = j;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        }
                        if (!leftPart) {
                            w.write(lineText);
                            w.newLine();
                        }
                        isChangeRight = !isChangeRight;
                        continue;
                    }
                    if (line.equals(CHANGE_DELIMETER)) {
                        if (isChangeLeft) {
                            isChangeLeft = false;
                            isChangeRight = true;
                            f1l2 = i - 1;
                            f2l1 = j;
                            continue;
                        }
                        if (isChangeRight) {
                            isChangeRight = false;
                            isChangeLeft = true;
                            f2l2 = j - 1;
                            f1l1 = i;
                            continue;
                        }
                    } else if (line.endsWith(CHANGE_DELIMETER)) {
                        lineText = line.substring(0, line.length() - CHANGE_DELIMETER.length()) + "\n";
                        if (isChangeLeft) {
                            text1.append(lineText);
                            if (leftPart) {
                                w.write(lineText);
                                w.newLine();
                            }
                            isChangeLeft = false;
                            isChangeRight = true;
                            f1l2 = i;
                            f2l1 = j;
                            continue;
                        }
                        if (!isChangeRight) continue;
                        text2.append(lineText);
                        if (!leftPart) {
                            w.write(lineText);
                            w.newLine();
                        }
                        isChangeRight = false;
                        isChangeLeft = true;
                        f2l2 = j;
                        f1l1 = i;
                        continue;
                    }
                    if (!isChangeLeft && !isChangeRight || leftPart == isChangeLeft) {
                        w.write(line);
                        w.newLine();
                    }
                    if (isChangeLeft) {
                        text1.append(line + "\n");
                    }
                    if (isChangeRight) {
                        text2.append(line + "\n");
                    }
                    if (!generateDiffs) continue;
                    if (isChangeLeft) {
                        ++i;
                        continue;
                    }
                    if (isChangeRight) {
                        ++j;
                        continue;
                    }
                    ++i;
                    ++j;
                }
                Object var21_20 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var21_21 = null;
                try {
                    r.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var23_25 = v0;
                w.close();
                throw throwable;
            }
            try {
                r.close();
                v1 = null;
                break block35;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var23_24 = v1;
        w.close();
        if (generateDiffs) {
            return diffList.toArray(new Difference[diffList.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void repairEntries(File file) throws IOException {
        block15: {
            String name = file.getName();
            File entries = new File(file.getParentFile(), "CVS" + File.separator + "Entries");
            File backup = new File(entries.getAbsolutePath() + ".Backup");
            int attemps = 100;
            while (backup.exists() && attemps-- > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException intrex) {
                    attemps = 0;
                }
            }
            if (attemps <= 0) {
                return;
            }
            backup.createNewFile();
            try {
                BufferedWriter writer;
                block14: {
                    BufferedReader reader = null;
                    writer = null;
                    try {
                        String line;
                        reader = new BufferedReader(new FileReader(entries));
                        writer = new BufferedWriter(new FileWriter(backup));
                        String pattern = "/" + name;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith(pattern)) {
                                line = ResolveConflictsExecutor.removeConflict(line);
                            }
                            writer.write(line + "\n");
                        }
                        Object var10_10 = null;
                        if (reader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                FileUtils.renameFile((File)backup, (File)entries);
                Object var12_13 = null;
                if (!backup.exists()) break block15;
                backup.delete();
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (backup.exists()) {
                    backup.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    private static String removeConflict(String line) {
        StringBuffer result = new StringBuffer();
        int n = line.length();
        int slashNum = 0;
        boolean ignoreField = false;
        for (int i = 0; i < n; ++i) {
            char c = line.charAt(i);
            if (!ignoreField) {
                result.append(c);
            }
            if (c != '/') continue;
            ignoreField = false;
            if (++slashNum != 3) continue;
            result.append("Result of merge/");
            ignoreField = true;
        }
        return result.toString();
    }

    static {
        $assertionsDisabled = !ResolveConflictsExecutor.class.desiredAssertionStatus();
    }

    private static class MergeConflictFileWriter
    extends FilterWriter {
        private Difference[] conflicts;
        private int lineNumber;
        private int currentConflict;
        private String leftName;
        private String rightName;
        private FileObject fo;

        public MergeConflictFileWriter(Writer delegate, FileObject fo, Difference[] conflicts, String leftName, String rightName) throws IOException {
            super(delegate);
            this.conflicts = conflicts;
            this.leftName = leftName;
            this.rightName = rightName;
            this.lineNumber = 1;
            this.currentConflict = 0;
            if (this.lineNumber == conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
            this.fo = fo;
        }

        public void write(String str) throws IOException {
            super.write(str);
            this.lineNumber += MergeConflictFileWriter.numChars('\n', str);
            if (this.currentConflict < this.conflicts.length && this.lineNumber >= this.conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(this.conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
        }

        private void writeConflict(Difference conflict) throws IOException {
            super.write(ResolveConflictsExecutor.CHANGE_LEFT + this.leftName + "\n");
            super.write(conflict.getFirstText());
            super.write("=======\n");
            super.write(conflict.getSecondText());
            super.write(ResolveConflictsExecutor.CHANGE_RIGHT + this.rightName + "\n");
        }

        private static int numChars(char c, String str) {
            int n = 0;
            int pos = str.indexOf(c);
            while (pos >= 0 && pos < str.length()) {
                ++n;
                pos = str.indexOf(c, pos + 1);
            }
            return n;
        }

        public void close() throws IOException {
            super.close();
            if (this.fo != null) {
                this.fo.refresh(true);
            }
        }
    }

    private static class MergeResultWriterInfo
    extends StreamSource {
        private File tempf1;
        private File tempf2;
        private File tempf3;
        private File outputFile;
        private File fileToRepairEntriesOf;
        private String mimeType;
        private String leftFileRevision;
        private String rightFileRevision;
        private FileObject fo;
        private FileLock lock;
        private String encoding;

        public MergeResultWriterInfo(File tempf1, File tempf2, File tempf3, File outputFile, String mimeType, String leftFileRevision, String rightFileRevision, FileObject fo, FileLock lock, String encoding) {
            this.tempf1 = tempf1;
            this.tempf2 = tempf2;
            this.tempf3 = tempf3;
            this.outputFile = outputFile;
            this.mimeType = mimeType;
            this.leftFileRevision = leftFileRevision;
            this.rightFileRevision = rightFileRevision;
            this.fo = fo;
            this.lock = lock;
            if (encoding == null) {
                encoding = EncodedReaderFactory.getDefault().getEncoding(tempf1);
            }
            this.encoding = encoding;
        }

        public String getName() {
            return this.outputFile.getName();
        }

        public String getTitle() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsExecutor == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsExecutor = ResolveConflictsExecutor.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsExecutor")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsExecutor), (String)"Merge.titleResult");
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            throw new IOException("No reader of merge result");
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            Writer w = this.fo != null ? EncodedReaderFactory.getDefault().getWriter(this.fo, this.lock, this.encoding) : EncodedReaderFactory.getDefault().getWriter(this.outputFile, this.mimeType, this.encoding);
            if (conflicts == null || conflicts.length == 0) {
                this.fileToRepairEntriesOf = this.outputFile;
                return w;
            }
            return new MergeConflictFileWriter(w, this.fo, conflicts, this.leftFileRevision, this.rightFileRevision);
        }

        public void close() {
            this.tempf1.delete();
            this.tempf2.delete();
            this.tempf3.delete();
            if (this.lock != null) {
                this.lock.releaseLock();
                this.lock = null;
            }
            this.fo = null;
            if (this.fileToRepairEntriesOf != null) {
                try {
                    ResolveConflictsExecutor.repairEntries(this.fileToRepairEntriesOf);
                }
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioex);
                }
                this.fileToRepairEntriesOf = null;
            }
        }
    }
}

