/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class CvsLiteFileHandler
extends DefaultFileHandler {
    CvsLiteFileHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createNewFile(File file) throws IOException {
        boolean exists = file.isFile();
        if (exists) {
            return false;
        }
        File parent = file.getParentFile();
        FileObject fo = Utils.mkfolders(parent);
        try {
            FilesystemHandler.ignoreEvents(true);
            try {
                fo.createData(file.getName());
            }
            catch (IOException e) {
                boolean bl = file.createNewFile();
                FilesystemHandler.ignoreEvents(false);
                return bl;
            }
        }
        finally {
            FilesystemHandler.ignoreEvents(false);
        }
        return true;
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return new FileOutputStream(file);
        }
        FileLock lock = fo.lock();
        OutputStream stream = fo.getOutputStream(lock);
        return new LockedOutputStream(lock, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalFile(String pathname) throws IOException {
        File fileToDelete = new File(pathname);
        FileObject fo = FileUtil.toFileObject((File)fileToDelete);
        if (fo == null) {
            fileToDelete.delete();
            return;
        }
        try {
            FilesystemHandler.ignoreEvents(true);
            fo.delete();
        }
        finally {
            FilesystemHandler.ignoreEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameLocalFile(String pathname, String newName) throws IOException {
        File sourceFile = new File(pathname);
        FileObject fo = FileUtil.toFileObject((File)sourceFile);
        if (fo == null) {
            sourceFile.renameTo(new File(sourceFile.getParentFile(), newName));
            return;
        }
        FileLock lock = null;
        try {
            lock = fo.lock();
            try {
                FilesystemHandler.ignoreEvents(true);
                fo.rename(lock, newName, null);
            }
            finally {
                FilesystemHandler.ignoreEvents(false);
            }
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private static class LockedOutputStream
    extends OutputStream {
        private final OutputStream peer;
        private final FileLock lock;

        public LockedOutputStream(FileLock lock, OutputStream peer) {
            this.lock = lock;
            this.peer = peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.lock.releaseLock();
            try {
                FilesystemHandler.ignoreEvents(true);
                this.peer.close();
            }
            finally {
                FilesystemHandler.ignoreEvents(false);
            }
        }

        public void flush() throws IOException {
            this.peer.flush();
        }

        public void write(byte[] b) throws IOException {
            this.peer.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.peer.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.peer.write(b);
        }
    }
}

