/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

final class SubprojectProviderImpl
implements SubprojectProvider {
    private final ReferenceHelper helper;

    SubprojectProviderImpl(ReferenceHelper helper) {
        this.helper = helper;
    }

    public Set getSubprojects() {
        return (Set)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                ReferenceHelper.RawReference[] refs = SubprojectProviderImpl.this.helper.getRawReferences();
                HashSet<String> foreignProjectNames = new HashSet<String>();
                for (int i = 0; i < refs.length; ++i) {
                    foreignProjectNames.add(refs[i].getForeignProjectName());
                }
                HashSet<Project> foreignProjects = new HashSet<Project>();
                Iterator it = foreignProjectNames.iterator();
                while (it.hasNext()) {
                    FileObject foreignProjectDir;
                    String foreignProjectName = (String)it.next();
                    String prop = "project." + foreignProjectName;
                    AntProjectHelper h = SubprojectProviderImpl.this.helper.getAntProjectHelper();
                    String foreignProjectDirS = ((SubprojectProviderImpl)SubprojectProviderImpl.this).helper.eval.getProperty(prop);
                    if (foreignProjectDirS == null || (foreignProjectDir = h.resolveFileObject(foreignProjectDirS)) == null) continue;
                    try {
                        Project p = ProjectManager.getDefault().findProject(foreignProjectDir);
                        if (p == null) continue;
                        foreignProjects.add(p);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                return foreignProjects;
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

