/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.grammar;

import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class AntGrammar
implements GrammarQuery {
    private static Enumeration empty;
    static final String KIND_SPECIAL = "special";
    static final String KIND_TASK = "task";
    static final String KIND_TYPE = "type";
    static final String KIND_DATA = "data";
    static final String SPECIAL_PROJECT = "project";
    static final String SPECIAL_TARGET = "target";
    static final String SPECIAL_DESCRIPTION = "description";
    static final String SPECIAL_IMPORT = "import";
    private static final String[] STOCK_PROPERTY_NAMES;
    private static final String[] PROPERTY_NAME_VALUED_PROPERTY_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    AntGrammar() {
    }

    private static Enumeration empty() {
        if (empty == null) {
            empty = Collections.enumeration(Collections.EMPTY_LIST);
        }
        return empty;
    }

    public Enumeration queryEntities(String prefix) {
        ArrayList<MyEntityReference> list = new ArrayList<MyEntityReference>();
        if ("lt".startsWith(prefix)) {
            list.add(new MyEntityReference("lt"));
        }
        if ("gt".startsWith(prefix)) {
            list.add(new MyEntityReference("gt"));
        }
        if ("apos".startsWith(prefix)) {
            list.add(new MyEntityReference("apos"));
        }
        if ("quot".startsWith(prefix)) {
            list.add(new MyEntityReference("quot"));
        }
        if ("amp".startsWith(prefix)) {
            list.add(new MyEntityReference("amp"));
        }
        return Collections.enumeration(list);
    }

    private static IntrospectedInfo getAntGrammar() {
        return IntrospectedInfo.getKnownInfo();
    }

    static final String[] typeOf(Element e) {
        String name = e.getNodeName();
        Node p = e.getParentNode();
        if (p == null) {
            throw new IllegalArgumentException("Detached node: " + e);
        }
        if (p.getNodeType() == 9) {
            if (name.equals(SPECIAL_PROJECT)) {
                return new String[]{KIND_SPECIAL, SPECIAL_PROJECT};
            }
            return null;
        }
        if (p.getNodeType() == 1) {
            String[] ptype = AntGrammar.typeOf((Element)p);
            if (ptype == null) {
                return null;
            }
            if (ptype[0] == KIND_SPECIAL) {
                if (ptype[1] == SPECIAL_PROJECT) {
                    if (name.equals(SPECIAL_DESCRIPTION)) {
                        return new String[]{KIND_SPECIAL, SPECIAL_DESCRIPTION};
                    }
                    if (name.equals(SPECIAL_TARGET)) {
                        return new String[]{KIND_SPECIAL, SPECIAL_TARGET};
                    }
                    if (name.equals(SPECIAL_IMPORT)) {
                        return new String[]{KIND_SPECIAL, SPECIAL_IMPORT};
                    }
                    String taskClazz = (String)AntGrammar.getAntGrammar().getDefs(KIND_TASK).get(name);
                    if (taskClazz != null) {
                        return new String[]{KIND_TASK, taskClazz};
                    }
                    String typeClazz = (String)AntGrammar.getAntGrammar().getDefs(KIND_TYPE).get(name);
                    if (typeClazz != null) {
                        return new String[]{KIND_TYPE, typeClazz};
                    }
                    return null;
                }
                if (ptype[1] == SPECIAL_TARGET) {
                    String taskClazz = (String)AntGrammar.getAntGrammar().getDefs(KIND_TASK).get(name);
                    if (taskClazz != null) {
                        return new String[]{KIND_TASK, taskClazz};
                    }
                    String typeClazz = (String)AntGrammar.getAntGrammar().getDefs(KIND_TYPE).get(name);
                    if (typeClazz != null) {
                        return new String[]{KIND_TYPE, typeClazz};
                    }
                    return null;
                }
                if (ptype[1] == SPECIAL_DESCRIPTION) {
                    return null;
                }
                if (ptype[1] == SPECIAL_IMPORT) {
                    return null;
                }
                throw new IllegalStateException(ptype[1]);
            }
            String pclazz = ptype[1];
            String clazz = (String)AntGrammar.getAntGrammar().getElements(pclazz).get(name);
            if (clazz != null) {
                return new String[]{KIND_DATA, clazz};
            }
            return null;
        }
        throw new IllegalArgumentException("Bad parent for " + e.toString() + ": " + p);
    }

    public Enumeration queryAttributes(HintContext ctx) {
        LinkedList<String> possibleAttributes;
        Element ownerElement = null;
        if (ctx.getNodeType() == 2) {
            ownerElement = ((Attr)ctx).getOwnerElement();
        } else if (ctx.getNodeType() == 1) {
            ownerElement = (Element)ctx;
        }
        if (ownerElement == null) {
            return AntGrammar.empty();
        }
        NamedNodeMap existingAttributes = ownerElement.getAttributes();
        String[] typePair = AntGrammar.typeOf(ownerElement);
        if (typePair == null) {
            return AntGrammar.empty();
        }
        String kind = typePair[0];
        String clazz = typePair[1];
        if (kind == KIND_SPECIAL && clazz == SPECIAL_PROJECT) {
            possibleAttributes = new LinkedList<String>();
            possibleAttributes.add("default");
            possibleAttributes.add("name");
            possibleAttributes.add("basedir");
        } else if (kind == KIND_SPECIAL && clazz == SPECIAL_TARGET) {
            possibleAttributes = new LinkedList();
            possibleAttributes.add("name");
            possibleAttributes.add("depends");
            possibleAttributes.add(SPECIAL_DESCRIPTION);
            possibleAttributes.add("if");
            possibleAttributes.add("unless");
        } else {
            if (kind == KIND_SPECIAL && clazz == SPECIAL_DESCRIPTION) {
                return AntGrammar.empty();
            }
            if (kind == KIND_SPECIAL && clazz == SPECIAL_IMPORT) {
                possibleAttributes = new LinkedList();
                possibleAttributes.add("file");
                possibleAttributes.add("optional");
            } else {
                possibleAttributes = new LinkedList();
                if (kind == KIND_TYPE) {
                    possibleAttributes.add("id");
                }
                if (AntGrammar.getAntGrammar().isKnown(clazz)) {
                    possibleAttributes.addAll(new TreeSet(AntGrammar.getAntGrammar().getAttributes(clazz).keySet()));
                }
                if (kind == KIND_TASK) {
                    possibleAttributes.add("id");
                    possibleAttributes.add(SPECIAL_DESCRIPTION);
                    possibleAttributes.add("taskname");
                }
            }
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyAttr> list = new ArrayList<MyAttr>();
        Iterator it = possibleAttributes.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix) || existingAttributes.getNamedItem(next) != null) continue;
            list.add(new MyAttr(next));
        }
        return Collections.enumeration(list);
    }

    public Enumeration queryElements(HintContext ctx) {
        List<String> elements;
        Node parent = ctx.getParentNode();
        if (parent == null) {
            return AntGrammar.empty();
        }
        if (parent.getNodeType() != 1) {
            return AntGrammar.empty();
        }
        String[] typePair = AntGrammar.typeOf((Element)parent);
        if (typePair == null) {
            return AntGrammar.empty();
        }
        String kind = typePair[0];
        String clazz = typePair[1];
        if (kind == KIND_SPECIAL && clazz == SPECIAL_PROJECT) {
            elements = new LinkedList<String>();
            elements.add(SPECIAL_TARGET);
            elements.add(SPECIAL_IMPORT);
            elements.add("property");
            elements.add(SPECIAL_DESCRIPTION);
            SortedSet tasks = AntGrammar.getSortedDefs(KIND_TASK);
            tasks.remove("property");
            tasks.remove(SPECIAL_IMPORT);
            elements.addAll(tasks);
            elements.addAll(AntGrammar.getSortedDefs(KIND_TYPE));
        } else if (kind == KIND_SPECIAL && clazz == SPECIAL_TARGET) {
            elements = new ArrayList(AntGrammar.getSortedDefs(KIND_TASK));
            elements.addAll(AntGrammar.getSortedDefs(KIND_TYPE));
        } else {
            if (kind == KIND_SPECIAL && clazz == SPECIAL_DESCRIPTION) {
                return AntGrammar.empty();
            }
            if (kind == KIND_SPECIAL && clazz == SPECIAL_IMPORT) {
                return AntGrammar.empty();
            }
            elements = AntGrammar.getAntGrammar().isKnown(clazz) ? new ArrayList(new TreeSet(AntGrammar.getAntGrammar().getElements(clazz).keySet())) : Collections.EMPTY_LIST;
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyElement> list = new ArrayList<MyElement>();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.add(new MyElement(next));
        }
        return Collections.enumeration(list);
    }

    private static SortedSet getSortedDefs(String kind) {
        TreeSet<Object> defs = new TreeSet<Object>(Collator.getInstance());
        defs.addAll(AntGrammar.getAntGrammar().getDefs(kind).keySet());
        return defs;
    }

    public Enumeration queryNotations(String prefix) {
        return AntGrammar.empty();
    }

    public Enumeration queryValues(HintContext ctx) {
        if (AntGrammar.canCompleteProperty(ctx.getCurrentPrefix())) {
            return AntGrammar.completeProperties(ctx);
        }
        if (ctx.getNodeType() != 2) {
            return AntGrammar.empty();
        }
        Attr ownerAttr = (Attr)ctx;
        Element ownerElement = ownerAttr.getOwnerElement();
        String attrName = ownerAttr.getName();
        String[] typePair = AntGrammar.typeOf(ownerElement);
        if (typePair == null) {
            return AntGrammar.empty();
        }
        ArrayList<String> choices = new ArrayList<String>();
        if (typePair[0].equals(KIND_SPECIAL)) {
            if (typePair[1].equals(SPECIAL_PROJECT)) {
                if (!attrName.equals("default") && attrName.equals("basedir")) {
                    // empty if block
                }
            } else if (typePair[1].equals(SPECIAL_TARGET)) {
                if (!attrName.equals("depends") && (attrName.equals("if") || attrName.equals("unless"))) {
                    choices.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(ctx)));
                }
            } else if (!typePair[1].equals(SPECIAL_DESCRIPTION)) {
                if (typePair[1].equals(SPECIAL_IMPORT)) {
                    if (!attrName.equals("file") && attrName.equals("optional")) {
                        choices.add("true");
                        choices.add("false");
                    }
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)typePair[1]);
                }
            }
        } else {
            String attrClazzName;
            String elementClazz = typePair[1];
            if (AntGrammar.getAntGrammar().isKnown(elementClazz) && (attrClazzName = (String)AntGrammar.getAntGrammar().getAttributes(elementClazz).get(attrName)) != null) {
                String[] enumTags;
                if (AntGrammar.getAntGrammar().isKnown(attrClazzName) && (enumTags = AntGrammar.getAntGrammar().getTags(attrClazzName)) != null) {
                    choices.addAll(Arrays.asList(enumTags));
                }
                if (attrClazzName.equals("boolean")) {
                    choices.add("true");
                    choices.add("false");
                } else if (!attrClazzName.equals("org.apache.tools.ant.types.Reference") && !attrClazzName.equals("org.apache.tools.ant.types.Path") && !attrClazzName.equals("java.io.File") && attrClazzName.equals("java.lang.String") && Arrays.asList(PROPERTY_NAME_VALUED_PROPERTY_NAMES).contains(attrName)) {
                    choices.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(ctx)));
                }
            }
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyText> list = new ArrayList<MyText>();
        Iterator it = choices.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.add(new MyText(next));
        }
        return Collections.enumeration(list);
    }

    private static boolean canCompleteProperty(String content) {
        if ((content = AntGrammar.deletedEscapedShells(content)).length() == 0) {
            return false;
        }
        if (content.charAt(content.length() - 1) == '$') {
            return true;
        }
        int idx = content.lastIndexOf("${");
        return idx != -1 && content.indexOf(125, idx) == -1;
    }

    private static Enumeration completeProperties(HintContext ctx) {
        String propPrefix;
        String header;
        String content = ctx.getCurrentPrefix();
        if (!$assertionsDisabled && content.length() <= 0) {
            throw new AssertionError();
        }
        if (content.charAt(content.length() - 1) == '$') {
            header = content + '{';
            propPrefix = "";
        } else {
            int idx = content.lastIndexOf("${");
            if (!$assertionsDisabled && idx == -1) {
                throw new AssertionError();
            }
            header = content.substring(0, idx + 2);
            propPrefix = content.substring(idx + 2);
        }
        String[] props = AntGrammar.likelyPropertyNames(ctx);
        boolean shortHeader = ctx.getNodeType() == 3;
        ArrayList<MyText> list = new ArrayList<MyText>();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].startsWith(propPrefix)) continue;
            String text = header + props[i] + '}';
            if (shortHeader) {
                if (!$assertionsDisabled && !text.startsWith(content)) {
                    throw new AssertionError((Object)("text=" + text + " content=" + content));
                }
                text = text.substring(content.length());
            }
            list.add(new MyText(text));
        }
        return Collections.enumeration(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] likelyPropertyNames(HintContext ctx) {
        Element parent;
        if (ctx.getNodeType() == 2) {
            parent = ((Attr)ctx).getOwnerElement();
        } else {
            if (ctx.getNodeType() != 3) {
                System.err.println("strange context type: " + ctx.getNodeType() + " " + ctx);
                return new String[0];
            }
            Node p = ctx.getParentNode();
            if (p != null && p.getNodeType() == 1) {
                parent = (Element)p;
            } else {
                System.err.println("strange parent of text node: " + p.getNodeType() + " " + p);
                return new String[0];
            }
        }
        while (parent.getParentNode() != null && parent.getParentNode().getNodeType() == 1) {
            parent = (Element)parent.getParentNode();
        }
        TreeSet<String> choices = new TreeSet<String>(Arrays.asList(STOCK_PROPERTY_NAMES));
        AntGrammar.visitForLikelyPropertyNames(parent, choices);
        Iterator it = choices.iterator();
        while (it.hasNext()) {
            String propname = (String)it.next();
            if (propname.indexOf("${") == -1) continue;
            it.remove();
        }
        return choices.toArray(new String[choices.size()]);
    }

    private static void visitForLikelyPropertyNames(Node n, Set choices) {
        short type = n.getNodeType();
        switch (type) {
            case 1: {
                Element el = (Element)n;
                String tagname = el.getTagName();
                if (tagname.equals("property")) {
                    String propname = el.getAttribute("name");
                    if (propname != null && propname.length() > 0) {
                        choices.add(propname);
                    }
                } else if (tagname.equals("buildnumber")) {
                    choices.add("build.number");
                } else if (tagname.equals("tstamp")) {
                    choices.add("DSTAMP");
                    choices.add("TSTAMP");
                    choices.add("TODAY");
                }
                for (int i = 0; i < PROPERTY_NAME_VALUED_PROPERTY_NAMES.length; ++i) {
                    String propname = el.getAttribute(PROPERTY_NAME_VALUED_PROPERTY_NAMES[i]);
                    if (propname == null || propname.length() <= 0) continue;
                    choices.add(propname);
                }
                break;
            }
            case 2: 
            case 3: {
                int end;
                int start;
                String text = AntGrammar.deletedEscapedShells(n.getNodeValue());
                int idx = 0;
                while ((start = text.indexOf("${", idx)) != -1 && (end = text.indexOf(125, start + 2)) != -1) {
                    String propname = text.substring(start + 2, end);
                    if (propname.length() > 0) {
                        choices.add(propname);
                    }
                    idx = end + 1;
                }
                break;
            }
        }
        NodeList l = n.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            AntGrammar.visitForLikelyPropertyNames(l.item(i), choices);
        }
        NamedNodeMap m = n.getAttributes();
        if (m != null) {
            for (int i = 0; i < m.getLength(); ++i) {
                AntGrammar.visitForLikelyPropertyNames(m.item(i), choices);
            }
        }
    }

    private static String deletedEscapedShells(String text) {
        return text.replaceAll("\\$\\$", "");
    }

    public GrammarResult queryDefault(HintContext ctx) {
        return null;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    public Component getCustomizer(HintContext ctx) {
        return null;
    }

    public boolean hasCustomizer(HintContext ctx) {
        return false;
    }

    public Node.Property[] getProperties(HintContext ctx) {
        return null;
    }

    static {
        $assertionsDisabled = !AntGrammar.class.desiredAssertionStatus();
        STOCK_PROPERTY_NAMES = new String[]{"ant.home", "basedir", "ant.file", "ant.project.name", "ant.java.version", "ant.version", "java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"};
        PROPERTY_NAME_VALUED_PROPERTY_NAMES = new String[]{"if", "unless", "property", "failureproperty", "errorproperty", "addproperty"};
    }

    private static class MyText
    extends AbstractResultNode
    implements Text {
        private String data;

        MyText(String data) {
            this.data = data;
        }

        public short getNodeType() {
            return 3;
        }

        public String getNodeValue() {
            return this.data;
        }

        public String getData() throws DOMException {
            return this.data;
        }

        public int getLength() {
            return this.data == null ? -1 : this.data.length();
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return null;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;

        MyElement(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public boolean isEmptyElement() {
            return false;
        }
    }
}

