/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.xml.core.lib.Convertors;
import org.netbeans.modules.xml.core.lib.Util;

public class EncodingHelper {
    private static final int EXPECTED_PROLOG_LENGTH = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(InputStream in) throws IOException {
        if (!in.markSupported()) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("EncodingHelper got unmarkable stream: " + in.getClass());
            }
            return null;
        }
        try {
            String enc;
            in.mark(1000);
            byte[] bytes = new byte[1000];
            for (int i = 0; i < bytes.length; ++i) {
                try {
                    int datum = in.read();
                    if (datum == -1) break;
                    bytes[i] = (byte)datum;
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            if ((enc = EncodingHelper.autoDetectEncoding(bytes)) == null) {
                String string = null;
                return string;
            }
            if ((enc = EncodingHelper.detectDeclaredEncoding(bytes, enc)) == null) {
                String string = null;
                return string;
            }
            String string = Convertors.iana2java(enc);
            return string;
        }
        finally {
            in.reset();
        }
    }

    static String autoDetectEncoding(byte[] buf) throws IOException {
        if (buf.length >= 4) {
            switch (buf[0]) {
                case 0: {
                    if (buf[1] != 60 || buf[2] != 0 || buf[3] != 63) break;
                    return "UnicodeBigUnmarked";
                }
                case 60: {
                    switch (buf[1]) {
                        case 0: {
                            if (buf[2] != 63 || buf[3] != 0) break;
                            return "UnicodeLittleUnmarked";
                        }
                        case 63: {
                            if (buf[2] != 120 || buf[3] != 109) break;
                            return "UTF8";
                        }
                    }
                    break;
                }
                case 76: {
                    if (buf[1] != 111 || buf[2] != -89 || buf[3] != -108) break;
                    return "Cp037";
                }
                case -2: {
                    if (buf[1] != -1 || buf[2] == 0 && buf[3] == 0) break;
                    return "UnicodeBig";
                }
                case -1: {
                    if (buf[1] != -2 || buf[2] == 0 && buf[3] == 0) break;
                    return "UnicodeLittle";
                }
                case -17: {
                    if (buf[1] != -69 || buf[2] != -65) break;
                    return "UTF8";
                }
            }
        }
        return null;
    }

    static String detectDeclaredEncoding(byte[] data, String baseEncoding) throws IOException {
        int i;
        String s;
        int iend;
        StringBuffer buf = new StringBuffer();
        char delimiter = '\"';
        InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(data), baseEncoding);
        try {
            int c = ((Reader)r).read();
            while (c != -1) {
                buf.append((char)c);
                c = ((Reader)r).read();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        iend = (iend = (s = buf.toString()).indexOf("?>")) == -1 ? s.length() : iend;
        int iestart = s.indexOf("encoding");
        if (iestart == -1 || iestart > iend) {
            return null;
        }
        char[] chars = s.toCharArray();
        for (i = iestart; i < iend && chars[i] != '='; ++i) {
        }
        while (i < iend) {
            if (chars[i] == '\'' || chars[i] == '\"') {
                delimiter = chars[i];
                break;
            }
            ++i;
        }
        int ivalstart = ++i;
        while (i < iend) {
            if (chars[i] == delimiter) {
                return new String(chars, ivalstart, i - ivalstart);
            }
            ++i;
        }
        return null;
    }

    static String parseMIMECharSet(String mime) {
        int i;
        String CHARSET = "charset";
        if (mime != null && (i = (mime = mime.toLowerCase()).indexOf(59)) != -1) {
            String attributes = mime.substring(i + 1);
            mime = mime.substring(0, i);
            i = attributes.indexOf("charset");
            if (i != -1) {
                if ((i = (attributes = attributes.substring(i + "charset".length())).indexOf(59)) != -1) {
                    attributes = attributes.substring(0, i);
                }
                if ((i = attributes.indexOf(61)) != -1) {
                    if ((i = (attributes = attributes.substring(i + 1)).indexOf(40)) != -1) {
                        attributes = attributes.substring(0, i);
                    }
                    if ((i = attributes.indexOf(34)) != -1) {
                        attributes = attributes.substring(i + 1);
                        attributes = attributes.substring(0, attributes.indexOf(34));
                    }
                    return attributes.trim();
                }
            }
        }
        return null;
    }

    public static String detectEncoding(Document doc) throws IOException {
        if (doc == null) {
            return null;
        }
        try {
            String text = doc.getText(0, doc.getLength() > 1000 ? 1000 : doc.getLength());
            ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
            return EncodingHelper.detectEncoding(in);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

