/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class MainProjectAction
extends BasicAction
implements PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;

    public MainProjectAction(ProjectActionPerformer performer, String name, Icon icon) {
        this(null, performer, name, icon);
    }

    public MainProjectAction(String command, String name, Icon icon) {
        this(command, null, name, icon);
    }

    public MainProjectAction(String command, ProjectActionPerformer performer, String name, Icon icon) {
        this.command = command;
        this.performer = performer;
        this.name = name;
        this.setDisplayName(name);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        this.refreshView();
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    public void actionPerformed(ActionEvent e) {
        Project p = OpenProjectList.getDefault().getMainProject();
        if (p == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.name)) {
                return;
            }
            p = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            if (Arrays.asList(ap.getSupportedActions()).contains(this.command)) {
                ap.invokeAction(this.command, Lookup.EMPTY);
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.refreshView();
            }
        } else {
            this.performer.perform(p);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "MainProject" || evt.getPropertyName() == "OpenProjects") {
            this.refreshView();
        }
    }

    private void refreshView() {
        boolean noOpenProject;
        Project p = OpenProjectList.getDefault().getMainProject();
        boolean bl = noOpenProject = OpenProjectList.getDefault().getOpenProjects().length == 0;
        if (this.command == null) {
            this.setEnabled(this.performer.enable(p));
        } else if (p == null) {
            this.setEnabled(!noOpenProject);
        } else if (ActionsUtil.commandSupported(p, this.command, Lookup.EMPTY)) {
            this.setEnabled(!noOpenProject);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean showNoMainProjectWarning(Project[] projects, String action) {
        boolean canceled;
        final JButton okButton = new JButton(NbBundle.getMessage((Class)NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning panel = new NoMainProjectWarning(projects);
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    if (panel.getSelectedProject() != null) {
                        okButton.doClick();
                    }
                } else {
                    okButton.setEnabled(panel.getSelectedProject() != null);
                }
            }
        });
        okButton.setEnabled(panel.getSelectedProject() != null);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, action == null ? NbBundle.getMessage((Class)NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)action), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            Project mainProject = panel.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(mainProject);
            canceled = false;
        }
        dlg.dispose();
        return canceled;
    }
}

