/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.swing.outline.TreePathSupport;

final class EventBroadcaster
implements TableModelListener,
TreeModelListener,
ExtTreeWillExpandListener,
TreeExpansionListener {
    static boolean log = false;
    private int logcount = 0;
    private DefaultOutlineModel model;
    private TreeExpansionEvent inProgressEvent = null;
    private TableModelEvent pendingExpansionEvent = null;
    private boolean inMultiEvent = false;
    private static final int NODES_CHANGED = 0;
    private static final int NODES_INSERTED = 1;
    private static final int NODES_REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private static final String[] types = new String[]{"nodesChanged", "nodesInserted", "nodesRemoved", "structureChanged"};
    private List tableListeners = new ArrayList();
    private List treeListeners = new ArrayList();

    public EventBroadcaster(DefaultOutlineModel model) {
        this.setModel(model);
    }

    private void log(String method, Object o) {
        if (log) {
            if (o instanceof TableModelEvent) {
                o = EventBroadcaster.tableModelEventToString((TableModelEvent)o);
            }
            System.err.println("EB-" + this.logcount++ + " " + method + ":" + (o instanceof String ? (String)o : o.toString()));
        }
    }

    public boolean areMoreEventsPending() {
        return this.inMultiEvent;
    }

    private DefaultOutlineModel getModel() {
        return this.model;
    }

    private void setModel(DefaultOutlineModel model) {
        this.model = model;
    }

    private AbstractLayoutCache getLayout() {
        return this.getModel().getLayout();
    }

    private TreePathSupport getTreePathSupport() {
        return this.getModel().getTreePathSupport();
    }

    private TreeModel getTreeModel() {
        return this.getModel().getTreeModel();
    }

    private TableModel getTableModel() {
        return this.getModel().getTableModel();
    }

    public synchronized void addTableModelListener(TableModelListener l) {
        this.tableListeners.add(l);
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        this.treeListeners.add(l);
    }

    public synchronized void removeTableModelListener(TableModelListener l) {
        this.tableListeners.remove(l);
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        this.treeListeners.remove(l);
    }

    private void fireTableChange(TableModelEvent e, TableModelListener[] listeners) {
        if (e == null) {
            return;
        }
        assert (e.getSource() == this.getModel());
        this.log("fireTableChange", e);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].tableChanged(e);
        }
    }

    private void fireTableChange(TableModelEvent e) {
        if (e == null) {
            return;
        }
        this.inMultiEvent = false;
        TableModelListener[] listeners = this.getTableModelListeners();
        this.fireTableChange(e, this.getTableModelListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChange(TableModelEvent[] e) {
        if (e == null || e.length == 0) {
            return;
        }
        TableModelListener[] listeners = this.getTableModelListeners();
        this.inMultiEvent = e.length > 1;
        try {
            for (int i = 0; i < e.length; ++i) {
                this.fireTableChange(e[i], listeners);
                if (i != e.length - 1) continue;
                this.inMultiEvent = false;
            }
        }
        finally {
            this.inMultiEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModelListener[] getTableModelListeners() {
        TableModelListener[] listeners = null;
        EventBroadcaster eventBroadcaster = this;
        synchronized (eventBroadcaster) {
            listeners = new TableModelListener[this.tableListeners.size()];
            listeners = this.tableListeners.toArray(listeners);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireTreeChange(TreeModelEvent e, int type) {
        if (e == null) {
            return;
        }
        assert (e.getSource() == this.getModel());
        TreeModelListener[] listeners = null;
        EventBroadcaster eventBroadcaster = this;
        synchronized (eventBroadcaster) {
            listeners = new TreeModelListener[this.treeListeners.size()];
            listeners = this.treeListeners.toArray(listeners);
        }
        this.log("fireTreeChange-" + types[type], e);
        block9: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 0: {
                    listeners[i].treeNodesChanged(e);
                    continue block9;
                }
                case 1: {
                    listeners[i].treeNodesInserted(e);
                    continue block9;
                }
                case 2: {
                    listeners[i].treeNodesRemoved(e);
                    continue block9;
                }
                case 3: {
                    listeners[i].treeStructureChanged(e);
                    continue block9;
                }
                default: {
                    assert (false);
                    continue block9;
                }
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (e.getType() == 0) : "Table model should only fire updates, never structural changes";
        this.fireTableChange(this.translateEvent(e));
    }

    public void treeNodesChanged(TreeModelEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(this.translateEvent(e), 0);
        TableModelEvent[] events = this.translateEvent(e, 0);
        this.getLayout().treeNodesChanged(e);
        this.fireTableChange(events);
    }

    public void treeNodesInserted(TreeModelEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(this.translateEvent(e), 1);
        TableModelEvent[] events = this.translateEvent(e, 1);
        this.getLayout().treeNodesInserted(e);
        this.fireTableChange(events);
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(e, 2);
        TableModelEvent[] events = this.translateEvent(e, 2);
        this.getLayout().treeNodesRemoved(e);
        this.fireTableChange(events);
    }

    public void treeStructureChanged(TreeModelEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        this.getLayout().treeStructureChanged(e);
        this.fireTreeChange(e, 3);
        this.getTreePathSupport().clear();
        this.fireTableChange(new TableModelEvent(this.getModel()));
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeWillCollapse", event);
        this.pendingExpansionEvent = this.translateEvent(event, false);
        this.log("treeWillCollapse generated ", this.pendingExpansionEvent);
        this.inProgressEvent = event;
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeWillExpand", event);
        this.pendingExpansionEvent = this.translateEvent(event, true);
        this.log("treeWillExpand generated", this.pendingExpansionEvent);
        this.inProgressEvent = event;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        TreePath path;
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeExpanded", event);
        if (event != null && (path = event.getPath()) != null && this.getTreePathSupport().isVisible(path)) {
            this.getLayout().setExpandedState(path, false);
        }
        this.log("about to fire", this.pendingExpansionEvent);
        path = event.getPath();
        int row = this.getLayout().getRowForPath(path);
        TableModelEvent evt = new TableModelEvent(this.getModel(), row, row, 0, 0);
        this.fireTableChange(new TableModelEvent[]{evt, this.pendingExpansionEvent});
        this.pendingExpansionEvent = null;
        this.inProgressEvent = null;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeExpanded", event);
        if (event != null) {
            this.updateExpandedDescendants(event.getPath());
        }
        this.log("about to fire", this.pendingExpansionEvent);
        TreePath path = event.getPath();
        int row = this.getLayout().getRowForPath(path);
        TableModelEvent evt = new TableModelEvent(this.getModel(), row, row, 0, 0);
        this.fireTableChange(new TableModelEvent[]{evt, this.pendingExpansionEvent});
        this.pendingExpansionEvent = null;
        this.inProgressEvent = null;
    }

    public void treeExpansionVetoed(TreeExpansionEvent event, ExpandVetoException exception) {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeExpansionVetoed", exception);
        if (event == this.inProgressEvent) {
            this.pendingExpansionEvent = null;
            this.inProgressEvent = null;
        }
    }

    private void updateExpandedDescendants(TreePath path) {
        this.getLayout().setExpandedState(path, true);
        TreePath[] descendants = this.getTreePathSupport().getExpandedDescendants(path);
        if (descendants.length > 0) {
            for (int i = 0; i < descendants.length; ++i) {
                this.getLayout().setExpandedState(descendants[i], true);
            }
        }
    }

    private TableModelEvent translateEvent(TableModelEvent e) {
        TableModelEvent nue = new TableModelEvent(this.getModel(), e.getFirstRow(), e.getLastRow(), e.getColumn() + 1, e.getType());
        return nue;
    }

    private TreeModelEvent translateEvent(TreeModelEvent e) {
        TreeModelEvent nue = new TreeModelEvent((Object)this.getModel(), e.getPath(), e.getChildIndices(), e.getChildren());
        return nue;
    }

    private TableModelEvent[] translateEvent(TreeModelEvent e, int type) {
        int i;
        Object[] blocks;
        boolean inClosedNode;
        TreePath path = e.getTreePath();
        int row = this.getLayout().getRowForPath(path);
        boolean bl = inClosedNode = !this.getLayout().isExpanded(path);
        if (inClosedNode) {
            if (row != -1) {
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return new TableModelEvent[]{new TableModelEvent(this.getModel(), row, row, 0, 0)};
                    }
                }
                assert (false) : "Unknown event type " + type;
            }
            return new TableModelEvent[0];
        }
        boolean discontiguous = EventBroadcaster.isDiscontiguous(e);
        if (discontiguous) {
            blocks = EventBroadcaster.getContiguousIndexBlocks(e, type == 2);
            this.log("discontiguous " + types[type] + " event", blocks.length + " blocks");
        } else {
            blocks = new Object[]{e.getChildIndices()};
        }
        TableModelEvent[] result = new TableModelEvent[blocks.length];
        block8: for (i = 0; i < blocks.length; ++i) {
            int[] currBlock = (int[])blocks[i];
            switch (type) {
                case 0: {
                    result[i] = this.createTableChangeEvent(e, currBlock);
                    continue block8;
                }
                case 1: {
                    result[i] = this.createTableInsertionEvent(e, currBlock);
                    continue block8;
                }
                case 2: {
                    result[i] = this.createTableDeletionEvent(e, currBlock);
                    continue block8;
                }
                default: {
                    assert (false) : "Unknown event type: " + type;
                    continue block8;
                }
            }
        }
        this.log("translateEvent", e);
        this.log("generated table events", new Integer(result.length));
        if (log) {
            for (i = 0; i < result.length; ++i) {
                this.log("  Event " + i, result[i]);
            }
        }
        return result;
    }

    private TableModelEvent translateEvent(TreeExpansionEvent e, boolean expand) {
        TreePath path = e.getPath();
        int firstRow = this.getLayout().getRowForPath(path) + 1;
        if (firstRow == -1) {
            return null;
        }
        TreePath[] paths = this.getTreePathSupport().getExpandedDescendants(path);
        int count = this.getTreeModel().getChildCount(path.getLastPathComponent());
        for (int i = 0; i < paths.length; ++i) {
            count += this.getTreeModel().getChildCount(paths[i].getLastPathComponent());
        }
        int lastRow = firstRow + count - 1;
        TableModelEvent result = new TableModelEvent(this.getModel(), firstRow, lastRow, -1, expand ? 1 : -1);
        return result;
    }

    private TableModelEvent createTableChangeEvent(TreeModelEvent e, int[] indices) {
        TableModelEvent result = null;
        TreePath path = e.getTreePath();
        int row = this.getLayout().getRowForPath(path);
        int first = indices[0];
        int last = indices[indices.length - 1];
        result = new TableModelEvent(this.getModel(), first, last, -1, 0);
        return result;
    }

    private TableModelEvent createTableInsertionEvent(TreeModelEvent e, int[] indices) {
        TableModelEvent result = null;
        this.log("createTableInsertionEvent", e);
        TreePath path = e.getTreePath();
        int row = this.getLayout().getRowForPath(path);
        boolean realInsert = this.getLayout().isExpanded(path);
        if (realInsert) {
            if (indices.length == 1) {
                int affectedRow = row + indices[0] + 1;
                result = new TableModelEvent(this.getModel(), affectedRow, affectedRow, -1, 1);
            } else {
                int lowest = indices[0] + 1;
                int highest = indices[indices.length - 1] + 1;
                result = new TableModelEvent(this.getModel(), row + lowest, row + highest, -1, 1);
            }
        } else {
            result = new TableModelEvent(this.getModel(), row, row, -1);
        }
        return result;
    }

    private TableModelEvent createTableDeletionEvent(TreeModelEvent e, int[] indices) {
        TableModelEvent result = null;
        this.log("createTableDeletionEvent " + Arrays.asList(EventBroadcaster.toArrayOfInteger(indices)), e);
        TreePath path = e.getTreePath();
        int row = this.getLayout().getRowForPath(path);
        if (row == -1) {
            return null;
        }
        int countRemoved = indices.length;
        Object[] children = this.getChildrenForIndices(e, indices);
        for (int i = 0; i < children.length; ++i) {
            TreePath childPath = path.pathByAddingChild(children[i]);
            if (this.getTreePathSupport().isExpanded(childPath)) {
                int visibleChildren = this.getLayout().getVisibleChildCount(childPath);
                if (log) {
                    this.log(childPath + " has ", new Integer(visibleChildren));
                }
                countRemoved += visibleChildren;
            }
            this.getTreePathSupport().removePath(path);
        }
        int firstRow = row + indices[0] + 1;
        this.log("firstRow", new Integer(firstRow));
        System.err.println("Count removed is " + countRemoved);
        int lastRow = firstRow + (countRemoved - 1);
        System.err.println("TableModelEvent: fromRow: " + firstRow + " toRow: " + lastRow);
        result = new TableModelEvent(this.getModel(), firstRow, lastRow, -1, -1);
        return result;
    }

    private static boolean isDiscontiguous(TreeModelEvent e) {
        int[] indices = e.getChildIndices();
        if (indices.length == 1) {
            return false;
        }
        Arrays.sort(indices);
        int lastVal = indices[0];
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] != lastVal + 1) {
                return true;
            }
            ++lastVal;
        }
        return false;
    }

    private static Object[] getContiguousIndexBlocks(TreeModelEvent e, boolean reverseOrder) {
        int i;
        int[] indices = e.getChildIndices();
        if (indices.length == 1) {
            return new Object[]{indices};
        }
        ArrayList<Object> al = new ArrayList<Object>();
        if (reverseOrder) {
            EventBroadcaster.inverseSort(indices);
        } else {
            Arrays.sort(indices);
        }
        ArrayList<Integer> currBlock = new ArrayList<Integer>(indices.length / 2);
        al.add(currBlock);
        int lastVal = -1;
        for (i = 0; i < indices.length; ++i) {
            if (i != 0) {
                boolean newBlock;
                boolean bl = reverseOrder ? indices[i] != lastVal - 1 : (newBlock = indices[i] != lastVal + 1);
                if (newBlock) {
                    currBlock = new ArrayList(indices.length - 1);
                    al.add(currBlock);
                }
            }
            currBlock.add(new Integer(indices[i]));
            lastVal = indices[i];
        }
        for (i = 0; i < al.size(); ++i) {
            ArrayList curr = (ArrayList)al.get(i);
            Integer[] ints = curr.toArray(new Integer[0]);
            al.set(i, EventBroadcaster.toArrayOfInt(ints));
        }
        return al.toArray();
    }

    private Object[] getChildrenForIndices(TreeModelEvent e, int[] indices) {
        Object[] children = e.getChildren();
        int[] allIndices = e.getChildIndices();
        ArrayList<Object> al = new ArrayList<Object>();
        for (int i = 0; i < indices.length; ++i) {
            int pos = Arrays.binarySearch(allIndices, indices[i]);
            if (pos > -1) {
                al.add(children[pos]);
            }
            if (al.size() == indices.length) break;
        }
        return al.toArray();
    }

    private static int[] toArrayOfInt(Integer[] ints) {
        int[] result = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    private static Integer[] toArrayOfInteger(int[] ints) {
        Integer[] result = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = new Integer(ints[i]);
        }
        return result;
    }

    private static void inverseSort(int[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * -1;
        }
        Arrays.sort(array);
        i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * -1;
        }
    }

    private static String tableModelEventToString(TableModelEvent e) {
        StringBuffer sb = new StringBuffer();
        sb.append("TableModelEvent ");
        switch (e.getType()) {
            case 1: {
                sb.append("insert ");
                break;
            }
            case -1: {
                sb.append("delete ");
                break;
            }
            case 0: {
                sb.append("update ");
                break;
            }
            default: {
                sb.append("Unknown type " + e.getType());
            }
        }
        sb.append("from ");
        switch (e.getFirstRow()) {
            case -1: {
                sb.append("header row ");
                break;
            }
            default: {
                sb.append(e.getFirstRow());
                sb.append(' ');
            }
        }
        sb.append("to ");
        sb.append(e.getLastRow());
        sb.append(" column ");
        switch (e.getColumn()) {
            case -1: {
                sb.append("ALL_COLUMNS");
                break;
            }
            default: {
                sb.append(e.getColumn());
            }
        }
        return sb.toString();
    }
}

