/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.io.IOException;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewTemplateAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class LookupNode
extends DataFolder.FolderNode
implements NewTemplateAction.Cookie {
    private static final String EA_HIDDEN = "hidden";
    private static final String EA_HELPCTX = "helpID";
    private static final HelpCtx INSTANCE_DEFAULT_HELP = new HelpCtx("org.openide.loaders.InstanceDataObject");
    private static final HelpCtx FOLDER_DEFAULT_HELP = new HelpCtx("org.openide.loaders.DataFolder");
    private static final String PREFIX_SETTING_CATEGORIES = "UI";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public LookupNode(DataFolder folder) {
        DataFolder dataFolder = folder;
        dataFolder.getClass();
        super(dataFolder, (Children)new Ch(folder));
        this.getCookieSet().add((Node.Cookie)this);
    }

    private boolean isUISettingCategoryNode() {
        DataFolder df = (DataFolder)super.getCookie(DataFolder.class);
        if (df != null) {
            String name = df.getPrimaryFile().getPath();
            return name.startsWith(PREFIX_SETTING_CATEGORIES);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        Object o = this.getDataObject().getPrimaryFile().getAttribute(EA_HELPCTX);
        if (o != null) {
            return new HelpCtx(o.toString());
        }
        HelpCtx ctx = this.getDataObject().getHelpCtx();
        if (ctx != null && ctx != HelpCtx.DEFAULT_HELP && !FOLDER_DEFAULT_HELP.equals((Object)ctx)) {
            return ctx;
        }
        Node n = this.getParentNode();
        if (n != null) {
            ctx = n.getHelpCtx();
        }
        return ctx;
    }

    public final Action[] getActions(boolean context) {
        if (this.isUISettingCategoryNode()) {
            return new Action[0];
        }
        return new Action[]{SystemAction.get((Class)FileSystemAction.class), null, SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)MoveUpAction.class), SystemAction.get((Class)MoveDownAction.class), SystemAction.get((Class)ReorderAction.class), null, SystemAction.get((Class)NewTemplateAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    public final Node.Cookie getCookie(Class type) {
        if (this.isUISettingCategoryNode()) {
            return null;
        }
        return super.getCookie(type);
    }

    public final TemplateWizard getTemplateWizard() {
        TemplateWizard templateWizard = this.createWizard();
        templateWizard.setTemplatesFolder(LookupNode.findFolder(this.root(), this.findName(), true));
        templateWizard.setTargetFolder(LookupNode.findFolder(this.root(), this.findName(), false));
        return templateWizard;
    }

    protected TemplateWizard createWizard() {
        return new TemplateWizard();
    }

    protected LookupNode createChild(DataFolder folder) {
        return new LookupNode(folder);
    }

    protected Node createChild(Node node) {
        return node.cloneNode();
    }

    protected String root() {
        return "Services";
    }

    private static String prefTemplates(String root) {
        return "Templates/" + root;
    }

    private static String prefObjects(String root) {
        return root;
    }

    private String findName() {
        DataFolder df = (DataFolder)this.getCookie(DataFolder.class);
        if (df == null) {
            return "";
        }
        String name = df.getPrimaryFile().getPath();
        if (name.startsWith(LookupNode.prefObjects(this.root()))) {
            name = name.substring(LookupNode.prefObjects(this.root()).length());
        }
        return name;
    }

    static DataFolder findFolder(String root, String name, boolean template) {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            name = template ? '/' + LookupNode.prefTemplates(root) + name : '/' + LookupNode.prefObjects(root) + name;
            FileObject fo = fs.findResource(name);
            if (fo == null && template) {
                name = LookupNode.prefTemplates(root);
            }
            if (fo == null) {
                fo = FileUtil.createFolder((FileObject)fs.getRoot(), (String)name);
            }
            return DataFolder.findFolder((FileObject)fo);
        }
        catch (IOException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    public final void refreshKey(Node node) {
        ((Ch)this.getChildren()).refreshKey(node);
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    protected Sheet createSheet() {
        return new Sheet();
    }

    public boolean canRename() {
        return false;
    }

    public Node cloneNode() {
        return new LookupNode((DataFolder)super.getCookie(DataFolder.class));
    }

    private static final class Ch
    extends FilterNode.Children {
        public Ch(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected void refreshKey(Node node) {
            super.refreshKey((Object)node);
        }

        protected Node[] createNodes(Object n) {
            Object node = (Node)n;
            DataObject obj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LookupNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (obj != null && Boolean.TRUE.equals(obj.getPrimaryFile().getAttribute(LookupNode.EA_HIDDEN))) {
                return new Node[0];
            }
            LookupNode parent = (LookupNode)this.getNode();
            if (obj != null) {
                if (obj instanceof DataFolder && n.equals(obj.getNodeDelegate())) {
                    node = parent.createChild((DataFolder)obj);
                    return new Node[]{node};
                }
                if (obj instanceof DataShadow) {
                    DataObject orig = ((DataShadow)obj).getOriginal();
                    FileObject fo = orig.getPrimaryFile();
                    if (fo.isFolder() && !fo.getChildren(false).hasMoreElements()) {
                        return null;
                    }
                    if (orig instanceof DataFolder) {
                        return new Node[]{parent.createChild((DataFolder)orig)};
                    }
                    obj = orig;
                    node = orig.getNodeDelegate();
                }
                node = new Leaf((Node)node, obj, (Node)parent);
            }
            node = parent.createChild((Node)node);
            return new Node[]{node};
        }
    }

    private static final class Leaf
    extends FilterNode {
        DataObject data;
        Node parent;

        Leaf(Node node, DataObject data, Node parent) {
            super(node, (Children)(data instanceof XMLDataObject || node.isLeaf() ? FilterNode.Children.LEAF : new FilterNode.Children(node)));
            this.data = data;
            this.parent = parent;
        }

        public boolean equals(Object o) {
            return this == o || this.getOriginal().equals(o) || o != null && o.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }

        public HelpCtx getHelpCtx() {
            Object o = this.data.getPrimaryFile().getAttribute(LookupNode.EA_HELPCTX);
            if (o != null) {
                return new HelpCtx(o.toString());
            }
            HelpCtx ctx = this.getOriginal().getHelpCtx();
            if (ctx != null && ctx != HelpCtx.DEFAULT_HELP && !INSTANCE_DEFAULT_HELP.equals((Object)ctx)) {
                return ctx;
            }
            Node n = this.getParentNode();
            if (n == null) {
                n = this.parent;
            }
            if (n != null) {
                ctx = n.getHelpCtx();
            }
            return ctx;
        }

        public Action getPreferredAction() {
            return null;
        }
    }
}

