/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ToolTipManager;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IDESettings
extends SystemOption {
    static final long serialVersionUID = 801136840705717911L;
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String PROP_PROXY_TYPE = "proxyType";
    public static final String PROP_PROXY_HOST = "userProxyHost";
    public static final String PROP_PROXY_PORT = "userProxyPort";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_MODULES_SORT_MODE = "modulesSortMode";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_UIMODE = "UIMode";
    public static final String PROP_NON_PROXY_HOSTS = "userNonProxy";
    public static final String PROP_IGNORED_FILES = "IgnoredFiles";
    public static final String KEY_PROXY_HOST = "http.proxyHost";
    public static final String KEY_PROXY_PORT = "http.proxyPort";
    public static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final int MODULES_SORT_UNSORTED = 0;
    public static final int MODULES_SORT_DISPLAYNAME = 1;
    public static final int MODULES_SORT_CODENAME = 2;
    public static final int MODULES_SORT_ENABLED = 3;
    public static final int MODULES_SORT_URL = 4;
    public static final int MODULES_SORT_CATEGORY = 5;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;
    private static boolean showToolTips;
    private static boolean showTips;
    private static int lastTip;
    private static boolean confirmDelete;
    private static int modulesSortMode;
    private static boolean useProxy;
    private static int proxyType;
    private static String userProxyHost;
    private static String userProxyPort;
    private static String presetNonProxyHosts;
    private String userNonProxyHosts = "";
    private static int uiMode;
    private static String ignoredFiles;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    protected void initialize() {
        super.initialize();
        this.userNonProxyHosts = IDESettings.getModifiedNonProxyHosts(this.getSystemNonProxyHosts());
        this.setProxy();
        this.setProxy();
        this.putProperty(PROP_WWWBROWSER, "", false);
    }

    private void setProxy() {
        String host = this.getProxyHost();
        String port = this.getProxyPort();
        String nonProxyHosts = this.getNonProxyHosts();
        System.setProperty(KEY_PROXY_HOST, host);
        System.setProperty(KEY_PROXY_PORT, port);
        System.setProperty(KEY_NON_PROXY_HOSTS, nonProxyHosts);
        System.setProperty(KEY_HTTPS_PROXY_HOST, host);
        System.setProperty(KEY_HTTPS_PROXY_PORT, port);
        System.setProperty(KEY_HTTPS_NON_PROXY_HOSTS, nonProxyHosts);
    }

    public static URL getRealHomeURL() {
        try {
            return new URL(NbBundle.getMessage((Class)IDESettings.class, (String)"URL_default_home_page"));
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getModulesSortMode() {
        return modulesSortMode;
    }

    public void setModulesSortMode(int nue) {
        int oldValue = modulesSortMode;
        modulesSortMode = nue;
        this.firePropertyChange(PROP_MODULES_SORT_MODE, new Integer(oldValue), new Integer(nue));
    }

    public boolean getShowToolTipsInIDE() {
        return showToolTips;
    }

    public void setShowToolTipsInIDE(boolean value) {
        if (showToolTips == value) {
            return;
        }
        showToolTips = value;
        ToolTipManager.sharedInstance().setEnabled(value);
        this.firePropertyChange(PROP_SHOW_TOOLTIPS_IN_IDE, !showToolTips ? Boolean.TRUE : Boolean.FALSE, showToolTips ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getConfirmDelete() {
        return confirmDelete;
    }

    public void setConfirmDelete(boolean value) {
        if (value == confirmDelete) {
            return;
        }
        Boolean oldValue = confirmDelete ? Boolean.TRUE : Boolean.FALSE;
        confirmDelete = value;
        this.firePropertyChange(PROP_CONFIRM_DELETE, oldValue, confirmDelete ? Boolean.TRUE : Boolean.FALSE);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)IDESettings.class).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IDESettings.class);
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String homePage) {
        HtmlBrowser.setHomePage((String)homePage);
    }

    public boolean getUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean value) {
        if (useProxy != value) {
            if (value) {
                this.setProxyType(2);
            } else {
                this.setProxyType(1);
            }
        }
    }

    public int getProxyType() {
        int type;
        int n = type = proxyType == -1 ? 1 : proxyType;
        if (type == 1 && !this.isSystemProxyDetect()) {
            type = 0;
        }
        return type;
    }

    public void setProxyType(int value) {
        if (proxyType != value) {
            int oldProxyType = proxyType;
            boolean oldUseProxy = this.getUseProxy();
            String oldHost = this.getProxyHost();
            String oldPort = this.getProxyPort();
            String oldNonProxyHosts = this.getNonProxyHosts();
            proxyType = value;
            if (oldUseProxy != this.getUseProxy()) {
                this.firePropertyChange(PROP_USE_PROXY, oldUseProxy ? Boolean.TRUE : Boolean.FALSE, this.getUseProxy() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (!oldHost.equals(this.getProxyHost())) {
                this.firePropertyChange(PROP_PROXY_HOST, oldHost, this.getProxyHost());
            }
            if (!oldPort.equals(this.getProxyPort())) {
                this.firePropertyChange(PROP_PROXY_PORT, oldPort, this.getProxyPort());
            }
            if (!oldNonProxyHosts.equals(this.getNonProxyHosts())) {
                this.firePropertyChange(PROP_NON_PROXY_HOSTS, oldNonProxyHosts, this.getNonProxyHosts());
            }
            this.setProxy();
        }
    }

    public String getUserProxyHost() {
        return userProxyHost;
    }

    public String getUserProxyPort() {
        return userProxyPort;
    }

    public void setUserProxyHost(String value) {
        String oldUserHost;
        if (!(value = value == null ? "" : value).equals(oldUserHost = this.getUserProxyHost())) {
            userProxyHost = value;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_HOST, value);
                System.setProperty(KEY_HTTPS_PROXY_HOST, value);
                this.firePropertyChange(PROP_PROXY_HOST, oldUserHost, value);
            }
        }
    }

    public void setUserProxyPort(String value) {
        String oldUserPort;
        if (!(value = value == null ? "" : value).equals(oldUserPort = this.getUserProxyPort())) {
            userProxyPort = value;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_PORT, value);
                System.setProperty(KEY_HTTPS_PROXY_PORT, value);
                this.firePropertyChange(PROP_PROXY_PORT, oldUserPort, value);
            }
        }
    }

    public String getProxyHost() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyHost();
            }
            case 2: {
                return this.getUserProxyHost();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void setUserNonProxyHosts(String value) {
        String string = value = value == null ? "" : value;
        if (!value.equals(this.userNonProxyHosts)) {
            System.setProperty(KEY_NON_PROXY_HOSTS, value);
            System.setProperty(KEY_HTTPS_NON_PROXY_HOSTS, value);
            this.firePropertyChange(KEY_NON_PROXY_HOSTS, this.userNonProxyHosts, value);
            this.userNonProxyHosts = value;
        }
    }

    public String getUserNonProxyHosts() {
        return this.userNonProxyHosts;
    }

    public void readOldProxyHost(String value) {
        this.setUserProxyHost(value);
    }

    public void readOldProxyPort(String value) {
        this.setUserProxyPort(value);
    }

    public void setProxyHost(String value) {
        String string = value = value == null ? "" : value;
        if (!$assertionsDisabled && 2 != this.getProxyType()) {
            throw new AssertionError((Object)("Don't set proxy host if proxy type " + this.getProxyType()));
        }
        if (!this.getUserProxyHost().equals(value)) {
            String oldHost = this.getUserProxyHost();
            this.setUserProxyHost(value);
            System.setProperty(KEY_PROXY_HOST, value);
            System.setProperty(KEY_HTTPS_PROXY_HOST, value);
        }
    }

    public String getProxyPort() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyPort();
            }
            case 2: {
                return this.getUserProxyPort();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void setProxyPort(String value) {
        String string = value = value == null ? "" : value;
        if (!$assertionsDisabled && 2 != this.getProxyType()) {
            throw new AssertionError((Object)("Don't set proxy port if proxy type " + this.getProxyType()));
        }
        if (!this.getUserProxyPort().equals(value)) {
            String oldPort = this.getUserProxyPort();
            this.setUserProxyPort(value);
            System.setProperty(KEY_PROXY_PORT, this.getProxyPort());
            System.setProperty(KEY_HTTPS_PROXY_PORT, this.getProxyPort());
        }
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean s) {
        boolean old = this.getShowFileExtensions();
        DataNode.setShowFileExtensions((boolean)s);
        this.firePropertyChange(PROP_SHOW_FILE_EXTENSIONS, old, s);
    }

    public HtmlBrowser.Factory getWWWBrowser() {
        block8: {
            try {
                Object obj = this.getProperty(PROP_WWWBROWSER);
                if (obj instanceof String && !"".equals(obj)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, (String)obj, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (obj != null && !"".equals(obj)) break block8;
                Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(HtmlBrowser.Factory.class));
                Iterator it = res.allInstances().iterator();
                while (it.hasNext()) {
                    Object brow = it.next();
                    FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder folder = DataFolder.findFolder((FileObject)fo);
                    DataObject[] dobjs = folder.getChildren();
                    for (int i = 0; i < dobjs.length; ++i) {
                        Object o = null;
                        try {
                            if (Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("hidden"))) continue;
                            InstanceCookie cookie = (InstanceCookie)dobjs[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (cookie == null || (o = cookie.instanceCreate()) == null || !o.equals(brow)) continue;
                            return (HtmlBrowser.Factory)brow;
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                            continue;
                        }
                        catch (ClassNotFoundException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
                return null;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return null;
    }

    public void setWWWBrowser(HtmlBrowser.Factory brow) {
        try {
            if (brow == null) {
                this.putProperty(PROP_WWWBROWSER, "", true);
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)brow));
            if (item != null) {
                this.putProperty(PROP_WWWBROWSER, item.getId(), true);
            } else {
                ErrorManager.getDefault().log("IDESettings: Cannot find browser in lookup");
                this.putProperty(PROP_WWWBROWSER, "", true);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void setUIMode(int uiMode) {
        if (IDESettings.uiMode == uiMode) {
            return;
        }
        int oldValue = IDESettings.uiMode;
        IDESettings.uiMode = uiMode;
        this.firePropertyChange(PROP_UIMODE, new Integer(oldValue), new Integer(uiMode));
    }

    public int getUIMode() {
        return uiMode;
    }

    private static String getModifiedNonProxyHosts(String systemPreset) {
        String fromUser;
        String fromSystem = systemPreset.replaceAll(";", "|").replaceAll(",", "|");
        String string = fromUser = presetNonProxyHosts == null ? "" : presetNonProxyHosts.replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            fromSystem = IDESettings.addReguralToNonProxyHosts(fromSystem);
        }
        String nonProxy = fromUser + (fromUser.length() == 0 ? "" : "|") + fromSystem + (fromSystem.length() == 0 ? "" : "|") + "localhost|127.0.0.1";
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
            if (!localhost.equals("localhost")) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            String localhost2 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!localhost2.equals("localhost") && !localhost2.equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost2;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return IDESettings.compactNonProxyHosts(nonProxy);
    }

    public String getIgnoredFiles() {
        return ignoredFiles;
    }

    public void setIgnoredFiles(String ignoredFiles) throws IllegalArgumentException {
        if (!IDESettings.ignoredFiles.equals(ignoredFiles)) {
            try {
                String oldIgnoredfiles = IDESettings.ignoredFiles;
                Pattern.compile(ignoredFiles);
                IDESettings.ignoredFiles = ignoredFiles;
                this.firePropertyChange(PROP_IGNORED_FILES, oldIgnoredfiles, ignoredFiles);
            }
            catch (PatternSyntaxException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                ErrorManager.getDefault().annotate((Throwable)iae, 256, e.getMessage(), e.getLocalizedMessage(), null, null);
                throw iae;
            }
        }
    }

    private boolean isSystemProxyDetect() {
        return System.getProperty("netbeans.system_http_proxy") != null;
    }

    private String getSystemProxyHost() {
        String systemProxy = System.getProperty("netbeans.system_http_proxy");
        if (systemProxy == null) {
            return "";
        }
        int i = systemProxy.indexOf(":");
        if (i <= 0 || i >= systemProxy.length() - 1) {
            return "";
        }
        return systemProxy.substring(0, i);
    }

    private String getSystemNonProxyHosts() {
        String systemProxy = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return systemProxy == null ? "" : systemProxy;
    }

    private static String normalizeProxyHost(String proxyHost) {
        if (proxyHost.toLowerCase().startsWith("http://")) {
            return proxyHost.substring(7, proxyHost.length());
        }
        return proxyHost;
    }

    private static String compactNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        HashSet<String> s = new HashSet<String>();
        String compactedProxyHosts = "";
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!s.add(t.toLowerCase(Locale.US))) continue;
            compactedProxyHosts = compactedProxyHosts + (compactedProxyHosts.length() > 0 ? "|" : "") + t;
        }
        return compactedProxyHosts;
    }

    private static String addReguralToNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        String reguralProxyHosts = "";
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf(42) == -1) {
                t = t + '*';
            } else if (t.indexOf(60) != -1) {
                t = "";
            }
            reguralProxyHosts = reguralProxyHosts + (reguralProxyHosts.length() > 0 ? "|" : "") + t;
        }
        return reguralProxyHosts;
    }

    private String getSystemProxyPort() {
        String systemProxy = System.getProperty("netbeans.system_http_proxy");
        if (systemProxy == null) {
            return "";
        }
        int i = systemProxy.indexOf(":");
        if (i <= 0 || i >= systemProxy.length() - 1) {
            return "";
        }
        return systemProxy.substring(i + 1);
    }

    public String getNonProxyHosts() {
        switch (this.getProxyType()) {
            case 1: {
                return IDESettings.getModifiedNonProxyHosts(this.getSystemNonProxyHosts());
            }
            case 2: {
                return this.getUserNonProxyHosts();
            }
            case 0: {
                return "";
            }
        }
        throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
    }

    static {
        $assertionsDisabled = !IDESettings.class.desiredAssertionStatus();
        showToolTips = true;
        showTips = true;
        lastTip = -1;
        confirmDelete = true;
        modulesSortMode = 5;
        useProxy = false;
        proxyType = -1;
        userProxyHost = System.getProperty(KEY_PROXY_HOST, "");
        userProxyPort = System.getProperty(KEY_PROXY_PORT, "");
        presetNonProxyHosts = System.getProperty(KEY_NON_PROXY_HOSTS, "");
        uiMode = 2;
        ignoredFiles = "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store))$|^\\.[#_]|~$";
    }
}

