/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SyntaxColoringPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JComboBox cbLanguages = new JComboBox();
    private JList lCategories = new JList();
    private JTextField tfFont = new JTextField("");
    private JButton bFont = new JButton("...");
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private JButton bForeground = new JButton("...");
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private JButton bBackground = new JButton("...");
    private JComboBox cbEffects = new JComboBox();
    private ColorComboBox effectsColorChooser = new ColorComboBox();
    private JPanel previewPanel = new JPanel();
    private ColorModel.Preview preview;
    private RequestProcessor.Task selectTask;
    private FontAndColorsPanel fontAndColorsPanel;
    private ColorModel colorModel = null;
    private String currentLanguage;
    private String currentProfile;
    private Map profiles = new HashMap();
    private Map toBeSaved = new HashMap();
    private boolean listen = false;
    private boolean blink = true;
    private int blinkSequence = 0;
    private RequestProcessor.Task task = new RequestProcessor("SyntaxColoringPanel").create(new Runnable(){

        public void run() {
            SyntaxColoringPanel.this.updatePreview();
            if (SyntaxColoringPanel.this.blinkSequence == 0) {
                return;
            }
            SyntaxColoringPanel.this.blinkSequence--;
            SyntaxColoringPanel.this.task.schedule(250);
        }
    });
    private Map defaults = new HashMap();
    private static Map convertALC = new HashMap();
    private static Integer defaultFontSize;

    public SyntaxColoringPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.fontAndColorsPanel = fontAndColorsPanel;
        this.cbLanguages.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Languages"));
        this.cbLanguages.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Languages"));
        this.lCategories.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Categories"));
        this.bFont.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Font"));
        this.bFont.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Font"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground_Chooser"));
        this.bForeground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground"));
        this.bForeground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background_Chooser"));
        this.bBackground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background"));
        this.bBackground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color_Chooser"));
        this.effectsColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color"));
        this.effectsColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color"));
        this.cbLanguages.addActionListener(this);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!SyntaxColoringPanel.this.listen) {
                    return;
                }
                SyntaxColoringPanel.this.selectTask.schedule(200);
            }
        });
        this.tfFont.setEditable(false);
        this.bFont.addActionListener(this);
        this.bFont.setMargin(new Insets(0, 0, 0, 0));
        this.bForeground.addActionListener(this);
        this.bForeground.setMargin(new Insets(0, 0, 0, 0));
        this.bBackground.addActionListener(this);
        this.bBackground.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_None"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Wave_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Strike_Through"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Effects"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Effects"));
        this.cbEffects.addActionListener(this);
        this.effectsColorChooser = new ColorComboBox();
        this.effectsColorChooser.addPropertyChangeListener(this);
        JLabel lCategory = new JLabel();
        SyntaxColoringPanel.loc(lCategory, "CTL_Category");
        lCategory.setLabelFor(this.lCategories);
        JLabel lbFont = new JLabel();
        SyntaxColoringPanel.loc(lbFont, "CTL_Font");
        lbFont.setLabelFor(this.bFont);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(new EtchedBorder());
        FormLayout layout = new FormLayout("p, 3dlu, 120dlu", "p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Languages"), lc.xy(1, 1), (Component)this.cbLanguages, cc.xy(3, 1));
        JPanel pLanguages = builder.getPanel();
        layout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g, 1dlu, p", "p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p, 3dlu, f:130dlu:g");
        builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.add((Component)pLanguages, cc.xyw(1, 1, 5));
        builder.add((Component)lCategory, lc.xy(1, 3));
        builder.add((Component)new JScrollPane(this.lCategories), cc.xywh(1, 5, 1, 9));
        builder.add((Component)lbFont, lc.xy(3, 5));
        builder.add((Component)this.tfFont, cc.xy(5, 5));
        builder.add((Component)this.bFont, cc.xy(7, 5));
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Foreground_label"), lc.xy(3, 7), (Component)this.foregroundColorChooser, cc.xyw(5, 7, 3));
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Background_label"), lc.xy(3, 9), (Component)this.backgroundColorChooser, cc.xyw(5, 9, 3));
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Effects_label"), lc.xy(3, 11), (Component)this.cbEffects, cc.xyw(5, 11, 3));
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Effects_color"), lc.xy(3, 13), (Component)this.effectsColorChooser, cc.xyw(5, 13, 3));
        builder.addLabel(SyntaxColoringPanel.loc("CTL_Preview"), lc.xyw(1, 15, 7), (Component)this.previewPanel, cc.xyw(1, 17, 7));
        this.selectTask = new RequestProcessor("SyntaxColoringPanel1").create(new Runnable(){

            public void run() {
                SyntaxColoringPanel.this.refreshUI();
                if (!SyntaxColoringPanel.this.blink) {
                    return;
                }
                SyntaxColoringPanel.this.startBlinking();
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getSource() == this.cbEffects) {
            this.effectsColorChooser.setEnabled(this.cbEffects.getSelectedIndex() > 0);
            if (this.cbEffects.getSelectedIndex() == 0) {
                this.effectsColorChooser.setColor(null);
            }
            this.updateData();
        } else if (evt.getSource() == this.cbLanguages) {
            this.setCurrentLanguage((String)this.cbLanguages.getSelectedItem());
        } else if (evt.getSource() == this.bFont) {
            PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
            AttributeSet category = this.getCurrentCategory();
            Font f = this.getFont(category);
            pe.setValue(f);
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), SyntaxColoringPanel.loc("CTL_Font_Chooser"));
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                f = (Font)pe.getValue();
                category = this.modifyFont(category, f);
                this.replaceCurrrentCategory(category);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getPropertyName() == "currentAElement") {
            String currentCategory = (String)evt.getNewValue();
            Vector categories = this.getCategories(this.currentProfile, this.currentLanguage);
            if (this.currentLanguage.equals(ColorModel.ALL_LANGUAGES)) {
                currentCategory = (String)convertALC.get(currentCategory);
            }
            int k = categories.size();
            for (int i = 0; i < k; ++i) {
                AttributeSet as = (AttributeSet)categories.get(i);
                if (!currentCategory.equals(as.getAttribute(StyleConstants.NameAttribute))) continue;
                this.blink = false;
                this.lCategories.setSelectedIndex(i);
                this.lCategories.ensureIndexIsVisible(i);
                this.blink = true;
                return;
            }
        }
        if (evt.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.currentLanguage = (String)colorModel.getLanguages().iterator().next();
        if (this.preview != null) {
            this.preview.removePropertyChangeListener("currentAElement", this);
        }
        Component component = colorModel.getSyntaxColoringPreviewComponent(this.currentLanguage);
        this.preview = (ColorModel.Preview)component;
        this.previewPanel.removeAll();
        this.previewPanel.add("Center", component);
        this.preview.addPropertyChangeListener("currentAElement", this);
        this.listen = false;
        ArrayList languages = new ArrayList(colorModel.getLanguages());
        Collections.sort(languages, new LanguagesComparator());
        Iterator it = languages.iterator();
        this.cbLanguages.removeAllItems();
        while (it.hasNext()) {
            this.cbLanguages.addItem(it.next());
        }
        this.listen = true;
        this.cbLanguages.setSelectedIndex(0);
    }

    void cancel() {
        this.toBeSaved = new HashMap();
        this.profiles = new HashMap();
    }

    void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator it = this.toBeSaved.keySet().iterator();
        while (it.hasNext()) {
            String profile = (String)it.next();
            Set toBeSavedLanguages = (Set)this.toBeSaved.get(profile);
            Map schemeMap = (Map)this.profiles.get(profile);
            Iterator it2 = toBeSavedLanguages.iterator();
            while (it2.hasNext()) {
                String languageName = (String)it2.next();
                this.colorModel.setCategories(profile, languageName, (Vector)schemeMap.get(languageName));
            }
        }
        this.toBeSaved = new HashMap();
        this.profiles = new HashMap();
    }

    boolean isChanged() {
        return !this.toBeSaved.isEmpty();
    }

    public void setCurrentProfile(String currentProfile) {
        String oldProfile = this.currentProfile;
        this.currentProfile = currentProfile;
        if (!this.colorModel.getProfiles().contains(currentProfile)) {
            this.cloneScheme(oldProfile, currentProfile);
        }
        Vector categories = this.getCategories(currentProfile, this.currentLanguage);
        this.lCategories.setListData(categories);
        this.blink = false;
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    void deleteProfile(String profile) {
        Iterator it = this.colorModel.getLanguages().iterator();
        HashMap<String, Vector> m = new HashMap<String, Vector>();
        boolean custom = this.colorModel.isCustomProfile(profile);
        while (it.hasNext()) {
            String language = (String)it.next();
            if (custom) {
                m.put(language, null);
                continue;
            }
            m.put(language, this.getDefaults(profile, language));
        }
        this.profiles.put(profile, m);
        this.toBeSaved.put(profile, new HashSet(this.colorModel.getLanguages()));
        if (!custom) {
            this.refreshUI();
        }
    }

    private void cloneScheme(String oldScheme, String newScheme) {
        HashMap m = new HashMap();
        Iterator it = this.colorModel.getLanguages().iterator();
        while (it.hasNext()) {
            String language = (String)it.next();
            Vector v = this.getCategories(oldScheme, language);
            m.put(language, new Vector(v));
            this.setToBeSaved(newScheme, language);
        }
        this.profiles.put(newScheme, m);
    }

    Collection getAllLanguages() {
        return this.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
    }

    Collection getSyntaxColorings() {
        return this.getCategories(this.currentProfile, this.currentLanguage);
    }

    private void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        this.blink = false;
        this.lCategories.setListData(this.getCategories(this.currentProfile, this.currentLanguage));
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)SyntaxColoringPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)SyntaxColoringPanel.loc(key));
        }
    }

    private void updateData() {
        int i = this.lCategories.getSelectedIndex();
        if (i < 0) {
            return;
        }
        AttributeSet category = this.getCurrentCategory();
        Color underline = null;
        Color wave = null;
        Color strikethrough = null;
        if (this.cbEffects.getSelectedIndex() == 1) {
            underline = this.effectsColorChooser.getColor();
        }
        if (this.cbEffects.getSelectedIndex() == 2) {
            wave = this.effectsColorChooser.getColor();
        }
        if (this.cbEffects.getSelectedIndex() == 3) {
            strikethrough = this.effectsColorChooser.getColor();
        }
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        if (this.backgroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        if (underline != null) {
            c.addAttribute(StyleConstants.Underline, underline);
        } else {
            c.removeAttribute(StyleConstants.Underline);
        }
        if (strikethrough != null) {
            c.addAttribute(StyleConstants.StrikeThrough, strikethrough);
        } else {
            c.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (wave != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, wave);
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.replaceCurrrentCategory(c);
        this.setToBeSaved(this.currentProfile, this.currentLanguage);
        this.updatePreview();
    }

    private void startBlinking() {
        this.blinkSequence = 5;
        this.task.schedule(0);
    }

    private void updatePreview() {
        Collection syntaxColorings = this.getSyntaxColorings();
        Collection allLanguages = this.getAllLanguages();
        if (this.blinkSequence % 2 == 1) {
            if (this.currentLanguage == ColorModel.ALL_LANGUAGES) {
                allLanguages = this.invertCategory(allLanguages, this.getCurrentCategory());
            } else {
                syntaxColorings = this.invertCategory(syntaxColorings, this.getCurrentCategory());
            }
        }
        this.preview.setParameters(this.currentLanguage, allLanguages, this.fontAndColorsPanel.getHighlights(), syntaxColorings);
    }

    private Collection invertCategory(Collection c, AttributeSet category) {
        if (category == null) {
            return c;
        }
        ArrayList<SimpleAttributeSet> result = new ArrayList<SimpleAttributeSet>(c);
        int i = result.indexOf(category);
        SimpleAttributeSet as = new SimpleAttributeSet(category);
        Color highlight = (Color)this.getValue(this.currentLanguage, category, StyleConstants.Background);
        if (highlight == null) {
            return result;
        }
        Color newColor = new Color(255 - highlight.getRed(), 255 - highlight.getGreen(), 255 - highlight.getBlue());
        as.addAttribute(StyleConstants.Underline, newColor);
        result.set(i, as);
        return result;
    }

    private void refreshUI() {
        this.listen = false;
        AttributeSet category = this.getCurrentCategory();
        if (category == null) {
            this.tfFont.setText("");
            this.bFont.setEnabled(false);
            this.cbEffects.setEnabled(false);
            this.foregroundColorChooser.setEnabled(false);
            this.foregroundColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.backgroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.effectsColorChooser.setEnabled(false);
            this.effectsColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.updatePreview();
            return;
        }
        this.bFont.setEnabled(true);
        this.cbEffects.setEnabled(true);
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        Color inheritedForeground = (Color)this.getDefault(this.currentLanguage, category, StyleConstants.Foreground);
        if (inheritedForeground == null) {
            inheritedForeground = Color.black;
        }
        this.foregroundColorChooser.setInheritedColor(inheritedForeground);
        Color inheritedBackground = (Color)this.getDefault(this.currentLanguage, category, StyleConstants.Background);
        if (inheritedBackground == null) {
            inheritedBackground = Color.white;
        }
        this.backgroundColorChooser.setInheritedColor(inheritedBackground);
        String font = this.fontToString(category);
        this.tfFont.setText(font);
        this.foregroundColorChooser.setColor((Color)category.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)category.getAttribute(StyleConstants.Background));
        if (category.getAttribute(StyleConstants.Underline) != null) {
            this.cbEffects.setSelectedIndex(1);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)category.getAttribute(StyleConstants.Underline));
        } else if (category.getAttribute(EditorStyleConstants.WaveUnderlineColor) != null) {
            this.cbEffects.setSelectedIndex(2);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        } else if (category.getAttribute(StyleConstants.StrikeThrough) != null) {
            this.cbEffects.setSelectedIndex(3);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)category.getAttribute(StyleConstants.StrikeThrough));
        } else {
            this.cbEffects.setSelectedIndex(0);
            this.effectsColorChooser.setEnabled(false);
            this.effectsColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
        }
        this.updatePreview();
        this.listen = true;
    }

    private void setToBeSaved(String currentProfile, String currentLanguage) {
        HashSet<String> s = (HashSet<String>)this.toBeSaved.get(currentProfile);
        if (s == null) {
            s = new HashSet<String>();
            this.toBeSaved.put(currentProfile, s);
        }
        s.add(currentLanguage);
    }

    private Vector getCategories(String profile, String language) {
        Vector v;
        if (this.colorModel == null) {
            return null;
        }
        HashMap m = (HashMap)this.profiles.get(profile);
        if (m == null) {
            m = new HashMap();
            this.profiles.put(profile, m);
        }
        if ((v = (Vector)m.get(language)) == null) {
            Collection c = this.colorModel.getCategories(profile, language);
            ArrayList l = new ArrayList(c);
            Collections.sort(l, new CategoryComparator());
            v = new Vector(l);
            m.put(language, v);
        }
        return v;
    }

    private Vector getDefaults(String profile, String language) {
        Vector v;
        HashMap m = (HashMap)this.defaults.get(profile);
        if (m == null) {
            m = new HashMap();
            this.defaults.put(profile, m);
        }
        if ((v = (Vector)m.get(language)) == null) {
            Collection c = this.colorModel.getDefaults(profile, language);
            ArrayList l = new ArrayList(c);
            Collections.sort(l, new CategoryComparator());
            v = new Vector(l);
            m.put(language, v);
        }
        return new Vector(v);
    }

    private AttributeSet getCurrentCategory() {
        int i = this.lCategories.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (AttributeSet)this.getCategories(this.currentProfile, this.currentLanguage).get(i);
    }

    private void replaceCurrrentCategory(AttributeSet newValues) {
        int i = this.lCategories.getSelectedIndex();
        this.getCategories(this.currentProfile, this.currentLanguage).set(i, newValues);
    }

    private AttributeSet getCategory(String profile, String language, String name) {
        Vector v = this.getCategories(profile, language);
        Iterator it = v.iterator();
        while (it.hasNext()) {
            AttributeSet c = (AttributeSet)it.next();
            if (!c.getAttribute(StyleConstants.NameAttribute).equals(name)) continue;
            return c;
        }
        return null;
    }

    private Object getValue(String language, AttributeSet category, Object key) {
        if (category.isDefined(key)) {
            return category.getAttribute(key);
        }
        return this.getDefault(language, category, key);
    }

    private Object getDefault(String language, AttributeSet category, Object key) {
        AttributeSet defaultAS;
        String name = (String)category.getAttribute(EditorStyleConstants.Default);
        if (name == null) {
            name = "default";
        }
        if (!name.equals(category.getAttribute(StyleConstants.NameAttribute)) && (defaultAS = this.getCategory(this.currentProfile, language, name)) != null) {
            return this.getValue(language, defaultAS, key);
        }
        if (!language.equals(ColorModel.ALL_LANGUAGES) && (defaultAS = this.getCategory(this.currentProfile, ColorModel.ALL_LANGUAGES, name)) != null) {
            return this.getValue(ColorModel.ALL_LANGUAGES, defaultAS, key);
        }
        if (key == StyleConstants.FontFamily) {
            return "Monospaced";
        }
        if (key == StyleConstants.FontSize) {
            return SyntaxColoringPanel.getDefaultFontSize();
        }
        return null;
    }

    private Font getFont(AttributeSet category) {
        int style;
        Boolean italic;
        Boolean bold;
        Integer size;
        String name = (String)this.getValue(this.currentLanguage, category, StyleConstants.FontFamily);
        if (name == null) {
            name = "Monospaced";
        }
        if ((size = (Integer)this.getValue(this.currentLanguage, category, StyleConstants.FontSize)) == null) {
            size = SyntaxColoringPanel.getDefaultFontSize();
        }
        if ((bold = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Bold)) == null) {
            bold = Boolean.FALSE;
        }
        if ((italic = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Italic)) == null) {
            italic = Boolean.FALSE;
        }
        int n = style = bold != false ? 1 : 0;
        if (italic.booleanValue()) {
            style += 2;
        }
        return new Font(name, style, size);
    }

    private AttributeSet modifyFont(AttributeSet category, Font f) {
        String fontName = f.getName();
        Integer fontSize = new Integer(f.getSize());
        Boolean bold = f.isBold();
        Boolean italic = f.isItalic();
        boolean isDefault = "default".equals(category.getAttribute(StyleConstants.NameAttribute));
        if (fontName.equals(this.getDefault(this.currentLanguage, category, StyleConstants.FontFamily)) && !isDefault) {
            fontName = null;
        }
        if (fontSize.equals(this.getDefault(this.currentLanguage, category, StyleConstants.FontSize)) && !isDefault) {
            fontSize = null;
        }
        if (bold.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Bold))) {
            bold = null;
        } else if (bold.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, category, StyleConstants.Bold) == null) {
            bold = null;
        }
        if (italic.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Italic))) {
            italic = null;
        } else if (italic.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, category, StyleConstants.Italic) == null) {
            italic = null;
        }
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        if (fontName != null) {
            c.addAttribute(StyleConstants.FontFamily, fontName);
        } else {
            c.removeAttribute(StyleConstants.FontFamily);
        }
        if (fontSize != null) {
            c.addAttribute(StyleConstants.FontSize, fontSize);
        } else {
            c.removeAttribute(StyleConstants.FontSize);
        }
        if (bold != null) {
            c.addAttribute(StyleConstants.Bold, bold);
        } else {
            c.removeAttribute(StyleConstants.Bold);
        }
        if (italic != null) {
            c.addAttribute(StyleConstants.Italic, italic);
        } else {
            c.removeAttribute(StyleConstants.Italic);
        }
        return c;
    }

    private String fontToString(AttributeSet category) {
        if ("default".equals(category.getAttribute(StyleConstants.NameAttribute))) {
            Boolean italic;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getValue(this.currentLanguage, category, StyleConstants.FontFamily));
            sb.append(' ');
            sb.append(this.getValue(this.currentLanguage, category, StyleConstants.FontSize));
            Boolean bold = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Bold);
            if (bold != null && bold.booleanValue()) {
                sb.append(' ').append(SyntaxColoringPanel.loc("CTL_Bold"));
            }
            if ((italic = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Italic)) != null && italic.booleanValue()) {
                sb.append(' ').append(SyntaxColoringPanel.loc("CTL_Italic"));
            }
            return sb.toString();
        }
        boolean def = false;
        StringBuffer sb = new StringBuffer();
        if (category.getAttribute(StyleConstants.FontFamily) != null) {
            sb.append('+').append(category.getAttribute(StyleConstants.FontFamily));
        } else {
            def = true;
        }
        if (category.getAttribute(StyleConstants.FontSize) != null) {
            sb.append('+').append(category.getAttribute(StyleConstants.FontSize));
        } else {
            def = true;
        }
        if (Boolean.TRUE.equals(category.getAttribute(StyleConstants.Bold))) {
            sb.append('+').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.FALSE.equals(category.getAttribute(StyleConstants.Bold))) {
            sb.append('-').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.TRUE.equals(category.getAttribute(StyleConstants.Italic))) {
            sb.append('+').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (Boolean.FALSE.equals(category.getAttribute(StyleConstants.Italic))) {
            sb.append('-').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (def) {
            sb.insert(0, SyntaxColoringPanel.loc("CTL_Inherited"));
            return sb.toString();
        }
        String result = sb.toString();
        return result.replace('+', ' ');
    }

    private static Integer getDefaultFontSize() {
        if (defaultFontSize == null && (defaultFontSize = (Integer)UIManager.get("customFontSize")) == null) {
            int s = UIManager.getFont("TextField.font").getSize();
            if (s < 12) {
                s = 12;
            }
            defaultFontSize = new Integer(s);
        }
        return defaultFontSize;
    }

    static {
        convertALC.put("java-block-comment", "comment");
        convertALC.put("java-keywords", "keyword");
        convertALC.put("java-line-comment", "comment");
        convertALC.put("java-dentifier", "identifier");
        convertALC.put("java-numeric-literals", "number");
        convertALC.put("java-operators", "operator");
        convertALC.put("java-char-literal", "char");
        convertALC.put("java-string-literal", "string");
        convertALC.put("java-whitespace", "whitespace");
        convertALC.put("java-identifier", "identifier");
        convertALC.put("java-error", "error");
    }

    private static class LanguagesComparator
    implements Comparator {
        private LanguagesComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(ColorModel.ALL_LANGUAGES)) {
                return o2.equals(ColorModel.ALL_LANGUAGES) ? 0 : -1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    }
}

