/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteSubprojectProviderImpl;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.SuiteOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class SuiteProject
implements Project {
    public static final String SUITE_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/suite.gif";
    private final AntProjectHelper helper;
    private final Lookup lookup;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$suite$SuiteProject;

    public SuiteProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.eval = this.createEvaluator();
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        Util.err.log("Loading suite project in " + this.getProjectDirectory());
        this.lookup = Lookups.fixed((Object[])new Object[]{new Info(), helper.createAuxiliaryConfiguration(), helper.createCacheDirectoryProvider(), new SavedHook(), new OpenedHook(), helper.createSharabilityQuery(this.eval, new String[0], new String[]{"build", "dist"}), new SuiteSubprojectProviderImpl(helper, this.eval), new SuiteProviderImpl(), new SuiteActions(this), new SuiteLogicalView(this), new SuiteCustomizer(this, helper, this.eval), new PrivilegedTemplatesImpl(), new SuiteOperations(this)});
    }

    public String toString() {
        return "SuiteProject[" + this.getProjectDirectory() + "]";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    public NbPlatform getPlatform(boolean fallback) {
        String destdir = this.getEvaluator().getProperty("netbeans.dest.dir");
        NbPlatform p = destdir != null ? NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(destdir)) : null;
        if (fallback && (p == null || !p.isValid())) {
            p = NbPlatform.getDefaultPlatform();
        }
        return p;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyProvider predefs = this.helper.getStockPropertyPreprovider();
        File dir = FileUtil.toFile((FileObject)this.getProjectDirectory());
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(this.helper.getPropertyProvider("nbproject/private/platform-private.properties"));
        providers.add(this.helper.getPropertyProvider("nbproject/platform.properties"));
        PropertyEvaluator baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        providers.add(new Util.UserPropertiesFileProvider(baseEval, dir));
        baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        class DestDirProvider
        extends Util.ComputedPropertyProvider {
            public DestDirProvider(PropertyEvaluator eval) {
                super(eval);
            }

            protected Map getProperties(Map inputPropertyValues) {
                String platformS = (String)inputPropertyValues.get("nbplatform.active");
                if (platformS != null) {
                    return Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + platformS + ".netbeans.dest.dir}");
                }
                return Collections.EMPTY_MAP;
            }

            protected Set inputProperties() {
                return Collections.singleton("nbplatform.active");
            }
        }
        providers.add(new DestDirProvider(baseEval));
        providers.add(this.helper.getPropertyProvider("nbproject/private/private.properties"));
        providers.add(this.helper.getPropertyProvider("nbproject/project.properties"));
        HashMap<String, String> fixedProps = new HashMap<String, String>();
        fixedProps.put("enabled.clusters", "");
        fixedProps.put("disabled.clusters", "");
        fixedProps.put("disabled.modules", "");
        providers.add(PropertyUtils.fixedPropertyProvider(fixedProps));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Ant/Project.xml", "Templates/Other/properties.properties"};
        private static final String[] RECOMMENDED_TYPES = new String[]{"oasis-XML-catalogs", "XML", "ant-script", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }
    }

    private final class SuiteProviderImpl
    implements SuiteProvider {
        private SuiteProviderImpl() {
        }

        public File getSuiteDirectory() {
            return FileUtil.toFile((FileObject)SuiteProject.this.getProjectDirectory());
        }
    }

    private final class SavedHook
    extends ProjectXmlSavedHook {
        SavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            SuiteProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", (class$org$netbeans$modules$apisupport$project$suite$SuiteProject == null ? (class$org$netbeans$modules$apisupport$project$suite$SuiteProject = SuiteProject.class$("org.netbeans.modules.apisupport.project.suite.SuiteProject")) : class$org$netbeans$modules$apisupport$project$suite$SuiteProject).getResource("resources/build-impl.xsl"), false);
            SuiteProject.this.genFilesHelper.refreshBuildScript("build.xml", (class$org$netbeans$modules$apisupport$project$suite$SuiteProject == null ? (class$org$netbeans$modules$apisupport$project$suite$SuiteProject = SuiteProject.class$("org.netbeans.modules.apisupport.project.suite.SuiteProject")) : class$org$netbeans$modules$apisupport$project$suite$SuiteProject).getResource("resources/build.xsl"), false);
        }
    }

    public final class OpenedHook
    extends ProjectOpenedHook {
        OpenedHook() {
        }

        public void projectOpened() {
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    String path = "nbproject/private/platform-private.properties";
                    EditableProperties ep = SuiteProject.this.helper.getProperties(path);
                    File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
                    ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
                    SuiteProject.this.helper.putProperties(path, ep);
                    try {
                        ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
            try {
                SuiteProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", (class$org$netbeans$modules$apisupport$project$suite$SuiteProject == null ? (class$org$netbeans$modules$apisupport$project$suite$SuiteProject = SuiteProject.class$("org.netbeans.modules.apisupport.project.suite.SuiteProject")) : class$org$netbeans$modules$apisupport$project$suite$SuiteProject).getResource("resources/build-impl.xsl"), true);
                SuiteProject.this.genFilesHelper.refreshBuildScript("build.xml", (class$org$netbeans$modules$apisupport$project$suite$SuiteProject == null ? (class$org$netbeans$modules$apisupport$project$suite$SuiteProject = SuiteProject.class$("org.netbeans.modules.apisupport.project.suite.SuiteProject")) : class$org$netbeans$modules$apisupport$project$suite$SuiteProject).getResource("resources/build.xsl"), true);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    private final class Info
    implements ProjectInformation,
    AntProjectListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
            SuiteProject.this.helper.addAntProjectListener((AntProjectListener)this);
        }

        private String getSimpleName() {
            Element nameEl = Util.findElement(SuiteProject.this.helper.getPrimaryConfigurationData(true), "name", "http://www.netbeans.org/ns/nb-module-suite-project/1");
            String text = nameEl != null ? Util.findText(nameEl) : null;
            return text != null ? text : "???";
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getSimpleName());
        }

        public String getDisplayName() {
            String appTitle = SuiteProject.this.getEvaluator().getProperty("app.title");
            if (appTitle != null) {
                return appTitle;
            }
            return this.getSimpleName();
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)SuiteProject.SUITE_ICON_PATH));
        }

        public Project getProject() {
            return SuiteProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.fireNameChange();
        }

        public void propertiesChanged(AntProjectEvent ev) {
            this.fireNameChange();
        }

        private void fireNameChange() {
            this.pcs.firePropertyChange("name", null, this.getName());
            this.pcs.firePropertyChange("displayName", null, this.getDisplayName());
        }
    }
}

