/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.web.project.ui.customizer.LibrariesChooser;
import org.netbeans.modules.web.project.ui.customizer.WarIncludesUiSupport;
import org.netbeans.modules.web.project.ui.customizer.WebClassPathUi;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WarIncludesUi {
    private WarIncludesUi() {
    }

    static class ClassPathCellRenderer
    extends DefaultTableCellRenderer {
        private static String RESOURCE_ICON_JAR = "org/netbeans/modules/web/project/ui/resources/jar.gif";
        private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/web/project/ui/resources/libraries.gif";
        private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/web/project/ui/resources/projectDependencies.gif";
        private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/web/project/ui/resources/referencedClasspath.gif";
        private static String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/web/project/ui/resources/brokenProjectBadge.gif";
        private static ImageIcon ICON_JAR = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_JAR));
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_LIBRARY = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_LIBRARY));
        private static ImageIcon ICON_ARTIFACT = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT));
        private static ImageIcon ICON_CLASSPATH = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH));
        private static ImageIcon ICON_BROKEN_BADGE = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_BROKEN_BADGE));
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        ClassPathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String s = null;
            if (value instanceof ClassPathSupport.Item) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)value;
                this.setIcon(ClassPathCellRenderer.getIcon(item));
                this.setToolTipText(this.getToolTipText(item));
                s = this.getDisplayName(item);
            }
            return super.getTableCellRendererComponent(table, s, isSelected, false, row, column);
        }

        private String getDisplayName(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                    }
                    return item.getLibrary().getDisplayName();
                }
                case 3: {
                    String name = (String)WELL_KNOWN_PATHS_NAMES.get(WebProjectProperties.getAntPropertyName(item.getReference()));
                    return name == null ? item.getReference() : name;
                }
                case 2: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                    }
                    return item.getArtifactURI().toString();
                }
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    return item.getFile().getPath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(Utilities.mergeImages((Image)ICON_LIBRARY.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ICON_LIBRARY;
                }
                case 2: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_ARTIFACT == null) {
                            ICON_BROKEN_ARTIFACT = new ImageIcon(Utilities.mergeImages((Image)ICON_ARTIFACT.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_ARTIFACT;
                    }
                    return ICON_ARTIFACT;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(Utilities.mergeImages((Image)ICON_JAR.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    File file = item.getFile();
                    return file.isDirectory() ? ClassPathCellRenderer.getFolderIcon() : ICON_JAR;
                }
                case 3: {
                    return ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ClassPathSupport.Item item) {
            return this.getDisplayName(item);
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
                DataFolder dataFolder = DataFolder.findFolder((FileObject)root);
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(12, ID.indexOf(".", 12));
        }

        private String getLibraryName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(7, ID.indexOf(".classpath"));
        }

        private String getFileRefName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(17, ID.length() - 1);
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
            WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_JavacTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_RunTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_BuildClassesDir_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener,
    TableModelListener {
        private final Project project;
        private final JTable list;
        private final WarIncludesUiSupport.ClasspathTableModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addJar;
        private final ButtonModel addLibrary;
        private final ButtonModel addAntArtifact;
        private final ButtonModel remove;

        public EditMediator(Project project, JTable list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove) {
            this.list = list;
            if (!(list.getModel() instanceof WarIncludesUiSupport.ClasspathTableModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (WarIncludesUiSupport.ClasspathTableModel)list.getModel();
            this.selectionModel = list.getSelectionModel();
            this.addJar = addJar;
            this.addLibrary = addLibrary;
            this.addAntArtifact = addAntArtifact;
            this.remove = remove;
            this.project = project;
        }

        public static void register(Project project, JTable list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove) {
            EditMediator em = new EditMediator(project, list, addJar, addLibrary, addAntArtifact, remove);
            addJar.addActionListener(em);
            addLibrary.addActionListener(em);
            addAntArtifact.addActionListener(em);
            remove.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.listModel.addTableModelListener(em);
            em.valueChanged(null);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addJar) {
                JFileChooser chooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                chooser.setFileSelectionMode(2);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_AddFile_DialogTitle"));
                chooser.setAcceptAllFileFilterUsed(true);
                File curDir = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
                chooser.setCurrentDirectory(curDir);
                int option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.list));
                if (option == 0) {
                    File[] files = chooser.getSelectedFiles();
                    WarIncludesUiSupport.addJarFiles(files, this.listModel);
                    curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                    FoldersListSettings.getDefault().setLastUsedClassPathFolder(curDir);
                }
            } else if (source == this.addLibrary) {
                HashSet<Library> includedLibraries = new HashSet<Library>();
                Iterator it = WarIncludesUiSupport.getIterator(this.listModel);
                while (it.hasNext()) {
                    ClassPathSupport.Item item = (ClassPathSupport.Item)it.next();
                    if (item.getType() != 1) continue;
                    includedLibraries.add(item.getLibrary());
                }
                Object[] options = new Object[]{new JButton(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_AddLibrary")), DialogDescriptor.CANCEL_OPTION};
                ((JButton)options[0]).setEnabled(false);
                ((JButton)options[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClassPathUi.class, (String)"AD_AddLibrary"));
                WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                String j2eeVersion = wm.getJ2eePlatformVersion();
                LibrariesChooser panel = new LibrariesChooser((JButton)options[0], j2eeVersion);
                DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    WarIncludesUiSupport.addLibraries(panel.getSelectedLibraries(), includedLibraries, this.list);
                }
                dlg.dispose();
            } else if (source == this.addAntArtifact) {
                AntArtifactChooser.ArtifactItem[] artifactItems = AntArtifactChooser.showDialog("jar", this.project, this.list.getParent());
                if (artifactItems != null) {
                    WarIncludesUiSupport.addArtifacts(artifactItems, this.listModel);
                }
            } else if (source == this.remove) {
                WarIncludesUiSupport.remove(this.list);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            ClassPathSupport.Item vcpi;
            boolean canRemove;
            DefaultListSelectionModel sm = (DefaultListSelectionModel)this.list.getSelectionModel();
            int index = sm.getMinSelectionIndex();
            boolean bl = canRemove = index != -1;
            if (canRemove && !(vcpi = (ClassPathSupport.Item)this.listModel.getValueAt(index, 0)).canDelete()) {
                canRemove = false;
            }
            this.remove.setEnabled(canRemove);
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 1) {
                ClassPathSupport.Item cpItem = (ClassPathSupport.Item)this.listModel.getValueAt(e.getFirstRow(), 0);
                String newPathInWar = (String)this.listModel.getValueAt(e.getFirstRow(), 1);
                String message = null;
                if (cpItem.getType() == 0 && newPathInWar.startsWith("WEB-INF")) {
                    if (newPathInWar.equals("WEB-INF\\lib") || newPathInWar.equals("WEB-INF/lib")) {
                        message = ((File)cpItem.getObject()).isDirectory() ? NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FOLDER_IN_WEBINF_LIB", (Object)newPathInWar) : NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FILE_IN_WEBINF_LIB", (Object)newPathInWar);
                    } else if (newPathInWar.equals("WEB-INF\\classes") || newPathInWar.equals("WEB-INF/classes")) {
                        message = NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FOLDER_IN_WEBINF_CLASSES", (Object)newPathInWar);
                    }
                }
                if (message != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(message, 2));
                }
                cpItem.setPathInWAR((String)this.listModel.getValueAt(e.getFirstRow(), 1));
            }
        }
    }
}

