/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterRepositoryConvertor
extends DOMConvertor
implements PropertyChangeListener {
    private static final String ATTR_ACTIVE = "active";
    private static final String ELEM_FILTER = "Filter";
    private static final String ELEM_FILTERS = "Filters";
    private Saver saver;

    private static Object create(FileObject fo) {
        return new FilterRepositoryConvertor();
    }

    public FilterRepositoryConvertor() {
        super("-//NetBeans org.netbeans.modules.tasklist//DTD Filters 1.0//EN", "http://tasklist.netbeans.org/dtd/filters-1_0.dtd", ELEM_FILTERS);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        FilterRepository rep = new FilterRepository();
        int activeIndex = Integer.parseInt(element.getAttribute(ATTR_ACTIVE));
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Filter f = (Filter)FilterRepositoryConvertor.delegateRead((Element)((Element)child));
            rep.add(f);
        }
        if (activeIndex != -1) {
            rep.setActive((Filter)rep.get(activeIndex));
        }
        return rep;
    }

    protected void writeElement(Document document, Element element, Object obj) throws IOException, DOMException {
        FilterRepository fr = (FilterRepository)obj;
        element.setAttribute(ATTR_ACTIVE, Integer.toString(fr.indexOf(fr.getActive())));
        Iterator fit = fr.iterator();
        while (fit.hasNext()) {
            Element childNode = FilterRepositoryConvertor.delegateWrite((Document)document, fit.next());
            element.appendChild(childNode);
        }
    }

    public void registerSaver(Object obj, Saver saver) {
        this.saver = saver;
        ((FilterRepository)obj).addPropertyChangeListener(this);
    }

    public void unregisterSaver(Object obj, Saver saver) {
        if (saver == null || saver != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + obj + ", Saver=" + saver + ")"));
        }
        ((FilterRepository)obj).removePropertyChangeListener(this);
        this.saver = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.saver.requestSave();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

