/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaTokenContext;

final class JCTokenProcessor
implements TokenProcessor {
    private static final int CONSTANT = 0;
    private static final int VARIABLE = 1;
    private static final int OPERATOR = 2;
    private static final int UNARY_OPERATOR = 3;
    private static final int DOT = 4;
    private static final int DOT_OPEN = 5;
    private static final int ARRAY_OPEN = 6;
    private static final int ARRAY = 7;
    private static final int PARENTHESIS_OPEN = 8;
    private static final int PARENTHESIS = 9;
    private static final int METHOD_OPEN = 10;
    private static final int METHOD = 11;
    private static final int CONSTRUCTOR = 12;
    private static final int CONVERSION = 13;
    private static final int TYPE = 14;
    private static final int NEW = 15;
    private static final int INSTANCEOF = 16;
    private static final int GENERIC_TYPE = 17;
    private static final int GENERIC_TYPE_OPEN = 18;
    private static final int GENERIC_WILD_CHAR = 19;
    private static final int ANNOTATION = 20;
    private static final int ANNOTATION_OPEN = 21;
    private static final int IMPORT = 22;
    private static final int CASE = 23;
    private static final int NO_EXP = -1;
    private char[] buffer;
    private int bufferStartPos;
    private int bufferOffsetDelta;
    private boolean stopped;
    private ArrayList expStack = new ArrayList();
    private TokenID lastValidTokenID;
    private String lastValidTokenText;
    private TokenID curTokenID;
    private int curTokenPosition;
    private String curTokenText;
    private int endScanOffset;
    private boolean java15;

    JCTokenProcessor(int endScanOffset) {
        this.endScanOffset = endScanOffset;
    }

    void setJava15(boolean java15) {
        this.java15 = java15;
    }

    final List getStack() {
        return this.expStack;
    }

    final TokenID getLastValidTokenID() {
        return this.lastValidTokenID;
    }

    final String getLastValidTokenText() {
        return this.lastValidTokenText;
    }

    final int getCurrentOffest() {
        return this.curTokenPosition;
    }

    final boolean isStopped() {
        return this.stopped;
    }

    final JCExpression getResultExp() {
        JCExpression result = this.peekExp();
        return result;
    }

    final JCExpression getResultEnclosingExp() {
        return this.peekExp2();
    }

    private void clearStack() {
        this.expStack.clear();
    }

    private void pushExp(JCExpression exp) {
        this.expStack.add(exp);
    }

    private JCExpression popExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? (JCExpression)this.expStack.remove(cnt - 1) : null;
    }

    private JCExpression peekExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? (JCExpression)this.expStack.get(cnt - 1) : null;
    }

    private JCExpression peekExp2() {
        int cnt = this.expStack.size();
        return cnt > 1 ? (JCExpression)this.expStack.get(cnt - 2) : null;
    }

    private JCExpression peekExp(int ind) {
        int cnt = this.expStack.size();
        return cnt >= ind ? (JCExpression)this.expStack.get(cnt - ind) : null;
    }

    private JCExpression createTokenExp(int id) {
        JCExpression exp = new JCExpression(id);
        this.addTokenTo(exp);
        return exp;
    }

    private void addTokenTo(JCExpression exp) {
        exp.addToken(this.curTokenID, this.curTokenPosition, this.curTokenText);
    }

    private int getValidExpID(JCExpression exp) {
        return exp != null ? exp.getExpID() : -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkJoin(TokenID tokenID) {
        boolean ret = true;
        boolean cont = true;
        block35: while (cont) {
            cont = false;
            JCExpression top = this.peekExp();
            JCExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            switch (this.getValidExpID(top)) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    block3 : switch (top2ID) {
                        case 3: {
                            switch (tokenID.getNumericID()) {
                                case 48: 
                                case 53: 
                                case 55: 
                                case 59: 
                                case 60: {
                                    break block3;
                                }
                            }
                            if (top2.getParameterCount() != 0) break;
                            this.popExp();
                            top2.addParameter(top);
                            break;
                        }
                        case 5: {
                            if (tokenID.getCategory() != JavaTokenContext.OPERATORS) break;
                            switch (tokenID.getNumericID()) {
                                case 53: {
                                    break block3;
                                }
                            }
                            this.popExp();
                            top2.addParameter(top);
                            top2.setExpID(4);
                            cont = true;
                            break;
                        }
                        case 13: {
                            if (tokenID.getCategory() != JavaTokenContext.OPERATORS) break;
                            switch (tokenID.getNumericID()) {
                                case 49: 
                                case 54: {
                                    JCExpression top3 = this.peekExp(3);
                                    if (top3 == null) break block3;
                                    switch (top3.getExpID()) {
                                        case 2: 
                                        case 8: 
                                        case 10: {
                                            this.popExp();
                                            top2.addParameter(top);
                                        }
                                    }
                                    break block3;
                                }
                            }
                        }
                    }
                    continue block35;
                }
            }
        }
        int leftOpID = JCExpression.getOperatorID(tokenID);
        if (leftOpID < 0) return ret;
        switch (JCExpression.getOperatorPrecedence(leftOpID)) {
            case 0: {
                JCExpression lastVar = null;
                JCExpression rightOp = this.peekExp();
                int rightOpID = -1;
                rightOpID = JCExpression.getOperatorID(rightOp);
                block23 : switch (JCExpression.getOperatorPrecedence(rightOpID)) {
                    case 0: {
                        rightOp = null;
                        break;
                    }
                    case 1: {
                        lastVar = rightOp;
                        rightOp = this.peekExp2();
                        rightOpID = JCExpression.getOperatorID(rightOp);
                        switch (JCExpression.getOperatorPrecedence(rightOpID)) {
                            case 0: {
                                rightOp = null;
                                break block23;
                            }
                            case 1: {
                                return false;
                            }
                        }
                        this.popExp();
                        rightOp.addParameter(lastVar);
                        lastVar = null;
                        break;
                    }
                }
                if (rightOp == null) return ret;
                this.popExp();
                cont = true;
                ArrayList<JCExpression> opStack = new ArrayList<JCExpression>();
                JCExpression leftOp = null;
                do {
                    if (leftOp == null) {
                        leftOp = this.popExp();
                        if (leftOp == null) break;
                        leftOpID = JCExpression.getOperatorID(leftOp);
                    }
                    switch (JCExpression.getOperatorPrecedence(leftOpID)) {
                        case 0: {
                            this.pushExp(leftOp);
                            cont = false;
                            break;
                        }
                        case 1: {
                            lastVar = leftOp;
                            leftOp = null;
                            break;
                        }
                        default: {
                            int leftOpPrec = JCExpression.getOperatorPrecedence(leftOpID);
                            int rightOpPrec = JCExpression.getOperatorPrecedence(rightOpID);
                            boolean rightPrec = leftOpPrec > rightOpPrec ? false : (leftOpPrec < rightOpPrec ? true : JCExpression.isOperatorRightAssociative(rightOpID));
                            if (rightPrec) {
                                if (lastVar != null) {
                                    rightOp.addParameter(lastVar);
                                }
                                if (opStack.size() > 0) {
                                    lastVar = rightOp;
                                    rightOp = (JCExpression)opStack.remove(opStack.size() - 1);
                                    rightOpID = JCExpression.getOperatorID(rightOp);
                                    break;
                                }
                                leftOp.addParameter(rightOp);
                                lastVar = null;
                                rightOp = leftOp;
                                rightOpID = leftOpID;
                                leftOp = null;
                                break;
                            }
                            if (lastVar != null) {
                                leftOp.addParameter(lastVar);
                                lastVar = null;
                            }
                            opStack.add(rightOp);
                            rightOp = leftOp;
                            rightOpID = leftOpID;
                            leftOp = null;
                        }
                    }
                } while (cont);
                if (lastVar != null) {
                    rightOp.addParameter(lastVar);
                }
                for (int i = opStack.size() - 1; i >= 0; --i) {
                    JCExpression op = (JCExpression)opStack.get(i);
                    op.addParameter(rightOp);
                    rightOp = op;
                }
                rightOp.swapOperatorParms();
                this.pushExp(rightOp);
                return ret;
            }
        }
        return ret;
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenOffset, int tokenLen) {
        TokenCategory category;
        if (tokenID != null && JavaTokenContext.KEYWORDS.equals(category = tokenID.getCategory()) && (tokenOffset += this.bufferOffsetDelta) + tokenLen + this.bufferStartPos == this.endScanOffset) {
            tokenID = JavaTokenContext.IDENTIFIER;
        }
        if (tokenID != null) {
            this.lastValidTokenID = tokenID;
        }
        this.curTokenID = tokenID;
        this.curTokenPosition = this.bufferStartPos + tokenOffset;
        this.lastValidTokenText = this.curTokenText = new String(this.buffer, tokenOffset, tokenLen);
        boolean err = false;
        this.stopped = false;
        this.checkJoin(tokenID);
        JCExpression top = this.peekExp();
        int topID = this.getValidExpID(top);
        JCExpression constExp = null;
        JavaCompletion.BaseType kwdType = null;
        if (tokenID == null) {
            err = true;
        } else if (tokenContextPath.contains(JavaTokenContext.contextPath)) {
            block0 : switch (tokenID.getNumericID()) {
                case 63: {
                    kwdType = JavaCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 64: {
                    kwdType = JavaCompletion.BYTE_TYPE;
                    break;
                }
                case 65: {
                    kwdType = JavaCompletion.CHAR_TYPE;
                    break;
                }
                case 66: {
                    kwdType = JavaCompletion.DOUBLE_TYPE;
                    break;
                }
                case 67: {
                    kwdType = JavaCompletion.FLOAT_TYPE;
                    break;
                }
                case 68: {
                    kwdType = JavaCompletion.INT_TYPE;
                    break;
                }
                case 69: {
                    kwdType = JavaCompletion.LONG_TYPE;
                    break;
                }
                case 70: {
                    kwdType = JavaCompletion.SHORT_TYPE;
                    break;
                }
                case 85: 
                case 112: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("boolean");
                    break;
                }
                case 97: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("null");
                    break;
                }
                case 77: {
                    if (topID == 5) {
                        this.pushExp(this.createTokenExp(1));
                        break;
                    }
                    err = true;
                    break;
                }
                case 96: {
                    switch (topID) {
                        case 1: 
                        case 15: {
                            err = true;
                            break block0;
                        }
                    }
                    this.pushExp(this.createTokenExp(15));
                    break;
                }
                case 92: {
                    this.pushExp(this.createTokenExp(22));
                    break;
                }
                case 103: {
                    switch (topID) {
                        case 22: {
                            top.addParameter(this.createTokenExp(22));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 105: {
                    if (topID == 19) break;
                }
                case 108: {
                    this.pushExp(this.createTokenExp(1));
                    break;
                }
                case 123: {
                    this.pushExp(this.createTokenExp(20));
                    break;
                }
                case 93: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(16));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 75: {
                    this.pushExp(this.createTokenExp(23));
                    break;
                }
                case 84: {
                    if (topID == 19) break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 94: 
                case 95: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 113: 
                case 114: 
                case 115: {
                    err = true;
                    break;
                }
                case 6: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        case 19: {
                            top.setExpID(1);
                            this.addTokenTo(top);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 52: {
                    if (topID == 18) {
                        this.pushExp(new JCExpression(19));
                        break;
                    }
                }
                case 17: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 61: 
                case 62: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 18: {
                    boolean genericType = false;
                    if (this.java15) {
                        switch (topID) {
                            case 1: 
                            case 4: {
                                this.popExp();
                                JCExpression genExp = this.createTokenExp(18);
                                genExp.addParameter(top);
                                this.pushExp(genExp);
                                genericType = true;
                                break;
                            }
                        }
                    }
                    if (err || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 19: {
                    boolean genericType = false;
                    if (this.java15) {
                        block73 : switch (topID) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top2.setExpID(17);
                                        this.addTokenTo(top2);
                                        genericType = true;
                                        top = top2;
                                        break block73;
                                    }
                                }
                                err = topID == 17;
                                break;
                            }
                        }
                    }
                    if (err || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 21: {
                    boolean genericType = false;
                    if (this.java15) {
                        block82 : switch (topID) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        JCExpression top3 = this.peekExp(3);
                                        if (this.getValidExpID(top3) == 18) {
                                            genericType = true;
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(17);
                                            this.addTokenTo(top2);
                                            this.popExp();
                                            top3.addParameter(top2);
                                            top3.setExpID(17);
                                            this.addTokenTo(top3);
                                            top = top3;
                                            break block82;
                                        }
                                        err = true;
                                        break block82;
                                    }
                                }
                                err = true;
                                break;
                            }
                        }
                    }
                    if (err || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 22: {
                    boolean genericType = false;
                    if (this.java15) {
                        block91 : switch (topID) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 18: {
                                        JCExpression top3 = this.peekExp(3);
                                        JCExpression top4 = this.peekExp(4);
                                        if (this.getValidExpID(top3) == 18 && this.getValidExpID(top4) == 18) {
                                            genericType = true;
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(17);
                                            this.addTokenTo(top2);
                                            this.popExp();
                                            top3.addParameter(top2);
                                            top3.setExpID(17);
                                            this.addTokenTo(top3);
                                            this.popExp();
                                            top4.addParameter(top3);
                                            top4.setExpID(17);
                                            this.addTokenTo(top4);
                                            top = top4;
                                            break block91;
                                        }
                                        err = true;
                                        break block91;
                                    }
                                }
                                err = true;
                                break;
                            }
                        }
                    }
                    if (err || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 59: 
                case 60: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case 1: {
                            JCExpression opExp = this.createTokenExp(3);
                            this.popExp();
                            opExp.addParameter(top);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 23: 
                case 24: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            JCExpression opExp = this.createTokenExp(2);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 31: 
                case 32: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 48: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression opExp = this.createTokenExp(5);
                            opExp.addParameter(top);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case 4: {
                            this.addTokenTo(top);
                            top.setExpID(5);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 49: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 19: {
                            JCExpression top2 = this.peekExp2();
                            switch (this.getValidExpID(top2)) {
                                case 10: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    break block0;
                                }
                                case 21: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    this.addTokenTo(top2);
                                    top = top2;
                                    break block0;
                                }
                                case 18: {
                                    switch (topID) {
                                        case 1: 
                                        case 4: 
                                        case 17: 
                                        case 19: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            this.addTokenTo(top2);
                                            top = top2;
                                            break block0;
                                        }
                                    }
                                    err = true;
                                    break block0;
                                }
                            }
                            err = true;
                            break block0;
                        }
                        case 10: {
                            this.addTokenTo(top);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 51: {
                    err = true;
                    break;
                }
                case 53: {
                    switch (topID) {
                        case 1: 
                        case 17: {
                            this.popExp();
                            JCExpression top2 = this.peekExp();
                            switch (this.getValidExpID(top2)) {
                                case 20: {
                                    top2.setExpID(21);
                                    top2.addParameter(top);
                                    break block0;
                                }
                                case 5: {
                                    JCExpression top3 = this.peekExp2();
                                    if (this.getValidExpID(top3) != 20) break;
                                    top2.setExpID(4);
                                    top2.addParameter(top);
                                    top3.setExpID(21);
                                    top3.addParameter(top2);
                                    this.popExp();
                                    break block0;
                                }
                            }
                            JCExpression mtdOpExp = this.createTokenExp(10);
                            mtdOpExp.addParameter(top);
                            this.pushExp(mtdOpExp);
                            break block0;
                        }
                        case 7: {
                            this.popExp();
                            JCExpression mtdExp = this.createTokenExp(11);
                            mtdExp.addParameter(top);
                            this.pushExp(mtdExp);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 18: {
                            this.pushExp(this.createTokenExp(8));
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 54: {
                    JCExpression top2;
                    boolean mtd = false;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: {
                            top2 = this.peekExp2();
                            block140 : switch (this.getValidExpID(top2)) {
                                case 8: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top2.setExpID(JCExpression.isValidType(top) ? 13 : 9);
                                    this.addTokenTo(top2);
                                    break;
                                }
                                case 18: {
                                    this.popExp();
                                    top2.setExpID(2);
                                    top2.addParameter(top);
                                    top = top2;
                                    top2 = this.peekExp2();
                                    if (this.getValidExpID(top2) != 10) break;
                                }
                                case 10: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    mtd = true;
                                    break;
                                }
                                case 13: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    top2 = this.peekExp2();
                                    switch (this.getValidExpID(top2)) {
                                        case 8: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(9);
                                            top = top2;
                                            break block140;
                                        }
                                        case 10: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top = top2;
                                            mtd = true;
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    err = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 10: {
                            mtd = true;
                            break;
                        }
                        default: {
                            err = true;
                        }
                    }
                    if (!mtd) break;
                    this.addTokenTo(top);
                    top.setExpID(11);
                    top2 = this.peekExp2();
                    switch (this.getValidExpID(top2)) {
                        case 5: {
                            JCExpression top3 = this.peekExp(3);
                            if (this.getValidExpID(top3) != 15) break;
                            this.popExp();
                            top2.addParameter(top);
                            top2.setExpID(4);
                            this.popExp();
                            top3.setExpID(12);
                            top3.addParameter(top2);
                            break;
                        }
                        case 15: {
                            top2.setExpID(12);
                            top2.addParameter(top);
                            this.popExp();
                        }
                    }
                    break;
                }
                case 55: {
                    switch (topID) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression arrExp = this.createTokenExp(6);
                            arrExp.addParameter(top);
                            this.pushExp(arrExp);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 124: {
                    switch (topID) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression arrExp = this.createTokenExp(7);
                            this.addTokenTo(arrExp);
                            arrExp.addParameter(top);
                            this.pushExp(arrExp);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 56: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 16: {
                            JCExpression top2 = this.peekExp2();
                            switch (this.getValidExpID(top2)) {
                                case 6: {
                                    JCExpression top3 = this.peekExp(3);
                                    this.popExp();
                                    if (this.getValidExpID(top3) == 15) {
                                        this.popExp();
                                        top3.setExpID(7);
                                        top3.addParameter(top2.getParameter(0));
                                        top3.addToken(top2.getTokenID(0), top2.getTokenOffset(0), top2.getTokenText(0));
                                        this.addTokenTo(top2);
                                        break block0;
                                    }
                                    top2.setExpID(7);
                                    top2.addParameter(top);
                                    this.addTokenTo(top2);
                                    break block0;
                                }
                            }
                            err = true;
                            break block0;
                        }
                        case 6: {
                            top.setExpID(7);
                            this.addTokenTo(top);
                            break block0;
                        }
                    }
                    err = true;
                    break;
                }
                case 57: {
                    JCExpression top2;
                    if (topID == 7 && this.getValidExpID(top2 = this.peekExp2()) == 15) {
                        this.popExp();
                        top2.setExpID(7);
                        top2.addParameter(top.getParameter(0));
                        top2.addToken(top.getTokenID(0), top.getTokenOffset(0), top.getTokenText(0));
                        top2.addToken(top.getTokenID(1), top.getTokenOffset(1), top.getTokenText(1));
                        this.stopped = true;
                        break;
                    }
                    err = true;
                    break;
                }
                case 58: {
                    err = true;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("char");
                    break;
                }
                case 10: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("java.lang.String");
                    break;
                }
                case 11: 
                case 13: 
                case 14: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("int");
                    break;
                }
                case 12: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("long");
                    break;
                }
                case 15: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("float");
                    break;
                }
                case 16: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("double");
                }
            }
        }
        if (constExp != null) {
            switch (topID) {
                case 5: {
                    err = true;
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 21: {
                    this.pushExp(constExp);
                    break;
                }
                case 18: {
                    top.setExpID(2);
                    top.addParameter(constExp);
                    break;
                }
                default: {
                    err = true;
                }
            }
        }
        if (kwdType != null) {
            switch (topID) {
                case -1: 
                case 2: 
                case 8: 
                case 15: {
                    JCExpression kwdExp = this.createTokenExp(14);
                    this.addTokenTo(kwdExp);
                    kwdExp.setType(kwdType.getClazz().getFullName());
                    this.pushExp(kwdExp);
                    break;
                }
                default: {
                    err = true;
                }
            }
        }
        if (err) {
            this.clearStack();
            if (tokenID == JavaTokenContext.IDENTIFIER) {
                this.pushExp(this.createTokenExp(1));
            }
        }
        return !this.stopped;
    }

    public int eot(int offset) {
        boolean reScan = true;
        while (reScan) {
            reScan = false;
            JCExpression top = this.peekExp();
            JCExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            if (top != null) {
                block0 : switch (this.getValidExpID(top)) {
                    case 1: {
                        JCExpression top3;
                        switch (top2ID) {
                            case 5: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(4);
                                reScan = true;
                                break block0;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break block0;
                            }
                            case 22: {
                                this.popExp();
                                top2.addParameter(top);
                                break block0;
                            }
                            case 18: 
                            case 20: 
                            case 21: 
                            case 23: {
                                this.popExp();
                                top2.addParameter(top);
                                reScan = false;
                                break block0;
                            }
                            case 2: {
                                JCExpression top4;
                                top3 = this.peekExp(3);
                                if (this.getValidExpID(top3) != 1 || this.getValidExpID(top4 = this.peekExp(4)) != 21) break;
                                top2.addParameter(top3);
                                top2.addParameter(top);
                                top4.addParameter(top2);
                                this.popExp();
                                this.popExp();
                                this.popExp();
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (top2ID) {
                            case 5: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(4);
                                reScan = true;
                                top = top2;
                                top2 = this.peekExp2();
                                top2ID = this.getValidExpID(top2);
                                if (top2ID != 15) break;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                            }
                        }
                        this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 11: {
                        switch (top2ID) {
                            case 5: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(4);
                                reScan = true;
                                break block0;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (top2ID) {
                            case 5: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(4);
                                reScan = true;
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        switch (top2ID) {
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break block0;
                            }
                            case 22: {
                                this.popExp();
                                top2.addParameter(top);
                                break block0;
                            }
                            case 18: 
                            case 20: 
                            case 21: {
                                this.popExp();
                                top2.addParameter(top);
                                reScan = false;
                                break block0;
                            }
                            case 2: {
                                JCExpression top4 = this.peekExp(4);
                                if (this.getValidExpID(top4) != 21) break;
                                top2.addParameter(this.peekExp(3));
                                top2.addParameter(top);
                                top4.addParameter(top2);
                                this.popExp();
                                this.popExp();
                                this.popExp();
                                reScan = false;
                            }
                        }
                        break;
                    }
                    case 8: {
                        this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 17: {
                        if (top2ID != 15) break;
                        this.popExp();
                        top2.addParameter(top);
                        top2.setExpID(12);
                        reScan = true;
                        break;
                    }
                    case 18: {
                        if (top.getParameterCount() > 1) break;
                    }
                    case 22: 
                    case 23: {
                        top.addParameter(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 2: {
                        JCExpression top3;
                        if (top2ID != 1 || this.getValidExpID(top3 = this.peekExp(3)) != 21) break;
                        top.addParameter(top2);
                        top.addParameter(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        top3.addParameter(top);
                        this.popExp();
                        this.popExp();
                    }
                }
                continue;
            }
            this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
        }
        return 0;
    }

    public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
        this.buffer = new char[len + preScan];
        System.arraycopy(buffer, offset - preScan, this.buffer, 0, len + preScan);
        this.bufferOffsetDelta = preScan - offset;
        this.bufferStartPos = startPos - preScan;
    }

    public String toString() {
        int cnt = this.expStack.size();
        StringBuffer sb = new StringBuffer();
        if (this.stopped) {
            sb.append("Parsing STOPPED by request.\n");
        }
        sb.append("Stack size is " + cnt + "\n");
        if (cnt > 0) {
            sb.append("Stack expressions:\n");
            for (int i = 0; i < cnt; ++i) {
                JCExpression e = (JCExpression)this.expStack.get(i);
                sb.append("Stack[");
                sb.append(i);
                sb.append("]: ");
                sb.append(e.toString(0));
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

