/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbfreeform;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EjbFreeFormActionProvider
implements ActionProvider {
    static final String NS_GENERAL = "http://www.netbeans.org/ns/freeform-project/1";
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private static final String LOAD_PROPS_TARGET = "-load-props";
    private static final String CHECK_PROPS_TARGET = "-check-props";
    private static final String INIT_TARGET = "-init";
    private static final String DEBUG_TARGET = "debug-nb";
    private static final String DISPLAY_BROWSER = "debug-display-browser";
    private static final String[] DEBUG_PROPERTIES;
    private static final String DEBUG_PROPERTIES_TEMPLATE = "/org/netbeans/modules/j2ee/ejbfreeform/resources/debug-properties.template";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration aux;
    private static final String[] SUPPORTED_ACTIONS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EjbFreeFormActionProvider(Project aProject, AntProjectHelper aHelper, AuxiliaryConfiguration aAux) {
        this.project = aProject;
        this.helper = aHelper;
        this.aux = aAux;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        boolean enabled = false;
        if (command.equals("debug")) {
            enabled = true;
        }
        return enabled;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        try {
            try {
                if (command.equals("debug")) {
                    this.handleDebug();
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    private void handleDebug() throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"ACTION_debug"), GENERAL_SCRIPT_PATH)) {
            return;
        }
        String propertiesFile = this.writeDebugProperties();
        Document script = this.readCustomScript(GENERAL_SCRIPT_PATH);
        if (script == null) {
            script = this.createCustomScript();
        }
        this.writeComments(script);
        this.writeTargets(script, propertiesFile);
        this.writeCustomScript(script, GENERAL_SCRIPT_PATH);
        this.addBinding("debug", GENERAL_SCRIPT_PATH, DEBUG_TARGET, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript(GENERAL_SCRIPT_PATH, DEBUG_TARGET);
        this.openFile(propertiesFile);
    }

    private boolean alert(String commandDisplayName, String scriptPath) {
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"TITLE_generate_target_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"TEXT_generate_target_dialog", (Object)commandDisplayName, (Object)scriptPath);
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        JButton generate = new JButton(NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"LBL_generate"));
        generate.setDefaultCapable(true);
        d.setOptions(new Object[]{generate, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == generate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String scriptPath) throws IOException, SAXException {
        Document script = null;
        FileObject scriptFile = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (scriptFile != null) {
            InputStream is = scriptFile.getInputStream();
            try {
                script = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
            }
            finally {
                is.close();
            }
        }
        return script;
    }

    Document createCustomScript() {
        Document script = XMLUtil.createDocument((String)"project", null, null, null);
        Element scriptRoot = script.getDocumentElement();
        scriptRoot.setAttribute("basedir", "..");
        String projname = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        scriptRoot.setAttribute("name", NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"LBL_generated_script_name", (Object)projname));
        this.copyProperties(this.helper.getPrimaryConfigurationData(true), scriptRoot);
        return script;
    }

    private void copyProperties(Element config, Element script) {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element properties = Util.findElement((Element)data, (String)"properties", (String)NS_GENERAL);
        if (properties != null) {
            Iterator propertiesIt = Util.findSubElements((Element)properties).iterator();
            while (propertiesIt.hasNext()) {
                Element el = (Element)propertiesIt.next();
                Element nue = script.getOwnerDocument().createElement("property");
                if (el.getLocalName().equals("property")) {
                    String name = el.getAttribute("name");
                    if (!$assertionsDisabled && name == null) {
                        throw new AssertionError();
                    }
                    String text = Util.findText((Element)el);
                    if (!$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    nue.setAttribute("name", name);
                    nue.setAttribute("value", text);
                } else if (el.getLocalName().equals("property-file")) {
                    String text = Util.findText((Element)el);
                    if (!$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    nue.setAttribute("file", text);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError(el);
                }
                script.appendChild(nue);
            }
        }
    }

    private void writeComments(Document script) {
        Comment comm4Edit = script.createComment(" " + NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"COMMENT_edit_target") + " ");
        Comment comm4Info = script.createComment(" " + NbBundle.getMessage((Class)EjbFreeFormActionProvider.class, (String)"COMMENT_more_info_debug") + " ");
        Element scriptRoot = script.getDocumentElement();
        scriptRoot.appendChild(comm4Edit);
        scriptRoot.appendChild(comm4Info);
    }

    private void writeTargets(Document script, String propertiesFile) {
        this.createLoadPropertiesTarget(script, propertiesFile);
        this.createCheckPropertiesTarget(script);
        this.createInitTarget(script);
        this.createDebugTarget(script);
    }

    private void createLoadPropertiesTarget(Document script, String propertiesFile) {
        Element target = script.createElement("target");
        target.setAttribute("name", LOAD_PROPS_TARGET);
        Element property = script.createElement("property");
        property.setAttribute("file", propertiesFile);
        target.appendChild(property);
        script.getDocumentElement().appendChild(target);
    }

    private void createCheckPropertiesTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", CHECK_PROPS_TARGET);
        for (int i = 0; i < DEBUG_PROPERTIES.length; ++i) {
            Element fail = script.createElement("fail");
            fail.setAttribute("unless", DEBUG_PROPERTIES[i]);
            target.appendChild(fail);
        }
        script.getDocumentElement().appendChild(target);
    }

    private void createInitTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", INIT_TARGET);
        target.setAttribute("depends", "-load-props, -check-props");
        script.getDocumentElement().appendChild(target);
    }

    private void createDebugTarget(Document script) {
        Element target = script.createElement("target");
        target.setAttribute("name", DEBUG_TARGET);
        target.setAttribute("depends", INIT_TARGET);
        target.setAttribute("if", "netbeans.home");
        Element nbjpdaconnect = script.createElement("nbjpdaconnect");
        nbjpdaconnect.setAttribute("name", "${jpda.session.name}");
        nbjpdaconnect.setAttribute("host", "${jpda.host}");
        nbjpdaconnect.setAttribute("address", "${jpda.address}");
        nbjpdaconnect.setAttribute("transport", "${jpda.transport}");
        Element sourcepath = script.createElement("sourcepath");
        Element path = script.createElement("path");
        path.setAttribute("path", "${debug.sourcepath}");
        sourcepath.appendChild(path);
        nbjpdaconnect.appendChild(sourcepath);
        target.appendChild(nbjpdaconnect);
        script.getDocumentElement().appendChild(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document script, String scriptPath) throws IOException {
        FileObject scriptFile = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (scriptFile == null) {
            scriptFile = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)scriptPath);
        }
        FileLock lock = scriptFile.lock();
        try {
            OutputStream os = scriptFile.getOutputStream(lock);
            try {
                XMLUtil.write((Document)script, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    void addBinding(String command, String scriptPath, String target, String propertyName, String dir, String pattern, String format, String separator) throws IOException {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element ideActions = Util.findElement((Element)data, (String)"ide-actions", (String)NS_GENERAL);
        if (ideActions == null) {
            return;
        }
        Document doc = data.getOwnerDocument();
        Element action = doc.createElementNS(NS_GENERAL, "action");
        action.setAttribute("name", command);
        Element script = doc.createElementNS(NS_GENERAL, "script");
        script.appendChild(doc.createTextNode(scriptPath));
        action.appendChild(script);
        Element targetEl = doc.createElementNS(NS_GENERAL, "target");
        targetEl.appendChild(doc.createTextNode(target));
        action.appendChild(targetEl);
        ideActions.appendChild(action);
        if (propertyName != null) {
            Element context = doc.createElementNS(NS_GENERAL, "context");
            Element property = doc.createElementNS(NS_GENERAL, "property");
            property.appendChild(doc.createTextNode(propertyName));
            context.appendChild(property);
            Element folder = doc.createElementNS(NS_GENERAL, "folder");
            folder.appendChild(doc.createTextNode(dir));
            context.appendChild(folder);
            if (pattern != null) {
                Element patternEl = doc.createElementNS(NS_GENERAL, "pattern");
                patternEl.appendChild(doc.createTextNode(pattern));
                context.appendChild(patternEl);
            }
            Element formatEl = doc.createElementNS(NS_GENERAL, "format");
            formatEl.appendChild(doc.createTextNode(format));
            context.appendChild(formatEl);
            Element arity = doc.createElementNS(NS_GENERAL, "arity");
            if (separator != null) {
                Element separatorEl = doc.createElementNS(NS_GENERAL, "separated-files");
                separatorEl.appendChild(doc.createTextNode(separator));
                arity.appendChild(separatorEl);
            } else {
                arity.appendChild(doc.createElementNS(NS_GENERAL, "one-file-only"));
            }
            context.appendChild(arity);
            action.appendChild(context);
        } else {
            Element contextMenu;
            Element view = Util.findElement((Element)data, (String)"view", (String)NS_GENERAL);
            if (view != null && (contextMenu = Util.findElement((Element)view, (String)"context-menu", (String)NS_GENERAL)) != null) {
                Element ideAction = doc.createElementNS(NS_GENERAL, "ide-action");
                ideAction.setAttribute("name", command);
                contextMenu.appendChild(ideAction);
            }
        }
        this.helper.putPrimaryConfigurationData(data, true);
        ProjectManager.getDefault().saveProject(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeDebugProperties() throws IOException {
        String file;
        String fileName = "debug";
        int i = 0;
        do {
            file = "nbproject/" + fileName + (i != 0 ? String.valueOf(i) : "") + ".properties";
            ++i;
        } while (this.helper.resolveFileObject(file) != null);
        FileObject fo = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)file);
        FileLock lock = fo.lock();
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            int read;
            out = new BufferedOutputStream(fo.getOutputStream(lock));
            in = EjbFreeFormActionProvider.class.getResourceAsStream(DEBUG_PROPERTIES_TEMPLATE);
            byte[] buffer = new byte[4096];
            do {
                read = in.read(buffer);
                ((OutputStream)out).write(buffer, 0, read);
            } while (read == buffer.length);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            lock.releaseLock();
        }
        EditableProperties ep = this.helper.getProperties(file);
        ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
        ep.setProperty("jpda.session.name", pi.getName());
        ep.setProperty("debug.sourcepath", this.findSourceFolders("java"));
        this.helper.putProperties(file, ep);
        return file;
    }

    private void jumpToBinding(String command) {
        this.jumpToFile("nbproject/project.xml", command, "action", "name");
    }

    private void jumpToBuildScript(String scriptPath, String target) {
        this.jumpToFile(scriptPath, target, "target", "name");
    }

    private void jumpToFile(String path, String match, String elementLocalName, String elementAttributeName) {
        DataObject fileDO;
        int line;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            line = EjbFreeFormActionProvider.findLine(file, match, elementLocalName, elementAttributeName);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        if (line == -1) {
            line = 0;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        LineCookie lines = (LineCookie)fileDO.getCookie(LineCookie.class);
        if (lines != null) {
            try {
                lines.getLineSet().getCurrent(line).show(2);
            }
            catch (IndexOutOfBoundsException e) {
                ErrorManager.getDefault().getInstance(EjbFreeFormActionProvider.class.getName()).log(16, e + " [file=" + file + " match=" + match + " line=" + line + "]");
                lines.getLineSet().getCurrent(0).show(2);
            }
        }
    }

    private void openFile(String path) {
        DataObject fileDO;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        EditCookie edit = (EditCookie)fileDO.getCookie(EditCookie.class);
        if (edit != null) {
            edit.edit();
        }
    }

    static final int findLine(FileObject file, String match, String elementLocalName, String elementAttributeName) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(file.getURL().toString());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        int[] line = new int[]{-1};
        class Handler
        extends DefaultHandler {
            private Locator locator;
            private final /* synthetic */ int[] val$line;
            private final /* synthetic */ String val$elementLocalName;
            private final /* synthetic */ String val$match;
            private final /* synthetic */ String val$elementAttributeName;

            Handler(int[] nArray, String string, String string2, String string3) {
                this.val$line = nArray;
                this.val$elementLocalName = string;
                this.val$match = string2;
                this.val$elementAttributeName = string3;
            }

            public void setDocumentLocator(Locator l) {
                this.locator = l;
            }

            public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                if (this.val$line[0] == -1 && localname.equals(this.val$elementLocalName) && this.val$match.equals(attr.getValue(this.val$elementAttributeName))) {
                    this.val$line[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        parser.parse(in, (DefaultHandler)new Handler(line, elementLocalName, match, elementAttributeName));
        return line[0];
    }

    private String findSourceFolders(String type) {
        StringBuffer result = new StringBuffer();
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element foldersEl = Util.findElement((Element)data, (String)"folders", (String)NS_GENERAL);
        if (foldersEl != null) {
            Iterator i = Util.findSubElements((Element)foldersEl).iterator();
            while (i.hasNext()) {
                Element locationEl;
                Element sourceFolderEl = (Element)i.next();
                Element typeEl = Util.findElement((Element)sourceFolderEl, (String)"type", (String)NS_GENERAL);
                if (typeEl == null || !Util.findText((Element)typeEl).equals(type) || (locationEl = Util.findElement((Element)sourceFolderEl, (String)"location", (String)NS_GENERAL)) == null) continue;
                String location = Util.findText((Element)locationEl);
                if (result.length() > 0) {
                    result.append(":");
                }
                result.append(location);
            }
        }
        return result.toString();
    }

    static {
        $assertionsDisabled = !EjbFreeFormActionProvider.class.desiredAssertionStatus();
        DEBUG_PROPERTIES = new String[]{"jpda.session.name", "jpda.host", "jpda.address", "jpda.transport", "debug.sourcepath"};
        SUPPORTED_ACTIONS = new String[]{"debug"};
    }
}

