/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.HashSet;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;

public class JavaVariablesFilter
extends VariablesFilterAdapter {
    private static HashSet getValueType;
    private static HashSet leafType;
    private static HashSet toStringValueType;
    private static HashSet mapEntryType;
    private static HashSet mapMapType;
    private static HashSet toArrayType;

    public String[] getSupportedTypes() {
        return new String[]{"java.lang.String", "java.lang.StringBuffer", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.ref.WeakReference", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", "java.beans.PropertyChangeSupport"};
    }

    public String[] getSupportedAncestors() {
        return new String[0];
    }

    public Object[] getChildren(TreeModel original, Variable variable, int from, int to) throws UnknownTypeException {
        ObjectVariable ov;
        String type = variable.getType();
        if (JavaVariablesFilter.isToArrayType(type)) {
            try {
                ObjectVariable ov2 = (ObjectVariable)variable;
                ov2 = (ObjectVariable)ov2.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return original.getChildren((Object)ov2, from, to);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (InvalidExpressionException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getChildren((Object)variable, from, to);
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (JavaVariablesFilter.isMapMapType(type)) {
            try {
                ov = (ObjectVariable)variable;
                ov = (ObjectVariable)ov.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                ov = (ObjectVariable)ov.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return original.getChildren((Object)ov, from, to);
            }
            catch (InvalidExpressionException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getChildren((Object)variable, from, to);
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (JavaVariablesFilter.isMapEntryType(type)) {
            ov = (ObjectVariable)variable;
            Object[] fs = new Field[]{ov.getField("key"), ov.getField("value")};
            return fs;
        }
        if (type.equals("java.beans.PropertyChangeSupport")) {
            try {
                ov = (ObjectVariable)variable;
                return ((ObjectVariable)ov.invokeMethod("getPropertyChangeListeners", "()[Ljava/beans/PropertyChangeListener;", new Variable[0])).getFields(from, to);
            }
            catch (InvalidExpressionException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getChildren((Object)variable, from, to);
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (type.equals("java.lang.ref.WeakReference")) {
            ov = (ObjectVariable)variable;
            return new Object[]{ov.getField("referent")};
        }
        return original.getChildren((Object)variable, from, to);
    }

    public int getChildrenCount(TreeModel original, Variable variable) throws UnknownTypeException {
        String type = variable.getType();
        if (JavaVariablesFilter.isToArrayType(type)) {
            try {
                ObjectVariable ov = (ObjectVariable)variable;
                ov = (ObjectVariable)ov.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return original.getChildrenCount((Object)ov);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (InvalidExpressionException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getChildrenCount((Object)variable);
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else if (JavaVariablesFilter.isMapMapType(type)) {
            try {
                ObjectVariable ov = (ObjectVariable)variable;
                ov = (ObjectVariable)ov.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                ov = (ObjectVariable)ov.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return original.getChildrenCount((Object)ov);
            }
            catch (InvalidExpressionException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getChildrenCount((Object)variable);
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            if (JavaVariablesFilter.isMapEntryType(type)) {
                return 2;
            }
            if (type.equals("java.beans.PropertyChangeSupport")) {
                return this.getChildren(original, variable, 0, 0).length;
            }
            if (type.equals("java.lang.ref.WeakReference")) {
                return 1;
            }
        }
        return original.getChildrenCount((Object)variable);
    }

    public boolean isLeaf(TreeModel original, Variable variable) throws UnknownTypeException {
        String type = variable.getType();
        if (JavaVariablesFilter.isLeafType(type)) {
            return true;
        }
        return original.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel original, Variable variable, String columnID) throws UnknownTypeException {
        String type = variable.getType();
        ObjectVariable ov = (ObjectVariable)variable;
        if (JavaVariablesFilter.isMapEntryType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            return ov.getField("key").getValue() + "=>" + ov.getField("value").getValue();
        }
        if (JavaVariablesFilter.isGetValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            return ov.getField("value").getValue();
        }
        if (JavaVariablesFilter.isToStringValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            try {
                return ov.getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                if (ex.getTargetException() != null && ex.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getValueAt((Object)variable, columnID);
                }
                return ex.getLocalizedMessage();
            }
        }
        return original.getValueAt((Object)variable, columnID);
    }

    private static boolean isGetValueType(String type) {
        if (getValueType == null) {
            getValueType = new HashSet();
            getValueType.add("java.lang.Character");
            getValueType.add("java.lang.Integer");
            getValueType.add("java.lang.Float");
            getValueType.add("java.lang.Byte");
            getValueType.add("java.lang.Boolean");
            getValueType.add("java.lang.Double");
            getValueType.add("java.lang.Long");
            getValueType.add("java.lang.Short");
        }
        return getValueType.contains(type);
    }

    private static boolean isLeafType(String type) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(type);
    }

    private static boolean isToStringValueType(String type) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
        }
        return toStringValueType.contains(type);
    }

    private static boolean isMapEntryType(String type) {
        if (mapEntryType == null) {
            mapEntryType = new HashSet();
            mapEntryType.add("java.util.HashMap$Entry");
            mapEntryType.add("java.util.Hashtable$Entry");
            mapEntryType.add("java.util.AbstractMap$SimpleEntry");
            mapEntryType.add("java.util.LinkedHashMap$Entry");
            mapEntryType.add("java.util.TreeMap$Entry");
        }
        return mapEntryType.contains(type);
    }

    private static boolean isMapMapType(String type) {
        if (mapMapType == null) {
            mapMapType = new HashSet();
            mapMapType.add("java.util.HashMap");
            mapMapType.add("java.util.IdentityHashMap");
            mapMapType.add("java.util.Hashtable");
            mapMapType.add("java.util.TreeMap");
            mapMapType.add("java.util.WeakHashMap");
            mapMapType.add("java.util.LinkedHashMap");
            mapMapType.add("java.util.concurrent.ConcurrentHashMap");
            mapMapType.add("java.util.EnumMap");
        }
        return mapMapType.contains(type);
    }

    private static boolean isToArrayType(String type) {
        if (toArrayType == null) {
            toArrayType = new HashSet();
            toArrayType.add("java.util.ArrayList");
            toArrayType.add("java.util.HashSet");
            toArrayType.add("java.util.LinkedHashSet");
            toArrayType.add("java.util.LinkedList");
            toArrayType.add("java.util.Stack");
            toArrayType.add("java.util.TreeSet");
            toArrayType.add("java.util.Vector");
            toArrayType.add("java.util.concurrent.CopyOnWriteArraySet");
            toArrayType.add("java.util.EnumSet");
        }
        return toArrayType.contains(type);
    }
}

