/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.ManyToMany;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.CollectionAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.mappings.ManyToManyMapping;

public class ManyToManyAccessor
extends CollectionAccessor {
    public ManyToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        ManyToMany manyToMany = (ManyToMany)this.getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            this.setFetchType(manyToMany.fetch());
            this.setMappedBy(manyToMany.mappedBy());
            this.setCascadeTypes(manyToMany.cascade());
            this.setTargetEntity(manyToMany.targetEntity());
        }
    }

    public boolean isManyToMany() {
        return true;
    }

    public void process() {
        ManyToManyMapping mapping = new ManyToManyMapping();
        this.populateCollectionMapping(mapping, "metadata_default_many_to_many_reference_class");
        if (this.m_mappedBy.equals("")) {
            this.processJoinTable(this.getJoinTable(), mapping);
        } else {
            mapping.setIsReadOnly(true);
            ManyToManyMapping ownerMapping = null;
            if (this.getOwningMapping().isManyToManyMapping()) {
                ownerMapping = (ManyToManyMapping)this.getOwningMapping();
            } else {
                this.getValidator().throwIvalidMappingEncountered(this.getJavaClass(), this.getReferenceClass());
            }
            mapping.setRelationTableName(ownerMapping.getRelationTableName());
            mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
            mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
            mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
            mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
        }
        this.m_descriptor.addMapping(mapping);
    }
}

