/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;

public class OperationEditorDrop
implements ActiveEditorDrop {
    OperationNode operationNode;

    public OperationEditorDrop(OperationNode operationNode) {
        this.operationNode = operationNode;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        Object mimeType = targetComponent.getDocument().getProperty("mimeType");
        if (mimeType != null && ("text/x-java".equals(mimeType) || "text/x-jsp".equals(mimeType))) {
            try {
                boolean enableDnD = false;
                Node clientNode = this.operationNode.getParentNode().getParentNode().getParentNode();
                FileObject srcRoot = (FileObject)clientNode.getLookup().lookup(FileObject.class);
                Project clientProject = FileOwnerQuery.getOwner((FileObject)srcRoot);
                Project targetProject = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)targetComponent.getDocument()));
                if (JaxWsUtils.addProjectReference(clientProject, targetProject)) {
                    JaxWsCodeGenerator.insertMethod(targetComponent.getDocument(), targetComponent.getCaret().getDot(), this.operationNode);
                    return true;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return false;
    }
}

