/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private EditorContext editor = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
    private LineBreakpoint breakpoint;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;

    public RunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)listener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
            }
        });
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        this.removeBreakpoint();
        this.createBreakpoint(LineBreakpoint.create((String)this.editor.getCurrentURL(), (int)this.editor.getCurrentLineNumber()));
        this.invokeAction();
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        final LineBreakpoint newBreakpoint = LineBreakpoint.create((String)this.editor.getCurrentURL(), (int)this.editor.getCurrentLineNumber());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RunToCursorActionProvider.this.removeBreakpoint();
                RunToCursorActionProvider.this.createBreakpoint(newBreakpoint);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            RunToCursorActionProvider.this.invokeAction();
                        }
                    });
                }
                catch (InterruptedException iex) {
                }
                catch (InvocationTargetException itex) {
                    ErrorManager.getDefault().notify((Throwable)itex);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    private void invokeAction() {
        ((ActionProvider)MainProjectManager.getDefault().getMainProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private boolean shouldBeEnabled() {
        int i;
        if (this.editor.getCurrentLineNumber() < 0) {
            return false;
        }
        if (!this.editor.getCurrentURL().endsWith(".java")) {
            return false;
        }
        Project p = MainProjectManager.getDefault().getMainProject();
        if (p == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private void createBreakpoint(LineBreakpoint breakpoint) {
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        this.breakpoint = breakpoint;
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    private class Listener
    extends DebuggerManagerAdapter {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "state") {
                int state = (Integer)e.getNewValue();
                if (state == 4 || state == 3) {
                    RunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = RunToCursorActionProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = RunToCursorActionProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }
    }
}

