/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.ElementIdStack;
import com.sun.xml.rpc.streaming.RecordedXMLReader;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class StAXReader
extends XMLReaderBase {
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private XMLStreamReader reader;
    private int state;
    private static final int CONTINUE = -10;
    private static final int[] stax2XMLReader = new int[16];
    private QName currentName;
    private AttributesImpl currentAttributes;
    private ArrayList allPrefixes;
    private ElementIdStack elementIds;
    private int elementId;

    public int getElementId() {
        return this.elementId;
    }

    public int getLineNumber() {
        return this.reader.getLocation().getLineNumber();
    }

    public int getState() {
        return this.state;
    }

    public int next() {
        if (this.state == 5) {
            return 5;
        }
        this.currentName = null;
        this.currentAttributes = null;
        try {
            do {
                this.state = stax2XMLReader[this.reader.next()];
            } while (this.state == -10);
            if (this.state == 1) {
                this.collectPrefixes();
                this.elementId = this.elementIds.pushNext();
            } else if (this.state == 2) {
                this.elementId = this.elementIds.pop();
            }
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
        return this.state;
    }

    static {
        int i = 0;
        while (i < 16) {
            StAXReader.stax2XMLReader[i] = -10;
            ++i;
        }
        StAXReader.stax2XMLReader[7] = 0;
        StAXReader.stax2XMLReader[1] = 1;
        StAXReader.stax2XMLReader[2] = 2;
        StAXReader.stax2XMLReader[4] = 3;
        StAXReader.stax2XMLReader[3] = 4;
        StAXReader.stax2XMLReader[8] = 5;
    }

    public void close() {
        this.state = 5;
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    private void collectPrefixes() {
        int i = 0;
        while (i < this.reader.getNamespaceCount()) {
            String prefix = this.reader.getNamespacePrefix(i);
            if (prefix != null) {
                this.allPrefixes.add(prefix);
            }
            ++i;
        }
    }

    private void finishSetup() {
        this.state = stax2XMLReader[this.reader.getEventType()];
        this.allPrefixes = new ArrayList();
        this.elementIds = new ElementIdStack();
    }

    private void printStreamConstants() {
        System.out.println(" ");
        System.out.println("XMLStreamConstants.START_ELEMENT: 1");
        System.out.println("XMLStreamConstants.END_ELEMENT: 2");
        System.out.println("XMLStreamConstants.PROCESSING_INSTRUCTION: 3");
        System.out.println("XMLStreamConstants.CHARACTERS: 4");
        System.out.println("XMLStreamConstants.COMMENT: 5");
        System.out.println("XMLStreamConstants.SPACE: 6");
        System.out.println("XMLStreamConstants.START_DOCUMENT: 7");
        System.out.println("XMLStreamConstants.END_DOCUMENT: 8");
        System.out.println("XMLStreamConstants.ENTITY_REFERENCE: 9");
        System.out.println("XMLStreamConstants.ATTRIBUTE: 10");
        System.out.println("XMLStreamConstants.DTD: 11");
        System.out.println("XMLStreamConstants.CDATA: 12");
        System.out.println("XMLStreamConstants.NAMESPACE: 13");
        System.out.println("XMLStreamConstants.NOTATION_DECLARATION: 14");
        System.out.println("XMLStreamConstants.ENTITY_DECLARATION: 15");
    }

    public void synchronizeReader() {
        this.currentName = null;
        this.currentAttributes = null;
        this.state = stax2XMLReader[this.reader.getEventType()];
    }

    public void skipElement(int id) {
        while (this.state != 5 && (this.state != 2 || this.elementId != id)) {
            this.next();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Attributes getAttributes() {
        if (this.currentAttributes != null) return this.currentAttributes;
        if (this.reader.getEventType() != 1) {
            if (this.reader.getEventType() != 10) {
                this.currentAttributes = new AttributesImpl(null);
                return this.currentAttributes;
            }
        }
        this.currentAttributes = new AttributesImpl(this.reader);
        return this.currentAttributes;
    }

    public XMLReader recordElement() {
        return new RecordedXMLReader(this, new NamespaceContextWrapper(this.reader.getNamespaceContext()));
    }

    public StAXReader(StringReader stringReader, boolean rejectDTDs) {
        try {
            this.reader = this.getInputFactory().createXMLStreamReader(stringReader);
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    public String getLocalName() {
        return this.reader.getLocalName();
    }

    public String getURI() {
        return this.reader.getNamespaceURI();
    }

    public String getValue() {
        return this.reader.getText();
    }

    public Iterator getPrefixes() {
        Iterator iter = this.allPrefixes.iterator();
        HashSet<String> set = new HashSet<String>(this.allPrefixes.size());
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (this.reader.getNamespaceURI(prefix) == null) continue;
            set.add(prefix);
        }
        return set.iterator();
    }

    public QName getName() {
        if (this.currentName == null) {
            this.currentName = this.reader.getName();
        }
        return this.currentName;
    }

    private XMLInputFactory getInputFactory() throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return inputFactory;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public StAXReader(Source source, boolean rejectDTDs) {
        try {
            boolean workingYet = false;
            if (workingYet) {
                this.reader = this.getInputFactory().createXMLStreamReader(source);
            } else {
                Transformer transformer = XmlUtil.newTransformer();
                ByteOutputStream bos = new ByteOutputStream();
                transformer.transform(source, new StreamResult((OutputStream)bos));
                ByteInputStream istream = new ByteInputStream(bos.getBytes(), bos.getCount());
                InputSource iSource = new InputSource((InputStream)istream);
                this.reader = this.getInputFactory().createXMLStreamReader(iSource.getByteStream(), iSource.getEncoding());
            }
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
        catch (TransformerException te) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(te));
        }
    }

    public StAXReader(InputSource source, boolean rejectDTDs) {
        try {
            this.reader = this.getInputFactory().createXMLStreamReader(source.getByteStream(), source.getEncoding());
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    public String getURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    public StAXReader(InputSource source, boolean rejectDTDs, XMLStreamReader reader) {
        this.reader = reader;
        this.finishSetup();
    }

    static class AttributeInfo {
        private QName name;
        private String value;

        boolean isNamespaceDeclaration() {
            return this.name.getNamespaceURI() == StAXReader.XMLNS_NAMESPACE_URI;
        }

        String getLocalName() {
            if (this.isNamespaceDeclaration()) {
                if (this.name.getLocalPart().equals("")) {
                    return "xmlns";
                }
                return "xmlns:" + this.name.getLocalPart();
            }
            return this.name.getLocalPart();
        }

        String getValue() {
            return this.value;
        }

        QName getName() {
            return this.name;
        }

        public AttributeInfo(QName name, String value) {
            this.name = name;
            this.value = value == null ? "" : value;
        }
    }

    public static class AttributesImpl
    implements Attributes {
        AttributeInfo[] atInfos;

        public int getLength() {
            return this.atInfos.length;
        }

        public boolean isNamespaceDeclaration(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].isNamespaceDeclaration();
            }
            return false;
        }

        public String getLocalName(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getLocalName();
            }
            return null;
        }

        public String getPrefix(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName().getPrefix();
            }
            return null;
        }

        public String getURI(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName().getNamespaceURI();
            }
            return null;
        }

        public String getValue(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        public int getIndex(String localName) {
            int i = 0;
            while (i < this.atInfos.length) {
                if (this.atInfos[i].getName().getLocalPart().equals(localName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public QName getName(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName();
            }
            return null;
        }

        public int getIndex(QName name) {
            int i = 0;
            while (i < this.atInfos.length) {
                if (this.atInfos[i].getName().equals(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public AttributesImpl(XMLStreamReader reader) {
            if (reader == null) {
                this.atInfos = new AttributeInfo[0];
            } else {
                int index = 0;
                String namespacePrefix = null;
                int namespaceCount = reader.getNamespaceCount();
                int attributeCount = reader.getAttributeCount();
                this.atInfos = new AttributeInfo[namespaceCount + attributeCount];
                int i = 0;
                while (i < namespaceCount) {
                    namespacePrefix = reader.getNamespacePrefix(i);
                    if (namespacePrefix == null) {
                        namespacePrefix = "";
                    }
                    this.atInfos[index++] = new AttributeInfo(new QName(StAXReader.XMLNS_NAMESPACE_URI, namespacePrefix, "xmlns"), reader.getNamespaceURI(i));
                    ++i;
                }
                int i2 = 0;
                while (i2 < attributeCount) {
                    this.atInfos[index++] = new AttributeInfo(reader.getAttributeName(i2), reader.getAttributeValue(i2));
                    ++i2;
                }
            }
        }

        public String getValue(String localName) {
            int index = this.getIndex(localName);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        public int getIndex(String uri, String localName) {
            int i = 0;
            while (i < this.atInfos.length) {
                QName qName = this.atInfos[i].getName();
                if (qName.getNamespaceURI().equals(uri) && qName.getLocalPart().equals(localName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String getValue(QName name) {
            int index = this.getIndex(name);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }
    }

    static class NamespaceContextWrapper
    extends NamespaceSupport {
        private NamespaceContext context;

        public Iterator getPrefixes() {
            throw new UnsupportedOperationException();
        }

        public NamespaceContextWrapper(NamespaceContext context) {
            this.context = context;
        }

        public String getPrefix(String uri) {
            return this.context.getPrefix(uri);
        }

        public String getURI(String prefix) {
            return this.context.getNamespaceURI(prefix);
        }

        public Iterator getPrefixes(String uri) {
            return this.context.getPrefixes(uri);
        }
    }
}

