/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.util.ArrayList;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public class ListenerGenerator {
    boolean isContext;
    boolean isContextAttr;
    boolean isSession;
    boolean isSessionAttr;
    boolean isRequest;
    boolean isRequestAttr;
    private ClassElement clazz;

    public ListenerGenerator(boolean isContext, boolean isContextAttr, boolean isSession, boolean isSessionAttr, boolean isRequest, boolean isRequestAttr) {
        this.isContext = isContext;
        this.isContextAttr = isContextAttr;
        this.isSession = isSession;
        this.isSessionAttr = isSessionAttr;
        this.isRequest = isRequest;
        this.isRequestAttr = isRequestAttr;
    }

    public void generate(ClassElement clazz) throws SourceException {
        this.clazz = clazz;
        this.generateImports();
        this.generateInterfaces();
        if (this.isContext) {
            this.addContextListenerMethods();
        }
        if (this.isContextAttr) {
            this.addContextAttrListenerMethods();
        }
        if (this.isSession) {
            this.addSessionListenerMethods();
        }
        if (this.isSessionAttr) {
            this.addSessionAttrListenerMethods();
        }
        if (this.isRequest) {
            this.addRequestListenerMethods();
        }
        if (this.isRequestAttr) {
            this.addRequestAttrListenerMethods();
        }
    }

    private void generateImports() throws SourceException {
        SourceElement srcEl = this.clazz.getSource();
        ArrayList<Import> imports = new ArrayList<Import>();
        if (this.isContext) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletContextListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletContextEvent"), false));
        }
        if (this.isContextAttr) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletContextAttributeListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletContextAttributeEvent"), false));
        }
        if (this.isSession) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.http.HttpSessionListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.http.HttpSessionEvent"), false));
        }
        if (this.isSessionAttr) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.http.HttpSessionAttributeListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.http.HttpSessionBindingEvent"), false));
        }
        if (this.isRequest) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletRequestListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletRequestEvent"), false));
        }
        if (this.isRequestAttr) {
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletRequestAttributeListener"), false));
            imports.add(new Import(Identifier.create((String)"javax.servlet.ServletRequestAttributeEvent"), false));
        }
        Import[] imp = new Import[imports.size()];
        imports.toArray(imp);
        srcEl.addImports(imp);
    }

    private void generateInterfaces() throws SourceException {
        if (this.isContext) {
            this.clazz.addInterface(Identifier.create((String)"ServletContextListener"));
        }
        if (this.isContextAttr) {
            this.clazz.addInterface(Identifier.create((String)"ServletContextAttributeListener"));
        }
        if (this.isSession) {
            this.clazz.addInterface(Identifier.create((String)"HttpSessionListener"));
        }
        if (this.isSessionAttr) {
            this.clazz.addInterface(Identifier.create((String)"HttpSessionAttributeListener"));
        }
        if (this.isRequest) {
            this.clazz.addInterface(Identifier.create((String)"ServletRequestListener"));
        }
        if (this.isRequestAttr) {
            this.clazz.addInterface(Identifier.create((String)"ServletRequestAttributeListener"));
        }
    }

    private void addContextListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_contextListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo_eg"));
        bodyBuf.append("\n/*\n");
        bodyBuf.append("    Connection con = // create connection\n");
        bodyBuf.append("    evt.getServletContext().setAttribute(\"con\", con);\n");
        bodyBuf.append("*/\n");
        this.addMethod("contextInitialized", "ServletContextEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_contextListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo_eg"));
        bodyBuf.append("\n/*\n");
        bodyBuf.append("        Connection con = (Connection) e.getServletContext().getAttribute(\"con\");\n");
        bodyBuf.append("        try { con.close(); } catch (SQLException ignored) { } // close connection\n");
        bodyBuf.append("*/\n");
        this.addMethod("contextDestroyed", "ServletContextEvent", docBuf, bodyBuf);
    }

    private void addContextAttrListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_contextAttrListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeAdded", "ServletContextAttributeEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_contextAttrListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeRemoved", "ServletContextAttributeEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_contextAttrListener_m3"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeReplaced", "ServletContextAttributeEvent", docBuf, bodyBuf);
    }

    private void addSessionListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_sessionListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("sessionCreated", "HttpSessionEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_sessionListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("sessionDestroyed", "HttpSessionEvent", docBuf, bodyBuf);
    }

    private void addSessionAttrListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_sessionAttrListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeAdded", "HttpSessionBindingEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_sessionAttrListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeRemoved", "HttpSessionBindingEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_sessionAttrListener_m3"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeReplaced", "HttpSessionBindingEvent", docBuf, bodyBuf);
    }

    private void addRequestListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_requestListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("requestInitialized", "ServletRequestEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_requestListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("requestDestroyed", "ServletRequestEvent", docBuf, bodyBuf);
    }

    private void addRequestAttrListenerMethods() throws SourceException {
        StringBuffer docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_requestAttrListener_m1"));
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeAdded", "ServletRequestAttributeEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_requestAttrListener_m2"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeRemoved", "ServletRequestAttributeEvent", docBuf, bodyBuf);
        docBuf = new StringBuffer();
        docBuf.append(NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_DOC_requestAttrListener_m3"));
        bodyBuf = new StringBuffer();
        bodyBuf.append("// " + NbBundle.getMessage(ListenerGenerator.class, (String)"TXT_todo") + "\n");
        this.addMethod("attributeReplaced", "ServletRequestAttributeEvent", docBuf, bodyBuf);
    }

    private void addMethod(String methodName, String eventName, StringBuffer javadoc, StringBuffer body) throws SourceException {
        MethodElement method = new MethodElement();
        method.setName(Identifier.create((String)methodName));
        method.setReturn(Type.VOID);
        method.setModifiers(1);
        MethodParameter mp = MethodParameter.parse((String)(eventName + " evt"));
        method.setParameters(new MethodParameter[]{mp});
        JavaDoc.Method doc = method.getJavaDoc();
        doc.setRawText(javadoc.toString());
        method.setBody(body.toString());
        this.clazz.addMethod(method);
    }
}

