/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Zone {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private Map data;
    private int type;
    private Name origin;
    private Object originNode;
    private int dclass;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private final void validate() throws IOException {
        this.originNode = this.exactName(this.origin);
        if (this.originNode == null) {
            throw new IOException(this.origin + ": no data specified");
        }
        RRset rRset = this.oneRRset(this.originNode, 6);
        if (rRset == null || rRset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Iterator iterator = rRset.rrs();
        this.SOA = (SOARecord)iterator.next();
        this.NS = this.oneRRset(this.originNode, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private final void maybeAddRecord(Record record) throws IOException {
        int n = record.getType();
        Name name = record.getName();
        if (n == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        }
    }

    private final void fromXFR(ZoneTransferIn zoneTransferIn) throws IOException, ZoneTransferException {
        this.data = new HashMap();
        this.type = 2;
        if (zoneTransferIn.getType() != 252) {
            throw new IllegalArgumentException("zones can only be created from AXFRs");
        }
        this.origin = zoneTransferIn.getName();
        List list2 = zoneTransferIn.run();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return this.dclass;
    }

    private final synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private final synchronized RRset[] allRRsets(Object object) {
        if (object instanceof List) {
            List list2 = (List)object;
            return (RRset[])list2.toArray(new RRset[list2.size()]);
        }
        RRset rRset = (RRset)object;
        return new RRset[]{rRset};
    }

    private final synchronized RRset oneRRset(Object object, int n) {
        if (n == 255) {
            throw new IllegalArgumentException("oneRRset(ANY)");
        }
        if (object instanceof List) {
            List list2 = (List)object;
            int n2 = 0;
            while (n2 < list2.size()) {
                RRset rRset = (RRset)list2.get(n2);
                if (rRset.getType() == n) {
                    return rRset;
                }
                ++n2;
            }
        } else {
            RRset rRset = (RRset)object;
            if (rRset.getType() == n) {
                return rRset;
            }
        }
        return null;
    }

    private final synchronized RRset findRRset(Name name, int n) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneRRset(object, n);
    }

    private final synchronized void addRRset(Name name, RRset rRset) {
        Object object;
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        if ((object = this.data.get(name)) == null) {
            this.data.put(name, rRset);
            return;
        }
        int n = rRset.getType();
        if (object instanceof List) {
            List list2 = (List)object;
            int n2 = 0;
            while (n2 < list2.size()) {
                RRset rRset2 = (RRset)list2.get(n2);
                if (rRset2.getType() == n) {
                    list2.set(n2, rRset);
                    return;
                }
                ++n2;
            }
            list2.add(rRset);
        } else {
            RRset rRset3 = (RRset)object;
            if (rRset3.getType() == n) {
                this.data.put(name, rRset);
            } else {
                LinkedList linkedList = new LinkedList();
                linkedList.add(rRset3);
                linkedList.add(rRset);
                this.data.put(name, linkedList);
            }
        }
    }

    private final synchronized void removeRRset(Name name, int n) {
        Object object = this.data.get(name);
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            List list2 = (List)object;
            int n2 = 0;
            while (n2 < list2.size()) {
                RRset rRset = (RRset)list2.get(n2);
                if (rRset.getType() == n) {
                    list2.remove(n2);
                    if (list2.size() == 0) {
                        this.data.remove(name);
                    }
                    return;
                }
                ++n2;
            }
        } else {
            RRset rRset = (RRset)object;
            if (rRset.getType() != n) {
                return;
            }
            this.data.remove(name);
        }
    }

    private final synchronized SetResponse lookup(Name name, int n) {
        RRset rRset;
        Name name2;
        Object object;
        int n2;
        int n3;
        if (!name.subdomain(this.origin)) {
            return SetResponse.ofType(1);
        }
        int n4 = name.labels();
        int n5 = n3 = this.origin.labels();
        while (n5 <= n4) {
            boolean bl;
            int n6 = 0;
            if (n5 == n3) {
                n6 = 1;
            }
            n2 = n6;
            boolean bl2 = false;
            if (n5 == n4) {
                bl2 = bl = true;
            }
            if ((object = this.exactName(name2 = n2 != 0 ? this.origin : (bl ? name : new Name(name, n4 - n5)))) != null) {
                RRset[] rRsetArray;
                if (n2 == 0 && (rRsetArray = this.oneRRset(object, 2)) != null) {
                    return new SetResponse(3, (RRset)rRsetArray);
                }
                if (bl && n == 255) {
                    SetResponse setResponse = new SetResponse(6);
                    rRsetArray = this.allRRsets(object);
                    int n7 = 0;
                    while (n7 < rRsetArray.length) {
                        setResponse.addRRset(rRsetArray[n7]);
                        ++n7;
                    }
                    return setResponse;
                }
                if (bl) {
                    rRset = this.oneRRset(object, n);
                    if (rRset != null) {
                        SetResponse setResponse = new SetResponse(6);
                        setResponse.addRRset(rRset);
                        return setResponse;
                    }
                    rRset = this.oneRRset(object, 5);
                    if (rRset != null) {
                        return new SetResponse(4, rRset);
                    }
                } else {
                    rRset = this.oneRRset(object, 39);
                    if (rRset != null) {
                        return new SetResponse(5, rRset);
                    }
                }
                if (bl) {
                    return SetResponse.ofType(2);
                }
            }
            ++n5;
        }
        if (this.hasWild) {
            n2 = 0;
            while (n2 < n4 - n3) {
                name2 = name.wild(n2 + 1);
                object = this.exactName(name2);
                if (object != null && (rRset = this.oneRRset(object, n)) != null) {
                    SetResponse setResponse = new SetResponse(6);
                    setResponse.addRRset(rRset);
                    return setResponse;
                }
                ++n2;
            }
        }
        return SetResponse.ofType(1);
    }

    public SetResponse findRecords(Name name, int n) {
        return this.lookup(name, n);
    }

    public RRset findExactMatch(Name name, int n) {
        return this.oneRRset(this.exactName(name), n);
    }

    public void addRRset(RRset rRset) {
        Name name = rRset.getName();
        this.addRRset(name, rRset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRecord(Record record) {
        Name name = record.getName();
        int n = record.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rRset = this.findRRset(name, n);
            if (rRset == null) {
                rRset = new RRset(record);
            }
            this.addRRset(name, rRset);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRecord(Record record) {
        Name name = record.getName();
        int n = record.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rRset = this.findRRset(name, n);
            if (rRset == null) {
                return;
            }
            rRset.deleteRR(record);
            if (rRset.size() == 0) {
                this.removeRRset(name, n);
            }
            return;
        }
    }

    public Iterator iterator() {
        return new ZoneIterator(false);
    }

    public Iterator AXFR() {
        return new ZoneIterator(true);
    }

    private final void nodeToString(StringBuffer stringBuffer, Object object) {
        RRset[] rRsetArray = this.allRRsets(object);
        int n = 0;
        while (n < rRsetArray.length) {
            RRset rRset = rRsetArray[n];
            Iterator iterator = rRset.rrs();
            while (iterator.hasNext()) {
                stringBuffer.append("" + iterator.next() + '\n');
            }
            iterator = rRset.sigs();
            while (iterator.hasNext()) {
                stringBuffer.append("" + iterator.next() + '\n');
            }
            ++n;
        }
    }

    public String toMasterFile() {
        Iterator iterator = this.data.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        this.nodeToString(stringBuffer, this.originNode);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (this.origin.equals(entry.getKey())) continue;
            this.nodeToString(stringBuffer, entry.getValue());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toMasterFile();
    }

    private final /* synthetic */ void this() {
        this.dclass = 1;
    }

    public Zone(Name name, String string) throws IOException {
        Record record;
        this.this();
        this.data = new HashMap();
        this.type = 1;
        if (name == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        Master master = new Master(string, name);
        this.origin = name;
        while ((record = master.nextRecord()) != null) {
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    public Zone(Name name, Record[] recordArray) throws IOException {
        this.this();
        this.data = new HashMap();
        this.type = 1;
        if (name == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        this.origin = name;
        int n = 0;
        while (n < recordArray.length) {
            this.maybeAddRecord(recordArray[n]);
            ++n;
        }
        this.validate();
    }

    public Zone(ZoneTransferIn zoneTransferIn) throws IOException, ZoneTransferException {
        this.this();
        this.fromXFR(zoneTransferIn);
    }

    public Zone(Name name, int n, String string) throws IOException, ZoneTransferException {
        this.this();
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, string, null);
        zoneTransferIn.setDClass(n);
        this.fromXFR(zoneTransferIn);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ZoneIterator
    implements Iterator {
        private Iterator zentries;
        private RRset[] current;
        private int count;
        private boolean wantLastSOA;

        public boolean hasNext() {
            boolean bl = false;
            if (this.current != null || this.wantLastSOA) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null && this.wantLastSOA) {
                this.wantLastSOA = false;
                return Zone.this.oneRRset(Zone.this.originNode, 6);
            }
            RRset rRset = this.current[this.count++];
            if (this.count == this.current.length) {
                this.current = null;
                while (this.zentries.hasNext()) {
                    RRset[] rRsetArray;
                    Map.Entry entry = (Map.Entry)this.zentries.next();
                    if (entry.getKey().equals(Zone.this.origin) || (rRsetArray = Zone.this.allRRsets(entry.getValue())).length == 0) continue;
                    this.current = rRsetArray;
                    this.count = 0;
                    break;
                }
            }
            return rRset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ZoneIterator(boolean bl) {
            this.zentries = Zone.this.data.entrySet().iterator();
            this.wantLastSOA = bl;
            RRset[] rRsetArray = Zone.this.allRRsets(Zone.this.originNode);
            this.current = new RRset[rRsetArray.length];
            int n = 0;
            int n2 = 2;
            while (n < rRsetArray.length) {
                int n3 = rRsetArray[n].getType();
                if (n3 == 6) {
                    this.current[0] = rRsetArray[n];
                } else if (n3 == 2) {
                    this.current[1] = rRsetArray[n];
                } else {
                    this.current[n2++] = rRsetArray[n];
                }
                ++n;
            }
        }
    }
}

