/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public strictfp final class StrictMath {
    private static Random rand;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static final double TWO_16 = 65536.0;
    private static final double TWO_20 = 1048576.0;
    private static final double TWO_24 = 1.6777216E7;
    private static final double TWO_27 = 1.34217728E8;
    private static final double TWO_28 = 2.68435456E8;
    private static final double TWO_29 = 5.36870912E8;
    private static final double TWO_31 = 2.147483648E9;
    private static final double TWO_49 = 5.62949953421312E14;
    private static final double TWO_52 = 4.503599627370496E15;
    private static final double TWO_54 = 1.8014398509481984E16;
    private static final double TWO_57 = 1.4411518807585587E17;
    private static final double TWO_60 = 1.152921504606847E18;
    private static final double TWO_64 = 1.8446744073709552E19;
    private static final double TWO_66 = 7.378697629483821E19;
    private static final double TWO_1023 = 8.98846567431158E307;
    private static final int[] TWO_OVER_PI;
    private static final double[] PI_OVER_TWO;
    private static final double PI_L = 1.2246467991473532E-16;
    private static final double PIO2_1 = 1.5707963267341256;
    private static final double PIO2_1L = 6.077100506506192E-11;
    private static final double PIO2_2 = 6.077100506303966E-11;
    private static final double PIO2_2L = 2.0222662487959506E-21;
    private static final double PIO2_3 = 2.0222662487111665E-21;
    private static final double PIO2_3L = 8.4784276603689E-32;
    private static final double SQRT_1_5 = 1.224744871391589;
    private static final double SQRT_2 = 1.4142135623730951;
    private static final double SQRT_3 = 1.7320508075688772;
    private static final double EXP_LIMIT_H = 709.782712893384;
    private static final double EXP_LIMIT_L = -745.1332191019411;
    private static final double CP = 0.9617966939259756;
    private static final double CP_H = 0.9617967009544373;
    private static final double CP_L = -7.028461650952758E-9;
    private static final double LN2 = 0.6931471805599453;
    private static final double LN2_H = 0.6931471803691238;
    private static final double LN2_L = 1.9082149292705877E-10;
    private static final double INV_LN2 = 1.4426950408889634;
    private static final double INV_LN2_H = (double)1.442695f;
    private static final double INV_LN2_L = 1.9259629911266175E-8;
    private static final double LG1 = 0.6666666666666735;
    private static final double LG2 = 0.3999999999940942;
    private static final double LG3 = 0.2857142874366239;
    private static final double LG4 = 0.22222198432149784;
    private static final double LG5 = 0.1818357216161805;
    private static final double LG6 = 0.15313837699209373;
    private static final double LG7 = 0.14798198605116586;
    private static final double L1 = 0.5999999999999946;
    private static final double L2 = 0.4285714285785502;
    private static final double L3 = 0.33333332981837743;
    private static final double L4 = 0.272728123808534;
    private static final double L5 = 0.23066074577556175;
    private static final double L6 = 0.20697501780033842;
    private static final double P1 = 0.16666666666666602;
    private static final double P2 = -0.0027777777777015593;
    private static final double P3 = 6.613756321437934E-5;
    private static final double P4 = -1.6533902205465252E-6;
    private static final double P5 = 4.1381367970572385E-8;
    private static final double DP_H = 0.5849624872207642;
    private static final double DP_L = 1.350039202129749E-8;
    private static final double OVT = 8.008566259537294E-17;
    private static final double S1 = -0.16666666666666632;
    private static final double S2 = 0.00833333333332249;
    private static final double S3 = -1.984126982985795E-4;
    private static final double S4 = 2.7557313707070068E-6;
    private static final double S5 = -2.5050760253406863E-8;
    private static final double S6 = 1.58969099521155E-10;
    private static final double C1 = 0.0416666666666666;
    private static final double C2 = -0.001388888888887411;
    private static final double C3 = 2.480158728947673E-5;
    private static final double C4 = -2.7557314351390663E-7;
    private static final double C5 = 2.087572321298175E-9;
    private static final double C6 = -1.1359647557788195E-11;
    private static final double T0 = 0.3333333333333341;
    private static final double T1 = 0.13333333333320124;
    private static final double T2 = 0.05396825397622605;
    private static final double T3 = 0.021869488294859542;
    private static final double T4 = 0.0088632398235993;
    private static final double T5 = 0.0035920791075913124;
    private static final double T6 = 0.0014562094543252903;
    private static final double T7 = 5.880412408202641E-4;
    private static final double T8 = 2.464631348184699E-4;
    private static final double T9 = 7.817944429395571E-5;
    private static final double T10 = 7.140724913826082E-5;
    private static final double T11 = -1.8558637485527546E-5;
    private static final double T12 = 2.590730518636337E-5;
    private static final double PS0 = 0.16666666666666666;
    private static final double PS1 = -0.3255658186224009;
    private static final double PS2 = 0.20121253213486293;
    private static final double PS3 = -0.04005553450067941;
    private static final double PS4 = 7.915349942898145E-4;
    private static final double PS5 = 3.479331075960212E-5;
    private static final double QS1 = -2.403394911734414;
    private static final double QS2 = 2.0209457602335057;
    private static final double QS3 = -0.6882839716054533;
    private static final double QS4 = 0.07703815055590194;
    private static final double ATAN_0_5H = 0.4636476090008061;
    private static final double ATAN_0_5L = 2.2698777452961687E-17;
    private static final double ATAN_1_5H = 0.982793723247329;
    private static final double ATAN_1_5L = 1.3903311031230998E-17;
    private static final double AT0 = 0.3333333333333293;
    private static final double AT1 = -0.19999999999876483;
    private static final double AT2 = 0.14285714272503466;
    private static final double AT3 = -0.11111110405462356;
    private static final double AT4 = 0.09090887133436507;
    private static final double AT5 = -0.0769187620504483;
    private static final double AT6 = 0.06661073137387531;
    private static final double AT7 = -0.058335701337905735;
    private static final double AT8 = 0.049768779946159324;
    private static final double AT9 = -0.036531572744216916;
    private static final double AT10 = 0.016285820115365782;

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static final float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static final double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static final float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return -(-f - f2);
        }
        return f < f2 ? f : f2;
    }

    public static final double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return -(-d - d2);
        }
        return d < d2 ? d : d2;
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public static final float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return f - -f2;
        }
        return f > f2 ? f : f2;
    }

    public static final double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d - -d2;
        }
        return d > d2 ? d : d2;
    }

    public static final double sin(double d) {
        if (d == Double.NEGATIVE_INFINITY || !(d < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 0.7853981633974483) {
            return StrictMath.sin(d, 0.0);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        switch (n & 3) {
            case 0: {
                return StrictMath.sin(dArray[0], dArray[1]);
            }
            case 1: {
                return StrictMath.cos(dArray[0], dArray[1]);
            }
            case 2: {
                return -StrictMath.sin(dArray[0], dArray[1]);
            }
        }
        return -StrictMath.cos(dArray[0], dArray[1]);
    }

    public static final double cos(double d) {
        if (d == Double.NEGATIVE_INFINITY || !(d < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 0.7853981633974483) {
            return StrictMath.cos(d, 0.0);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        switch (n & 3) {
            case 0: {
                return StrictMath.cos(dArray[0], dArray[1]);
            }
            case 1: {
                return -StrictMath.sin(dArray[0], dArray[1]);
            }
            case 2: {
                return -StrictMath.cos(dArray[0], dArray[1]);
            }
        }
        return StrictMath.sin(dArray[0], dArray[1]);
    }

    public static final double tan(double d) {
        if (d == Double.NEGATIVE_INFINITY || !(d < Double.POSITIVE_INFINITY)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 0.7853981633974483) {
            return StrictMath.tan(d, 0.0, false);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        double d2 = dArray[0];
        double d3 = dArray[1];
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
        }
        return StrictMath.tan(d2, d3, bl);
    }

    public static final double asin(double d) {
        boolean bl;
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
        }
        if (bl = bl2) {
            d = -d;
        }
        if (!(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return bl ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d < 0.5) {
            if (d < 7.450580596923828E-9) {
                return bl ? -d : d;
            }
            double d2 = d * d;
            double d3 = d2 * (0.16666666666666666 + d2 * (-0.3255658186224009 + d2 * (0.20121253213486293 + d2 * (-0.04005553450067941 + d2 * (7.915349942898145E-4 + d2 * 3.479331075960212E-5)))));
            double d4 = 1.0 + d2 * (-2.403394911734414 + d2 * (2.0209457602335057 + d2 * (-0.6882839716054533 + d2 * 0.07703815055590194)));
            return bl ? -d - d * (d3 / d4) : d + d * (d3 / d4);
        }
        double d5 = 1.0 - d;
        double d6 = d5 * 0.5;
        double d7 = d6 * (0.16666666666666666 + d6 * (-0.3255658186224009 + d6 * (0.20121253213486293 + d6 * (-0.04005553450067941 + d6 * (7.915349942898145E-4 + d6 * 3.479331075960212E-5)))));
        double d8 = 1.0 + d6 * (-2.403394911734414 + d6 * (2.0209457602335057 + d6 * (-0.6882839716054533 + d6 * 0.07703815055590194)));
        double d9 = StrictMath.sqrt(d6);
        if (d >= 0.975) {
            d5 = d7 / d8;
            d6 = 1.5707963267948966 - ((double)2 * (d9 + d9 * d5) - 6.123233995736766E-17);
        } else {
            d5 = (float)d9;
            double d10 = (d6 - d5 * d5) / (d9 + d5);
            d7 = (double)2 * d9 * (d7 / d8) - (6.123233995736766E-17 - (double)2 * d10);
            d8 = 0.7853981633974483 - (double)2 * d5;
            d6 = 0.7853981633974483 - (d7 - d8);
        }
        return bl ? -d6 : d6;
    }

    public static final double acos(double d) {
        boolean bl;
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
        }
        if (bl = bl2) {
            d = -d;
        }
        if (!(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return bl ? Math.PI : 0.0;
        }
        if (d < 0.5) {
            if (d < 6.938893903907228E-18) {
                return 1.5707963267948966;
            }
            double d2 = d * d;
            double d3 = d2 * (0.16666666666666666 + d2 * (-0.3255658186224009 + d2 * (0.20121253213486293 + d2 * (-0.04005553450067941 + d2 * (7.915349942898145E-4 + d2 * 3.479331075960212E-5)))));
            double d4 = 1.0 + d2 * (-2.403394911734414 + d2 * (2.0209457602335057 + d2 * (-0.6882839716054533 + d2 * 0.07703815055590194)));
            double d5 = d - (6.123233995736766E-17 - d * (d3 / d4));
            return bl ? 1.5707963267948966 + d5 : 1.5707963267948966 - d5;
        }
        if (bl) {
            double d6 = (1.0 + d) * 0.5;
            double d7 = d6 * (0.16666666666666666 + d6 * (-0.3255658186224009 + d6 * (0.20121253213486293 + d6 * (-0.04005553450067941 + d6 * (7.915349942898145E-4 + d6 * 3.479331075960212E-5)))));
            double d8 = 1.0 + d6 * (-2.403394911734414 + d6 * (2.0209457602335057 + d6 * (-0.6882839716054533 + d6 * 0.07703815055590194)));
            double d9 = StrictMath.sqrt(d6);
            double d10 = d7 / d8 * d9 - 6.123233995736766E-17;
            return Math.PI - (double)2 * (d9 + d10);
        }
        double d11 = (1.0 - d) * 0.5;
        double d12 = StrictMath.sqrt(d11);
        double d13 = (float)d12;
        double d14 = (d11 - d13 * d13) / (d12 + d13);
        double d15 = d11 * (0.16666666666666666 + d11 * (-0.3255658186224009 + d11 * (0.20121253213486293 + d11 * (-0.04005553450067941 + d11 * (7.915349942898145E-4 + d11 * 3.479331075960212E-5)))));
        double d16 = 1.0 + d11 * (-2.403394911734414 + d11 * (2.0209457602335057 + d11 * (-0.6882839716054533 + d11 * 0.07703815055590194)));
        double d17 = d15 / d16 * d12 + d14;
        return (double)2 * (d13 + d17);
    }

    public static final double atan(double d) {
        double d2;
        double d3;
        boolean bl;
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
        }
        if (bl = bl2) {
            d = -d;
        }
        if (d >= 7.378697629483821E19) {
            return bl ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (!(d >= 0.4375)) {
            if (!(d >= 1.862645149230957E-9)) {
                return bl ? -d : d;
            }
            d3 = 0.0;
            d2 = 0.0;
        } else if (d < 1.1875) {
            if (d < 0.6875) {
                d = ((double)2 * d - 1.0) / ((double)2 + d);
                d3 = 0.4636476090008061;
                d2 = 2.2698777452961687E-17;
            } else {
                d = (d - 1.0) / (d + 1.0);
                d3 = 0.7853981633974483;
                d2 = 3.061616997868383E-17;
            }
        } else if (d < 2.4375) {
            d = (d - 1.5) / (1.0 + 1.5 * d);
            d3 = 0.982793723247329;
            d2 = 1.3903311031230998E-17;
        } else {
            d = -1.0 / d;
            d3 = 1.5707963267948966;
            d2 = 6.123233995736766E-17;
        }
        double d4 = d * d;
        double d5 = d4 * d4;
        double d6 = d4 * (0.3333333333333293 + d5 * (0.14285714272503466 + d5 * (0.09090887133436507 + d5 * (0.06661073137387531 + d5 * (0.049768779946159324 + d5 * 0.016285820115365782)))));
        double d7 = d5 * (-0.19999999999876483 + d5 * (-0.11111110405462356 + d5 * (-0.0769187620504483 + d5 * (-0.058335701337905735 + d5 * -0.036531572744216916))));
        if (d3 == 0.0) {
            return bl ? d * (d6 + d7) - d : d - d * (d6 + d7);
        }
        d4 = d3 - (d * (d6 + d7) - d2 - d);
        return bl ? -d4 : d4;
    }

    public static final double atan2(double d, double d2) {
        if (d2 != d2 || d != d) {
            return Double.NaN;
        }
        if (d2 == 1.0) {
            return StrictMath.atan(d);
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (d == Double.POSITIVE_INFINITY) {
                return 0.7853981633974483;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return -0.7853981633974483;
            }
            return 0.0 * d;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d == Double.POSITIVE_INFINITY) {
                return 2.356194490192345;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return -2.356194490192345;
            }
            return 1.0 / (0.0 * d) == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (d == 0.0) {
            if (1.0 / (0.0 * d2) == Double.POSITIVE_INFINITY) {
                return d;
            }
            return 1.0 / d == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d2 == 0.0) {
            return d < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        double d3 = StrictMath.abs(d / d2);
        d3 = d3 > 1.152921504606847E18 ? 1.5707963267948966 : (d2 < 0.0 && d3 < 8.673617379884035E-19 ? 0.0 : StrictMath.atan(d3));
        if (d2 > 0.0) {
            return d > 0.0 ? d3 : -d3;
        }
        return d > 0.0 ? Math.PI - (d3 - 1.2246467991473532E-16) : d3 - 1.2246467991473532E-16 - Math.PI;
    }

    public static final double exp(double d) {
        int n;
        double d2;
        double d3;
        if (d != d) {
            return d;
        }
        if (d > 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (d < -745.1332191019411) {
            return 0.0;
        }
        double d4 = StrictMath.abs(d);
        if (d4 > 0.34657359027997264) {
            if (d4 < 1.0397207708399179) {
                d3 = d4 - 0.6931471803691238;
                d2 = 1.9082149292705877E-10;
                n = 1;
            } else {
                n = (int)(1.4426950408889634 * d4 + 0.5);
                d3 = d4 - (double)n * 0.6931471803691238;
                d2 = (double)n * 1.9082149292705877E-10;
            }
            if (d < 0.0) {
                d3 = -d3;
                d2 = -d2;
                n = -n;
            }
            d = d3 - d2;
        } else {
            if (d4 < 3.725290298461914E-9) {
                return 1.0;
            }
            n = 0;
            d2 = d3 = (double)0;
        }
        d4 = d * d;
        double d5 = d - d4 * (0.16666666666666602 + d4 * (-0.0027777777777015593 + d4 * (6.613756321437934E-5 + d4 * (-1.6533902205465252E-6 + d4 * 4.1381367970572385E-8))));
        if (n == 0) {
            return 1.0 - (d * d5 / (d5 - (double)2) - d);
        }
        double d6 = 1.0 - (d2 - d * d5 / ((double)2 - d5) - d3);
        return StrictMath.scale(d6, n);
    }

    public static final double log(double d) {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d < 0.0) {
            return Double.NaN;
        }
        if (!(d < Double.POSITIVE_INFINITY)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52);
        if (n == 0) {
            l = Double.doubleToLongBits(d *= 1.8014398509481984E16);
            n = (int)(l >> 52) - 54;
        }
        n -= 1023;
        d = Double.longBitsToDouble(l = l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        if (d >= 1.4142135623730951) {
            d *= 0.5;
            ++n;
        }
        if (StrictMath.abs(d -= 1.0) < 9.5367431640625E-7) {
            if (d == 0.0) {
                return (double)n * 0.6931471803691238 + (double)n * 1.9082149292705877E-10;
            }
            double d2 = d * d * (0.5 - 0.3333333333333333 * d);
            if (n == 0) {
                return d - d2;
            }
            return (double)n * 0.6931471803691238 - (d2 - (double)n * 1.9082149292705877E-10 - d);
        }
        double d3 = d / ((double)2 + d);
        double d4 = d3 * d3;
        double d5 = d4 * d4;
        double d6 = d5 * (0.3999999999940942 + d5 * (0.22222198432149784 + d5 * 0.15313837699209373));
        double d7 = d4 * (0.6666666666666735 + d5 * (0.2857142874366239 + d5 * (0.1818357216161805 + d5 * 0.14798198605116586)));
        double d8 = d7 + d6;
        if (l >= 4608896875255300096L && l < 4609073930987110400L) {
            double d9 = 0.5 * d * d;
            if (n == 0) {
                return d - (d9 - d3 * (d9 + d8));
            }
            return (double)n * 0.6931471803691238 - (d9 - (d3 * (d9 + d8) + (double)n * 1.9082149292705877E-10) - d);
        }
        if (n == 0) {
            return d - d3 * (d - d8);
        }
        return (double)n * 0.6931471803691238 - (d3 * (d - d8) - (double)n * 1.9082149292705877E-10 - d);
    }

    public static final double sqrt(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0 || !(d < Double.POSITIVE_INFINITY)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52);
        if (n == 0) {
            l = Double.doubleToLongBits(d *= 1.8014398509481984E16);
            n = (int)(l >> 52) - 54;
        }
        l = l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (((n -= 1023) & 1) == 1) {
            l <<= 1;
        }
        n >>= 1;
        l <<= 1;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0x20000000000000L;
        while (l4 != 0L) {
            long l5 = l3 + l4;
            if (l5 <= l) {
                l3 = l5 + l4;
                l -= l5;
                l2 += l4;
            }
            l <<= 1;
            l4 >>= 1;
        }
        if (l != 0L) {
            l2 += l2 & 1L;
        }
        return Double.longBitsToDouble((l2 >> 1) + ((long)n + 1022L << 52));
    }

    public static final double pow(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 == 1.0) {
            return d;
        }
        if (d2 == -1.0) {
            return 1.0 / d;
        }
        if (d != d || d2 != d2) {
            return Double.NaN;
        }
        int n = 0;
        if (d < 0.0 && StrictMath.floor(d2) == d2) {
            int n2 = 0;
            if (d2 % (double)2 == 0.0) {
                n2 = 1;
            }
            n = n2 + 1;
        }
        double d14 = StrictMath.abs(d);
        double d15 = StrictMath.abs(d2);
        if (d15 == Double.POSITIVE_INFINITY) {
            if (d14 == 1.0) {
                return Double.NaN;
            }
            if (d14 > 1.0) {
                return d2 > 0.0 ? d2 : 0.0;
            }
            return d2 < 0.0 ? -d2 : 0.0;
        }
        if (d2 == (double)2) {
            return d * d;
        }
        if (d2 == 0.5) {
            return StrictMath.sqrt(d);
        }
        if (d == 0.0 || d14 == Double.POSITIVE_INFINITY || d14 == 1.0) {
            if (d2 < 0.0) {
                d14 = 1.0 / d14;
            }
            if (d < 0.0) {
                if (d == -1.0 && n == 0) {
                    d14 = Double.NaN;
                } else if (n == 1) {
                    d14 = -d14;
                }
            }
            return d14;
        }
        if (d < 0.0 && n == 0) {
            return Double.NaN;
        }
        if (d15 > 2.147483648E9) {
            if (d15 > 1.8446744073709552E19) {
                return (d14 < 1.0 ? d2 < 0.0 : d2 > 0.0) ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (d14 < 0.9999995231628418) {
                return d2 < 0.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (d14 >= (double)1.000001f) {
                return d2 > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            d13 = d - 1.0;
            d12 = d13 * d13 * (0.5 - d13 * (0.3333333333333333 - d13 * 0.25));
            d11 = (double)1.442695f * d13;
            d10 = d13 * 1.9259629911266175E-8 - d12 * 1.4426950408889634;
            d9 = (float)(d11 + d10);
            d8 = d10 - (d9 - d11);
        } else {
            boolean bl2;
            long l = Double.doubleToLongBits(d14);
            int n3 = (int)(l >> 52);
            if (n3 == 0) {
                l = Double.doubleToLongBits(d14 *= 1.8014398509481984E16);
                n3 = (int)(l >> 52) - 54;
            }
            n3 -= 1023;
            d14 = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
            if (d14 < 1.224744871391589) {
                bl2 = false;
            } else if (d14 < 1.7320508075688772) {
                bl2 = true;
            } else {
                bl2 = false;
                d14 *= 0.5;
                ++n3;
            }
            d11 = d14 - (bl2 ? 1.5 : 1.0);
            d10 = 1.0 / (d14 + (bl2 ? 1.5 : 1.0));
            double d16 = d11 * d10;
            double d17 = (float)d16;
            double d18 = (float)(d14 + (bl2 ? 1.5 : 1.0));
            d7 = d14 - (d18 - (bl2 ? 1.5 : 1.0));
            double d19 = d10 * (d11 - d17 * d18 - d17 * d7);
            double d20 = d16 * d16;
            double d21 = d19 * (d17 + d16) + d20 * d20 * (0.5999999999999946 + d20 * (0.4285714285785502 + d20 * (0.33333332981837743 + d20 * (0.272728123808534 + d20 * (0.23066074577556175 + d20 * 0.20697501780033842)))));
            d20 = d17 * d17;
            d18 = (float)((double)3 + d20 + d21);
            d7 = d21 - (d18 - (double)3 - d20);
            d11 = d17 * d18;
            d10 = d19 * d18 + d7 * d16;
            double d22 = (float)(d11 + d10);
            double d23 = d10 - (d22 - d11);
            double d24 = 0.9617967009544373 * d22;
            double d25 = -7.028461650952758E-9 * d22 + d23 * 0.9617966939259756 + (bl2 ? 1.350039202129749E-8 : 0.0);
            d13 = n3;
            d9 = (float)(d24 + d25 + (bl2 ? 0.5849624872207642 : 0.0) + d13);
            d8 = d25 - (d9 - d13 - (bl2 ? 0.5849624872207642 : 0.0) - d24);
        }
        boolean bl3 = false;
        if (d < 0.0 && n == 1) {
            bl3 = bl = true;
        }
        if ((d6 = (d5 = (d2 - (d4 = (double)((float)d2))) * d9 + d2 * d8) + (d3 = d4 * d9)) >= 1024.0) {
            if (d6 > 1024.0 || d5 + 8.008566259537294E-17 > d6 - d3) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else if (d6 <= -1075.0 && (d6 < -1075.0 || d5 <= d6 - d3)) {
            return bl ? -0.0 : 0.0;
        }
        int n4 = StrictMath.round((float)d6);
        d13 = (float)(d5 + (d3 -= (double)n4));
        d11 = d13 * 0.6931471803691238;
        d10 = (d5 - (d13 - d3)) * 0.6931471805599453 + d13 * 1.9082149292705877E-10;
        d6 = d11 + d10;
        d12 = d10 - (d6 - d11);
        d13 = d6 * d6;
        d9 = d6 - d13 * (0.16666666666666602 + d13 * (-0.0027777777777015593 + d13 * (6.613756321437934E-5 + d13 * (-1.6533902205465252E-6 + d13 * 4.1381367970572385E-8))));
        d7 = d6 * d9 / (d9 - (double)2) - (d12 + d6 * d12);
        d6 = StrictMath.scale(1.0 - (d7 - d6), n4);
        return bl ? -d6 : d6;
    }

    public static final double IEEEremainder(double d, double d2) {
        boolean bl;
        if (d == Double.NEGATIVE_INFINITY || !(d < Double.POSITIVE_INFINITY) || d2 == 0.0 || d2 != d2) {
            return Double.NaN;
        }
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = bl = true;
        }
        if ((d = StrictMath.abs(d)) == (d2 = StrictMath.abs(d2)) || d == 0.0) {
            return 0.0 * d;
        }
        if (d2 < 8.98846567431158E307) {
            d %= d2 + d2;
        }
        if (d2 < 4.450147717014403E-308) {
            if (d + d > d2 && (d -= d2) + d >= d2) {
                d -= d2;
            }
        } else if (d > (d2 *= 0.5) && (d -= d2) >= d2) {
            d -= d2;
        }
        return bl ? -d : d;
    }

    public static final double ceil(double d) {
        return -StrictMath.floor(-d);
    }

    public static final double floor(double d) {
        double d2 = StrictMath.abs(d);
        if (!(d2 < 4.503599627370496E15) || (double)((long)d) == d) {
            return d;
        }
        if (d2 < 1.0) {
            return d >= 0.0 ? 0.0 * d : -1.0;
        }
        return d < 0.0 ? (double)((long)d) - 1.0 : (double)((long)d);
    }

    public static final double rint(double d) {
        double d2 = StrictMath.abs(d);
        if (!(d2 < 4.503599627370496E15)) {
            return d;
        }
        if (d2 <= 0.5) {
            return 0.0 * d;
        }
        if (d2 % (double)2 <= 0.5) {
            return (long)d;
        }
        return (long)(d + (d < 0.0 ? -0.5 : 0.5));
    }

    public static final int round(float f) {
        return (int)StrictMath.floor(f + 0.5f);
    }

    public static final long round(double d) {
        return (long)StrictMath.floor(d + 0.5);
    }

    public static final synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static final double toRadians(double d) {
        return d * Math.PI / 180.0;
    }

    public static final double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    private static final int remPiOver2(double d, double[] dArray) {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = bl = true;
        }
        if ((d = StrictMath.abs(d)) < 2.356194490192345) {
            double d2 = d - 1.5707963267341256;
            if ((float)d != 1.5707964f) {
                dArray[0] = d2 - 6.077100506506192E-11;
                dArray[1] = d2 - dArray[0] - 6.077100506506192E-11;
            } else {
                dArray[0] = (d2 -= 6.077100506303966E-11) - 2.0222662487959506E-21;
                dArray[1] = d2 - dArray[0] - 2.0222662487959506E-21;
            }
            n = 1;
        } else if (d <= 1647099.3291652855) {
            n = (int)(0.6366197723675814 * d + 0.5);
            double d3 = d - (double)n * 1.5707963267341256;
            double d4 = (double)n * 6.077100506506192E-11;
            dArray[0] = d3 - d4;
            if ((n >= 32 || (float)d == (float)d4) && d / dArray[0] >= 65536.0) {
                double d5 = d3;
                d4 = (double)n * 6.077100506303966E-11;
                d3 = d5 - d4;
                d4 = (double)n * 2.0222662487959506E-21 - (d5 - d3 - d4);
                dArray[0] = d3 - d4;
                if (d / dArray[0] >= 5.62949953421312E14) {
                    d5 = d3;
                    d4 = (double)n * 2.0222662487111665E-21;
                    d3 = d5 - d4;
                    d4 = (double)n * 8.4784276603689E-32 - (d5 - d3 - d4);
                    dArray[0] = d3 - d4;
                }
            }
            dArray[1] = d3 - dArray[0] - d4;
        } else {
            int n2 = (int)(Double.doubleToLongBits(d) >> 52) - 1046;
            double d6 = StrictMath.scale(d, -n2);
            double[] dArray2 = new double[3];
            int n3 = 0;
            while (n3 < 2) {
                dArray2[n3] = (int)d6;
                d6 = (d6 - dArray2[n3]) * 1.6777216E7;
                ++n3;
            }
            dArray2[2] = d6;
            n3 = 2;
            while (dArray2[n3] == 0.0) {
                --n3;
            }
            n = StrictMath.remPiOver2(dArray2, dArray, n2, n3);
        }
        if (bl) {
            dArray[0] = -dArray[0];
            dArray[1] = -dArray[1];
            return -n;
        }
        return n;
    }

    private static final int remPiOver2(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        int n4;
        double d;
        double d2;
        int n5;
        int[] nArray = new int[20];
        double[] dArray3 = new double[20];
        double[] dArray4 = new double[20];
        boolean bl = false;
        int n6 = n5 = 4;
        int n7 = StrictMath.max((n - 3) / 24, 0);
        int n8 = n - 24 * (n7 + 1);
        int n9 = n7 - n2;
        int n10 = n2 + n5;
        int n11 = 0;
        while (n11 <= n10) {
            int n12 = 0;
            if (n9 >= 0) {
                n12 = TWO_OVER_PI[n9];
            }
            dArray3[n11] = n12;
            ++n11;
            ++n9;
        }
        n11 = 0;
        while (n11 <= n5) {
            n9 = 0;
            d2 = 0.0;
            while (n9 <= n2) {
                d2 += dArray[n9] * dArray3[n2 + n11 - n9];
                ++n9;
            }
            dArray4[n11] = d2;
            ++n11;
        }
        do {
            int n13;
            n11 = 0;
            n9 = n6;
            d = dArray4[n6];
            while (n9 > 0) {
                d2 = (int)(5.960464477539063E-8 * d);
                nArray[n11] = (int)(d - 1.6777216E7 * d2);
                d = dArray4[n9 - 1] + d2;
                ++n11;
                --n9;
            }
            d = StrictMath.scale(d, n8);
            d -= 8.0 * StrictMath.floor(d * 0.125);
            n4 = (int)d;
            d -= (double)n4;
            n3 = 0;
            if (n8 > 0) {
                n11 = nArray[n6 - 1] >> 24 - n8;
                n4 += n11;
                int n14 = n6 - 1;
                nArray[n14] = nArray[n14] - (n11 << 24 - n8);
                n3 = nArray[n6 - 1] >> 23 - n8;
            } else if (n8 == 0) {
                n3 = nArray[n6 - 1] >> 23;
            } else if (d >= 0.5) {
                n3 = 2;
            }
            if (n3 > 0) {
                ++n4;
                n13 = 0;
                n11 = 0;
                while (n11 < n6) {
                    n9 = nArray[n11];
                    if (n13 == 0) {
                        if (n9 != 0) {
                            n13 = 1;
                            nArray[n11] = 0x1000000 - n9;
                        }
                    } else {
                        nArray[n11] = 0xFFFFFF - n9;
                    }
                    ++n11;
                }
                switch (n8) {
                    case 1: {
                        int n15 = n6 - 1;
                        nArray[n15] = nArray[n15] & 0x7FFFFF;
                        break;
                    }
                    case 2: {
                        int n16 = n6 - 1;
                        nArray[n16] = nArray[n16] & 0x3FFFFF;
                    }
                }
                if (n3 == 2) {
                    d = 1.0 - d;
                    if (n13 != 0) {
                        d -= StrictMath.scale(1.0, n8);
                    }
                }
            }
            if (d != 0.0) continue;
            n9 = 0;
            n11 = n6 - 1;
            while (n11 >= n5) {
                n9 |= nArray[n11];
                --n11;
            }
            if (n9 != 0) continue;
            n13 = 1;
            while (nArray[n5 - n13] == 0) {
                ++n13;
            }
            n11 = n6 + 1;
            while (n11 <= n6 + n13) {
                dArray3[n2 + n11] = TWO_OVER_PI[n7 + n11];
                n9 = 0;
                d2 = 0.0;
                while (n9 <= n2) {
                    d2 += dArray[n9] * dArray3[n2 + n11 - n9];
                    ++n9;
                }
                dArray4[n11] = d2;
                ++n11;
            }
            n6 += n13;
            bl = true;
        } while (bl);
        if (d == 0.0) {
            --n6;
            n8 -= 24;
            while (nArray[n6] == 0) {
                --n6;
                n8 -= 24;
            }
        } else if ((d = StrictMath.scale(d, -n8)) >= 1.6777216E7) {
            d2 = (int)(5.960464477539063E-8 * d);
            nArray[n6] = (int)(d - 1.6777216E7 * d2);
            n8 += 24;
            nArray[++n6] = (int)d2;
        } else {
            nArray[n6] = (int)d;
        }
        d2 = StrictMath.scale(1.0, n8);
        n11 = n6;
        while (n11 >= 0) {
            dArray4[n11] = d2 * (double)nArray[n11];
            d2 *= 5.960464477539063E-8;
            --n11;
        }
        double[] dArray5 = new double[20];
        n11 = n6;
        while (n11 >= 0) {
            d2 = 0.0;
            int n17 = 0;
            while (n17 <= n5 && n17 <= n6 - n11) {
                d2 += PI_OVER_TWO[n17] * dArray4[n11 + n17];
                ++n17;
            }
            dArray5[n6 - n11] = d2;
            --n11;
        }
        d2 = 0.0;
        n11 = n6;
        while (n11 >= 0) {
            d2 += dArray5[n11];
            --n11;
        }
        dArray2[0] = n3 == 0 ? d2 : -d2;
        d2 = dArray5[0] - d2;
        n11 = 1;
        while (n11 <= n6) {
            d2 += dArray5[n11];
            ++n11;
        }
        dArray2[1] = n3 == 0 ? d2 : -d2;
        return n4;
    }

    private static final double scale(double d, int n) {
        if (d == 0.0 || d == Double.NEGATIVE_INFINITY || !(d < Double.POSITIVE_INFINITY) || n == 0) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n2 = (int)(l >> 52) & 0x7FF;
        if (n2 == 0) {
            n2 = ((int)(Double.doubleToLongBits(d *= 1.8014398509481984E16) >> 52) & 0x7FF) - 54;
        }
        if ((n2 += n) > 2046) {
            return Double.POSITIVE_INFINITY * d;
        }
        if (n2 > 0) {
            return Double.longBitsToDouble(l & 0x800FFFFFFFFFFFFFL | (long)n2 << 52);
        }
        if (n2 <= -54) {
            return 0.0 * d;
        }
        d = Double.longBitsToDouble(l & 0x800FFFFFFFFFFFFFL | (long)(n2 += 54) << 52);
        return d * 5.551115123125783E-17;
    }

    private static final double sin(double d, double d2) {
        if (StrictMath.abs(d) < 7.450580596923828E-9) {
            return d;
        }
        double d3 = d * d;
        double d4 = d3 * d;
        double d5 = 0.00833333333332249 + d3 * (-1.984126982985795E-4 + d3 * (2.7557313707070068E-6 + d3 * (-2.5050760253406863E-8 + d3 * 1.58969099521155E-10)));
        if (d2 == 0.0) {
            return d + d4 * (-0.16666666666666632 + d3 * d5);
        }
        return d - (d3 * (0.5 * d2 - d4 * d5) - d2 - d4 * -0.16666666666666632);
    }

    private static final double cos(double d, double d2) {
        if ((d = StrictMath.abs(d)) < 7.450580596923828E-9) {
            return 1.0;
        }
        double d3 = d * d;
        double d4 = d3 * (0.0416666666666666 + d3 * (-0.001388888888887411 + d3 * (2.480158728947673E-5 + d3 * (-2.7557314351390663E-7 + d3 * (2.087572321298175E-9 + d3 * -1.1359647557788195E-11)))));
        if (d < 0.3) {
            return 1.0 - (0.5 * d3 - (d3 * d4 - d * d2));
        }
        double d5 = d > 0.78125 ? 0.28125 : d * 0.25;
        return 1.0 - d5 - (0.5 * d3 - d5 - (d3 * d4 - d * d2));
    }

    private static final double tan(double d, double d2, boolean bl) {
        double d3;
        double d4;
        boolean bl2;
        boolean bl3;
        boolean bl4 = false;
        if (d < 0.0) {
            bl4 = true;
        }
        if (bl3 = bl4) {
            d = -d;
            d2 = -d2;
        }
        if (d < 3.725290298461914E-9) {
            return (double)(bl3 ? -1 : 1) * (bl ? -1.0 / d : d);
        }
        boolean bl5 = false;
        if (d >= 0.6744) {
            bl5 = true;
        }
        if (bl2 = bl5) {
            d4 = 0.7853981633974483 - d;
            d3 = 3.061616997868383E-17 - d2;
            d = d4 + d3;
            d2 = 0.0;
        }
        d4 = d * d;
        d3 = d4 * d4;
        double d5 = 0.13333333333320124 + d3 * (0.021869488294859542 + d3 * (0.0035920791075913124 + d3 * (5.880412408202641E-4 + d3 * (7.817944429395571E-5 + d3 * -1.8558637485527546E-5))));
        double d6 = d4 * (0.05396825397622605 + d3 * (0.0088632398235993 + d3 * (0.0014562094543252903 + d3 * (2.464631348184699E-4 + d3 * (7.140724913826082E-5 + d3 * 2.590730518636337E-5)))));
        double d7 = d4 * d;
        d5 = d2 + d4 * (d7 * (d5 + d6) + d2);
        d3 = d + (d5 += 0.3333333333333341 * d7);
        if (bl2) {
            d6 = bl ? -1 : 1;
            return (double)(bl3 ? -1 : 1) * (d6 - (double)2 * (d - (d3 * d3 / (d3 + d6) - d5)));
        }
        if (!bl) {
            return d3;
        }
        d4 = (float)d3;
        d6 = d5 - (d4 - d);
        double d8 = -1.0 / d3;
        double d9 = (float)d8;
        return d9 + d8 * (1.0 + d9 * d4 + d9 * d6);
    }

    public static final double signum(double d) {
        return Math.signum(d);
    }

    public static final float signum(float f) {
        return Math.signum(f);
    }

    public static final double ulp(double d) {
        return Math.ulp(d);
    }

    public static final float ulp(float f) {
        return Math.ulp(f);
    }

    private StrictMath() {
    }

    static {
        TWO_OVER_PI = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        PI_OVER_TWO = new double[]{1.570796251296997, 7.549789415861596E-8, 5.390302529957765E-15, 3.282003415807913E-22, 1.270655753080676E-29, 1.2293330898111133E-36, 2.7337005381646456E-44, 2.1674168387780482E-51};
    }
}

