/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UnicastConnection
implements Runnable,
ProtocolConstants {
    public static final long CONNECTION_TIMEOUT = 10000L;
    UnicastConnectionManager manager;
    Socket sock;
    DataInputStream din;
    DataOutputStream dout;
    ObjectInputStream oin;
    ObjectOutputStream oout;
    long reviveTime;
    long expireTime;

    void acceptConnection() throws IOException {
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        int n = this.din.readInt();
        if (n != 1246907721) {
            throw new IOException("bad protocol header");
        }
        short s = this.din.readShort();
        if (s != 2) {
            throw new IOException("bad protocol version");
        }
        int n2 = this.din.readUnsignedByte();
        if (n2 != 76) {
            this.dout.writeByte(78);
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
            this.dout.flush();
            String string = this.din.readUTF();
            int n3 = this.din.readInt();
        }
    }

    void makeConnection(int n) throws IOException {
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.dout.writeInt(1246907721);
        this.dout.writeShort(2);
        this.dout.writeByte(n);
        this.dout.flush();
        if (n != 76) {
            int n2 = this.din.readUnsignedByte();
            if (n2 != 78) {
                throw new RemoteException("Unsupported protocol");
            }
            String string = this.din.readUTF();
            int n3 = this.din.readInt();
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
            this.dout.flush();
        }
    }

    DataInputStream getDataInputStream() throws IOException {
        return this.din;
    }

    DataOutputStream getDataOutputStream() throws IOException {
        return this.dout;
    }

    ObjectInputStream getObjectInputStream() throws IOException {
        if (this.oin == null) {
            throw new IOException("no ObjectInputtream for reading more objects");
        }
        return this.oin;
    }

    ObjectInputStream startObjectInputStream() throws IOException {
        this.oin = new RMIObjectInputStream(this.din);
        return this.oin;
    }

    ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oout == null) {
            throw new IOException("no ObjectOutputStream for sending more objects");
        }
        return this.oout;
    }

    ObjectOutputStream startObjectOutputStream() throws IOException {
        this.oout = new RMIObjectOutputStream(this.dout);
        return this.oout;
    }

    void disconnect() {
        try {
            if (this.oout != null) {
                this.oout.close();
            }
            this.sock.close();
        }
        catch (IOException iOException) {}
        this.oin = null;
        this.oout = null;
        this.din = null;
        this.dout = null;
        this.sock = null;
    }

    static boolean isExpired(UnicastConnection unicastConnection, long l) {
        return l > unicastConnection.expireTime;
    }

    static void resetTime(UnicastConnection unicastConnection) {
        long l;
        unicastConnection.reviveTime = l = System.currentTimeMillis();
        unicastConnection.expireTime = l + 10000L;
    }

    public void run() {
        while (true) {
            try {
                UnicastServer.dispatch(this);
            }
            catch (Exception exception) {
                this.manager.discardConnection(this);
                return;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.reviveTime = 0L;
        this.expireTime = Long.MAX_VALUE;
    }

    UnicastConnection(UnicastConnectionManager unicastConnectionManager, Socket socket) {
        this.this();
        this.manager = unicastConnectionManager;
        this.sock = socket;
    }
}

