/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.framework;

import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;

public class AssertTest
extends TestCase {
    public void testFail() {
        try {
            AssertTest.fail();
        }
        catch (AssertionFailedError e) {
            return;
        }
        throw new AssertionFailedError();
    }

    public void testAssertEquals() {
        Object o = new Object();
        AssertTest.assertEquals(o, o);
        try {
            AssertTest.assertEquals(new Object(), new Object());
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertEqualsNull() {
        AssertTest.assertEquals(null, null);
    }

    public void testAssertStringEquals() {
        AssertTest.assertEquals("a", "a");
    }

    public void testAssertNullNotEqualsString() {
        try {
            AssertTest.assertEquals(null, "foo");
            AssertTest.fail();
        }
        catch (ComparisonFailure comparisonFailure) {
            // empty catch block
        }
    }

    public void testAssertStringNotEqualsNull() {
        try {
            AssertTest.assertEquals("foo", null);
            AssertTest.fail();
        }
        catch (ComparisonFailure e) {
            e.getMessage();
        }
    }

    public void testAssertNullNotEqualsNull() {
        try {
            AssertTest.assertEquals(null, new Object());
        }
        catch (AssertionFailedError e) {
            e.getMessage();
            return;
        }
        AssertTest.fail();
    }

    public void testAssertNull() {
        AssertTest.assertNull(null);
        try {
            AssertTest.assertNull(new Object());
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertNotNull() {
        AssertTest.assertNotNull(new Object());
        try {
            AssertTest.assertNotNull(null);
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertTrue() {
        AssertTest.assertTrue(true);
        try {
            AssertTest.assertTrue(false);
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertFalse() {
        AssertTest.assertFalse(false);
        try {
            AssertTest.assertFalse(true);
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertSame() {
        Object o = new Object();
        AssertTest.assertSame(o, o);
        try {
            AssertTest.assertSame(new Integer(1), new Integer(1));
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertNotSame() {
        AssertTest.assertNotSame(new Integer(1), null);
        AssertTest.assertNotSame(null, new Integer(1));
        AssertTest.assertNotSame(new Integer(1), new Integer(1));
        try {
            Integer obj = new Integer(1);
            AssertTest.assertNotSame(obj, obj);
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }

    public void testAssertNotSameFailsNull() {
        try {
            AssertTest.assertNotSame(null, null);
        }
        catch (AssertionFailedError e) {
            return;
        }
        AssertTest.fail();
    }
}

