/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.filter;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.rdb.connection.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

/**
 * @author ledunnel
 */
public class FilterWizard extends Wizard implements INewWizard {
	private ISelection selection;

	private FilterWizardPage page;

	public FilterWizard(ISelection sel) {
		super();
		selection = sel;
	}

	public void addPages() {
		super.addPages();
		page = new FilterWizardPage(
				"org.eclipse.wst.rdb.server.internal.ui.explorer.filter", //$NON-NLS-1$
				ResourceLoader.INSTANCE.queryString("_UI_TITLE_FILTER"), ImageDescription.getFilterWizardDescriptor(), //$NON-NLS-1$
				selection);
		addPage(page);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		Object sel = ((StructuredSelection) selection).getFirstElement();
		page.setConnectionFilter(sel);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench,
	 *      org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {

	}

	public void createPageControls(Composite pageContainer) {
		super.createPageControls(pageContainer);
	}
}