/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal;

import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

/**
 * This interface is a mix-in interface to be used with an <code>IEditorInput</code> 
 * to add additional information to the editor input for the SQL editor.
 */
public interface ISQLEditorInput extends IEditorInput {

    /**
     * Gets the <code>ConnectionInfo</code> object associated with this input.
     * The <code>ConnectionInfo</code> object contains the information needed
     * to connect to a database.
     * 
     * @return the <code>ConnectionInfo</code> object associated with this input
     * or <code>null</code> if none
     */
    public ConnectionInfo getConnectionInfo();

    /**
     * Gets the <code>Database</code> object associated with this input.  The
     * <code>Database</code> object provides access to database metadata (catalog)
     * information.
     * 
     * @return the <code>Database</code> object associated with this input, or
     * <code>null</code> if none
     */
    public Database getDatabase();
    
    /**
     * Gets the default schema name to use with the connection or database
     * associated with this input.
     * 
     * @return the default schema name to use with this input, or null if none
     */
    public String getDefaultSchemaName();
    
    /**
     * Sets the <code>ConnectionInfo</code> associated with this input to the given 
     * object.
     * 
     * @param connInfo the <code>ConnectionInfo</code> object to set
     */
    public void setConnectionInfo( ConnectionInfo connInfo );

    /**
     * Sets the <code>Database</code> object associated with this input to the
     * given object.
     * 
     * @param database the <code>Database</code> object to set
     */
    public void setDatabase( Database database );

    /**
     * Sets the default schema name to use with the connection or database
     * associated with this input.
     * 
     * @param schemaname the default schema name to set
     */
    public void setDefaultSchemaName( String schemaName );

}
