/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;


/**
 * @author ljulien
 */
public class ServerExplorerConnectionManagedListener implements ConnectionManagerListener
{
    private Map sharingListenerMap = new HashMap ();
   
    private ConnectionInfo getConnectionInfo (String name)
    {
        for (Iterator iterator = sharingListenerMap.keySet().iterator(); iterator.hasNext (); )
        {
            ConnectionInfo info = (ConnectionInfo) iterator.next();
            if (info.getName().equals(name))
            {
                return info;
            }
        }
        return null;
    }
  
    private void removeConnectionFromMap (ConnectionInfo info)
    {
        if (this.sharingListenerMap.containsKey(info))
        {
            ConnectionSharingListener listener = (ConnectionSharingListener) this.sharingListenerMap.get(info);
            info.removeConnectionSharingListener(listener);
            this.sharingListenerMap.remove(info);
        }
    }
    
    public void dispose ()
    {
        ConnectionInfo [] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        for (int i = 0, n = infos.length; i < n; i++)
        {
            ConnectionInfo info = infos[i];
            if (info.getSharedDatabase() != null)
            {
                info.removeSharedDatabase();
            }
            if (info.getSharedConnection() != null)
            {
            	try
				{
					info.getSharedConnection().close();
					info.removeSharedConnection();
				}
				catch (SQLException e)
				{
					Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
				}
            }
            removeConnectionFromMap (infos[i]);
        }
    }
    
    public void connectionInfoCreated(final ConnectionInfo info)
    {
        Display.getDefault().syncExec(new Runnable()
        {
            public void run()
            {
                if (!sharingListenerMap.containsKey(info))
                {
                    ConnectionSharingListener listener = new ServerExplorerConnectionSharingListener();
                    info.addConnectionSharingListener(listener);
                    sharingListenerMap.put(info, listener);
                    new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
                }
            }
        });
    }

    public void connectionInfoRemoved(final String name)
    {
        Display.getDefault().syncExec(new Runnable()
        {
            public void run()
            {
                ConnectionInfo info = getConnectionInfo(name);
                removeConnectionFromMap(info);
                if (info != null)
                {
                    try
                    {
                        IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                        IServicesManager.INSTANCE.getServerExplorerContentService().deleteServer(new IConnectionNode[] { node });
                    }
                    catch (ServerNotFoundException e)
                    {
                    }
                }
            }
        });
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info)
    {
    }

    public void connected(final ConnectionInfo info, Connection connection)
    {
        Display.getDefault().syncExec(new Runnable()
        {
            public void run()
            {
                new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
            }
        });

    }

    public void disconnected(final ConnectionInfo info, Connection connection)
    {
        Display.getDefault().syncExec(new Runnable()
        {
            public void run()
            {
                try
                {
                    IConnectionNode connectionNode = ConnectionNodeUtil.getConnectionNode(info);
                    IServicesManager.INSTANCE.getServerExplorerContentService().disconnectServers(
                            new IConnectionNode[] { connectionNode });
                }
                catch (ServerNotFoundException e)
                {
                }
            }
        });
    }
}
