/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal.cactus;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.server.ui.internal.ImageResource;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.jst.server.ui.internal.cactus.CactusAddLibrariesProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class NewServletTestCaseWizard
extends Wizard
implements INewWizard {
    private static final String SUPERCLASS_NAME = "org.apache.cactus.ServletTestCase";
    protected static final String[] CLASSES_TO_CHECK = new String[]{"org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "org.apache.commons.logging.Log", "org.aspectj.lang.JoinPoint", "org.apache.commons.httpclient.HttpClient"};
    protected static final String[] REQUIRED_LIBRARIES = new String[]{"cactus-1.7.2.jar", "junit-3.8.1.jar", "aspectjrt-1.2.1.jar", "commons-logging-1.0.4.jar", "commons-httpclient-2.0.2.jar"};
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;
    private NewTestCaseWizardPageTwo fPage2;
    private NewTestCaseWizardPageOne fPage1;

    public NewServletTestCaseWizard() {
        this.setWindowTitle(Messages.NewServletTestCaseWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(ImageResource.getImageDescriptor("wiz_cactus_test"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public void addPages() {
        super.addPages();
        this.fPage2 = new NewTestCaseWizardPageTwo();
        this.fPage1 = new CactusPage1(this.fPage2);
        this.addPage((IWizardPage)this.fPage1);
        this.fPage1.init(this.getSelection());
        this.addPage((IWizardPage)this.fPage2);
    }

    protected static Control createEmptySpace(Composite parent) {
        return NewServletTestCaseWizard.createEmptySpace(parent, 1);
    }

    private static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected boolean checkForWebProject() throws CoreException {
        IPackageFragmentRoot root = this.fPage1.getPackageFragmentRoot();
        if (root == null) {
            return false;
        }
        IJavaProject project = root.getJavaProject();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project.getProject());
        if (facetedProject != null) {
            Iterator facets = facetedProject.getProjectFacets().iterator();
            while (facets.hasNext()) {
                IProjectFacetVersion facet = (IProjectFacetVersion)facets.next();
                if (!facet.getProjectFacet().getId().equals("jst.web")) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkForCactusLibraries() {
        IPackageFragmentRoot root = this.fPage1.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject project = root.getJavaProject();
        ArrayList<String> missingLibraries = new ArrayList<String>();
        try {
            int i = 0;
            while (i < CLASSES_TO_CHECK.length) {
                IType type = project.findType(CLASSES_TO_CHECK[i]);
                if (type == null) {
                    missingLibraries.add(REQUIRED_LIBRARIES[i]);
                }
                ++i;
            }
            if (missingLibraries.size() > 0 && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.NewServletTestCaseWizard_ErrorMessageTitleMissingLibrary, (String)NLS.bind((String)Messages.NewServletTestCaseWizard_ErrorMessageMissingLibrary, (Object[])missingLibraries.toArray()))) {
                CactusAddLibrariesProposal.installLibraries(project.getProject());
            }
        }
        catch (JavaModelException e) {
            JavaServerUIPlugin.log(e);
        }
    }

    public boolean performFinish() {
        if (this.finishPage(this.fPage1.getRunnable())) {
            IType newClass = this.fPage1.getCreatedType();
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            String title = Messages.NewServletTestCaseWizard_ErrorTitleNew;
            String message = Messages.NewServletTestCaseWizard_ErrorTitleCreateOfElementFailed;
            NewServletTestCaseWizard.displayMessageDialog(e, e.getMessage(), this.getShell(), title, message);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(Messages.NewServletTestCaseWizard_ErrorMessageSeeErrorLog);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = NewServletTestCaseWizard.getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        JavaServerUIPlugin.log(e);
                    }
                }
            });
        }
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = NewServletTestCaseWizard.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = JavaServerUIPlugin.getInstance().getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    private class CactusPage1
    extends NewTestCaseWizardPageOne {
        private Button fBeginButton;
        private Button fEndButton;
        private Button fBeginXXXButton;
        private Button fEndXXXButton;
        private Composite fCactusButtonComposite;

        public CactusPage1(NewTestCaseWizardPageTwo page2) {
            super(page2);
        }

        public void init(IStructuredSelection selection) {
            super.init(selection);
            this.validateIfJUnitProject();
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setSuperClass(NewServletTestCaseWizard.SUPERCLASS_NAME, true);
        }

        protected void createJUnit4Controls(Composite composite, int nColumns) {
        }

        protected IStatus superClassChanged() {
            String superClassName = this.getSuperClass();
            if (superClassName == null || superClassName.trim().equals("")) {
                Status status = new Status(4, "org.eclipse.jst.server.ui", 4, Messages.NewServletTestCaseWizard_WarningMessageSuperclassIsEmpty, null);
                return status;
            }
            if (superClassName.equals(NewServletTestCaseWizard.SUPERCLASS_NAME)) {
                return Status.OK_STATUS;
            }
            if (this.getPackageFragmentRoot() != null) {
                try {
                    IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                    if (type == null) {
                        Status status = new Status(2, "org.eclipse.jst.server.ui", 2, Messages.NewServletTestCaseWizard_WarningMessageSuperclassDoesNotExist, null);
                        return status;
                    }
                    if (type.isInterface()) {
                        Status status = new Status(2, "org.eclipse.jst.server.ui", 2, Messages.NewServletTestCaseWizard_WarningMessageSuperclassIsInterface, null);
                        return status;
                    }
                    ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
                    IType[] superTypes = hierarchy.getAllSuperclasses(type);
                    int i = 0;
                    while (i < superTypes.length) {
                        if (superTypes[i].getFullyQualifiedName().equals(NewServletTestCaseWizard.SUPERCLASS_NAME)) {
                            return Status.OK_STATUS;
                        }
                        ++i;
                    }
                    Status status = new Status(2, "org.eclipse.jst.server.ui", 2, Messages.NewServletTestCaseWizard_WarningMessageSuperclassNotServletTestCase, null);
                    return status;
                }
                catch (JavaModelException e) {
                    JavaServerUIPlugin.log(e);
                }
            }
            return Status.OK_STATUS;
        }

        private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
            IType type = jproject.findType(classToTestName);
            if (type == null && pack != null && !pack.isDefaultPackage()) {
                type = jproject.findType(pack.getElementName(), classToTestName);
            }
            if (type == null) {
                type = jproject.findType("java.lang", classToTestName);
            }
            return type;
        }

        protected IStatus validateIfJUnitProject() {
            try {
                if (!NewServletTestCaseWizard.this.checkForWebProject()) {
                    String msg = Messages.NewServletTestCaseWizard_WarningMessageSelectAWebProject;
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.NewServletTestCaseWizard_WarningTitleWebProjectRequired, (String)msg);
                    return new Status(2, "org.eclipse.jst.server.ui", 4, msg, null);
                }
                NewServletTestCaseWizard.this.checkForCactusLibraries();
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.jst.server.ui", 4, "Failed to check for cactus libraries.", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
            super.createTypeMembers(type, imports, monitor);
            if (this.fBeginButton.getSelection()) {
                this.generateBeginMethod(type, imports);
            }
            if (this.fEndButton.getSelection()) {
                this.generateEndMethod(type, imports);
            }
            if (this.fBeginXXXButton.getSelection()) {
                this.generateBeginXXXMethods(type, imports);
            }
            if (this.fEndXXXButton.getSelection()) {
                this.generateEndXXXMethods(type, imports);
            }
        }

        private void generateBeginMethod(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
            StringBuffer methodBuffer = new StringBuffer();
            methodBuffer.append("public void begin(");
            methodBuffer.append(imports.addImport("org.apache.cactus.WebRequest"));
            methodBuffer.append(" request) throws ");
            methodBuffer.append(imports.addImport("java.lang.Exception"));
            methodBuffer.append(" {\n\n\t} ");
            type.createMethod(methodBuffer.toString(), null, false, null);
        }

        private void generateEndMethod(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
            StringBuffer methodBuffer = new StringBuffer();
            methodBuffer.append("public void end(");
            methodBuffer.append(imports.addImport("org.apache.cactus.WebRequest"));
            methodBuffer.append(" request) throws ");
            methodBuffer.append(imports.addImport("java.lang.Exception"));
            methodBuffer.append(" {\n\n\t} ");
            type.createMethod(methodBuffer.toString(), null, false, null);
        }

        private void generateBeginXXXMethods(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
            this.generateXXXMethods(type, imports, "begin");
        }

        private void generateXXXMethods(IType type, NewTypeWizardPage.ImportsManager imports, String prefix) throws JavaModelException {
            IMethod[] testMethods = type.getMethods();
            int i = 0;
            while (i < testMethods.length) {
                IMethod testMethod = testMethods[i];
                String testMethodName = testMethod.getElementName();
                if (testMethodName.startsWith("test")) {
                    String newMethodName = String.valueOf(prefix) + testMethodName.substring(4);
                    StringBuffer methodBuffer = new StringBuffer();
                    methodBuffer.append("public void ");
                    methodBuffer.append(newMethodName);
                    methodBuffer.append("(");
                    methodBuffer.append(imports.addImport("org.apache.cactus.WebRequest"));
                    methodBuffer.append(" request) throws ");
                    methodBuffer.append(imports.addImport("java.lang.Exception"));
                    methodBuffer.append(" {\n\n\t} ");
                    type.createMethod(methodBuffer.toString(), (IJavaElement)testMethod, false, null);
                }
                ++i;
            }
        }

        private void generateEndXXXMethods(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
            this.generateXXXMethods(type, imports, "end");
        }

        protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
            super.createMethodStubSelectionControls(composite, nColumns);
            NewServletTestCaseWizard.createEmptySpace(composite);
            this.fCactusButtonComposite = new Composite(composite, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = 3;
            this.fCactusButtonComposite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.makeColumnsEqualWidth = true;
            this.fCactusButtonComposite.setLayout((Layout)layout);
            this.fBeginButton = this.createSelectionButton("begin()", this.fCactusButtonComposite);
            this.fEndButton = this.createSelectionButton("end()", this.fCactusButtonComposite);
            this.fBeginXXXButton = this.createSelectionButton("beginXXX() methods", this.fCactusButtonComposite);
            this.fEndXXXButton = this.createSelectionButton("endXXX() methods", this.fCactusButtonComposite);
        }

        private Button createSelectionButton(String text, Composite group) {
            Button button = new Button(group, 16416);
            button.setFont(group.getFont());
            button.setText(text);
            GridData data = new GridData();
            data.horizontalAlignment = 1;
            data.verticalAlignment = 2;
            button.setLayoutData((Object)data);
            return button;
        }
    }
}

